/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.nav;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.ivoa.vodml.annotation.VodmlType;
import org.ivoa.vodml.jaxb.XmlIdManagement;
import org.ivoa.vodml.nav.ModelInstanceTraverser;
import org.ivoa.vodml.nav.VodmlTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    static final AtomicLong NEXT_ID = new AtomicLong(1000L);
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static void findReferences(Object modelInstance, final Map<Class, Set> l) {
        final Set<Class> classes = l.keySet();
        logger.info("finding references to {}", classes);
        ModelInstanceTraverser.traverse(modelInstance, new ModelInstanceTraverser.Visitor(){

            @Override
            public void startInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
                if (v.kind == VodmlType.reference) {
                    if (classes.contains(o.getClass())) {
                        Set s = (Set)l.get(o.getClass());
                        s.add(o);
                    } else if (o.getClass().getSuperclass() != Object.class) {
                        for (Class c : classes) {
                            if (!c.isAssignableFrom(o.getClass())) continue;
                            Set s = (Set)l.get(c);
                            s.add(o);
                            break;
                        }
                    }
                }
            }
        });
    }

    public static List<XmlIdManagement> findXmlIDs(Object modelInstance) {
        final ArrayList<XmlIdManagement> retval = new ArrayList<XmlIdManagement>();
        ModelInstanceTraverser.traverse(modelInstance, new ModelInstanceTraverser.Visitor(){

            @Override
            public void startInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
                if (firstVisit && o instanceof XmlIdManagement) {
                    XmlIdManagement i = (XmlIdManagement)o;
                    retval.add(i);
                }
            }
        });
        return retval;
    }

    public static void makeUniqueIDs(List<? extends XmlIdManagement> els) {
        Set currentValues = els.stream().map(p -> p.getXmlId()).collect(Collectors.toSet());
        for (XmlIdManagement xmlIdManagement : els) {
            Long l;
            String id = xmlIdManagement.getXmlId();
            if (id != null && !id.isEmpty() && !id.trim().equals("0")) continue;
            while (currentValues.contains((l = Long.valueOf(NEXT_ID.getAndIncrement())).toString())) {
            }
            currentValues.add(l.toString());
            xmlIdManagement.setXmlId(l.toString());
        }
    }
}

