/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.stdtypes;

import javax.persistence.Embeddable;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlType;

@VoDml(ref="ivoa:rational", type=VodmlType.primitiveType)
@Embeddable
public class Rational {
    private int numerator;
    private int denominator;

    public Rational(int _n, int _d) {
        this.numerator = _n;
        this.denominator = _d;
    }

    public Rational(String sv) {
        String[] words = sv.trim().split("[(/)]");
        if (words.length != 2) {
            throw new IllegalArgumentException("String value in constructor must be of form '(%f/%f)'");
        }
        this.numerator = Integer.parseInt(words[0]);
        this.denominator = Integer.parseInt(words[1]);
    }

    public Rational() {
        this(0, 1);
    }

    public final String toString() {
        return String.format("(%d/%d)", this.numerator, this.denominator);
    }

    public int getNumerator() {
        return this.numerator;
    }

    public void setNumerator(int numerator) {
        this.numerator = numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public void setDenominator(int denominator) {
        this.denominator = denominator;
    }
}

