/*
 * Created on 10 Nov 2022 
 * Copyright 2022 Paul Harrison (paul.harrison@manchester.ac.uk)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License in file LICENSE
 */ 

package org.ivoa.vodml.serialization;

import java.io.PrintWriter;

import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.nav.ModelInstanceTraverser;
import org.ivoa.vodml.nav.ModelInstanceTraverser.FullVisitor;
import org.ivoa.vodml.nav.VodmlTypeInfo;

/**
 * This performs serialization to a generic "Instance" format.
 * FIXME this is experimental and something towards a MiVOT like representation.
 * @author Paul Harrison (paul.harrison@manchester.ac.uk) 
 * @since 10 Nov 2022
 */
public class InstanceSerializer<T> {
   public InstanceSerializer(ModelManagement<T> model) {
        logger.error("this class is not suitable for production use yet");//FIXME remove message when OK.
        this.mm = model;
    }

 
    /** logger for this class */
    private static final org.slf4j.Logger logger = org.slf4j.LoggerFactory
            .getLogger(InstanceSerializer.class);

    /**
     *  .
     * @author Paul Harrison (paul.harrison@manchester.ac.uk) 
     * @since 10 Nov 2022
     */
    public class InstanceSerializationVisitor implements FullVisitor {

        private PrintWriter w;
        private int indent = 5;

        /**
         * @param w where the instance is written to.
         */
        public InstanceSerializationVisitor(PrintWriter w) {
            this.w =w;
        }
        private void unindent()
        {
            indent -=3;
            if(indent <1 ) indent=1;
        }

        /**
         * {@inheritDoc}
         * overrides @see org.ivoa.vodml.nav.ModelInstanceTraverser.Visitor#startInstance(java.lang.Object, org.ivoa.vodml.nav.VodmlTypeInfo, boolean)
         */
        @Override
        public void startInstance(Object o, VodmlTypeInfo v,
                boolean firstVisit) {

            switch (v.role) {  
            case objectType:
            case  dataType:
            {
                w.format("%s <INSTANCE dmtype=\"%s\">\n"," ".repeat(indent), v.vodmlRef);
                indent += 3;
                break;
            }
            case  attribute:
            {
                w.format("%s <attribute dmtype=\"%s\">\n"," ".repeat(indent), v.vodmlRef);
                indent += 3;
                break;
            }
            case composition:
            {
                w.format("%s <COMPOSITION>\n"," ".repeat(indent));
                indent += 3;
                break;

            }
            case reference:
            {
                w.format("%s <ref dmtype=\"%s\" first=%s>\n"," ".repeat(indent), v.vodmlRef, firstVisit);
                indent += 3;
                break;
            }
            default:

                logger.debug("starting: {} {} {} ",o,firstVisit,v);
                break;
            }

        }

        /**
         * {@inheritDoc}
         * overrides @see org.ivoa.vodml.nav.ModelInstanceTraverser.FullVisitor#leaf(java.lang.Object, org.ivoa.vodml.nav.VodmlTypeInfo, boolean)
         */
        @Override
        public void leaf(Object o, VodmlTypeInfo v, boolean firstVisit) {
            switch (v.role) {
               case attribute:
               {
                    w.format("%s %s: %s\n"," ".repeat(indent), v.vodmlRef, o);
                    break;
               }

            default:
               

                logger.debug("leaf: {} {} {} ",o,firstVisit,v);
                break;
            }
        }

        /**
         * {@inheritDoc}
         * overrides @see org.ivoa.vodml.nav.ModelInstanceTraverser.FullVisitor#endInstance(java.lang.Object, org.ivoa.vodml.nav.VodmlTypeInfo, boolean)
         */
        @Override
        public void endInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
            switch (v.role) {  
            case objectType:
            case  dataType:
            {
                unindent();
                w.format("%s </INSTANCE>   %s\n"," ".repeat(indent), v.vodmlRef);
                break;
            }
            case  attribute:
            {
                unindent();
                w.format("%s </attribute>   %s\n"," ".repeat(indent), v.vodmlRef);
                break;
            }
            case  reference:
            {
                unindent();
                w.format("%s </ref>   %s\n"," ".repeat(indent), v.vodmlRef);
                break;
            }
            case composition:
            {
                unindent();
                w.format("%s </COMPOSITION>\n"," ".repeat(indent));
                break;

            }
            default:
                logger.debug("ending: {} {} {} ",o,firstVisit,v);
                break;
            }

        }

    }

    /**
     * @param management
     */

    final ModelManagement<T> mm;

    public void serialize(PrintWriter w)
    {
        w.println("<VODML>");
        ModelInstanceTraverser.traverse(mm.getContent(), new InstanceSerializationVisitor(w));
        w.println("</VODML>");
    }


}


