/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.serialization;

import java.io.PrintWriter;
import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.nav.ModelInstanceTraverser;
import org.ivoa.vodml.nav.VodmlTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceSerializer<T> {
    private static final Logger logger = LoggerFactory.getLogger(InstanceSerializer.class);
    final ModelManagement<T> mm;

    public InstanceSerializer(ModelManagement<T> model) {
        logger.error("this class is not suitable for production use yet");
        this.mm = model;
    }

    public void serialize(PrintWriter w) {
        w.println("<VODML>");
        ModelInstanceTraverser.traverse(this.mm.getContent(), (ModelInstanceTraverser.FullVisitor)new InstanceSerializationVisitor(w));
        w.println("</VODML>");
    }

    public class InstanceSerializationVisitor
    implements ModelInstanceTraverser.FullVisitor {
        private PrintWriter w;
        private int indent = 5;

        public InstanceSerializationVisitor(PrintWriter w) {
            this.w = w;
        }

        private void unindent() {
            this.indent -= 3;
            if (this.indent < 1) {
                this.indent = 1;
            }
        }

        @Override
        public void startInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
            switch (v.role) {
                case objectType: 
                case dataType: {
                    this.w.format("%s <INSTANCE dmtype=\"%s\">\n", " ".repeat(this.indent), v.vodmlRef);
                    this.indent += 3;
                    break;
                }
                case attribute: {
                    this.w.format("%s <attribute dmtype=\"%s\">\n", " ".repeat(this.indent), v.vodmlRef);
                    this.indent += 3;
                    break;
                }
                case composition: {
                    this.w.format("%s <COMPOSITION>\n", " ".repeat(this.indent));
                    this.indent += 3;
                    break;
                }
                case reference: {
                    this.w.format("%s <ref dmtype=\"%s\" first=%s>\n", " ".repeat(this.indent), v.vodmlRef, firstVisit);
                    this.indent += 3;
                    break;
                }
                default: {
                    logger.debug("starting: {} {} {} ", new Object[]{o, firstVisit, v});
                }
            }
        }

        @Override
        public void leaf(Object o, VodmlTypeInfo v, boolean firstVisit) {
            switch (v.role) {
                case attribute: {
                    this.w.format("%s %s: %s\n", " ".repeat(this.indent), v.vodmlRef, o);
                    break;
                }
                default: {
                    logger.debug("leaf: {} {} {} ", new Object[]{o, firstVisit, v});
                }
            }
        }

        @Override
        public void endInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
            switch (v.role) {
                case objectType: 
                case dataType: {
                    this.unindent();
                    this.w.format("%s </INSTANCE>   %s\n", " ".repeat(this.indent), v.vodmlRef);
                    break;
                }
                case attribute: {
                    this.unindent();
                    this.w.format("%s </attribute>   %s\n", " ".repeat(this.indent), v.vodmlRef);
                    break;
                }
                case reference: {
                    this.unindent();
                    this.w.format("%s </ref>   %s\n", " ".repeat(this.indent), v.vodmlRef);
                    break;
                }
                case composition: {
                    this.unindent();
                    this.w.format("%s </COMPOSITION>\n", " ".repeat(this.indent));
                    break;
                }
                default: {
                    logger.debug("ending: {} {} {} ", new Object[]{o, firstVisit, v});
                }
            }
        }
    }
}

