/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.validation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.util.ValidationEventCollector;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.Session;
import org.ivoa.vodml.ModelDescription;
import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.VodmlModel;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;
import org.ivoa.vodml.validation.ModelValidator;

public abstract class AbstractBaseValidation {
    protected <T> RoundTripResult<T> roundTripJSON(ModelManagement<T> m) throws JsonProcessingException {
        T model = m.theModel();
        Class<?> clazz = model.getClass();
        ObjectMapper mapper = m.jsonMapper();
        String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(model);
        System.out.println("JSON output");
        System.out.println(json);
        Object retval = mapper.readValue(json, clazz);
        return new RoundTripResult<Object>(true, retval);
    }

    protected <T> RoundTripResult<T> roundtripXML(ModelManagement<T> modelManagement) throws ParserConfigurationException, JAXBException, PropertyException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        T model = modelManagement.theModel();
        Class<?> clazz = model.getClass();
        JAXBContext jc = modelManagement.contextFactory();
        StringWriter sw = new StringWriter();
        Marshaller m = jc.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        m.marshal(model, (Writer)sw);
        TransformerFactory transfac = TransformerFactory.newInstance();
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        StringWriter sw2 = new StringWriter();
        StreamResult result = new StreamResult(sw2);
        trans.transform(new StreamSource(new StringReader(sw.toString())), result);
        System.out.println(sw2.toString());
        Unmarshaller um = jc.createUnmarshaller();
        ValidationEventCollector vc = new ValidationEventCollector();
        um.setEventHandler((ValidationEventHandler)vc);
        JAXBElement el = um.unmarshal((Source)new StreamSource(new StringReader(sw2.toString())), clazz);
        if (vc.hasEvents()) {
            for (ValidationEvent err : vc.getEvents()) {
                System.err.println(err.getMessage());
            }
        }
        Object modelin = el.getValue();
        return new RoundTripResult<Object>(!vc.hasEvents(), modelin);
    }

    protected <M, I, T extends JPAManipulationsForObjectType<I>> RoundTripResult<T> roundtripRDB(ModelManagement<M> modelManagement, T entity) {
        EntityManager em = this.setupH2Db(modelManagement.pu_name());
        em.getTransaction().begin();
        entity.persistRefs(em);
        em.persist(entity);
        em.getTransaction().commit();
        I id = entity.getId();
        em.clear();
        em.getEntityManagerFactory().getCache().evictAll();
        JPAManipulationsForObjectType r = (JPAManipulationsForObjectType)em.createNamedQuery(entity.getClass().getSimpleName() + ".findById", entity.getClass()).setParameter("id", id).getSingleResult();
        return new RoundTripResult<JPAManipulationsForObjectType>(true, r);
    }

    protected EntityManager setupH2Db(String puname) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("jakarta.persistence.jdbc.url", "jdbc:h2:mem:" + puname + ";DB_CLOSE_DELAY=-1");
        props.put("jakarta.persistence.jdbc.driver", "org.h2.Driver");
        props.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        props.put("jakarta.persistence.schema-generation.scripts.create-target", "test.sql");
        props.put("jakarta.persistence.schema-generation.scripts.drop-target", "test-drop.sql");
        props.put("hibernate.hbm2ddl.schema-generation.script.append", "false");
        props.put("jakarta.persistence.schema-generation.create-source", "metadata");
        props.put("jakarta.persistence.schema-generation.database.action", "drop-and-create");
        props.put("jakarta.persistence.schema-generation.scripts.action", "drop-and-create");
        props.put("jakarta.persistence.jdbc.user", "");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)puname, props);
        EntityManager em = emf.createEntityManager();
        return em;
    }

    protected <T> ModelValidator.ValidationResult validateModel(VodmlModel<T> m) throws JAXBException {
        ModelDescription desc = m.descriptor();
        File schemaFile = new File(desc.schemaMap().get(desc.xmlNamespace()));
        ModelValidator v = new ModelValidator(schemaFile, m.management().contextFactory());
        return v.validate(m);
    }

    protected void dumpDbData(EntityManager em, String filename) {
        Session sess = (Session)em.unwrap(Session.class);
        sess.doWork(conn -> {
            PreparedStatement ps = conn.prepareStatement("SCRIPT TO ?");
            ps.setString(1, filename);
            ps.execute();
        });
    }

    public static class RoundTripResult<T> {
        public final boolean isValid;
        public final T retval;

        RoundTripResult(boolean isValid, T retval) {
            this.isValid = isValid;
            this.retval = retval;
        }
    }
}

