/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.validation;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.util.JAXBSource;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModelValidator {
    private static final Logger logger = LoggerFactory.getLogger(ModelValidator.class);
    private final Source[] schemaFiles;
    private final JAXBContext jc;
    protected Map<ErrorKind, List<ErrorDescription>> errorMap;

    public ModelValidator(File schemaFile, JAXBContext jc) {
        this.schemaFiles = new Source[]{new StreamSource(schemaFile)};
        this.jc = jc;
    }

    <T> ValidationResult validate(T p) {
        try {
            this.errorMap = new HashMap<ErrorKind, List<ErrorDescription>>();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(this.schemaFiles);
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new SimpleErrorHandler());
            JAXBSource source = new JAXBSource(this.jc, p);
            validator.validate((Source)source);
        }
        catch (SAXException e) {
            ErrorDescription d = new ErrorDescription(e);
            ModelValidator.put(this.errorMap, d.kind, d);
        }
        catch (JAXBException | IOException e) {
            ErrorDescription d = new ErrorDescription(new RuntimeException(e));
            ModelValidator.put(this.errorMap, d.kind, d);
        }
        return new ValidationResult(this.errorMap.isEmpty(), this.errorMap);
    }

    private static <KEY, VALUE> void put(Map<KEY, List<VALUE>> map, KEY key, VALUE value) {
        map.computeIfAbsent(key, k -> new ArrayList()).add(value);
    }

    private class SimpleErrorHandler
    implements ErrorHandler {
        private SimpleErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            ModelValidator.put(ModelValidator.this.errorMap, kind, err);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            ModelValidator.put(ModelValidator.this.errorMap, kind, err);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            ErrorKind kind = ErrorKind.Warning;
            ErrorDescription err = new ErrorDescription(kind, exception);
            logger.trace(err.toString());
            ModelValidator.put(ModelValidator.this.errorMap, kind, err);
        }
    }

    private class ErrorDescription {
        String desc;
        ErrorKind kind;
        int line;
        int column;

        ErrorDescription(ErrorKind kind, SAXParseException e) {
            this.desc = e.getMessage();
            this.kind = kind;
            this.line = e.getLineNumber();
            this.column = e.getColumnNumber();
        }

        ErrorDescription(SAXException e) {
            this.desc = e.getMessage();
            this.kind = ErrorKind.Sax;
            this.line = 0;
            this.column = 0;
        }

        ErrorDescription(RuntimeException e) {
            this.desc = e.getCause().getMessage();
            this.kind = ErrorKind.Unknown;
            this.line = 0;
            this.column = 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Validation ");
            builder.append((Object)this.kind);
            builder.append(" ").append(this.desc);
            if (this.line > 0) {
                builder.append(" line=");
                builder.append(this.line);
                if (this.column > 0) {
                    builder.append(", column=");
                    builder.append(this.column);
                }
            }
            return builder.toString();
        }
    }

    public static class ValidationResult {
        public final boolean isOk;
        private final Map<ErrorKind, List<ErrorDescription>> errorMap;

        ValidationResult(boolean isOk, Map<ErrorKind, List<ErrorDescription>> errorMap) {
            this.isOk = isOk;
            this.errorMap = new HashMap<ErrorKind, List<ErrorDescription>>(errorMap);
        }

        public void printValidationErrors(PrintStream printStream) {
            this.errorMap.forEach((kind, errors) -> errors.stream().forEach(printStream::println));
        }
    }

    public static enum ErrorKind {
        Unknown,
        Warning,
        Error,
        FatalError,
        Sax;

    }
}

