/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.nav;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.nav.ReflectIveVodmlTypeGetter;
import org.ivoa.vodml.nav.VodmlTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelInstanceTraverser {
    private static final Logger logger = LoggerFactory.getLogger(ModelInstanceTraverser.class);
    private final Map<Object, VodmlTypeInfo> objVisited = new IdentityHashMap<Object, VodmlTypeInfo>();
    private final Map<Class<?>, ClassInfo> classCache = new HashMap();
    private Deque<ObjInfo> stack = new LinkedList<ObjInfo>();

    public static FullVisitor makeFullVisitor(final Visitor vis) {
        return new FullVisitor(){

            @Override
            public void startInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
                vis.startInstance(o, v, firstVisit);
            }

            @Override
            public void leaf(Object o, VodmlTypeInfo v, boolean firstVisit) {
            }

            @Override
            public void endInstance(Object o, VodmlTypeInfo v, boolean firstVisit) {
            }
        };
    }

    public static void traverse(Object o, Visitor visitor) {
        ModelInstanceTraverser.traverse(o, ModelInstanceTraverser.makeFullVisitor(visitor));
    }

    public static void traverse(Object o, FullVisitor visitor) {
        ModelInstanceTraverser traverser;
        ModelInstanceTraverser modelInstanceTraverser = traverser = new ModelInstanceTraverser();
        Objects.requireNonNull(modelInstanceTraverser);
        ObjInfo oi = modelInstanceTraverser.new ObjInfo(o);
        traverser.walk(oi, visitor);
    }

    public static void traverse(List<Object> o, Visitor visitor) {
        ModelInstanceTraverser.traverse(o, ModelInstanceTraverser.makeFullVisitor(visitor));
    }

    public static void traverse(List<Object> o, FullVisitor visitor) {
        ModelInstanceTraverser traverser;
        ModelInstanceTraverser modelInstanceTraverser = traverser = new ModelInstanceTraverser();
        Objects.requireNonNull(modelInstanceTraverser);
        ObjInfo oi = modelInstanceTraverser.new ObjInfo(o, new VodmlTypeInfo("", VodmlRole.model));
        traverser.walk(oi, visitor);
    }

    private void walk(ObjInfo oiroot, FullVisitor visitor) {
        this.stack.add(oiroot);
        visitor.startInstance(oiroot.ob.o, oiroot.ob.vodmlt, !oiroot.alreadyVisited);
        while (!this.stack.isEmpty()) {
            ObjInfo oi = this.stack.peekLast();
            Object current = oi.ob.o;
            if (current == null) {
                this.stack.removeLast();
                continue;
            }
            if (this.objVisited.containsKey(current)) {
                logger.debug("already visited {}", (Object)current.toString());
                this.stack.removeLast();
                continue;
            }
            if (oi.children.hasNext()) {
                ObjBase next = oi.children.next();
                if (next.vodmlt.role == VodmlRole.attribute && next.vodmlt.vodmlTypeRole == VodmlRole.primitiveType) {
                    visitor.leaf(next.o, next.vodmlt, !this.objVisited.containsKey(next.o));
                    continue;
                }
                ObjInfo loi = new ObjInfo(next.o, next.vodmlt);
                visitor.startInstance(next.o, next.vodmlt, !loi.alreadyVisited);
                this.stack.add(loi);
                continue;
            }
            visitor.endInstance(current, oi.ob.vodmlt, !oi.alreadyVisited);
            this.objVisited.put(current, oi.ob.vodmlt);
            this.stack.removeLast();
        }
    }

    private ClassInfo getClassInfo(Object o) {
        Class<?> current = o.getClass();
        ClassInfo cc = this.classCache.get(current);
        if (cc != null) {
            return cc;
        }
        cc = new ClassInfo(o);
        this.classCache.put(current, cc);
        return cc;
    }

    private static boolean donotexaminefields(Class<?> c) {
        return c.isPrimitive() || c.isEnum() || c.getCanonicalName().startsWith("java") || c.getAnnotation(VoDml.class) == null;
    }

    private static class ClassInfo {
        boolean container = false;
        final Collection<Field> refFields = new ArrayList<Field>();
        final Class<?> clazz;

        public ClassInfo(Object o) {
            this.clazz = o.getClass();
            if (ModelInstanceTraverser.donotexaminefields(this.clazz)) {
                if (this.clazz.isArray() || o instanceof Collection || o instanceof Map) {
                    this.container = true;
                }
                return;
            }
            Collection<Field> fields = ClassInfo.getDeepDeclaredFields(this.clazz);
            for (Field field : fields) {
                this.refFields.add(field);
            }
        }

        private static Collection<Field> getDeepDeclaredFields(Class<?> c) {
            ArrayList<Field> fields = new ArrayList<Field>();
            for (Class<?> curr = c; curr != null; curr = curr.getSuperclass()) {
                if (ModelInstanceTraverser.donotexaminefields(curr)) continue;
                ClassInfo.getDeclaredFields(curr, fields);
            }
            return fields;
        }

        private static void getDeclaredFields(Class<?> c, Collection<Field> fields) {
            try {
                Field[] local;
                for (Field field : local = c.getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception ignored) {
                        logger.warn("ignored exception", (Throwable)ignored);
                    }
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) || field.getName().startsWith("this$")) continue;
                    fields.add(field);
                }
            }
            catch (Throwable ignored) {
                throw new RuntimeException("exception in model reflection code ", ignored);
            }
        }
    }

    private class ObjInfo {
        final Iterator<ObjBase> children;
        final boolean alreadyVisited;
        final ObjBase ob;

        public ObjInfo(Object o, VodmlTypeInfo t) {
            this(modelInstanceTraverser.new ObjBase(o, t));
        }

        public ObjInfo(Object o) {
            this(modelInstanceTraverser.new ObjBase(o));
        }

        private ObjInfo(ObjBase inob) {
            this.ob = inob;
            if (ModelInstanceTraverser.this.objVisited.containsKey(this.ob.o)) {
                logger.trace("object {} has already been visited");
                this.children = new ArrayList().iterator();
                this.alreadyVisited = true;
            } else {
                this.alreadyVisited = false;
                if (this.ob.o.getClass().isArray()) {
                    this.children = Arrays.stream((Object[])this.ob.o).map(ao -> ao != null ? new ObjBase(ao) : null).iterator();
                } else if (this.ob.o instanceof Collection) {
                    Collection col = (Collection)this.ob.o;
                    ArrayList vals = new ArrayList(col.size());
                    col.forEach(co -> {
                        if (co != null) {
                            vals.add(new ObjBase(co));
                        }
                    });
                    this.children = vals.iterator();
                } else if (this.ob.o instanceof Map) {
                    Map m = (Map)this.ob.o;
                    ArrayList vals = new ArrayList(m.size() * 2);
                    m.forEach((t, u) -> {
                        vals.add(new ObjBase(t));
                        vals.add(new ObjBase(u));
                    });
                    this.children = vals.iterator();
                } else if (this.ob.vodmlt.role != VodmlRole.primitiveType) {
                    ArrayList<ObjBase> vals = new ArrayList<ObjBase>(this.ob.c.refFields.size());
                    for (Field field : this.ob.c.refFields) {
                        try {
                            Object value = field.get(this.ob.o);
                            if (value != null && field.isAnnotationPresent(VoDml.class)) {
                                vals.add(new ObjBase(value, new ReflectIveVodmlTypeGetter(field).vodmlInfo()));
                                continue;
                            }
                            logger.debug("field {} ignored as it is NULL or has no VO-DML type information", (Object)field);
                        }
                        catch (IllegalAccessException ignored) {
                            logger.warn("ignored exception", (Throwable)ignored);
                        }
                    }
                    this.children = vals.iterator();
                } else {
                    this.children = new ArrayList().iterator();
                }
            }
        }

        public ObjInfo(ClassInfo c, VodmlTypeInfo vodmlt) {
            this.ob = new ObjBase(null, c, vodmlt);
            this.children = new ArrayList().iterator();
            this.alreadyVisited = false;
        }
    }

    private class ObjBase {
        final Object o;
        final VodmlTypeInfo vodmlt;
        final ClassInfo c;

        public ObjBase(Object o) {
            this(o, modelInstanceTraverser.getClassInfo(o), new ReflectIveVodmlTypeGetter(o.getClass()).vodmlInfo());
        }

        public ObjBase(Object o, VodmlTypeInfo t) {
            this(o, modelInstanceTraverser.getClassInfo(o), t);
        }

        private ObjBase(Object o, ClassInfo c, VodmlTypeInfo vodmlt) {
            this.o = o;
            this.vodmlt = vodmlt;
            this.c = c;
        }
    }

    public static interface FullVisitor
    extends Visitor {
        public void leaf(Object var1, VodmlTypeInfo var2, boolean var3);

        public void endInstance(Object var1, VodmlTypeInfo var2, boolean var3);
    }

    @FunctionalInterface
    public static interface Visitor {
        public void startInstance(Object var1, VodmlTypeInfo var2, boolean var3);
    }
}

