/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.nav;

import java.lang.reflect.Field;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.nav.VodmlTypeGetter;
import org.ivoa.vodml.nav.VodmlTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectIveVodmlTypeGetter
implements VodmlTypeGetter {
    private static final Logger logger = LoggerFactory.getLogger(ReflectIveVodmlTypeGetter.class);
    private final VoDml vodmlann;
    private final String id;
    private final VodmlTypeInfo info;

    public ReflectIveVodmlTypeGetter(Class<?> c) {
        this.vodmlann = c.getAnnotation(VoDml.class);
        this.id = c.getCanonicalName();
        if (this.vodmlann != null) {
            this.info = new VodmlTypeInfo(this.vodmlann.id(), this.vodmlann.role());
        } else {
            logger.trace("no VODML meta information for {}  - this should be expected  ", (Object)this.id);
            this.info = VodmlTypeInfo.UNKNOWN;
        }
    }

    public ReflectIveVodmlTypeGetter(Field f) {
        this.vodmlann = f.getAnnotation(VoDml.class);
        this.id = f.getName();
        if (this.vodmlann != null) {
            switch (this.vodmlann.role()) {
                case attribute: {
                    this.info = new VodmlTypeInfo(this.vodmlann.id(), this.vodmlann.role(), this.vodmlann.type(), this.vodmlann.typeRole());
                    break;
                }
                default: {
                    this.info = new VodmlTypeInfo(this.vodmlann.id(), this.vodmlann.role(), this.vodmlann.type());
                    break;
                }
            }
        } else {
            logger.trace("no VODML meta information for {} - this should be expected ", (Object)this.id);
            this.info = VodmlTypeInfo.UNKNOWN;
        }
    }

    @Override
    public VodmlTypeInfo vodmlInfo() {
        return this.info;
    }
}

