/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.vodml.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.ivoa.vodml.VodmlModel;
import org.ivoa.vodml.validation.AbstractBaseValidation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AutoRoundTripTest<M extends VodmlModel<M>>
extends AbstractBaseValidation {
    public abstract M createModel();

    public abstract void testModel(M var1);

    @Test
    void testXmlRoundTrip() throws JAXBException, TransformerConfigurationException, ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException, IOException {
        M model = this.createModel();
        AbstractBaseValidation.RoundTripResult result = this.roundtripXML(model);
        Assertions.assertTrue((boolean)result.isValid, (String)"reading XML back had errors");
        Assertions.assertNotNull(result.retval, (String)"returned object from XML serialization null");
        this.testModel((VodmlModel)result.retval);
    }

    @Test
    void testJSONRoundTrip() throws JsonProcessingException {
        M model = this.createModel();
        AbstractBaseValidation.RoundTripResult result = this.roundTripJSON(model);
        Assertions.assertTrue((boolean)result.isValid, (String)"reading JSON back had errors");
        Assertions.assertNotNull(result.retval, (String)"returned object from JSON serialization null");
        this.testModel((VodmlModel)result.retval);
    }
}

