/*
 * Decompiled with CFR 0.152.
 */
package org.jastronomy.jsofa;

import org.jastronomy.jsofa.JSOFAIllegalParameter;
import org.jastronomy.jsofa.JSOFAInternalError;

public class JSOFA {
    public static final String SOFA_RELEASE = "2016-07-29";
    public static final String SOFA_REVISION = "12";
    public static final double DS2R = 7.27220521664304E-5;
    public static final double DPI = Math.PI;
    public static final double D2PI = Math.PI * 2;
    public static final double DR2D = 57.29577951308232;
    public static final double DD2R = Math.PI / 180;
    public static final double DR2AS = 206264.80624709636;
    public static final double DAS2R = 4.84813681109536E-6;
    public static final double TURNAS = 1296000.0;
    public static final double DMAS2R = 4.84813681109536E-9;
    public static final double DTY = 365.242198781;
    public static final double DJ00 = 2451545.0;
    public static final double DJM0 = 2400000.5;
    public static final double DJM00 = 51544.5;
    public static final double DAYSEC = 86400.0;
    public static final double DJY = 365.25;
    public static final double DJC = 36525.0;
    public static final double DJM = 365250.0;
    public static final double DJM77 = 43144.0;
    public static final double TTMTAI = 32.184;
    public static final double DAU = 1.4959787E11;
    public static final double CMPS = 2.99792458E8;
    public static final double AULT = 499.004782;
    public static final double DC = 173.1446333113497;
    public static final double ELG = 6.969290134E-10;
    public static final double ELB = 1.550519768E-8;
    public static final double SRS = 1.97412574336E-8;
    public static final double TDB0 = -6.55E-5;
    public static final int IYV = 2016;
    static final LeapInfo[] leapSeconds = new LeapInfo[]{new LeapInfo(1960, 1, 1.417818), new LeapInfo(1961, 1, 1.422818), new LeapInfo(1961, 8, 1.372818), new LeapInfo(1962, 1, 1.845858), new LeapInfo(1963, 11, 1.945858), new LeapInfo(1964, 1, 3.24013), new LeapInfo(1964, 4, 3.34013), new LeapInfo(1964, 9, 3.44013), new LeapInfo(1965, 1, 3.54013), new LeapInfo(1965, 3, 3.64013), new LeapInfo(1965, 7, 3.74013), new LeapInfo(1965, 9, 3.84013), new LeapInfo(1966, 1, 4.31317), new LeapInfo(1968, 2, 4.21317), new LeapInfo(1972, 1, 10.0), new LeapInfo(1972, 7, 11.0), new LeapInfo(1973, 1, 12.0), new LeapInfo(1974, 1, 13.0), new LeapInfo(1975, 1, 14.0), new LeapInfo(1976, 1, 15.0), new LeapInfo(1977, 1, 16.0), new LeapInfo(1978, 1, 17.0), new LeapInfo(1979, 1, 18.0), new LeapInfo(1980, 1, 19.0), new LeapInfo(1981, 7, 20.0), new LeapInfo(1982, 7, 21.0), new LeapInfo(1983, 7, 22.0), new LeapInfo(1985, 7, 23.0), new LeapInfo(1988, 1, 24.0), new LeapInfo(1990, 1, 25.0), new LeapInfo(1991, 1, 26.0), new LeapInfo(1992, 7, 27.0), new LeapInfo(1993, 7, 28.0), new LeapInfo(1994, 7, 29.0), new LeapInfo(1996, 1, 30.0), new LeapInfo(1997, 7, 31.0), new LeapInfo(1999, 1, 32.0), new LeapInfo(2006, 1, 33.0), new LeapInfo(2009, 1, 34.0), new LeapInfo(2012, 7, 35.0), new LeapInfo(2015, 7, 36.0), new LeapInfo(2017, 1, 37.0)};
    private static int[][] mfals;
    private static final int[][] mfapl;

    private static double dint(double A) {
        return A < 0.0 ? StrictMath.ceil(A) : StrictMath.floor(A);
    }

    private static double dnint(double A) {
        return A < 0.0 ? StrictMath.ceil(A - 0.5) : StrictMath.floor(A + 0.5);
    }

    private static double dsign(double A, double B) {
        return B < 0.0 ? -StrictMath.abs(A) : StrictMath.abs(A);
    }

    public static char jauA2af(int ndp, double angle, int[] idmsf) {
        double F = 2.3873241463784303;
        char retval = JSOFA.jauD2tf(ndp, angle * 2.3873241463784303, idmsf);
        return retval;
    }

    public static char jauA2tf(int ndp, double angle, int[] ihmsf) {
        return JSOFA.jauD2tf(ndp, angle / (Math.PI * 2), ihmsf);
    }

    public static double jauAnp(double a) {
        double w = JSOFA.fmod(a, Math.PI * 2);
        if (w < 0.0) {
            w += Math.PI * 2;
        }
        return w;
    }

    public static double jauAnpm(double a) {
        double w = JSOFA.fmod(a, Math.PI * 2);
        if (StrictMath.abs(w) >= Math.PI) {
            w -= JSOFA.dsign(Math.PI * 2, a);
        }
        return w;
    }

    public static FrameBias jauBi00() {
        double DPBIAS = -2.0253091528350866E-7;
        double DEBIAS = -3.3060414542221477E-8;
        double DRA0 = -7.078279744199226E-8;
        FrameBias retval = new FrameBias();
        retval.dpsibi = -2.0253091528350866E-7;
        retval.depsbi = -3.3060414542221477E-8;
        retval.dra = -7.078279744199226E-8;
        return retval;
    }

    public static void jauBp00(double date1, double date2, double[][] rb, double[][] rp, double[][] rbp) {
        double EPS0 = 0.40909280422232897;
        double[][] rbw = new double[3][3];
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        FrameBias fb = JSOFA.jauBi00();
        double dpsibi = fb.dpsibi;
        double depsbi = fb.depsbi;
        double dra0 = fb.dra;
        double psia77 = (5038.7784 + (-1.07259 + -0.001147 * t) * t) * t * 4.84813681109536E-6;
        double oma77 = 0.40909280422232897 + (0.05127 + -0.007726 * t) * t * t * 4.84813681109536E-6;
        double chia = (10.5526 + (-2.38064 + -0.001125 * t) * t) * t * 4.84813681109536E-6;
        PrecessionDeltaTerms pc = JSOFA.jauPr00(date1, date2);
        double dpsipr = pc.dpsipr;
        double depspr = pc.depspr;
        double psia = psia77 + dpsipr;
        double oma = oma77 + depspr;
        JSOFA.jauIr(rbw);
        JSOFA.jauRz(dra0, rbw);
        JSOFA.jauRy(dpsibi * StrictMath.sin(0.40909280422232897), rbw);
        JSOFA.jauRx(-depsbi, rbw);
        JSOFA.jauCr(rbw, rb);
        JSOFA.jauIr(rp);
        JSOFA.jauRx(0.40909280422232897, rp);
        JSOFA.jauRz(-psia, rp);
        JSOFA.jauRx(-oma, rp);
        JSOFA.jauRz(chia, rp);
        double[][] rt = JSOFA.jauRxr(rp, rbw);
        JSOFA.jauCr(rt, rbp);
    }

    public static void jauBp06(double date1, double date2, double[][] rb, double[][] rp, double[][] rbp) {
        FWPrecessionAngles fw = JSOFA.jauPfw06(2400000.5, 51544.5);
        double[][] rt = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib, fw.epsa);
        JSOFA.jauCr(rt, rb);
        rt = JSOFA.jauPmat06(date1, date2);
        JSOFA.jauCr(rt, rbp);
        double[][] rbt = JSOFA.jauTr(rb);
        rt = JSOFA.jauRxr(rbp, rbt);
        JSOFA.jauCr(rt, rp);
    }

    public static CelestialIntermediatePole jauBpn2xy(double[][] rbpn) {
        return new CelestialIntermediatePole(rbpn[2][0], rbpn[2][1]);
    }

    public static double[][] jauC2i00a(double date1, double date2) {
        double[][] rbpn = JSOFA.jauPnm00a(date1, date2);
        double[][] rc2i = JSOFA.jauC2ibpn(date1, date2, rbpn);
        return rc2i;
    }

    public static double[][] jauC2i00b(double date1, double date2) {
        double[][] rbpn = JSOFA.jauPnm00b(date1, date2);
        double[][] rc2i = JSOFA.jauC2ibpn(date1, date2, rbpn);
        return rc2i;
    }

    public static double[][] jauC2i06a(double date1, double date2) {
        double[][] rbpn = JSOFA.jauPnm06a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS06(date1, date2, cip.x, cip.y);
        double[][] rc2i = JSOFA.jauC2ixys(cip.x, cip.y, s);
        return rc2i;
    }

    public static double[][] jauC2ibpn(double date1, double date2, double[][] rbpn) {
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double[][] rc2i = JSOFA.jauC2ixy(date1, date2, cip.x, cip.y);
        return rc2i;
    }

    public static double[][] jauC2ixy(double date1, double date2, double x, double y) {
        double[][] rc2i = JSOFA.jauC2ixys(x, y, JSOFA.jauS00(date1, date2, x, y));
        return rc2i;
    }

    public static double[][] jauC2ixys(double x, double y, double s) {
        double[][] rc2i = new double[3][3];
        double r2 = x * x + y * y;
        double e = r2 > 0.0 ? StrictMath.atan2(y, x) : 0.0;
        double d = StrictMath.atan(StrictMath.sqrt(r2 / (1.0 - r2)));
        JSOFA.jauIr(rc2i);
        JSOFA.jauRz(e, rc2i);
        JSOFA.jauRy(d, rc2i);
        JSOFA.jauRz(-(e + s), rc2i);
        return rc2i;
    }

    public static SphericalCoordinate jauC2s(double[] p) {
        double x = p[0];
        double y = p[1];
        double z = p[2];
        double d2 = x * x + y * y;
        double theta = d2 == 0.0 ? 0.0 : StrictMath.atan2(y, x);
        double phi = z == 0.0 ? 0.0 : StrictMath.atan2(z, StrictMath.sqrt(d2));
        return new SphericalCoordinate(theta, phi);
    }

    public static double[][] jauC2t00a(double tta, double ttb, double uta, double utb, double xp, double yp) {
        double[][] rc2i = new double[3][3];
        rc2i = JSOFA.jauC2i00a(tta, ttb);
        double era = JSOFA.jauEra00(uta, utb);
        double sp = JSOFA.jauSp00(tta, ttb);
        double[][] rpom = JSOFA.jauPom00(xp, yp, sp);
        double[][] rc2t = JSOFA.jauC2tcio(rc2i, era, rpom);
        return rc2t;
    }

    public static double[][] jauC2t00b(double tta, double ttb, double uta, double utb, double xp, double yp) {
        double[][] rc2i = JSOFA.jauC2i00b(tta, ttb);
        double era = JSOFA.jauEra00(uta, utb);
        double[][] rpom = JSOFA.jauPom00(xp, yp, 0.0);
        double[][] rc2t = JSOFA.jauC2tcio(rc2i, era, rpom);
        return rc2t;
    }

    public static double[][] jauC2t06a(double tta, double ttb, double uta, double utb, double xp, double yp) {
        double[][] rc2i = JSOFA.jauC2i06a(tta, ttb);
        double era = JSOFA.jauEra00(uta, utb);
        double sp = JSOFA.jauSp00(tta, ttb);
        double[][] rpom = JSOFA.jauPom00(xp, yp, sp);
        double[][] rc2t = JSOFA.jauC2tcio(rc2i, era, rpom);
        return rc2t;
    }

    public static double[][] jauC2tcio(double[][] rc2i, double era, double[][] rpom) {
        double[][] r = new double[3][3];
        JSOFA.jauCr(rc2i, r);
        JSOFA.jauRz(era, r);
        double[][] rc2t = JSOFA.jauRxr(rpom, r);
        return rc2t;
    }

    public static double[][] jauC2teqx(double[][] rbpn, double gst, double[][] rpom) {
        double[][] r = new double[3][3];
        JSOFA.jauCr(rbpn, r);
        JSOFA.jauRz(gst, r);
        double[][] rc2t = JSOFA.jauRxr(rpom, r);
        return rc2t;
    }

    public static double[][] jauC2tpe(double tta, double ttb, double uta, double utb, double dpsi, double deps, double xp, double yp) {
        PrecessionNutation pn = JSOFA.jauPn00(tta, ttb, dpsi, deps);
        double gmst = JSOFA.jauGmst00(uta, utb, tta, ttb);
        double ee = JSOFA.jauEe00(tta, ttb, pn.epsa, dpsi);
        double sp = JSOFA.jauSp00(tta, ttb);
        double[][] rpom = JSOFA.jauPom00(xp, yp, sp);
        double[][] rc2t = JSOFA.jauC2teqx(pn.rbpn, gmst + ee, rpom);
        return rc2t;
    }

    public static double[][] jauC2txy(double tta, double ttb, double uta, double utb, double x, double y, double xp, double yp) {
        double[][] rc2i = new double[3][3];
        double[][] rpom = new double[3][3];
        rc2i = JSOFA.jauC2ixy(tta, ttb, x, y);
        double era = JSOFA.jauEra00(uta, utb);
        double sp = JSOFA.jauSp00(tta, ttb);
        rpom = JSOFA.jauPom00(xp, yp, sp);
        double[][] rc2t = JSOFA.jauC2tcio(rc2i, era, rpom);
        return rc2t;
    }

    public static JulianDate jauCal2jd(int iy, int im, int id) throws JSOFAIllegalParameter {
        int ly;
        int IYMIN = -4799;
        int[] mtab = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (iy < -4799) {
            throw new JSOFAIllegalParameter("bad year", -1);
        }
        if (im < 1 || im > 12) {
            throw new JSOFAIllegalParameter("bad month", -2);
        }
        int n = ly = im == 2 && iy % 4 == 0 && (iy % 100 != 0 || iy % 400 == 0) ? 1 : 0;
        if (id < 1 || id > mtab[im - 1] + ly) {
            // empty if block
        }
        int my = (im - 14) / 12;
        long iypmy = iy + my;
        double djm0 = 2400000.5;
        double djm = 1461L * (iypmy + 4800L) / 4L + 367L * (long)(im - 2 - 12 * my) / 12L - 3L * ((iypmy + 4900L) / 100L) / 4L + (long)id - 2432076L;
        return new JulianDate(djm0, djm);
    }

    public static double[] jauCp(double[] p, double[] c) {
        c[0] = p[0];
        c[1] = p[1];
        c[2] = p[2];
        return c;
    }

    public static double[][] jauCpv(double[][] pv, double[][] c) {
        c[0] = JSOFA.jauCp(pv[0], c[0]);
        c[1] = JSOFA.jauCp(pv[1], c[1]);
        return c;
    }

    public static void jauCr(double[][] r, double[][] c) {
        JSOFA.jauCp(r[0], c[0]);
        JSOFA.jauCp(r[1], c[1]);
        JSOFA.jauCp(r[2], c[2]);
    }

    public static char jauD2tf(int ndp, double days, int[] ihmsf) {
        double rs;
        int n;
        int nrs;
        char sign = days >= 0.0 ? (char)'+' : '-';
        double a = 86400.0 * StrictMath.abs(days);
        if (ndp < 0) {
            nrs = 1;
            for (n = 1; n <= -ndp; ++n) {
                nrs *= n == 2 || n == 4 ? 6 : 10;
            }
            rs = nrs;
            double w = a / rs;
            a = rs * JSOFA.dnint(w);
        }
        nrs = 1;
        for (n = 1; n <= ndp; ++n) {
            nrs *= 10;
        }
        rs = nrs;
        double rm = rs * 60.0;
        double rh = rm * 60.0;
        a = JSOFA.dnint(rs * a);
        double ah = a / rh;
        ah = JSOFA.dint(ah);
        double am = (a -= ah * rh) / rm;
        am = JSOFA.dint(am);
        double as = (a -= am * rm) / rs;
        as = JSOFA.dint(as);
        double af = a - as * rs;
        ihmsf[0] = (int)ah;
        ihmsf[1] = (int)am;
        ihmsf[2] = (int)as;
        ihmsf[3] = (int)af;
        return sign;
    }

    public static CalendarHMS jauD2dtf(String scale, int ndp, double d1, double d2) throws JSOFAIllegalParameter, JSOFAInternalError {
        int id2;
        int im2;
        int iy2;
        int[] ihmsf1 = new int[4];
        double a1 = d1;
        double b1 = d2;
        Calendar cal = JSOFA.jauJd2cal(a1, b1);
        int iy1 = cal.iy;
        int im1 = cal.im;
        int id1 = cal.id;
        double fd = cal.fd;
        boolean leap = false;
        if (scale.equalsIgnoreCase("UTC")) {
            double dat0 = JSOFA.jauDat(iy1, im1, id1, 0.0);
            double dat12 = JSOFA.jauDat(iy1, im1, id1, 0.5);
            cal = JSOFA.jauJd2cal(a1 + 1.5, b1 - fd);
            iy2 = cal.iy;
            im2 = cal.im;
            id2 = cal.id;
            double dat24 = JSOFA.jauDat(iy2, im2, id2, 0.0);
            double dleap = dat24 - (2.0 * dat12 - dat0);
            boolean bl = leap = dleap != 0.0;
            if (leap) {
                fd += fd * dleap / 86400.0;
            }
        }
        JSOFA.jauD2tf(ndp, fd, ihmsf1);
        if (ihmsf1[0] > 23) {
            cal = JSOFA.jauJd2cal(a1 + 1.5, b1 - fd);
            iy2 = cal.iy;
            im2 = cal.im;
            id2 = cal.id;
            if (!leap) {
                iy1 = iy2;
                im1 = im2;
                id1 = id2;
                ihmsf1[0] = 0;
                ihmsf1[1] = 0;
                ihmsf1[2] = 0;
            } else {
                if (ihmsf1[2] > 0) {
                    iy1 = iy2;
                    im1 = im2;
                    id1 = id2;
                    ihmsf1[0] = 0;
                    ihmsf1[1] = 0;
                    ihmsf1[2] = 0;
                } else {
                    ihmsf1[0] = 23;
                    ihmsf1[1] = 59;
                    ihmsf1[2] = 60;
                }
                if (ndp < 0 && ihmsf1[2] == 60) {
                    iy1 = iy2;
                    im1 = im2;
                    id1 = id2;
                    ihmsf1[0] = 0;
                    ihmsf1[1] = 0;
                    ihmsf1[2] = 0;
                }
            }
        }
        return new CalendarHMS(iy1, im1, id1, ihmsf1);
    }

    public static JulianDate jauDtf2d(String scale, int iy, int im, int id, int ihr, int imn, double sec) throws JSOFAIllegalParameter, JSOFAInternalError {
        int js = 0;
        JulianDate jd = JSOFA.jauCal2jd(iy, im, id);
        double dj = jd.djm0;
        double w = jd.djm1;
        dj += w;
        double day = 86400.0;
        double seclim = 60.0;
        if (scale.equals("UTC")) {
            double dat0 = JSOFA.jauDat(iy, im, id, 0.0);
            double dat12 = JSOFA.jauDat(iy, im, id, 0.5);
            Calendar cal = JSOFA.jauJd2cal(dj, 1.5);
            int iy2 = cal.iy;
            int im2 = cal.im;
            int id2 = cal.id;
            w = cal.fd;
            double dat24 = JSOFA.jauDat(iy2, im2, id2, 0.0);
            double dleap = dat24 - (2.0 * dat12 - dat0);
            day += dleap;
            if (ihr == 23 && imn == 59) {
                seclim += dleap;
            }
        }
        if (ihr >= 0 && ihr <= 23) {
            if (imn >= 0 && imn <= 59) {
                if (sec >= 0.0) {
                    if (sec >= seclim) {
                        js += 2;
                    }
                } else {
                    js = -6;
                }
            } else {
                js = -5;
            }
        } else {
            js = -4;
        }
        if (js < 0) {
            throw new JSOFAInternalError("problem with time", js);
        }
        double time = (60.0 * (double)(60 * ihr + imn) + sec) / day;
        return new JulianDate(dj, time);
    }

    public static double jauDat(int iy, int im, int id, double fd) throws JSOFAIllegalParameter, JSOFAInternalError {
        int i;
        double[][] drift = new double[][]{{37300.0, 0.001296}, {37300.0, 0.001296}, {37300.0, 0.001296}, {37665.0, 0.0011232}, {37665.0, 0.0011232}, {38761.0, 0.001296}, {38761.0, 0.001296}, {38761.0, 0.001296}, {38761.0, 0.001296}, {38761.0, 0.001296}, {38761.0, 0.001296}, {38761.0, 0.001296}, {39126.0, 0.002592}, {39126.0, 0.002592}};
        int NERA1 = drift.length;
        int NDAT = leapSeconds.length;
        double da = 0.0;
        double deltat = 0.0;
        if (fd < 0.0 || fd > 1.0) {
            throw new JSOFAIllegalParameter("bad day fraction", -4);
        }
        JulianDate jd = JSOFA.jauCal2jd(iy, im, id);
        double djm = jd.djm1;
        if (iy < JSOFA.leapSeconds[0].iyear) {
            throw new JSOFAInternalError("year before UTC start", 1);
        }
        if (iy > 2021) {
            // empty if block
        }
        int m = 12 * iy + im;
        for (i = NDAT - 1; i >= 0 && m < 12 * JSOFA.leapSeconds[i].iyear + JSOFA.leapSeconds[i].month; --i) {
        }
        da = JSOFA.leapSeconds[i].delat;
        if (i < NERA1) {
            da += (djm + fd - drift[i][0]) * drift[i][1];
        }
        deltat = da;
        return deltat;
    }

    /*
     * Opcode count of 13778 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static double jauDtdb(double date1, double date2, double ut, double elong, double u, double v) {
        int j;
        double[][] fairhd = new double[][]{{0.001656674564, 6283.075849991, 6.240054195}, {2.2417471E-5, 5753.384884897, 4.296977442}, {1.3839792E-5, 12566.151699983, 6.19690441}, {4.770086E-6, 529.690965095, 0.444401603}, {4.67674E-6, 6069.776754553, 4.021195093}, {2.256707E-6, 213.299095438, 5.543113262}, {1.694205E-6, -3.523118349, 5.025132748}, {1.554905E-6, 77713.77146792, 5.19846709}, {1.276839E-6, 7860.419392439, 5.988822341}, {1.193379E-6, 5223.693919802, 3.64982373}, {1.115322E-6, 3930.20969622, 1.422745069}, {7.94185E-7, 11506.769769794, 2.322313077}, {4.47061E-7, 26.2983198, 3.615796498}, {4.35206E-7, -398.149003408, 4.349338347}, {6.00309E-7, 1577.343542448, 2.678271909}, {4.96817E-7, 6208.294251424, 5.696701824}, {4.86306E-7, 5884.926846583, 0.520007179}, {4.32392E-7, 74.781598567, 2.435898309}, {4.68597E-7, 6244.942814354, 5.866398759}, {3.7551E-7, 5507.553238667, 4.103476804}, {2.43085E-7, -775.522611324, 3.651837925}, {1.73435E-7, 18849.227549974, 6.153743485}, {2.30685E-7, 5856.477659115, 4.773852582}, {2.03747E-7, 12036.460734888, 4.333987818}, {1.43935E-7, -796.298006816, 5.957517795}, {1.5908E-7, 10977.078804699, 1.890075226}, {1.19979E-7, 38.133035638, 4.551585768}, {1.18971E-7, 5486.777843175, 1.914547226}, {1.1612E-7, 1059.381930189, 0.873504123}, {1.37927E-7, 11790.629088659, 1.135934669}, {9.8358E-8, 2544.314419883, 0.092793886}, {1.01868E-7, -5573.142801634, 5.984503847}, {8.0164E-8, 206.185548437, 2.095377709}, {7.9645E-8, 4694.002954708, 2.949233637}, {6.2617E-8, 20.775395492, 2.654394814}, {7.5019E-8, 2942.463423292, 4.980931759}, {6.4397E-8, 5746.271337896, 1.280308748}, {6.3814E-8, 5760.498431898, 4.167901731}, {4.8042E-8, 2146.165416475, 1.495846011}, {4.8373E-8, 155.420399434, 2.25157373}, {5.8844E-8, 426.598190876, 4.839650148}, {4.6551E-8, -0.980321068, 0.921573539}, {5.4139E-8, 17260.15465469, 3.411091093}, {4.2411E-8, 6275.962302991, 2.869567043}, {4.0184E-8, -7.113547001, 3.565975565}, {3.6564E-8, 5088.628839767, 3.324679049}, {4.0759E-8, 12352.852604545, 3.981496998}, {3.6507E-8, 801.820931124, 6.248866009}, {3.6955E-8, 3154.687084896, 5.071801441}, {4.2732E-8, 632.783739313, 5.720622217}, {4.256E-8, 161000.685737473, 1.270837679}, {4.048E-8, 15720.838784878, 2.546610123}, {2.8244E-8, -6286.59896834, 5.069663519}, {3.3477E-8, 6062.663207553, 4.144987272}, {3.4867E-8, 522.577418094, 5.210064075}, {3.2438E-8, 6076.890301554, 0.749317412}, {3.0215E-8, 7084.896781115, 3.389610345}, {2.9247E-8, -71430.695617928, 4.183178762}, {3.3529E-8, 9437.762934887, 2.404714239}, {3.2423E-8, 8827.390269875, 5.541473556}, {2.7567E-8, 6279.552731642, 5.040846034}, {2.9862E-8, 12139.553509107, 1.770181024}, {2.2509E-8, 10447.387839604, 1.460726241}, {2.0937E-8, 8429.241266467, 0.652303414}, {2.0322E-8, 419.484643875, 3.735430632}, {2.4816E-8, -1194.447010225, 1.087136918}, {2.5196E-8, 1748.016413067, 2.901883301}, {2.1691E-8, 14143.495242431, 5.952658009}, {1.7673E-8, 6812.766815086, 3.186129845}, {2.2567E-8, 6133.512652857, 3.307984806}, {1.6155E-8, 10213.285546211, 1.331103168}, {1.4751E-8, 1349.867409659, 4.308933301}, {1.5949E-8, -220.412642439, 4.00529827}, {1.5974E-8, -2352.866153772, 6.145309371}, {1.4223E-8, 17789.845619785, 2.104551349}, {1.7806E-8, 73.297125859, 3.475975097}, {1.3671E-8, -536.804512095, 5.971672571}, {1.1942E-8, 8031.092263058, 2.053414715}, {1.4318E-8, 16730.463689596, 3.016058075}, {1.2462E-8, 103.092774219, 1.737438797}, {1.0962E-8, 3.590428652, 2.196567739}, {1.5078E-8, 19651.048481098, 3.96948077}, {1.0396E-8, 951.718406251, 5.717799605}, {1.1707E-8, -4705.732307544, 2.654125618}, {1.0453E-8, 5863.591206116, 1.91370455}, {1.242E-8, 4690.479836359, 4.734090399}, {1.1847E-8, 5643.178563677, 5.489005403}, {8.61E-9, 3340.6124267, 3.661698944}, {1.1622E-8, 5120.601145584, 4.863931876}, {1.0825E-8, 553.569402842, 0.842715011}, {8.666E-9, -135.065080035, 3.293406547}, {9.963E-9, 149.563197135, 4.870690598}, {9.858E-9, 6309.374169791, 1.06181641}, {7.959E-9, 316.391869657, 2.465042647}, {1.0099E-8, 283.859318865, 1.942176992}, {7.147E-9, -242.728603974, 3.661486981}, {7.505E-9, 5230.807466803, 4.920937029}, {8.323E-9, 11769.853693166, 1.229392026}, {7.49E-9, -6256.777530192, 3.658444681}, {9.37E-9, 149854.400134205, 0.673880395}, {7.117E-9, 38.027672636, 5.294249518}, {7.857E-9, 12168.002696575, 0.525733528}, {7.019E-9, 6206.809778716, 0.83768881}, {6.056E-9, 955.599741609, 4.194535082}, {8.107E-9, 13367.972631107, 3.793235253}, {6.731E-9, 5650.292110678, 5.639906583}, {7.332E-9, 36.64856293, 0.114858677}, {6.366E-9, 4164.311989613, 2.262081818}, {6.858E-9, 5216.580372801, 0.642063318}, {6.919E-9, 6681.2248534, 6.018501522}, {6.826E-9, 7632.94325965, 3.458654112}, {5.308E-9, -1592.596013633, 2.500382359}, {5.096E-9, 11371.704689758, 2.547107806}, {4.841E-9, 5333.900241022, 0.437078094}, {5.582E-9, 5966.683980335, 2.246174308}, {6.304E-9, 11926.254413669, 2.512929171}, {6.603E-9, 23581.258177318, 5.393136889}, {5.123E-9, -1.484472708, 2.999641028}, {4.648E-9, 1589.072895284, 1.27584709}, {5.119E-9, 6438.496249426, 1.486539246}, {4.521E-9, 4292.33083295, 6.140635794}, {5.68E-9, 23013.539539587, 4.557814849}, {5.488E-9, -3.455808046, 0.090675389}, {4.193E-9, 7234.794256242, 4.869091389}, {3.742E-9, 7238.6755916, 4.69197618}, {4.148E-9, -110.206321219, 3.016173439}, {4.553E-9, 11499.656222793, 5.554998314}, {4.892E-9, 5436.99301524, 1.475415597}, {4.044E-9, 4732.030627343, 1.398784824}, {4.164E-9, 12491.370101415, 5.650931916}, {4.349E-9, 11513.883316794, 2.181745369}, {3.919E-9, 12528.018664345, 5.823319737}, {3.129E-9, 6836.645252834, 0.003844094}, {4.08E-9, -7058.598461315, 3.690360123}, {3.27E-9, 76.266071276, 1.517189902}, {2.954E-9, 6283.143160294, 4.447203799}, {2.872E-9, 28.449187468, 1.158692983}, {2.881E-9, 735.876513532, 0.34925025}, {3.279E-9, 5849.364112115, 4.893384368}, {3.625E-9, 6209.778724132, 1.473760578}, {3.074E-9, 949.17560897, 5.185878737}, {2.775E-9, 9917.69687451, 1.030026325}, {2.646E-9, 10973.55568635, 3.918259169}, {2.575E-9, 25132.303399966, 6.109659023}, {3.5E-9, 263.083923373, 1.892100742}, {2.74E-9, 18319.53658488, 4.32051951}, {2.464E-9, 202.253395174, 4.698203059}, {2.409E-9, 2.542797281, 5.325009315}, {3.354E-9, -90955.551694697, 1.942656623}, {2.296E-9, 6496.374945429, 5.061810696}, {3.002E-9, 6172.869528772, 2.797822767}, {3.202E-9, 27511.467873537, 0.531673101}, {2.954E-9, -6283.008539689, 4.533471191}, {2.353E-9, 639.897286314, 3.734548088}, {2.401E-9, 16200.772724501, 2.60554707}, {3.053E-9, 233141.314403759, 3.029030662}, {3.024E-9, 83286.914269554, 2.355556099}, {2.863E-9, 17298.182327326, 5.240963796}, {2.103E-9, -7079.373856808, 5.756641637}, {2.303E-9, 83996.847317911, 2.013686814}, {2.303E-9, 18073.70493865, 1.08910041}, {2.381E-9, 63.735898303, 0.759188178}, {2.493E-9, 6386.16862421, 0.645026535}, {2.366E-9, 3.932153263, 6.215885448}, {2.169E-9, 11015.106477335, 4.845297676}, {2.397E-9, 6243.458341645, 3.809290043}, {2.183E-9, 1162.474704408, 6.179611691}, {2.353E-9, 6246.427287062, 4.78171976}, {2.199E-9, -245.831646229, 5.956152284}, {1.729E-9, 3894.181829542, 1.264976635}, {1.896E-9, -3128.388765096, 4.914231596}, {2.085E-9, 35.164090221, 1.405158503}, {2.024E-9, 14712.317116458, 2.752035928}, {1.737E-9, 6290.189396992, 5.280820144}, {2.229E-9, 491.557929457, 1.571007057}, {1.602E-9, 14314.16811305, 4.203664806}, {2.186E-9, 454.909366527, 1.402101526}, {1.897E-9, 22483.848574493, 4.167932508}, {1.825E-9, -3738.761430108, 0.545828785}, {1.894E-9, 1052.268383188, 5.81716745}, {1.421E-9, 20.355319399, 2.419886601}, {1.408E-9, 10984.1923517, 2.732084787}, {1.847E-9, 10873.98603048, 2.903477885}, {1.391E-9, -8635.942003763, 0.5938915}, {1.388E-9, -7.046236698, 1.166145902}, {1.81E-9, -88860.057071188, 0.487355242}, {1.288E-9, -1990.745017041, 3.91302288}, {1.297E-9, 23543.230504682, 3.063805171}, {1.335E-9, -266.607041722, 3.995764039}, {1.376E-9, 10969.965257698, 5.152914309}, {1.745E-9, 244287.600007027, 3.626395673}, {1.649E-9, 31441.677569757, 1.95204926}, {1.416E-9, 9225.539273283, 4.996408389}, {1.238E-9, 4804.209275927, 5.503379738}, {1.472E-9, 4590.910180489, 4.164913291}, {1.169E-9, 6040.347246017, 5.841719038}, {1.039E-9, 5540.085789459, 2.769753519}, {1.004E-9, -170.672870619, 0.755008103}, {1.284E-9, 10575.406682942, 5.306538209}, {1.278E-9, 71.812653151, 4.713486491}, {1.321E-9, 18209.33026366, 2.624866359}, {1.297E-9, 21228.392023546, 0.382603541}, {9.54E-10, 6282.095528923, 0.882213514}, {1.145E-9, 6058.731054289, 1.169483931}, {9.79E-10, 5547.19933646, 5.448375984}, {9.87E-10, -6262.300454499, 2.656486959}, {1.07E-9, -154717.609887482, 1.827624012}, {9.91E-10, 4701.116501708, 4.387001801}, {1.155E-9, -14.227094002, 3.04270075}, {1.176E-9, 277.034993741, 3.335519004}, {8.9E-10, 13916.019109642, 5.601498297}, {8.84E-10, -1551.045222648, 1.088831705}, {8.76E-10, 5017.508371365, 3.969902609}, {8.06E-10, 15110.466119866, 5.142876744}, {7.73E-10, -4136.910433516, 0.022067765}, {1.077E-9, 175.1660598, 1.844913056}, {9.54E-10, -6284.05617106, 0.968480906}, {7.37E-10, 5326.786694021, 4.923831588}, {8.45E-10, -433.711737877, 4.749245231}, {8.19E-10, 8662.240323563, 5.991247817}, {8.52E-10, 199.072001436, 2.189604979}, {7.23E-10, 17256.631536341, 6.068719637}, {9.4E-10, 6037.244203762, 6.197428148}, {8.85E-10, 11712.955318231, 3.280414875}, {7.06E-10, 12559.038152982, 2.824848947}, {7.32E-10, 2379.164473572, 2.501813417}, {7.64E-10, -6127.655450557, 2.236346329}, {9.08E-10, 131.541961686, 2.52125749}, {9.07E-10, 35371.887265976, 3.370195967}, {6.73E-10, 1066.49547719, 3.876512374}, {8.14E-10, 17654.78053975, 4.627122566}, {6.3E-10, 36.027866677, 0.156368499}, {7.98E-10, 515.463871093, 5.151962502}, {7.98E-10, 148.078724426, 5.909225055}, {8.06E-10, 309.278322656, 6.054064447}, {6.07E-10, -39.617508346, 2.839021623}, {6.01E-10, 412.371096874, 3.984225404}, {6.46E-10, 11403.676995575, 3.852959484}, {7.04E-10, 13521.751441591, 2.300991267}, {6.03E-10, -65147.619767937, 4.140083146}, {6.09E-10, 10177.257679534, 0.437122327}, {6.31E-10, 5767.611978898, 4.026532329}, {5.76E-10, 11087.285125918, 4.760293101}, {6.74E-10, 14945.316173554, 6.270510511}, {7.26E-10, 5429.879468239, 6.039606892}, {7.1E-10, 28766.924424484, 5.672617711}, {6.47E-10, 11856.218651625, 3.397132627}, {6.78E-10, -5481.254918868, 6.249666675}, {6.18E-10, 22003.91463487, 2.466427018}, {7.38E-10, 6134.997125565, 2.24266889}, {6.6E-10, 625.670192312, 5.864091907}, {6.94E-10, 3496.032826134, 2.668309141}, {5.31E-10, 6489.261398429, 1.68188878}, {6.11E-10, -143571.324284214, 2.424978312}, {5.75E-10, 12043.574281889, 4.2164924}, {5.53E-10, 12416.588502848, 4.772158039}, {6.89E-10, 4686.889407707, 6.224271088}, {4.95E-10, 7342.457780181, 3.817285811}, {5.67E-10, 3634.621024518, 1.64926469}, {5.15E-10, 18635.928454536, 3.945345892}, {4.86E-10, -323.505416657, 4.061673868}, {6.62E-10, 25158.601719765, 1.794058369}, {5.09E-10, 846.082834751, 3.053874588}, {4.72E-10, -12569.674818332, 5.112133338}, {4.61E-10, 6179.983075773, 0.513669325}, {6.41E-10, 83467.156352816, 3.210727723}, {5.2E-10, 10344.295065386, 2.445597761}, {4.93E-10, 18422.629359098, 1.676939306}, {4.78E-10, 1265.567478626, 5.487314569}, {4.72E-10, -18.159247265, 1.999707589}, {5.59E-10, 11190.377900137, 5.783236356}, {4.94E-10, 9623.688276691, 3.022645053}, {4.63E-10, 5739.157790895, 1.411223013}, {4.32E-10, 16858.482532933, 1.179256434}, {5.74E-10, 72140.628666286, 1.75819183}, {4.84E-10, 17267.268201691, 3.290589143}, {5.5E-10, 4907.302050146, 0.864024298}, {3.99E-10, 14.977853527, 2.09444191}, {4.91E-10, 224.344795702, 0.878372791}, {4.32E-10, 20426.571092422, 6.003829241}, {4.81E-10, 5749.452731634, 4.309591964}, {4.8E-10, 5757.31703816, 1.142348571}, {4.85E-10, 6702.560493867, 0.210580917}, {4.26E-10, 6055.549660552, 4.274476529}, {4.8E-10, 5959.570433334, 5.03135103}, {4.66E-10, 12562.628581634, 4.959581597}, {5.2E-10, 39302.096962196, 4.788002889}, {4.58E-10, 12132.439962106, 1.880103788}, {4.7E-10, 12029.347187887, 1.405611197}, {4.16E-10, -7477.522860216, 1.08235633}, {4.49E-10, 11609.862544012, 4.179989585}, {4.65E-10, 17253.04110769, 0.353496295}, {3.62E-10, -4535.059436924, 1.583849576}, {3.83E-10, 21954.157609398, 3.747376371}, {3.89E-10, 17.252277143, 1.395753179}, {3.31E-10, 18052.929543158, 0.566790582}, {4.3E-10, 13517.870106233, 0.685827538}, {3.68E-10, -5756.908003246, 0.731374317}, {3.3E-10, 10557.594160824, 3.71004368}, {3.32E-10, 20199.094959633, 1.652901407}, {3.84E-10, 11933.36796067, 5.827781531}, {3.87E-10, 10454.501386605, 2.541182564}, {3.25E-10, 15671.081759407, 2.178850542}, {3.18E-10, 138.517496871, 2.253253037}, {3.05E-10, 9388.005909415, 0.578340206}, {3.52E-10, 5749.861766548, 3.000297967}, {3.11E-10, 6915.859589305, 1.693574249}, {2.97E-10, 24072.921469776, 1.997249392}, {3.63E-10, -640.877607382, 5.071820966}, {3.23E-10, 12592.450019783, 1.072262823}, {3.41E-10, 12146.667056108, 4.700657997}, {2.9E-10, 9779.108676125, 1.812320441}, {3.42E-10, 6132.028180148, 4.322238614}, {3.29E-10, 6268.84875599, 3.033827743}, {3.74E-10, 17996.031168222, 3.388716544}, {2.85E-10, -533.214083444, 4.687313233}, {3.38E-10, 6065.84460129, 0.877776108}, {2.76E-10, 24.298513841, 0.770299429}, {3.36E-10, -2388.894020449, 5.353796034}, {2.9E-10, 3097.883822726, 4.075291557}, {3.18E-10, 709.933048357, 5.941207518}, {2.71E-10, 13095.842665077, 3.208912203}, {3.31E-10, 6073.708907816, 4.007881169}, {2.92E-10, 742.990060533, 2.714333592}, {3.62E-10, 29088.811415985, 3.215977013}, {2.8E-10, 12359.966151546, 0.710872502}, {2.67E-10, 10440.274292604, 4.730108488}, {2.62E-10, 838.96928775, 1.327720272}, {2.5E-10, 16496.361396202, 0.898769761}, {3.25E-10, 20597.243963041, 0.180044365}, {2.68E-10, 6148.010769956, 5.152666276}, {2.84E-10, 5636.065016677, 5.655385808}, {3.01E-10, 6080.822454817, 2.135396205}, {2.94E-10, -377.373607916, 3.708784168}, {2.36E-10, 2118.763860378, 1.733578756}, {2.34E-10, 5867.523359379, 5.575209112}, {2.68E-10, -226858.238553767, 0.069432392}, {2.65E-10, 167283.761587465, 4.369302826}, {2.8E-10, 28237.233459389, 5.304829118}, {2.92E-10, 12345.739057544, 4.096094132}, {2.23E-10, 19800.945956225, 3.069327406}, {3.01E-10, 43232.306658416, 6.205311188}, {2.64E-10, 18875.525869774, 1.417263408}, {3.04E-10, -1823.175188677, 3.409035232}, {3.01E-10, 109.945688789, 0.510922054}, {2.6E-10, 813.55028396, 2.389438934}, {2.99E-10, 316428.228673312, 5.384595078}, {2.11E-10, 5756.566278634, 3.789392838}, {2.09E-10, 5750.203491159, 1.661943545}, {2.4E-10, 12489.885628707, 5.684549045}, {2.16E-10, 6303.851245484, 3.862942261}, {2.03E-10, 1581.959348283, 5.549853589}, {2.0E-10, 5642.198242609, 1.016115785}, {1.97E-10, -70.849445304, 4.690702525}, {2.27E-10, 6287.008003254, 2.911891613}, {1.97E-10, 533.623118358, 1.048982898}, {2.05E-10, -6279.48542134, 1.82936273}, {2.09E-10, -10988.808157535, 2.636140084}, {2.08E-10, -227.52618944, 4.127883842}, {1.91E-10, 415.552490612, 4.40116565}, {1.9E-10, 29296.615389579, 4.175658539}, {2.64E-10, 66567.485864652, 4.601102551}, {2.56E-10, -3646.350377354, 0.506364778}, {1.88E-10, 13119.721102825, 2.032195842}, {1.85E-10, -209.366942175, 4.694756586}, {1.98E-10, 25934.124331089, 3.832703118}, {1.95E-10, 4061.219215394, 3.308463427}, {2.34E-10, 5113.487598583, 1.716090661}, {1.88E-10, 1478.866574064, 5.68686578}, {2.22E-10, 11823.16163945, 1.942386641}, {1.81E-10, 10770.893256262, 1.999482059}, {1.71E-10, 6546.159773364, 1.182807992}, {2.06E-10, 70.328180442, 5.934076062}, {1.69E-10, 20995.392966449, 2.169080622}, {1.91E-10, 10660.686935042, 5.405515999}, {2.28E-10, 33019.021112205, 4.656985514}, {1.84E-10, -4933.208440333, 3.327476868}, {2.2E-10, -135.62532501, 1.765430262}, {1.66E-10, 23141.558382925, 3.454132746}, {1.91E-10, 6144.558353121, 5.020393445}, {1.8E-10, 6084.003848555, 0.602182191}, {1.63E-10, 17782.732072784, 4.960593133}, {2.25E-10, 16460.333529525, 2.596451817}, {2.22E-10, 5905.702242076, 3.731990323}, {2.04E-10, 227.476132789, 5.636192701}, {1.59E-10, 16737.577236597, 3.600691544}, {2.0E-10, 6805.653268085, 0.868220961}, {1.87E-10, 11919.140866668, 2.629456641}, {1.61E-10, 127.471796607, 2.86257472}, {2.05E-10, 6286.666278643, 1.742882331}, {1.89E-10, 153.778810485, 4.812372643}, {1.68E-10, 16723.350142595, 0.027860588}, {1.49E-10, 11720.068865232, 0.659721876}, {1.89E-10, 5237.921013804, 5.245313}, {1.43E-10, 6709.674040867, 4.317625647}, {1.46E-10, 4487.81740627, 4.815297007}, {1.44E-10, -664.75604513, 5.38136688}, {1.75E-10, 5127.714692584, 4.728443327}, {1.62E-10, 6254.626662524, 1.435132069}, {1.87E-10, 47162.516354635, 1.354371923}, {1.46E-10, 11080.171578918, 3.369695406}, {1.8E-10, -348.924420448, 2.490902145}, {1.48E-10, 151.047669843, 3.799109588}, {1.57E-10, 6197.24855116, 1.284375887}, {1.67E-10, 146.594251718, 0.759969109}, {1.33E-10, -5331.357443741, 5.409701889}, {1.54E-10, 95.979227218, 3.366890614}, {1.48E-10, -6418.140930027, 3.384104996}, {1.28E-10, -6525.804453965, 3.803419985}, {1.3E-10, 11293.470674356, 0.939039445}, {1.52E-10, -5729.506447149, 0.734117523}, {1.38E-10, 210.1177017, 2.564216078}, {1.23E-10, 6066.595360816, 4.517099537}, {1.4E-10, 18451.078546566, 0.64204913}, {1.26E-10, 11300.584221356, 3.485280663}, {1.19E-10, 10027.903195729, 3.217431161}, {1.51E-10, 4274.518310832, 4.404359108}, {1.17E-10, 6072.958148291, 0.36632465}, {1.65E-10, -7668.637425143, 4.298212528}, {1.17E-10, -6245.048177356, 5.379518958}, {1.3E-10, -5888.449964932, 4.527681115}, {1.21E-10, -543.918059096, 6.109429504}, {1.62E-10, 9683.594581116, 5.720092446}, {1.41E-10, 6219.339951688, 0.679068671}, {1.18E-10, 22743.409379516, 4.881123092}, {1.29E-10, 1692.165669502, 0.351407289}, {1.26E-10, 5657.405657679, 5.146592349}, {1.14E-10, 728.762966531, 0.520791814}, {1.2E-10, 52.5966396, 0.9485163}, {1.15E-10, 65.220371012, 3.504914846}, {1.26E-10, 5881.403728234, 5.577502482}, {1.58E-10, 163096.180360983, 2.957128968}, {1.34E-10, 12341.806904281, 2.598576764}, {1.51E-10, 16627.370915377, 3.98570205}, {1.09E-10, 1368.660252845, 0.014730471}, {1.31E-10, 6211.263196841, 0.085077024}, {1.46E-10, 5792.741760812, 0.708426604}, {1.46E-10, -77.750543984, 3.1215766}, {1.07E-10, 5341.013788022, 0.288231904}, {1.38E-10, 6281.591377283, 2.797450317}, {1.13E-10, -6277.552925684, 2.788904128}, {1.15E-10, -525.758811831, 5.8952222}, {1.38E-10, 6016.46880827, 6.096188999}, {1.39E-10, 23539.707386333, 2.028195445}, {1.46E-10, -4176.041342449, 4.660008502}, {1.07E-10, 16062.184526117, 4.066520001}, {1.42E-10, 83783.548222473, 2.936315115}, {1.28E-10, 9380.959672717, 3.223844306}, {1.35E-10, 6205.325306007, 1.638054048}, {1.01E-10, 2699.734819318, 5.481603249}, {1.04E-10, -568.821874027, 2.205734493}, {1.03E-10, 6321.103522627, 2.440421099}, {1.19E-10, 6321.208885629, 2.547496264}, {1.38E-10, 1975.492545856, 2.314608466}, {1.21E-10, 137.033024162, 4.539108237}, {1.23E-10, 19402.796952817, 4.538074405}, {1.19E-10, 22805.735565994, 2.869040566}, {1.33E-10, 64471.991241142, 6.056405489}, {1.29E-10, -85.827298831, 2.540635083}, {1.31E-10, 13613.804277336, 4.005732868}, {1.04E-10, 9814.604100291, 1.959967212}, {1.12E-10, 16097.679950283, 3.58902626}, {1.23E-10, 2107.034507542, 1.728627253}, {1.21E-10, 36949.230808424, 6.072332087}, {1.08E-10, -12539.853380183, 3.716133846}, {1.13E-10, -7875.671863624, 2.725771122}, {1.09E-10, 4171.425536614, 4.033338079}, {1.01E-10, 6247.91175977, 3.441347021}, {1.13E-10, 7330.728427345, 0.656372122}, {1.13E-10, 51092.726050855, 2.791483066}, {1.06E-10, 5621.84292321, 1.815323326}, {1.01E-10, 111.430161497, 5.711033677}, {1.03E-10, 909.818733055, 2.812745443}, {1.01E-10, 1790.642637886, 1.965746028}, {1.02156724E-4, 6283.075849991, 4.249032005}, {1.706807E-6, 12566.151699983, 4.205904248}, {2.69668E-7, 213.299095438, 3.400290479}, {2.65919E-7, 529.690965095, 5.836047367}, {2.10568E-7, -3.523118349, 6.262738348}, {7.7996E-8, 5223.693919802, 4.670344204}, {5.4764E-8, 1577.343542448, 4.53480017}, {5.9146E-8, 26.2983198, 1.083044735}, {3.442E-8, -398.149003408, 5.980077351}, {3.2088E-8, 18849.227549974, 4.162913471}, {3.3595E-8, 5507.553238667, 5.980162321}, {2.9198E-8, 5856.477659115, 0.623811863}, {2.7764E-8, 155.420399434, 3.745318113}, {2.519E-8, 5746.271337896, 2.980330535}, {2.2997E-8, -796.298006816, 1.174411803}, {2.4976E-8, 5760.498431898, 2.46791369}, {2.1774E-8, 206.185548437, 3.85478754}, {1.7925E-8, -775.522611324, 1.092065955}, {1.3794E-8, 426.598190876, 2.699831988}, {1.3276E-8, 6062.663207553, 5.84580192}, {1.1774E-8, 12036.460734888, 2.292832062}, {1.2869E-8, 6076.890301554, 5.33342568}, {1.2152E-8, 1059.381930189, 6.222874454}, {1.1081E-8, -7.113547001, 5.154724984}, {1.0143E-8, 4694.002954708, 4.044013795}, {9.357E-9, 5486.777843175, 3.416081409}, {1.0084E-8, 522.577418094, 0.749320262}, {8.587E-9, 10977.078804699, 2.777152598}, {8.628E-9, 6275.962302991, 4.562060226}, {8.158E-9, -220.412642439, 5.806891533}, {7.746E-9, 2544.314419883, 1.603197066}, {7.67E-9, 2146.165416475, 3.00020044}, {7.098E-9, 74.781598567, 0.443725817}, {6.18E-9, -536.804512095, 1.302642751}, {5.818E-9, 5088.628839767, 4.827723531}, {4.945E-9, -6286.59896834, 0.26830517}, {4.774E-9, 1349.867409659, 5.808636673}, {4.687E-9, -242.728603974, 5.15489057}, {6.089E-9, 1748.016413067, 4.403765209}, {5.975E-9, -1194.447010225, 2.583472591}, {4.229E-9, 951.718406251, 0.931172179}, {5.264E-9, 553.569402842, 2.336107252}, {3.049E-9, 5643.178563677, 1.36263443}, {2.974E-9, 6812.766815086, 1.583012668}, {3.403E-9, -2352.866153772, 2.552189886}, {3.03E-9, 419.484643875, 5.286473844}, {3.21E-9, -7.046236698, 1.863796539}, {3.058E-9, 9437.762934887, 4.226420633}, {2.589E-9, 12352.852604545, 1.99193582}, {2.927E-9, 5216.580372801, 2.319951253}, {2.425E-9, 5230.807466803, 3.084752833}, {2.656E-9, 3154.687084896, 2.487447866}, {2.445E-9, 10447.387839604, 2.34713916}, {2.99E-9, 4690.479836359, 6.23587205}, {2.89E-9, 5863.591206116, 0.095197563}, {2.498E-9, 6438.496249426, 2.9947798}, {1.889E-9, 8031.092263058, 3.569003717}, {2.567E-9, 801.820931124, 3.425611498}, {1.803E-9, -71430.695617928, 2.192295512}, {1.782E-9, 3.932153263, 5.180433689}, {1.694E-9, -4705.732307544, 4.641779174}, {1.704E-9, -1592.596013633, 3.997097652}, {1.735E-9, 5849.364112115, 0.417558428}, {1.643E-9, 8429.241266467, 2.180619584}, {1.68E-9, 38.133035638, 4.164529426}, {2.045E-9, 7084.896781115, 0.526323854}, {1.458E-9, 4292.33083295, 1.356098141}, {1.437E-9, 20.355319399, 3.89543936}, {1.738E-9, 6279.552731642, 0.087484036}, {1.367E-9, 14143.495242431, 3.987576591}, {1.344E-9, 7234.794256242, 0.090454338}, {1.438E-9, 11499.656222793, 0.974387904}, {1.257E-9, 6836.645252834, 1.509069366}, {1.358E-9, 11513.883316794, 0.49557226}, {1.628E-9, 7632.94325965, 4.968445721}, {1.169E-9, 103.092774219, 2.838496795}, {1.162E-9, 4164.311989613, 3.408387778}, {1.092E-9, 6069.776754553, 3.617942651}, {1.008E-9, 17789.845619785, 0.286350174}, {1.008E-9, 639.897286314, 1.610762073}, {9.18E-10, 10213.285546211, 5.532798067}, {1.011E-9, -6256.777530192, 0.661826484}, {7.53E-10, 16730.463689596, 3.905030235}, {7.37E-10, 11926.254413669, 4.641956361}, {6.94E-10, 3340.6124267, 2.111120332}, {7.01E-10, 3894.181829542, 2.760823491}, {6.89E-10, -135.065080035, 4.76880078}, {7.0E-10, 13367.972631107, 5.760439898}, {6.64E-10, 6040.347246017, 1.05121584}, {6.54E-10, 5650.292110678, 4.911332503}, {7.88E-10, 6681.2248534, 4.699648011}, {6.28E-10, 5333.900241022, 5.024608847}, {7.55E-10, -110.206321219, 4.370971253}, {6.28E-10, 6290.189396992, 3.660478857}, {6.35E-10, 25132.303399966, 4.121051532}, {5.34E-10, 5966.683980335, 1.173284524}, {5.43E-10, -433.711737877, 0.345585464}, {5.17E-10, -1990.745017041, 5.414571768}, {5.04E-10, 5767.611978898, 2.328281115}, {4.85E-10, 5753.384884897, 1.685874771}, {4.63E-10, 7860.419392439, 5.297703006}, {6.04E-10, 515.463871093, 0.591998446}, {4.43E-10, 12168.002696575, 4.830881244}, {5.7E-10, 199.072001436, 3.899190272}, {4.65E-10, 10969.965257698, 0.476681802}, {4.24E-10, -7079.373856808, 1.112242763}, {4.27E-10, 735.876513532, 1.99421448}, {4.78E-10, -6127.655450557, 3.778025483}, {4.14E-10, 10973.55568635, 5.441088327}, {5.12E-10, 1589.072895284, 0.107123853}, {3.78E-10, 10984.1923517, 0.915087231}, {4.02E-10, 11371.704689758, 4.107281715}, {4.53E-10, 9917.69687451, 1.917490952}, {3.95E-10, 149.563197135, 2.763124165}, {3.71E-10, 5739.157790895, 3.112111866}, {3.5E-10, 11790.629088659, 0.440639857}, {3.56E-10, 6133.512652857, 5.444568842}, {3.44E-10, 412.371096874, 5.676832684}, {3.83E-10, 955.599741609, 5.559734846}, {3.33E-10, 6496.374945429, 0.261537984}, {3.4E-10, 6055.549660552, 5.975534987}, {3.34E-10, 1066.49547719, 2.335063907}, {3.99E-10, 11506.769769794, 5.32123091}, {3.14E-10, 18319.53658488, 2.313312404}, {4.24E-10, 1052.268383188, 1.211961766}, {3.07E-10, 63.735898303, 3.169551388}, {3.29E-10, 29.821438149, 6.10691208}, {3.57E-10, 6309.374169791, 4.223760346}, {3.12E-10, -3738.761430108, 2.180556645}, {3.01E-10, 309.278322656, 1.499984572}, {2.68E-10, 12043.574281889, 2.447520648}, {2.57E-10, 12491.370101415, 3.662331761}, {2.9E-10, 625.670192312, 1.272834584}, {2.56E-10, 5429.879468239, 1.913426912}, {3.39E-10, 3496.032826134, 4.165930011}, {2.83E-10, 3930.20969622, 4.325565754}, {2.41E-10, 12528.018664345, 3.832324536}, {3.04E-10, 4686.889407707, 1.612348468}, {2.59E-10, 16200.772724501, 3.470173146}, {2.38E-10, 12139.553509107, 1.147977842}, {2.36E-10, 6172.869528772, 3.776271728}, {2.96E-10, -7058.598461315, 0.460368852}, {3.06E-10, 10575.406682942, 0.554749016}, {2.51E-10, 17298.182327326, 0.83433251}, {2.9E-10, 4732.030627343, 4.759564091}, {2.61E-10, 5884.926846583, 0.298259862}, {2.49E-10, 5547.19933646, 3.749366406}, {2.13E-10, 11712.955318231, 5.415666119}, {2.23E-10, 4701.116501708, 2.703203558}, {2.68E-10, -640.877607382, 0.283670793}, {2.09E-10, 5636.065016677, 1.238477199}, {1.93E-10, 10177.257679534, 1.94325134}, {1.82E-10, 6283.143160294, 2.456157599}, {1.84E-10, -227.52618944, 5.888038582}, {1.82E-10, -6283.008539689, 0.241332086}, {2.28E-10, -6284.05617106, 2.657323816}, {1.66E-10, 7238.6755916, 5.93062911}, {1.67E-10, 3097.883822726, 5.570955333}, {1.59E-10, -323.505416657, 5.7866707}, {1.54E-10, -4136.910433516, 1.517805532}, {1.76E-10, 12029.347187887, 3.139266834}, {1.67E-10, 12132.439962106, 3.556352289}, {1.53E-10, 202.253395174, 1.463313961}, {1.57E-10, 17267.268201691, 1.586837396}, {1.42E-10, 83996.847317911, 0.022670115}, {1.52E-10, 17260.15465469, 0.708528947}, {1.44E-10, 6084.003848555, 5.187075177}, {1.35E-10, 5756.566278634, 1.993229262}, {1.34E-10, 5750.203491159, 3.457197134}, {1.44E-10, 5326.786694021, 6.066193291}, {1.6E-10, 11015.106477335, 1.710431974}, {1.33E-10, 3634.621024518, 2.836451652}, {1.34E-10, 18073.70493865, 5.453106665}, {1.34E-10, 1162.474704408, 5.326898811}, {1.28E-10, 5642.198242609, 2.511652591}, {1.6E-10, 632.783739313, 5.628785365}, {1.32E-10, 13916.019109642, 0.819294053}, {1.22E-10, 14314.16811305, 5.677408071}, {1.25E-10, 12359.966151546, 5.251984735}, {1.21E-10, 5749.452731634, 2.210924603}, {1.36E-10, -245.831646229, 1.646502367}, {1.2E-10, 5757.31703816, 3.240883049}, {1.34E-10, 12146.667056108, 3.059480037}, {1.37E-10, 6206.809778716, 1.867105418}, {1.41E-10, 17253.04110769, 2.069217456}, {1.29E-10, -7477.522860216, 2.781469314}, {1.16E-10, 5540.085789459, 4.281176991}, {1.16E-10, 9779.108676125, 3.320925381}, {1.29E-10, 5237.921013804, 3.497704076}, {1.13E-10, 5959.570433334, 0.98321084}, {1.22E-10, 6282.095528923, 2.67493886}, {1.4E-10, -11.045700264, 4.957936982}, {1.08E-10, 23543.230504682, 1.390113589}, {1.06E-10, -12569.674818332, 0.429631317}, {1.1E-10, -266.607041722, 5.501340197}, {1.15E-10, 12559.038152982, 4.691456618}, {1.34E-10, -2388.894020449, 0.577313584}, {1.09E-10, 10440.274292604, 6.218148717}, {1.02E-10, -543.918059096, 1.477842615}, {1.08E-10, 21228.392023546, 2.237753948}, {1.01E-10, -4535.059436924, 3.100492232}, {1.03E-10, 76.266071276, 5.594294322}, {1.04E-10, 949.17560897, 5.67428781}, {1.01E-10, 13517.870106233, 2.196632348}, {1.0E-10, 11933.36796067, 4.05608416}, {4.32299E-6, 6283.075849991, 2.642893748}, {4.06495E-7, 0.0, 4.71238898}, {1.22605E-7, 12566.151699983, 2.438140634}, {1.9476E-8, 213.299095438, 1.642186981}, {1.6916E-8, 529.690965095, 4.510959344}, {1.3374E-8, -3.523118349, 1.502210314}, {8.042E-9, 26.2983198, 0.478549024}, {7.824E-9, 155.420399434, 5.254710405}, {4.894E-9, 5746.271337896, 4.68321085}, {4.875E-9, 5760.498431898, 0.759507698}, {4.416E-9, 5223.693919802, 6.028853166}, {4.088E-9, -7.113547001, 0.060926389}, {4.433E-9, 77713.77146792, 3.627734103}, {3.277E-9, 18849.227549974, 2.327912542}, {2.703E-9, 6062.663207553, 1.271941729}, {3.435E-9, -775.522611324, 0.747446224}, {2.618E-9, 6076.890301554, 3.633715689}, {3.146E-9, 206.185548437, 5.647874613}, {2.544E-9, 1577.343542448, 6.23290427}, {2.218E-9, -220.412642439, 1.309509946}, {2.197E-9, 5856.477659115, 2.407212349}, {2.897E-9, 5753.384884897, 5.863842246}, {1.766E-9, 426.598190876, 0.754113147}, {1.738E-9, -796.298006816, 2.714942671}, {1.695E-9, 522.577418094, 2.629369842}, {1.584E-9, 5507.553238667, 1.341138229}, {1.503E-9, -242.728603974, 0.377699736}, {1.552E-9, -536.804512095, 2.904684667}, {1.37E-9, -398.149003408, 1.265599125}, {1.889E-9, -5573.142801634, 4.413514859}, {1.722E-9, 6069.776754553, 2.445966339}, {1.124E-9, 1059.381930189, 5.041799657}, {1.258E-9, 553.569402842, 3.849557278}, {8.31E-10, 951.718406251, 2.471094709}, {7.67E-10, 4694.002954708, 5.363125422}, {7.56E-10, 1349.867409659, 1.046195744}, {7.75E-10, -11.045700264, 0.245548001}, {5.97E-10, 2146.165416475, 4.543268798}, {5.68E-10, 5216.580372801, 4.178853144}, {7.11E-10, 1748.016413067, 5.934271972}, {4.99E-10, 12036.460734888, 0.62443441}, {6.71E-10, -1194.447010225, 4.136047594}, {4.88E-10, 5849.364112115, 2.209679987}, {6.21E-10, 6438.496249426, 4.518860804}, {4.95E-10, -6286.59896834, 1.868201275}, {4.56E-10, 5230.807466803, 1.271231591}, {4.51E-10, 5088.628839767, 0.084060889}, {4.35E-10, 5643.178563677, 3.324456609}, {3.87E-10, 10977.078804699, 4.052488477}, {5.47E-10, 161000.685737473, 2.841633844}, {5.22E-10, 3154.687084896, 2.171979966}, {3.75E-10, 5486.777843175, 4.983027306}, {4.21E-10, 5863.591206116, 4.546432249}, {4.39E-10, 7084.896781115, 0.522967921}, {3.09E-10, 2544.314419883, 3.172606705}, {3.47E-10, 4690.479836359, 1.479586566}, {3.17E-10, 801.820931124, 3.553088096}, {2.62E-10, 419.484643875, 0.60663555}, {2.48E-10, 6836.645252834, 3.014082064}, {2.45E-10, -1592.596013633, 5.51952622}, {2.25E-10, 4292.33083295, 2.877956536}, {2.14E-10, 7234.794256242, 1.605227587}, {2.05E-10, 5767.611978898, 0.625804796}, {1.8E-10, 10447.387839604, 3.499954526}, {2.29E-10, 199.072001436, 5.632304604}, {2.14E-10, 639.897286314, 5.960227667}, {1.75E-10, -433.711737877, 2.162417992}, {2.09E-10, 515.463871093, 2.322150893}, {1.73E-10, 6040.347246017, 2.556183691}, {1.84E-10, 6309.374169791, 4.73229679}, {2.27E-10, 149854.400134205, 5.385812217}, {1.54E-10, 8031.092263058, 5.12072092}, {1.51E-10, 5739.157790895, 4.815000443}, {1.97E-10, 7632.94325965, 0.222827271}, {1.97E-10, 74.781598567, 3.91045677}, {1.38E-10, 6055.549660552, 1.397484253}, {1.49E-10, -6127.655450557, 5.333727496}, {1.37E-10, 3894.181829542, 4.281749907}, {1.35E-10, 9437.762934887, 5.979971885}, {1.39E-10, -2352.866153772, 4.715630782}, {1.42E-10, 6812.766815086, 0.513330157}, {1.2E-10, -4705.732307544, 0.194160689}, {1.31E-10, -71430.695617928, 3.79226E-4}, {1.24E-10, 6279.552731642, 2.122264908}, {1.08E-10, -6256.777530192, 0.883445696}, {1.43388E-7, 6283.075849991, 1.131453581}, {6.671E-9, 12566.151699983, 0.775148887}, {1.48E-9, 155.420399434, 0.48001688}, {9.34E-10, 213.299095438, 6.144453084}, {7.95E-10, 529.690965095, 2.941595619}, {6.73E-10, 5746.271337896, 0.120415406}, {6.72E-10, 5760.498431898, 5.317009738}, {3.89E-10, -220.412642439, 3.090323467}, {3.73E-10, 6062.663207553, 3.003551964}, {3.6E-10, 6076.890301554, 1.918913041}, {3.16E-10, -21.340641002, 5.545798121}, {3.15E-10, -242.728603974, 1.884932563}, {2.78E-10, 206.185548437, 1.266254859}, {2.38E-10, -536.804512095, 4.53266483}, {1.85E-10, 522.577418094, 4.578313856}, {2.45E-10, 18849.227549974, 0.587467082}, {1.8E-10, 426.598190876, 5.151178553}, {2.0E-10, 553.569402842, 5.355983739}, {1.41E-10, 5223.693919802, 1.336556009}, {1.04E-10, 5856.477659115, 4.239842759}, {3.826E-9, 6283.075849991, 5.705257275}, {3.03E-10, 12566.151699983, 5.407132842}, {2.09E-10, 155.420399434, 1.989815753}};
        double t = (date1 - 2451545.0 + date2) / 365250.0;
        double tsol = JSOFA.fmod(ut, 1.0) * (Math.PI * 2) + elong;
        double w = t / 3600.0;
        double elsun = JSOFA.fmod(280.46645683 + 1.29602771103429E9 * w, 360.0) * (Math.PI / 180);
        double emsun = JSOFA.fmod(357.52910918 + 1.295965810481E9 * w, 360.0) * (Math.PI / 180);
        double d = JSOFA.fmod(297.85019547 + 1.602961601209E10 * w, 360.0) * (Math.PI / 180);
        double elj = JSOFA.fmod(34.35151874 + 1.0930689989453E8 * w, 360.0) * (Math.PI / 180);
        double els = JSOFA.fmod(50.0774443 + 4.404639847038E7 * w, 360.0) * (Math.PI / 180);
        double wt = 2.9E-14 * u * StrictMath.sin(tsol + elsun - els) + 1.0E-13 * u * StrictMath.sin(tsol - 2.0 * emsun) + 1.33E-13 * u * StrictMath.sin(tsol - d) + 1.33E-13 * u * StrictMath.sin(tsol + elsun - elj) - 2.29E-13 * u * StrictMath.sin(tsol + 2.0 * elsun + emsun) - 2.2E-12 * v * StrictMath.cos(elsun + emsun) + 5.312E-12 * u * StrictMath.sin(tsol - emsun) - 1.3677E-11 * u * StrictMath.sin(tsol + 2.0 * elsun) - 1.3184E-10 * v * StrictMath.cos(elsun) + 3.17679E-10 * u * StrictMath.sin(tsol);
        double w0 = 0.0;
        for (j = 473; j >= 0; --j) {
            w0 += fairhd[j][0] * StrictMath.sin(fairhd[j][1] * t + fairhd[j][2]);
        }
        double w1 = 0.0;
        for (j = 678; j >= 474; --j) {
            w1 += fairhd[j][0] * StrictMath.sin(fairhd[j][1] * t + fairhd[j][2]);
        }
        double w2 = 0.0;
        for (j = 763; j >= 679; --j) {
            w2 += fairhd[j][0] * StrictMath.sin(fairhd[j][1] * t + fairhd[j][2]);
        }
        double w3 = 0.0;
        for (j = 783; j >= 764; --j) {
            w3 += fairhd[j][0] * StrictMath.sin(fairhd[j][1] * t + fairhd[j][2]);
        }
        double w4 = 0.0;
        for (j = 786; j >= 784; --j) {
            w4 += fairhd[j][0] * StrictMath.sin(fairhd[j][1] * t + fairhd[j][2]);
        }
        double wf = t * (t * (t * (t * w4 + w3) + w2) + w1) + w0;
        double wj = 6.5E-10 * StrictMath.sin(6069.776754 * t + 4.021194) + 3.3E-10 * StrictMath.sin(213.299095 * t + 5.543132) + -1.96E-9 * StrictMath.sin(6208.294251 * t + 5.696701) + -1.73E-9 * StrictMath.sin(74.781599 * t + 2.4359) + 3.638E-8 * t * t;
        w = wt + wf + wj;
        return w;
    }

    public static double jauEe00(double date1, double date2, double epsa, double dpsi) {
        double ee = dpsi * StrictMath.cos(epsa) + JSOFA.jauEect00(date1, date2);
        return ee;
    }

    public static double jauEe00a(double date1, double date2) {
        PrecessionDeltaTerms nutd = JSOFA.jauPr00(date1, date2);
        double epsa = JSOFA.jauObl80(date1, date2) + nutd.depspr;
        NutationTerms nut = JSOFA.jauNut00a(date1, date2);
        double ee = JSOFA.jauEe00(date1, date2, epsa, nut.dpsi);
        return ee;
    }

    public static double jauEe00b(double date1, double date2) {
        PrecessionDeltaTerms nutd = JSOFA.jauPr00(date1, date2);
        double epsa = JSOFA.jauObl80(date1, date2) + nutd.depspr;
        NutationTerms nut = JSOFA.jauNut00b(date1, date2);
        double ee = JSOFA.jauEe00(date1, date2, epsa, nut.dpsi);
        return ee;
    }

    public static double jauEe06a(double date1, double date2) {
        double gst06a = JSOFA.jauGst06a(0.0, 0.0, date1, date2);
        double gmst06 = JSOFA.jauGmst06(0.0, 0.0, date1, date2);
        double ee = JSOFA.jauAnpm(gst06a - gmst06);
        return ee;
    }

    public static double jauEect00(double date1, double date2) {
        int j;
        double a;
        int i;
        double[] fa = new double[14];
        TERM[] e0 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 0.00264096, -3.9E-7), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, 6.352E-5, -2.0E-8), new TERM(new int[]{0, 0, 2, -2, 3, 0, 0, 0}, 1.175E-5, 1.0E-8), new TERM(new int[]{0, 0, 2, -2, 1, 0, 0, 0}, 1.121E-5, 1.0E-8), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, -4.55E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 3, 0, 0, 0}, 2.02E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 1, 0, 0, 0}, 1.98E-6, 0.0), new TERM(new int[]{0, 0, 0, 0, 3, 0, 0, 0}, -1.72E-6, 0.0), new TERM(new int[]{0, 1, 0, 0, 1, 0, 0, 0}, -1.41E-6, -1.0E-8), new TERM(new int[]{0, 1, 0, 0, -1, 0, 0, 0}, -1.26E-6, -1.0E-8), new TERM(new int[]{1, 0, 0, 0, -1, 0, 0, 0}, -6.3E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, 1, 0, 0, 0}, -6.3E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 3, 0, 0, 0}, 4.6E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 1, 0, 0, 0}, 4.5E-7, 0.0), new TERM(new int[]{0, 0, 4, -4, 4, 0, 0, 0}, 3.6E-7, 0.0), new TERM(new int[]{0, 0, 1, -1, 1, -8, 12, 0}, -2.4E-7, -1.2E-7), new TERM(new int[]{0, 0, 2, 0, 0, 0, 0, 0}, 3.2E-7, 0.0), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, 2.8E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 3, 0, 0, 0}, 2.7E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 1, 0, 0, 0}, 2.6E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 0, 0, 0, 0}, -2.1E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -3, 0, 0, 0}, 1.9E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -1, 0, 0, 0}, 1.8E-7, 0.0), new TERM(new int[]{0, 0, 0, 0, 0, 8, -13, -1}, -1.0E-7, 5.0E-8), new TERM(new int[]{0, 0, 0, 2, 0, 0, 0, 0}, 1.5E-7, 0.0), new TERM(new int[]{2, 0, -2, 0, -1, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, 1, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 2, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, -1, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{0, 0, 4, -2, 4, 0, 0, 0}, 1.3E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 4, 0, 0, 0}, -1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -3, 0, 0, 0}, 1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -1, 0, 0, 0}, 1.1E-7, 0.0)};
        TERM[] e1 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, -8.7E-7, 0.0)};
        int NE0 = e0.length;
        int NE1 = e1.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        fa[0] = JSOFA.jauFal03(t);
        fa[1] = JSOFA.jauFalp03(t);
        fa[2] = JSOFA.jauFaf03(t);
        fa[3] = JSOFA.jauFad03(t);
        fa[4] = JSOFA.jauFaom03(t);
        fa[5] = JSOFA.jauFave03(t);
        fa[6] = JSOFA.jauFae03(t);
        fa[7] = JSOFA.jauFapa03(t);
        double s0 = 0.0;
        double s1 = 0.0;
        for (i = NE0 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)e0[i].nfa[j] * fa[j];
            }
            s0 += e0[i].s * StrictMath.sin(a) + e0[i].c * StrictMath.cos(a);
        }
        for (i = NE1 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)e1[i].nfa[j] * fa[j];
            }
            s1 += e1[i].s * StrictMath.sin(a) + e1[i].c * StrictMath.cos(a);
        }
        double eect = (s0 + s1 * t) * 4.84813681109536E-6;
        return eect;
    }

    public static ReferenceEllipsoid jauEform(int n) throws JSOFAIllegalParameter {
        double f;
        double a;
        switch (n) {
            case 1: {
                a = 6378137.0;
                f = 0.0033528106647474805;
                break;
            }
            case 2: {
                a = 6378137.0;
                f = 0.003352810681182319;
                break;
            }
            case 3: {
                a = 6378135.0;
                f = 0.003352779454167505;
                break;
            }
            default: {
                double a2 = 0.0;
                double f2 = 0.0;
                throw new JSOFAIllegalParameter("illegal ellipsoid identifier", -1);
            }
        }
        return new ReferenceEllipsoid(a, f);
    }

    public static double jauEo06a(double date1, double date2) {
        double[][] r = JSOFA.jauPnm06a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(r);
        double s = JSOFA.jauS06(date1, date2, cip.x, cip.y);
        double eo = JSOFA.jauEors(r, s);
        return eo;
    }

    public static double jauEors(double[][] rnpb, double s) {
        double x = rnpb[2][0];
        double ax = x / (1.0 + rnpb[2][2]);
        double xs = 1.0 - ax * x;
        double ys = -ax * rnpb[2][1];
        double zs = -x;
        double p = rnpb[0][0] * xs + rnpb[0][1] * ys + rnpb[0][2] * zs;
        double q = rnpb[1][0] * xs + rnpb[1][1] * ys + rnpb[1][2] * zs;
        double eo = p != 0.0 || q != 0.0 ? s - StrictMath.atan2(q, p) : s;
        return eo;
    }

    public static double jauEpb(double dj1, double dj2) {
        double D1900 = 36524.68648;
        return 1900.0 + (dj1 - 2451545.0 + (dj2 + 36524.68648)) / 365.242198781;
    }

    public static JulianDate jauEpb2jd(double epb) {
        double djm0 = 2400000.5;
        double djm = 15019.81352 + (epb - 1900.0) * 365.242198781;
        return new JulianDate(djm0, djm);
    }

    public static double jauEpj(double dj1, double dj2) {
        return 2000.0 + (dj1 - 2451545.0 + dj2) / 365.25;
    }

    public static JulianDate jauEpj2jd(double epj) {
        double djm0 = 2400000.5;
        double djm = 51544.5 + (epj - 2000.0) * 365.25;
        return new JulianDate(djm0, djm);
    }

    public static int jauEpv00(double date1, double date2, double[][] pvh, double[][] pvb) {
        double am12 = 2.11284E-7;
        double am13 = -9.1603E-8;
        double am21 = -2.30286E-7;
        double am22 = 0.917482137087;
        double am23 = -0.397776982902;
        double am32 = 0.397776982902;
        double am33 = 0.917482137087;
        double[][] ce0 = new double[][]{Ephemeris.e0x, Ephemeris.e0y, Ephemeris.e0z};
        double[][] ce1 = new double[][]{Ephemeris.e1x, Ephemeris.e1y, Ephemeris.e1z};
        double[][] ce2 = new double[][]{Ephemeris.e2x, Ephemeris.e2y, Ephemeris.e2z};
        double[][] cs0 = new double[][]{Ephemeris.s0x, Ephemeris.s0y, Ephemeris.s0z};
        double[][] cs1 = new double[][]{Ephemeris.s1x, Ephemeris.s1y, Ephemeris.s1z};
        double[][] cs2 = new double[][]{Ephemeris.s2x, Ephemeris.s2y, Ephemeris.s2z};
        int[] ne0 = new int[]{Ephemeris.e0x.length / 3, Ephemeris.e0y.length / 3, Ephemeris.e0z.length / 3};
        int[] ne1 = new int[]{Ephemeris.e1x.length / 3, Ephemeris.e1y.length / 3, Ephemeris.e1z.length / 3};
        int[] ne2 = new int[]{Ephemeris.e2x.length / 3, Ephemeris.e2y.length / 3, Ephemeris.e2z.length / 3};
        int[] ns0 = new int[]{Ephemeris.s0x.length / 3, Ephemeris.s0y.length / 3, Ephemeris.s0z.length / 3};
        int[] ns1 = new int[]{Ephemeris.s1x.length / 3, Ephemeris.s1y.length / 3, Ephemeris.s1z.length / 3};
        int[] ns2 = new int[]{Ephemeris.s2x.length / 3, Ephemeris.s2y.length / 3, Ephemeris.s2z.length / 3};
        double[] ph = new double[3];
        double[] vh = new double[3];
        double[] pb = new double[3];
        double[] vb = new double[3];
        double t = (date1 - 2451545.0 + date2) / 365.25;
        double t2 = t * t;
        int jstat = StrictMath.abs(t) <= 100.0 ? 0 : 1;
        for (int i = 0; i < 3; ++i) {
            double cp;
            double ct;
            double p;
            double c;
            double b;
            double a;
            int j;
            double xyz = 0.0;
            double xyzd = 0.0;
            int nterms = ne0[i];
            int idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = ce0[i][idx++];
                b = ce0[i][idx++];
                c = ce0[i][idx++];
                p = b + c * t;
                xyz += a * StrictMath.cos(p);
                xyzd -= a * c * StrictMath.sin(p);
            }
            nterms = ne1[i];
            idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = ce1[i][idx++];
                b = ce1[i][idx++];
                c = ce1[i][idx++];
                ct = c * t;
                p = b + ct;
                cp = StrictMath.cos(p);
                xyz += a * t * cp;
                xyzd += a * (cp - ct * StrictMath.sin(p));
            }
            nterms = ne2[i];
            idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = ce2[i][idx++];
                b = ce2[i][idx++];
                c = ce2[i][idx++];
                ct = c * t;
                p = b + ct;
                cp = StrictMath.cos(p);
                xyz += a * t2 * cp;
                xyzd += a * t * (2.0 * cp - ct * StrictMath.sin(p));
            }
            ph[i] = xyz;
            vh[i] = xyzd / 365.25;
            nterms = ns0[i];
            idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = cs0[i][idx++];
                b = cs0[i][idx++];
                c = cs0[i][idx++];
                p = b + c * t;
                xyz += a * StrictMath.cos(p);
                xyzd -= a * c * StrictMath.sin(p);
            }
            nterms = ns1[i];
            idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = cs1[i][idx++];
                b = cs1[i][idx++];
                c = cs1[i][idx++];
                ct = c * t;
                p = b + ct;
                cp = StrictMath.cos(p);
                xyz += a * t * cp;
                xyzd += a * (cp - ct * StrictMath.sin(p));
            }
            nterms = ns2[i];
            idx = 0;
            for (j = 0; j < nterms; ++j) {
                a = cs2[i][idx++];
                b = cs2[i][idx++];
                c = cs2[i][idx++];
                ct = c * t;
                p = b + ct;
                cp = StrictMath.cos(p);
                xyz += a * t2 * cp;
                xyzd += a * t * (2.0 * cp - ct * StrictMath.sin(p));
            }
            pb[i] = xyz;
            vb[i] = xyzd / 365.25;
        }
        double x = ph[0];
        double y = ph[1];
        double z = ph[2];
        pvh[0][0] = x + 2.11284E-7 * y + -9.1603E-8 * z;
        pvh[0][1] = -2.30286E-7 * x + 0.917482137087 * y + -0.397776982902 * z;
        pvh[0][2] = 0.397776982902 * y + 0.917482137087 * z;
        x = vh[0];
        y = vh[1];
        z = vh[2];
        pvh[1][0] = x + 2.11284E-7 * y + -9.1603E-8 * z;
        pvh[1][1] = -2.30286E-7 * x + 0.917482137087 * y + -0.397776982902 * z;
        pvh[1][2] = 0.397776982902 * y + 0.917482137087 * z;
        x = pb[0];
        y = pb[1];
        z = pb[2];
        pvb[0][0] = x + 2.11284E-7 * y + -9.1603E-8 * z;
        pvb[0][1] = -2.30286E-7 * x + 0.917482137087 * y + -0.397776982902 * z;
        pvb[0][2] = 0.397776982902 * y + 0.917482137087 * z;
        x = vb[0];
        y = vb[1];
        z = vb[2];
        pvb[1][0] = x + 2.11284E-7 * y + -9.1603E-8 * z;
        pvb[1][1] = -2.30286E-7 * x + 0.917482137087 * y + -0.397776982902 * z;
        pvb[1][2] = 0.397776982902 * y + 0.917482137087 * z;
        return jstat;
    }

    public static double jauEqeq94(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double om = JSOFA.jauAnpm((450160.28 + (-482890.539 + (7.455 + 0.008 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(-5.0 * t, 1.0) * (Math.PI * 2));
        NutationTerms nt = JSOFA.jauNut80(date1, date2);
        double eps0 = JSOFA.jauObl80(date1, date2);
        double ee = nt.dpsi * StrictMath.cos(eps0) + 4.84813681109536E-6 * (0.00264 * StrictMath.sin(om) + 6.3E-5 * StrictMath.sin(om + om));
        return ee;
    }

    public static double jauEra00(double dj1, double dj2) {
        double d2;
        double d1;
        if (dj1 < dj2) {
            d1 = dj1;
            d2 = dj2;
        } else {
            d1 = dj2;
            d2 = dj1;
        }
        double t = d1 + (d2 - 2451545.0);
        double f = JSOFA.fmod(d1, 1.0) + JSOFA.fmod(d2, 1.0);
        double theta = JSOFA.jauAnp(Math.PI * 2 * (f + 0.779057273264 + 0.00273781191135448 * t));
        return theta;
    }

    public static double jauFad03(double t) {
        double a = JSOFA.fmod(1072260.703692 + t * (1.602961601209E9 + t * (-6.3706 + t * (0.006593 + t * -3.169E-5))), 1296000.0) * 4.84813681109536E-6;
        return a;
    }

    public static double jauFae03(double t) {
        double a = JSOFA.fmod(1.753470314 + 628.3075849991 * t, Math.PI * 2);
        return a;
    }

    public static double jauFaf03(double t) {
        double a = JSOFA.fmod(335779.526232 + t * (1.7395272628478E9 + t * (-12.7512 + t * (-0.001037 + t * 4.17E-6))), 1296000.0) * 4.84813681109536E-6;
        return a;
    }

    public static double jauFaju03(double t) {
        double a = JSOFA.fmod(0.599546497 + 52.9690962641 * t, Math.PI * 2);
        return a;
    }

    public static double jauFal03(double t) {
        double a = JSOFA.fmod(485868.249036 + t * (1.7179159232178E9 + t * (31.8792 + t * (0.051635 + t * -2.447E-4))), 1296000.0) * 4.84813681109536E-6;
        return a;
    }

    public static double jauFalp03(double t) {
        double a = JSOFA.fmod(1287104.793048 + t * (1.295965810481E8 + t * (-0.5532 + t * (1.36E-4 + t * -1.149E-5))), 1296000.0) * 4.84813681109536E-6;
        return a;
    }

    public static double jauFama03(double t) {
        double a = JSOFA.fmod(6.203480913 + 334.06124267 * t, Math.PI * 2);
        return a;
    }

    public static double jauFame03(double t) {
        double a = JSOFA.fmod(4.402608842 + 2608.7903141574 * t, Math.PI * 2);
        return a;
    }

    public static double jauFane03(double t) {
        double a = JSOFA.fmod(5.311886287 + 3.8133035638 * t, Math.PI * 2);
        return a;
    }

    public static double jauFaom03(double t) {
        double a = JSOFA.fmod(450160.398036 + t * (-6962890.5431 + t * (7.4722 + t * (0.007702 + t * -5.939E-5))), 1296000.0) * 4.84813681109536E-6;
        return a;
    }

    public static double jauFapa03(double t) {
        double a = (0.02438175 + 5.38691E-6 * t) * t;
        return a;
    }

    public static double jauFasa03(double t) {
        double a = JSOFA.fmod(0.874016757 + 21.329910496 * t, Math.PI * 2);
        return a;
    }

    public static double jauFaur03(double t) {
        double a = JSOFA.fmod(5.481293872 + 7.4781598567 * t, Math.PI * 2);
        return a;
    }

    public static double jauFave03(double t) {
        double a = JSOFA.fmod(3.176146697 + 1021.3285546211 * t, Math.PI * 2);
        return a;
    }

    public static CatalogCoords jauFk52h(double r5, double d5, double dr5, double dd5, double px5, double rv5) {
        double[][] pv5 = new double[2][3];
        double[][] r5h = new double[3][3];
        double[] s5h = new double[3];
        double[] wxp = new double[3];
        double[] vv = new double[3];
        double[][] pvh = new double[2][3];
        JSOFA.jauStarpv(r5, d5, dr5, dd5, px5, rv5, pv5);
        JSOFA.jauFk5hip(r5h, s5h);
        int i = 0;
        while (i < 3) {
            int n = i++;
            s5h[n] = s5h[n] / 365.25;
        }
        pvh[0] = JSOFA.jauRxp(r5h, pv5[0]);
        wxp = JSOFA.jauPxp(pv5[0], s5h);
        vv = JSOFA.jauPpp(wxp, pv5[1]);
        pvh[1] = JSOFA.jauRxp(r5h, vv);
        CatalogCoords cat = null;
        try {
            cat = JSOFA.jauPvstar(pvh);
        }
        catch (JSOFAInternalError e) {
            e.printStackTrace();
        }
        return cat;
    }

    public static void jauFk5hip(double[][] r5h, double[] s5h) {
        double[] v = new double[3];
        double epx = -9.647792254079767E-8;
        double epy = -4.4118044980967775E-8;
        double epz = 1.1102233297408375E-7;
        double omx = -1.4544410433286077E-9;
        double omy = 2.9088820866572155E-9;
        double omz = 3.3936957677667517E-9;
        v[0] = epx;
        v[1] = epy;
        v[2] = epz;
        double[][] r5ht = JSOFA.jauRv2m(v);
        JSOFA.jauCr(r5ht, r5h);
        s5h[0] = omx;
        s5h[1] = omy;
        s5h[2] = omz;
    }

    public static SphericalCoordinate jauFk5hz(double r5, double d5, double date1, double date2) {
        double rh;
        double[] p5e = new double[3];
        double[][] r5h = new double[3][3];
        double[] s5h = new double[3];
        double[] vst = new double[3];
        double[][] rst = new double[3][3];
        double[] p5 = new double[3];
        double[] ph = new double[3];
        double t = -(date1 - 2451545.0 + date2) / 365.25;
        p5e = JSOFA.jauS2c(r5, d5);
        JSOFA.jauFk5hip(r5h, s5h);
        vst = JSOFA.jauSxp(t, s5h);
        rst = JSOFA.jauRv2m(vst);
        p5 = JSOFA.jauTrxp(rst, p5e);
        ph = JSOFA.jauRxp(r5h, p5);
        SphericalCoordinate sc = JSOFA.jauC2s(ph);
        sc.alpha = rh = JSOFA.jauAnp(sc.alpha);
        return sc;
    }

    public static double[][] jauFw2m(double gamb, double phib, double psi, double eps) {
        double[][] r = new double[3][3];
        JSOFA.jauIr(r);
        JSOFA.jauRz(gamb, r);
        JSOFA.jauRx(phib, r);
        JSOFA.jauRz(-psi, r);
        JSOFA.jauRx(-eps, r);
        return r;
    }

    public static CelestialIntermediatePole jauFw2xy(double gamb, double phib, double psi, double eps) {
        double[][] r = new double[3][3];
        r = JSOFA.jauFw2m(gamb, phib, psi, eps);
        return JSOFA.jauBpn2xy(r);
    }

    public static GeodeticCoord jauGc2gd(int n, double[] xyz) throws JSOFAIllegalParameter {
        ReferenceEllipsoid el = JSOFA.jauEform(n);
        GeodeticCoord gc = JSOFA.jauGc2gde(el.a, el.f, xyz);
        return gc;
    }

    public static GeodeticCoord jauGc2gde(double a, double f, double[] xyz) throws JSOFAIllegalParameter {
        double height;
        double phi;
        if (f < 0.0 || f >= 1.0) {
            throw new JSOFAIllegalParameter("bad f", -1);
        }
        if (a <= 0.0) {
            throw new JSOFAIllegalParameter("bad a", -2);
        }
        double aeps2 = a * a * 1.0E-32;
        double e2 = (2.0 - f) * f;
        double e4t = e2 * e2 * 1.5;
        double ec2 = 1.0 - e2;
        if (ec2 <= 0.0) {
            throw new JSOFAIllegalParameter("bad f", -1);
        }
        double ec = StrictMath.sqrt(ec2);
        double b = a * ec;
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double p2 = x * x + y * y;
        double elong = p2 > 0.0 ? StrictMath.atan2(y, x) : 0.0;
        double absz = StrictMath.abs(z);
        if (p2 > aeps2) {
            double p = StrictMath.sqrt(p2);
            double s0 = absz / a;
            double pn = p / a;
            double zc = ec * s0;
            double c0 = ec * pn;
            double c02 = c0 * c0;
            double c03 = c02 * c0;
            double s02 = s0 * s0;
            double s03 = s02 * s0;
            double a02 = c02 + s02;
            double a0 = StrictMath.sqrt(a02);
            double a03 = a02 * a0;
            double d0 = zc * a03 + e2 * s03;
            double f0 = pn * a03 - e2 * c03;
            double b0 = e4t * s02 * c02 * pn * (a0 - ec);
            double s1 = d0 * f0 - b0 * s0;
            double cc = ec * (f0 * f0 - b0 * c0);
            phi = StrictMath.atan(s1 / cc);
            double s12 = s1 * s1;
            double cc2 = cc * cc;
            height = (p * cc + absz * s1 - a * StrictMath.sqrt(ec2 * s12 + cc2)) / StrictMath.sqrt(s12 + cc2);
        } else {
            phi = 1.5707963267948966;
            height = absz - b;
        }
        if (z < 0.0) {
            phi = -phi;
        }
        return new GeodeticCoord(elong, phi, height);
    }

    public static double[] jauGd2gc(int n, double elong, double phi, double height) throws JSOFAIllegalParameter, JSOFAInternalError {
        ReferenceEllipsoid em = JSOFA.jauEform(n);
        return JSOFA.jauGd2gce(em.a, em.f, elong, phi, height);
    }

    public static double[] jauGd2gce(double a, double f, double elong, double phi, double height) throws JSOFAInternalError {
        double d;
        double[] xyz = new double[3];
        double sp = StrictMath.sin(phi);
        double cp = StrictMath.cos(phi);
        double w = 1.0 - f;
        if ((d = cp * cp + (w *= w) * sp * sp) <= 0.0) {
            throw new JSOFAInternalError("illegal combination of arguments d< 0", -1);
        }
        double ac = a / StrictMath.sqrt(d);
        double as = w * ac;
        double r = (ac + height) * cp;
        xyz[0] = r * StrictMath.cos(elong);
        xyz[1] = r * StrictMath.sin(elong);
        xyz[2] = (as + height) * sp;
        return xyz;
    }

    public static double jauGmst00(double uta, double utb, double tta, double ttb) {
        double t = (tta - 2451545.0 + ttb) / 36525.0;
        double gmst = JSOFA.jauAnp(JSOFA.jauEra00(uta, utb) + (0.014506 + (4612.15739966 + (1.39667721 + (-9.344E-5 + 1.882E-5 * t) * t) * t) * t) * 4.84813681109536E-6);
        return gmst;
    }

    public static double jauGmst06(double uta, double utb, double tta, double ttb) {
        double t = (tta - 2451545.0 + ttb) / 36525.0;
        double gmst = JSOFA.jauAnp(JSOFA.jauEra00(uta, utb) + (0.014506 + (4612.156534 + (1.3915817 + (-4.4E-7 + (-2.9956E-5 + -3.68E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6);
        return gmst;
    }

    public static double jauGmst82(double dj1, double dj2) {
        double d2;
        double d1;
        double A = -19089.45159;
        double B = 8640184.812866;
        double C = 0.093104;
        double D = -6.2E-6;
        if (dj1 < dj2) {
            d1 = dj1;
            d2 = dj2;
        } else {
            d1 = dj2;
            d2 = dj1;
        }
        double t = (d1 + (d2 - 2451545.0)) / 36525.0;
        double f = 86400.0 * (JSOFA.fmod(d1, 1.0) + JSOFA.fmod(d2, 1.0));
        double gmst = JSOFA.jauAnp(7.27220521664304E-5 * (A + (B + (C + D * t) * t) * t + f));
        return gmst;
    }

    public static double jauGst00a(double uta, double utb, double tta, double ttb) {
        double gmst00 = JSOFA.jauGmst00(uta, utb, tta, ttb);
        double ee00a = JSOFA.jauEe00a(tta, ttb);
        double gst = JSOFA.jauAnp(gmst00 + ee00a);
        return gst;
    }

    public static double jauGst00b(double uta, double utb) {
        double gmst00 = JSOFA.jauGmst00(uta, utb, uta, utb);
        double ee00b = JSOFA.jauEe00b(uta, utb);
        double gst = JSOFA.jauAnp(gmst00 + ee00b);
        return gst;
    }

    public static double jauGst06(double uta, double utb, double tta, double ttb, double[][] rnpb) {
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rnpb);
        double s = JSOFA.jauS06(tta, ttb, cip.x, cip.y);
        double era = JSOFA.jauEra00(uta, utb);
        double eors = JSOFA.jauEors(rnpb, s);
        double gst = JSOFA.jauAnp(era - eors);
        return gst;
    }

    public static double jauGst06a(double uta, double utb, double tta, double ttb) {
        double[][] rnpb = new double[3][3];
        rnpb = JSOFA.jauPnm06a(tta, ttb);
        double gst = JSOFA.jauGst06(uta, utb, tta, ttb, rnpb);
        return gst;
    }

    public static double jauGst94(double uta, double utb) {
        double gmst82 = JSOFA.jauGmst82(uta, utb);
        double eqeq94 = JSOFA.jauEqeq94(uta, utb);
        double gst = JSOFA.jauAnp(gmst82 + eqeq94);
        return gst;
    }

    public static CatalogCoords jauH2fk5(double rh, double dh, double drh, double ddh, double pxh, double rvh) {
        double[][] pvh = new double[2][3];
        double[][] r5h = new double[3][3];
        double[] s5h = new double[3];
        double[] sh = new double[3];
        double[] wxp = new double[3];
        double[] vv = new double[3];
        double[][] pv5 = new double[2][3];
        JSOFA.jauStarpv(rh, dh, drh, ddh, pxh, rvh, pvh);
        JSOFA.jauFk5hip(r5h, s5h);
        int i = 0;
        while (i < 3) {
            int n = i++;
            s5h[n] = s5h[n] / 365.25;
        }
        sh = JSOFA.jauRxp(r5h, s5h);
        pv5[0] = JSOFA.jauTrxp(r5h, pvh[0]);
        wxp = JSOFA.jauPxp(pvh[0], sh);
        vv = JSOFA.jauPmp(pvh[1], wxp);
        pv5[1] = JSOFA.jauTrxp(r5h, vv);
        CatalogCoords cat = null;
        try {
            cat = JSOFA.jauPvstar(pv5);
        }
        catch (JSOFAInternalError e) {
            e.printStackTrace();
        }
        return cat;
    }

    public static CatalogCoords jauHfk5z(double rh, double dh, double date1, double date2) {
        double[] ph = new double[3];
        double[][] r5h = new double[3][3];
        double[] s5h = new double[3];
        double[] sh = new double[3];
        double[] vst = new double[3];
        double[][] rst = new double[3][3];
        double[][] r5ht = new double[3][3];
        double[][] pv5e = new double[2][3];
        double[] vv = new double[3];
        double t = (date1 - 2451545.0 + date2) / 365.25;
        ph = JSOFA.jauS2c(rh, dh);
        JSOFA.jauFk5hip(r5h, s5h);
        sh = JSOFA.jauRxp(r5h, s5h);
        vst = JSOFA.jauSxp(t, s5h);
        rst = JSOFA.jauRv2m(vst);
        r5ht = JSOFA.jauRxr(r5h, rst);
        pv5e[0] = JSOFA.jauTrxp(r5ht, ph);
        vv = JSOFA.jauPxp(sh, ph);
        pv5e[1] = JSOFA.jauTrxp(r5ht, vv);
        SphericalPositionVelocity pvs = JSOFA.jauPv2s(pv5e);
        double r5 = JSOFA.jauAnp(pvs.pos.theta);
        return new CatalogCoords(r5, pvs.pos.phi, pvs.vel.theta, pvs.vel.phi, 0.0, 0.0);
    }

    public static void jauIr(double[][] r) {
        JSOFA.jauZr(r);
        r[0][0] = 1.0;
        r[1][1] = 1.0;
        r[2][2] = 1.0;
    }

    public static Calendar jauJd2cal(double dj1, double dj2) throws JSOFAIllegalParameter {
        double d2;
        double d1;
        double djmin = -68569.5;
        double djmax = 1.0E9;
        double dj = dj1 + dj2;
        if (dj < -68569.5 || dj > 1.0E9) {
            throw new JSOFAIllegalParameter("input julian date out of range", -1);
        }
        if (dj1 >= dj2) {
            d1 = dj1;
            d2 = dj2;
        } else {
            d1 = dj2;
            d2 = dj1;
        }
        double f1 = JSOFA.fmod(d1, 1.0);
        double f2 = JSOFA.fmod(d2 -= 0.5, 1.0);
        double f = JSOFA.fmod(f1 + f2, 1.0);
        if (f < 0.0) {
            f += 1.0;
        }
        double d = StrictMath.floor(d1 - f1) + StrictMath.floor(d2 - f2) + StrictMath.floor(f1 + f2 - f);
        long jd = (long)StrictMath.floor(d) + 1L;
        long l = jd + 68569L;
        long n = 4L * l / 146097L;
        long i = 4000L * ((l -= (146097L * n + 3L) / 4L) + 1L) / 1461001L;
        long k = 80L * (l -= 1461L * i / 4L - 31L) / 2447L;
        int id = (int)(l - 2447L * k / 80L);
        l = k / 11L;
        int im = (int)(k + 2L - 12L * l);
        int iy = (int)(100L * (n - 49L) + i + l);
        return new Calendar(iy, im, id, f);
    }

    public static int jauJdcalf(int ndp, double dj1, double dj2, int[] iymdf) {
        double d2;
        double d1;
        double denom;
        int j;
        if (ndp >= 0 && ndp <= 9) {
            j = 0;
            denom = StrictMath.pow(10.0, ndp);
        } else {
            j = 1;
            denom = 1.0;
        }
        if (dj1 >= dj2) {
            d1 = dj1;
            d2 = dj2;
        } else {
            d1 = dj2;
            d2 = dj1;
        }
        double f1 = JSOFA.fmod(d1, 1.0);
        double f2 = JSOFA.fmod(d2 -= 0.5, 1.0);
        d1 = StrictMath.floor(d1 - f1);
        d2 = StrictMath.floor(d2 - f2);
        double f = StrictMath.floor((f1 + f2) * denom) / denom;
        d2 += f + 0.5;
        try {
            Calendar cal = JSOFA.jauJd2cal(d1, d2);
            iymdf[0] = cal.iy;
            iymdf[1] = cal.im;
            iymdf[2] = cal.id;
            iymdf[3] = (int)(cal.fd * denom);
        }
        catch (JSOFAIllegalParameter e) {
            j = -1;
        }
        return j;
    }

    public static double[][] jauNum00a(double date1, double date2) {
        PrecessionNutation pn = JSOFA.jauPn00a(date1, date2);
        return pn.rn;
    }

    public static double[][] jauNum00b(double date1, double date2) {
        PrecessionNutation pn = JSOFA.jauPn00b(date1, date2);
        return pn.rn;
    }

    public static double[][] jauNum06a(double date1, double date2) {
        double eps = JSOFA.jauObl06(date1, date2);
        NutationTerms nut = JSOFA.jauNut06a(date1, date2);
        double[][] rmatn = JSOFA.jauNumat(eps, nut.dpsi, nut.deps);
        return rmatn;
    }

    public static double[][] jauNumat(double epsa, double dpsi, double deps) {
        double[][] rmatn = new double[3][3];
        JSOFA.jauIr(rmatn);
        JSOFA.jauRx(epsa, rmatn);
        JSOFA.jauRz(-dpsi, rmatn);
        JSOFA.jauRx(-(epsa + deps), rmatn);
        return rmatn;
    }

    /*
     * Opcode count of 27759 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static NutationTerms jauNut00a(double date1, double date2) {
        double carg;
        double sarg;
        double arg;
        int i;
        final class NutationModel {
            int nl;
            int nlp;
            int nf;
            int nd;
            int nom;
            double sp;
            double spt;
            double cp;
            double ce;
            double cet;
            double se;

            public NutationModel(int nl, int nlp, int nf, int nd, int nom, double sp, double spt, double cp, double ce, double cet, double se) {
                this.nl = nl;
                this.nlp = nlp;
                this.nf = nf;
                this.nd = nd;
                this.nom = nom;
                this.sp = sp;
                this.spt = spt;
                this.cp = cp;
                this.ce = ce;
                this.cet = cet;
                this.se = se;
            }
        }
        NutationModel[] xls = new NutationModel[]{new NutationModel(0, 0, 0, 0, 1, -1.72064161E8, -174666.0, 33386.0, 9.2052331E7, 9086.0, 15377.0), new NutationModel(0, 0, 2, -2, 2, -1.3170906E7, -1675.0, -13696.0, 5730336.0, -3015.0, -4587.0), new NutationModel(0, 0, 2, 0, 2, -2276413.0, -234.0, 2796.0, 978459.0, -485.0, 1374.0), new NutationModel(0, 0, 0, 0, 2, 2074554.0, 207.0, -698.0, -897492.0, 470.0, -291.0), new NutationModel(0, 1, 0, 0, 0, 1475877.0, -3633.0, 11817.0, 73871.0, -184.0, -1924.0), new NutationModel(0, 1, 2, -2, 2, -516821.0, 1226.0, -524.0, 224386.0, -677.0, -174.0), new NutationModel(1, 0, 0, 0, 0, 711159.0, 73.0, -872.0, -6750.0, 0.0, 358.0), new NutationModel(0, 0, 2, 0, 1, -387298.0, -367.0, 380.0, 200728.0, 18.0, 318.0), new NutationModel(1, 0, 2, 0, 2, -301461.0, -36.0, 816.0, 129025.0, -63.0, 367.0), new NutationModel(0, -1, 2, -2, 2, 215829.0, -494.0, 111.0, -95929.0, 299.0, 132.0), new NutationModel(0, 0, 2, -2, 1, 128227.0, 137.0, 181.0, -68982.0, -9.0, 39.0), new NutationModel(-1, 0, 2, 0, 2, 123457.0, 11.0, 19.0, -53311.0, 32.0, -4.0), new NutationModel(-1, 0, 0, 2, 0, 156994.0, 10.0, -168.0, -1235.0, 0.0, 82.0), new NutationModel(1, 0, 0, 0, 1, 63110.0, 63.0, 27.0, -33228.0, 0.0, -9.0), new NutationModel(-1, 0, 0, 0, 1, -57976.0, -63.0, -189.0, 31429.0, 0.0, -75.0), new NutationModel(-1, 0, 2, 2, 2, -59641.0, -11.0, 149.0, 25543.0, -11.0, 66.0), new NutationModel(1, 0, 2, 0, 1, -51613.0, -42.0, 129.0, 26366.0, 0.0, 78.0), new NutationModel(-2, 0, 2, 0, 1, 45893.0, 50.0, 31.0, -24236.0, -10.0, 20.0), new NutationModel(0, 0, 0, 2, 0, 63384.0, 11.0, -150.0, -1220.0, 0.0, 29.0), new NutationModel(0, 0, 2, 2, 2, -38571.0, -1.0, 158.0, 16452.0, -11.0, 68.0), new NutationModel(0, -2, 2, -2, 2, 32481.0, 0.0, 0.0, -13870.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 2, 0, -47722.0, 0.0, -18.0, 477.0, 0.0, -25.0), new NutationModel(2, 0, 2, 0, 2, -31046.0, -1.0, 131.0, 13238.0, -11.0, 59.0), new NutationModel(1, 0, 2, -2, 2, 28593.0, 0.0, -1.0, -12338.0, 10.0, -3.0), new NutationModel(-1, 0, 2, 0, 1, 20441.0, 21.0, 10.0, -10758.0, 0.0, -3.0), new NutationModel(2, 0, 0, 0, 0, 29243.0, 0.0, -74.0, -609.0, 0.0, 13.0), new NutationModel(0, 0, 2, 0, 0, 25887.0, 0.0, -66.0, -550.0, 0.0, 11.0), new NutationModel(0, 1, 0, 0, 1, -14053.0, -25.0, 79.0, 8551.0, -2.0, -45.0), new NutationModel(-1, 0, 0, 2, 1, 15164.0, 10.0, 11.0, -8001.0, 0.0, -1.0), new NutationModel(0, 2, 2, -2, 2, -15794.0, 72.0, -16.0, 6850.0, -42.0, -5.0), new NutationModel(0, 0, -2, 2, 0, 21783.0, 0.0, 13.0, -167.0, 0.0, 13.0), new NutationModel(1, 0, 0, -2, 1, -12873.0, -10.0, -37.0, 6953.0, 0.0, -14.0), new NutationModel(0, -1, 0, 0, 1, -12654.0, 11.0, 63.0, 6415.0, 0.0, 26.0), new NutationModel(-1, 0, 2, 2, 1, -10204.0, 0.0, 25.0, 5222.0, 0.0, 15.0), new NutationModel(0, 2, 0, 0, 0, 16707.0, -85.0, -10.0, 168.0, -1.0, 10.0), new NutationModel(1, 0, 2, 2, 2, -7691.0, 0.0, 44.0, 3268.0, 0.0, 19.0), new NutationModel(-2, 0, 2, 0, 0, -11024.0, 0.0, -14.0, 104.0, 0.0, 2.0), new NutationModel(0, 1, 2, 0, 2, 7566.0, -21.0, -11.0, -3250.0, 0.0, -5.0), new NutationModel(0, 0, 2, 2, 1, -6637.0, -11.0, 25.0, 3353.0, 0.0, 14.0), new NutationModel(0, -1, 2, 0, 2, -7141.0, 21.0, 8.0, 3070.0, 0.0, 4.0), new NutationModel(0, 0, 0, 2, 1, -6302.0, -11.0, 2.0, 3272.0, 0.0, 4.0), new NutationModel(1, 0, 2, -2, 1, 5800.0, 10.0, 2.0, -3045.0, 0.0, -1.0), new NutationModel(2, 0, 2, -2, 2, 6443.0, 0.0, -7.0, -2768.0, 0.0, -4.0), new NutationModel(-2, 0, 0, 2, 1, -5774.0, -11.0, -15.0, 3041.0, 0.0, -5.0), new NutationModel(2, 0, 2, 0, 1, -5350.0, 0.0, 21.0, 2695.0, 0.0, 12.0), new NutationModel(0, -1, 2, -2, 1, -4752.0, -11.0, -3.0, 2719.0, 0.0, -3.0), new NutationModel(0, 0, 0, -2, 1, -4940.0, -11.0, -21.0, 2720.0, 0.0, -9.0), new NutationModel(-1, -1, 0, 2, 0, 7350.0, 0.0, -8.0, -51.0, 0.0, 4.0), new NutationModel(2, 0, 0, -2, 1, 4065.0, 0.0, 6.0, -2206.0, 0.0, 1.0), new NutationModel(1, 0, 0, 2, 0, 6579.0, 0.0, -24.0, -199.0, 0.0, 2.0), new NutationModel(0, 1, 2, -2, 1, 3579.0, 0.0, 5.0, -1900.0, 0.0, 1.0), new NutationModel(1, -1, 0, 0, 0, 4725.0, 0.0, -6.0, -41.0, 0.0, 3.0), new NutationModel(-2, 0, 2, 0, 2, -3075.0, 0.0, -2.0, 1313.0, 0.0, -1.0), new NutationModel(3, 0, 2, 0, 2, -2904.0, 0.0, 15.0, 1233.0, 0.0, 7.0), new NutationModel(0, -1, 0, 2, 0, 4348.0, 0.0, -10.0, -81.0, 0.0, 2.0), new NutationModel(1, -1, 2, 0, 2, -2878.0, 0.0, 8.0, 1232.0, 0.0, 4.0), new NutationModel(0, 0, 0, 1, 0, -4230.0, 0.0, 5.0, -20.0, 0.0, -2.0), new NutationModel(-1, -1, 2, 2, 2, -2819.0, 0.0, 7.0, 1207.0, 0.0, 3.0), new NutationModel(-1, 0, 2, 0, 0, -4056.0, 0.0, 5.0, 40.0, 0.0, -2.0), new NutationModel(0, -1, 2, 2, 2, -2647.0, 0.0, 11.0, 1129.0, 0.0, 5.0), new NutationModel(-2, 0, 0, 0, 1, -2294.0, 0.0, -10.0, 1266.0, 0.0, -4.0), new NutationModel(1, 1, 2, 0, 2, 2481.0, 0.0, -7.0, -1062.0, 0.0, -3.0), new NutationModel(2, 0, 0, 0, 1, 2179.0, 0.0, -2.0, -1129.0, 0.0, -2.0), new NutationModel(-1, 1, 0, 1, 0, 3276.0, 0.0, 1.0, -9.0, 0.0, 0.0), new NutationModel(1, 1, 0, 0, 0, -3389.0, 0.0, 5.0, 35.0, 0.0, -2.0), new NutationModel(1, 0, 2, 0, 0, 3339.0, 0.0, -13.0, -107.0, 0.0, 1.0), new NutationModel(-1, 0, 2, -2, 1, -1987.0, 0.0, -6.0, 1073.0, 0.0, -2.0), new NutationModel(1, 0, 0, 0, 2, -1981.0, 0.0, 0.0, 854.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 1, 0, 4026.0, 0.0, -353.0, -553.0, 0.0, -139.0), new NutationModel(0, 0, 2, 1, 2, 1660.0, 0.0, -5.0, -710.0, 0.0, -2.0), new NutationModel(-1, 0, 2, 4, 2, -1521.0, 0.0, 9.0, 647.0, 0.0, 4.0), new NutationModel(-1, 1, 0, 1, 1, 1314.0, 0.0, 0.0, -700.0, 0.0, 0.0), new NutationModel(0, -2, 2, -2, 1, -1283.0, 0.0, 0.0, 672.0, 0.0, 0.0), new NutationModel(1, 0, 2, 2, 1, -1331.0, 0.0, 8.0, 663.0, 0.0, 4.0), new NutationModel(-2, 0, 2, 2, 2, 1383.0, 0.0, -2.0, -594.0, 0.0, -2.0), new NutationModel(-1, 0, 0, 0, 2, 1405.0, 0.0, 4.0, -610.0, 0.0, 2.0), new NutationModel(1, 1, 2, -2, 2, 1290.0, 0.0, 0.0, -556.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 4, 2, -1214.0, 0.0, 5.0, 518.0, 0.0, 2.0), new NutationModel(-1, 0, 4, 0, 2, 1146.0, 0.0, -3.0, -490.0, 0.0, -1.0), new NutationModel(2, 0, 2, -2, 1, 1019.0, 0.0, -1.0, -527.0, 0.0, -1.0), new NutationModel(2, 0, 2, 2, 2, -1100.0, 0.0, 9.0, 465.0, 0.0, 4.0), new NutationModel(1, 0, 0, 2, 1, -970.0, 0.0, 2.0, 496.0, 0.0, 1.0), new NutationModel(3, 0, 0, 0, 0, 1575.0, 0.0, -6.0, -50.0, 0.0, 0.0), new NutationModel(3, 0, 2, -2, 2, 934.0, 0.0, -3.0, -399.0, 0.0, -1.0), new NutationModel(0, 0, 4, -2, 2, 922.0, 0.0, -1.0, -395.0, 0.0, -1.0), new NutationModel(0, 1, 2, 0, 1, 815.0, 0.0, -1.0, -422.0, 0.0, -1.0), new NutationModel(0, 0, -2, 2, 1, 834.0, 0.0, 2.0, -440.0, 0.0, 1.0), new NutationModel(0, 0, 2, -2, 3, 1248.0, 0.0, 0.0, -170.0, 0.0, 1.0), new NutationModel(-1, 0, 0, 4, 0, 1338.0, 0.0, -5.0, -39.0, 0.0, 0.0), new NutationModel(2, 0, -2, 0, 1, 716.0, 0.0, -2.0, -389.0, 0.0, -1.0), new NutationModel(-2, 0, 0, 4, 0, 1282.0, 0.0, -3.0, -23.0, 0.0, 1.0), new NutationModel(-1, -1, 0, 2, 1, 742.0, 0.0, 1.0, -391.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 1, 1, 1020.0, 0.0, -25.0, -495.0, 0.0, -10.0), new NutationModel(0, 1, 0, 0, 2, 715.0, 0.0, -4.0, -326.0, 0.0, 2.0), new NutationModel(0, 0, -2, 0, 1, -666.0, 0.0, -3.0, 369.0, 0.0, -1.0), new NutationModel(0, -1, 2, 0, 1, -667.0, 0.0, 1.0, 346.0, 0.0, 1.0), new NutationModel(0, 0, 2, -1, 2, -704.0, 0.0, 0.0, 304.0, 0.0, 0.0), new NutationModel(0, 0, 2, 4, 2, -694.0, 0.0, 5.0, 294.0, 0.0, 2.0), new NutationModel(-2, -1, 0, 2, 0, -1014.0, 0.0, -1.0, 4.0, 0.0, -1.0), new NutationModel(1, 1, 0, -2, 1, -585.0, 0.0, -2.0, 316.0, 0.0, -1.0), new NutationModel(-1, 1, 0, 2, 0, -949.0, 0.0, 1.0, 8.0, 0.0, -1.0), new NutationModel(-1, 1, 0, 1, 2, -595.0, 0.0, 0.0, 258.0, 0.0, 0.0), new NutationModel(1, -1, 0, 0, 1, 528.0, 0.0, 0.0, -279.0, 0.0, 0.0), new NutationModel(1, -1, 2, 2, 2, -590.0, 0.0, 4.0, 252.0, 0.0, 2.0), new NutationModel(-1, 1, 2, 2, 2, 570.0, 0.0, -2.0, -244.0, 0.0, -1.0), new NutationModel(3, 0, 2, 0, 1, -502.0, 0.0, 3.0, 250.0, 0.0, 2.0), new NutationModel(0, 1, -2, 2, 0, -875.0, 0.0, 1.0, 29.0, 0.0, 0.0), new NutationModel(-1, 0, 0, -2, 1, -492.0, 0.0, -3.0, 275.0, 0.0, -1.0), new NutationModel(0, 1, 2, 2, 2, 535.0, 0.0, -2.0, -228.0, 0.0, -1.0), new NutationModel(-1, -1, 2, 2, 1, -467.0, 0.0, 1.0, 240.0, 0.0, 1.0), new NutationModel(0, -1, 0, 0, 2, 591.0, 0.0, 0.0, -253.0, 0.0, 0.0), new NutationModel(1, 0, 2, -4, 1, -453.0, 0.0, -1.0, 244.0, 0.0, -1.0), new NutationModel(-1, 0, -2, 2, 0, 766.0, 0.0, 1.0, 9.0, 0.0, 0.0), new NutationModel(0, -1, 2, 2, 1, -446.0, 0.0, 2.0, 225.0, 0.0, 1.0), new NutationModel(2, -1, 2, 0, 2, -488.0, 0.0, 2.0, 207.0, 0.0, 1.0), new NutationModel(0, 0, 0, 2, 2, -468.0, 0.0, 0.0, 201.0, 0.0, 0.0), new NutationModel(1, -1, 2, 0, 1, -421.0, 0.0, 1.0, 216.0, 0.0, 1.0), new NutationModel(-1, 1, 2, 0, 2, 463.0, 0.0, 0.0, -200.0, 0.0, 0.0), new NutationModel(0, 1, 0, 2, 0, -673.0, 0.0, 2.0, 14.0, 0.0, 0.0), new NutationModel(0, -1, -2, 2, 0, 658.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 3, 2, -2, 2, -438.0, 0.0, 0.0, 188.0, 0.0, 0.0), new NutationModel(0, 0, 0, 1, 1, -390.0, 0.0, 0.0, 205.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 2, 0, 639.0, -11.0, -2.0, -19.0, 0.0, 0.0), new NutationModel(2, 1, 2, 0, 2, 412.0, 0.0, -2.0, -176.0, 0.0, -1.0), new NutationModel(1, 1, 0, 0, 1, -361.0, 0.0, 0.0, 189.0, 0.0, 0.0), new NutationModel(1, 1, 2, 0, 1, 360.0, 0.0, -1.0, -185.0, 0.0, -1.0), new NutationModel(2, 0, 0, 2, 0, 588.0, 0.0, -3.0, -24.0, 0.0, 0.0), new NutationModel(1, 0, -2, 2, 0, -578.0, 0.0, 1.0, 5.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 2, 2, -396.0, 0.0, 0.0, 171.0, 0.0, 0.0), new NutationModel(0, 1, 0, 1, 0, 565.0, 0.0, -1.0, -6.0, 0.0, 0.0), new NutationModel(0, 1, 0, -2, 1, -335.0, 0.0, -1.0, 184.0, 0.0, -1.0), new NutationModel(-1, 0, 2, -2, 2, 357.0, 0.0, 1.0, -154.0, 0.0, 0.0), new NutationModel(0, 0, 0, -1, 1, 321.0, 0.0, 1.0, -174.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 0, 1, -301.0, 0.0, -1.0, 162.0, 0.0, 0.0), new NutationModel(1, 0, 2, -1, 2, -334.0, 0.0, 0.0, 144.0, 0.0, 0.0), new NutationModel(1, -1, 0, 2, 0, 493.0, 0.0, -2.0, -15.0, 0.0, 0.0), new NutationModel(0, 0, 0, 4, 0, 494.0, 0.0, -2.0, -19.0, 0.0, 0.0), new NutationModel(1, 0, 2, 1, 2, 337.0, 0.0, -1.0, -143.0, 0.0, -1.0), new NutationModel(0, 0, 2, 1, 1, 280.0, 0.0, -1.0, -144.0, 0.0, 0.0), new NutationModel(1, 0, 0, -2, 2, 309.0, 0.0, 1.0, -134.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 4, 1, -263.0, 0.0, 2.0, 131.0, 0.0, 1.0), new NutationModel(1, 0, -2, 0, 1, 253.0, 0.0, 1.0, -138.0, 0.0, 0.0), new NutationModel(1, 1, 2, -2, 1, 245.0, 0.0, 0.0, -128.0, 0.0, 0.0), new NutationModel(0, 0, 2, 2, 0, 416.0, 0.0, -2.0, -17.0, 0.0, 0.0), new NutationModel(-1, 0, 2, -1, 1, -229.0, 0.0, 0.0, 128.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 2, 1, 231.0, 0.0, 0.0, -120.0, 0.0, 0.0), new NutationModel(4, 0, 2, 0, 2, -259.0, 0.0, 2.0, 109.0, 0.0, 1.0), new NutationModel(2, -1, 0, 0, 0, 375.0, 0.0, -1.0, -8.0, 0.0, 0.0), new NutationModel(2, 1, 2, -2, 2, 252.0, 0.0, 0.0, -108.0, 0.0, 0.0), new NutationModel(0, 1, 2, 1, 2, -245.0, 0.0, 1.0, 104.0, 0.0, 0.0), new NutationModel(1, 0, 4, -2, 2, 243.0, 0.0, -1.0, -104.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 0, 1, 208.0, 0.0, 1.0, -112.0, 0.0, 0.0), new NutationModel(0, 1, 0, 2, 1, 199.0, 0.0, 0.0, -102.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 4, 1, -208.0, 0.0, 1.0, 105.0, 0.0, 0.0), new NutationModel(2, 0, 2, 0, 0, 335.0, 0.0, -2.0, -14.0, 0.0, 0.0), new NutationModel(1, 0, 0, 1, 0, -325.0, 0.0, 1.0, 7.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 4, 1, -187.0, 0.0, 0.0, 96.0, 0.0, 0.0), new NutationModel(-1, 0, 4, 0, 1, 197.0, 0.0, -1.0, -100.0, 0.0, 0.0), new NutationModel(2, 0, 2, 2, 1, -192.0, 0.0, 2.0, 94.0, 0.0, 1.0), new NutationModel(0, 0, 2, -3, 2, -188.0, 0.0, 0.0, 83.0, 0.0, 0.0), new NutationModel(-1, -2, 0, 2, 0, 276.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 1, 0, 0, 0, -286.0, 0.0, 1.0, 6.0, 0.0, 0.0), new NutationModel(0, 0, 4, 0, 2, 186.0, 0.0, -1.0, -79.0, 0.0, 0.0), new NutationModel(0, 0, 0, 0, 3, -219.0, 0.0, 0.0, 43.0, 0.0, 0.0), new NutationModel(0, 3, 0, 0, 0, 276.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 2, -4, 1, -153.0, 0.0, -1.0, 84.0, 0.0, 0.0), new NutationModel(0, -1, 0, 2, 1, -156.0, 0.0, 0.0, 81.0, 0.0, 0.0), new NutationModel(0, 0, 0, 4, 1, -154.0, 0.0, 1.0, 78.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 4, 2, -174.0, 0.0, 1.0, 75.0, 0.0, 0.0), new NutationModel(1, 0, 2, 4, 2, -163.0, 0.0, 2.0, 69.0, 0.0, 1.0), new NutationModel(-2, 2, 0, 2, 0, -228.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 0, 1, 91.0, 0.0, -4.0, -54.0, 0.0, -2.0), new NutationModel(-2, 0, 0, 2, 2, 175.0, 0.0, 0.0, -75.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 0, 2, -159.0, 0.0, 0.0, 69.0, 0.0, 0.0), new NutationModel(0, 0, 4, -2, 1, 141.0, 0.0, 0.0, -72.0, 0.0, 0.0), new NutationModel(3, 0, 2, -2, 1, 147.0, 0.0, 0.0, -75.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 2, 1, -132.0, 0.0, 0.0, 69.0, 0.0, 0.0), new NutationModel(1, 0, 0, -1, 1, 159.0, 0.0, -28.0, -54.0, 0.0, 11.0), new NutationModel(0, -2, 0, 2, 0, 213.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 4, 1, 123.0, 0.0, 0.0, -64.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 0, 1, -118.0, 0.0, -1.0, 66.0, 0.0, 0.0), new NutationModel(1, 1, 2, 2, 2, 144.0, 0.0, -1.0, -61.0, 0.0, 0.0), new NutationModel(0, 0, 2, 4, 1, -121.0, 0.0, 1.0, 60.0, 0.0, 0.0), new NutationModel(3, 0, 2, 2, 2, -134.0, 0.0, 1.0, 56.0, 0.0, 1.0), new NutationModel(-1, 1, 2, -2, 1, -105.0, 0.0, 0.0, 57.0, 0.0, 0.0), new NutationModel(2, 0, 0, -4, 1, -102.0, 0.0, 0.0, 56.0, 0.0, 0.0), new NutationModel(0, 0, 0, -2, 2, 120.0, 0.0, 0.0, -52.0, 0.0, 0.0), new NutationModel(2, 0, 2, -4, 1, 101.0, 0.0, 0.0, -54.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 2, 1, -113.0, 0.0, 0.0, 59.0, 0.0, 0.0), new NutationModel(0, 0, 2, -1, 1, -106.0, 0.0, 0.0, 61.0, 0.0, 0.0), new NutationModel(0, -2, 2, 2, 2, -129.0, 0.0, 1.0, 55.0, 0.0, 0.0), new NutationModel(2, 0, 0, 2, 1, -114.0, 0.0, 0.0, 57.0, 0.0, 0.0), new NutationModel(4, 0, 2, -2, 2, 113.0, 0.0, -1.0, -49.0, 0.0, 0.0), new NutationModel(2, 0, 0, -2, 2, -102.0, 0.0, 0.0, 44.0, 0.0, 0.0), new NutationModel(0, 2, 0, 0, 1, -94.0, 0.0, 0.0, 51.0, 0.0, 0.0), new NutationModel(1, 0, 0, -4, 1, -100.0, 0.0, -1.0, 56.0, 0.0, 0.0), new NutationModel(0, 2, 2, -2, 1, 87.0, 0.0, 0.0, -47.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 4, 0, 161.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 0, 1, 96.0, 0.0, 0.0, -50.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 4, 0, 151.0, 0.0, -1.0, -5.0, 0.0, 0.0), new NutationModel(-1, -2, 2, 2, 2, -104.0, 0.0, 0.0, 44.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 4, 2, -110.0, 0.0, 0.0, 48.0, 0.0, 0.0), new NutationModel(1, -1, 2, 2, 1, -100.0, 0.0, 1.0, 50.0, 0.0, 0.0), new NutationModel(-2, 1, 0, 2, 0, 92.0, 0.0, -5.0, 12.0, 0.0, -2.0), new NutationModel(-2, 1, 2, 0, 1, 82.0, 0.0, 0.0, -45.0, 0.0, 0.0), new NutationModel(2, 1, 0, -2, 1, 82.0, 0.0, 0.0, -45.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 0, 1, -78.0, 0.0, 0.0, 41.0, 0.0, 0.0), new NutationModel(-2, 0, 2, -2, 1, -77.0, 0.0, 0.0, 43.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 2, 2, 2.0, 0.0, 0.0, 54.0, 0.0, 0.0), new NutationModel(0, -1, 2, -1, 2, 94.0, 0.0, 0.0, -40.0, 0.0, 0.0), new NutationModel(-1, 0, 4, -2, 2, -93.0, 0.0, 0.0, 40.0, 0.0, 0.0), new NutationModel(0, -2, 2, 0, 2, -83.0, 0.0, 10.0, 40.0, 0.0, -2.0), new NutationModel(-1, 0, 2, 1, 2, 83.0, 0.0, 0.0, -36.0, 0.0, 0.0), new NutationModel(2, 0, 0, 0, 2, -91.0, 0.0, 0.0, 39.0, 0.0, 0.0), new NutationModel(0, 0, 2, 0, 3, 128.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-2, 0, 4, 0, 2, -79.0, 0.0, 0.0, 34.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 0, 1, -83.0, 0.0, 0.0, 47.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 2, 1, 84.0, 0.0, 0.0, -44.0, 0.0, 0.0), new NutationModel(3, 0, 0, 0, 1, 83.0, 0.0, 0.0, -43.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 3, 2, 91.0, 0.0, 0.0, -39.0, 0.0, 0.0), new NutationModel(2, -1, 2, 0, 1, -77.0, 0.0, 0.0, 39.0, 0.0, 0.0), new NutationModel(0, 1, 2, 2, 1, 84.0, 0.0, 0.0, -43.0, 0.0, 0.0), new NutationModel(0, -1, 2, 4, 2, -92.0, 0.0, 1.0, 39.0, 0.0, 0.0), new NutationModel(2, -1, 2, 2, 2, -92.0, 0.0, 1.0, 39.0, 0.0, 0.0), new NutationModel(0, 2, -2, 2, 0, -94.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 2, -1, 1, 68.0, 0.0, 0.0, -36.0, 0.0, 0.0), new NutationModel(0, -2, 0, 0, 1, -61.0, 0.0, 0.0, 32.0, 0.0, 0.0), new NutationModel(1, 0, 2, -4, 2, 71.0, 0.0, 0.0, -31.0, 0.0, 0.0), new NutationModel(1, -1, 0, -2, 1, 62.0, 0.0, 0.0, -34.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 0, 1, -63.0, 0.0, 0.0, 33.0, 0.0, 0.0), new NutationModel(1, -1, 2, -2, 2, -73.0, 0.0, 0.0, 32.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 4, 0, 115.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 3, 0, -103.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 2, 2, 63.0, 0.0, 0.0, -28.0, 0.0, 0.0), new NutationModel(0, 2, 2, 0, 2, 74.0, 0.0, 0.0, -32.0, 0.0, 0.0), new NutationModel(1, 1, 0, 2, 0, -103.0, 0.0, -3.0, 3.0, 0.0, -1.0), new NutationModel(2, 0, 2, -1, 2, -69.0, 0.0, 0.0, 30.0, 0.0, 0.0), new NutationModel(1, 0, 2, 1, 1, 57.0, 0.0, 0.0, -29.0, 0.0, 0.0), new NutationModel(4, 0, 0, 0, 0, 94.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(2, 1, 2, 0, 1, 64.0, 0.0, 0.0, -33.0, 0.0, 0.0), new NutationModel(3, -1, 2, 0, 2, -63.0, 0.0, 0.0, 26.0, 0.0, 0.0), new NutationModel(-2, 2, 0, 2, 1, -38.0, 0.0, 0.0, 20.0, 0.0, 0.0), new NutationModel(1, 0, 2, -3, 1, -43.0, 0.0, 0.0, 24.0, 0.0, 0.0), new NutationModel(1, 1, 2, -4, 1, -45.0, 0.0, 0.0, 23.0, 0.0, 0.0), new NutationModel(-1, -1, 2, -2, 1, 47.0, 0.0, 0.0, -24.0, 0.0, 0.0), new NutationModel(0, -1, 0, -1, 1, -48.0, 0.0, 0.0, 25.0, 0.0, 0.0), new NutationModel(0, -1, 0, -2, 1, 45.0, 0.0, 0.0, -26.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 0, 2, 56.0, 0.0, 0.0, -25.0, 0.0, 0.0), new NutationModel(-2, 0, -2, 2, 0, 88.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 4, 0, -75.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -2, 0, 0, 0, 85.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, 1, 1, 49.0, 0.0, 0.0, -26.0, 0.0, 0.0), new NutationModel(-1, 2, 0, 2, 0, -74.0, 0.0, -3.0, -1.0, 0.0, -1.0), new NutationModel(1, -1, 2, -2, 1, -39.0, 0.0, 0.0, 21.0, 0.0, 0.0), new NutationModel(1, 2, 2, -2, 2, 45.0, 0.0, 0.0, -20.0, 0.0, 0.0), new NutationModel(2, -1, 2, -2, 2, 51.0, 0.0, 0.0, -22.0, 0.0, 0.0), new NutationModel(1, 0, 2, -1, 1, -40.0, 0.0, 0.0, 21.0, 0.0, 0.0), new NutationModel(2, 1, 2, -2, 1, 41.0, 0.0, 0.0, -21.0, 0.0, 0.0), new NutationModel(-2, 0, 0, -2, 1, -42.0, 0.0, 0.0, 24.0, 0.0, 0.0), new NutationModel(1, -2, 2, 0, 2, -51.0, 0.0, 0.0, 22.0, 0.0, 0.0), new NutationModel(0, 1, 2, 1, 1, -42.0, 0.0, 0.0, 22.0, 0.0, 0.0), new NutationModel(1, 0, 4, -2, 1, 39.0, 0.0, 0.0, -21.0, 0.0, 0.0), new NutationModel(-2, 0, 4, 2, 2, 46.0, 0.0, 0.0, -18.0, 0.0, 0.0), new NutationModel(1, 1, 2, 1, 2, -53.0, 0.0, 0.0, 22.0, 0.0, 0.0), new NutationModel(1, 0, 0, 4, 0, 82.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(1, 0, 2, 2, 0, 81.0, 0.0, -1.0, -4.0, 0.0, 0.0), new NutationModel(2, 0, 2, 1, 2, 47.0, 0.0, 0.0, -19.0, 0.0, 0.0), new NutationModel(3, 1, 2, 0, 2, 53.0, 0.0, 0.0, -23.0, 0.0, 0.0), new NutationModel(4, 0, 2, 0, 1, -45.0, 0.0, 0.0, 22.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 0, 0, -44.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 1, -2, 2, 1, -33.0, 0.0, 0.0, 16.0, 0.0, 0.0), new NutationModel(1, 0, -2, 1, 0, -61.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(0, -1, -2, 2, 1, 28.0, 0.0, 0.0, -15.0, 0.0, 0.0), new NutationModel(2, -1, 0, -2, 1, -38.0, 0.0, 0.0, 19.0, 0.0, 0.0), new NutationModel(-1, 0, 2, -1, 2, -33.0, 0.0, 0.0, 21.0, 0.0, 0.0), new NutationModel(1, 0, 2, -3, 2, -60.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, -2, 3, 48.0, 0.0, 0.0, -10.0, 0.0, 0.0), new NutationModel(0, 0, 2, -3, 1, 27.0, 0.0, 0.0, -14.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 2, 1, 38.0, 0.0, 0.0, -20.0, 0.0, 0.0), new NutationModel(0, 0, 2, -4, 2, 31.0, 0.0, 0.0, -13.0, 0.0, 0.0), new NutationModel(-2, 1, 0, 0, 1, -29.0, 0.0, 0.0, 15.0, 0.0, 0.0), new NutationModel(-1, 0, 0, -1, 1, 28.0, 0.0, 0.0, -15.0, 0.0, 0.0), new NutationModel(2, 0, 2, -4, 2, -32.0, 0.0, 0.0, 15.0, 0.0, 0.0), new NutationModel(0, 0, 4, -4, 4, 45.0, 0.0, 0.0, -8.0, 0.0, 0.0), new NutationModel(0, 0, 4, -4, 2, -44.0, 0.0, 0.0, 19.0, 0.0, 0.0), new NutationModel(-1, -2, 0, 2, 1, 28.0, 0.0, 0.0, -15.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 3, 0, -51.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, -2, 2, 1, -36.0, 0.0, 0.0, 20.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 2, 2, 44.0, 0.0, 0.0, -19.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 2, 1, 26.0, 0.0, 0.0, -14.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 2, 0, -60.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, -1, 0, 0, 1, 35.0, 0.0, 0.0, -18.0, 0.0, 0.0), new NutationModel(-2, 1, 2, 2, 2, -27.0, 0.0, 0.0, 11.0, 0.0, 0.0), new NutationModel(1, 1, 0, 1, 0, 47.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, 1, 4, -2, 2, 36.0, 0.0, 0.0, -15.0, 0.0, 0.0), new NutationModel(-1, 1, 0, -2, 1, -36.0, 0.0, 0.0, 20.0, 0.0, 0.0), new NutationModel(0, 0, 0, -4, 1, -35.0, 0.0, 0.0, 19.0, 0.0, 0.0), new NutationModel(1, -1, 0, 2, 1, -37.0, 0.0, 0.0, 19.0, 0.0, 0.0), new NutationModel(1, 1, 0, 2, 1, 32.0, 0.0, 0.0, -16.0, 0.0, 0.0), new NutationModel(-1, 2, 2, 2, 2, 35.0, 0.0, 0.0, -14.0, 0.0, 0.0), new NutationModel(3, 1, 2, -2, 2, 32.0, 0.0, 0.0, -13.0, 0.0, 0.0), new NutationModel(0, -1, 0, 4, 0, 65.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, -1, 0, 2, 0, 47.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, 0, 4, 0, 1, 32.0, 0.0, 0.0, -16.0, 0.0, 0.0), new NutationModel(2, 0, 4, -2, 2, 37.0, 0.0, 0.0, -16.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 4, 1, -30.0, 0.0, 0.0, 15.0, 0.0, 0.0), new NutationModel(1, 0, 0, 4, 1, -32.0, 0.0, 0.0, 16.0, 0.0, 0.0), new NutationModel(1, -2, 2, 2, 2, -31.0, 0.0, 0.0, 13.0, 0.0, 0.0), new NutationModel(0, 0, 2, 3, 2, 37.0, 0.0, 0.0, -16.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 4, 2, 31.0, 0.0, 0.0, -13.0, 0.0, 0.0), new NutationModel(3, 0, 0, 2, 0, 49.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 0, 4, 2, 2, 32.0, 0.0, 0.0, -13.0, 0.0, 0.0), new NutationModel(1, 1, 2, 2, 1, 23.0, 0.0, 0.0, -12.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 6, 2, -43.0, 0.0, 0.0, 18.0, 0.0, 0.0), new NutationModel(2, 1, 2, 2, 2, 26.0, 0.0, 0.0, -11.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 6, 2, -32.0, 0.0, 0.0, 14.0, 0.0, 0.0), new NutationModel(1, 0, 2, 4, 1, -29.0, 0.0, 0.0, 14.0, 0.0, 0.0), new NutationModel(2, 0, 2, 4, 2, -27.0, 0.0, 0.0, 12.0, 0.0, 0.0), new NutationModel(1, 1, -2, 1, 0, 30.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 1, 2, 1, 2, -11.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(2, 0, -2, 0, 2, -21.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 1, 2, -34.0, 0.0, 0.0, 15.0, 0.0, 0.0), new NutationModel(-4, 0, 2, 2, 1, -10.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 1, 0, -36.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 2, 2, -9.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(1, 0, 0, -1, 2, -12.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(0, -1, 2, -2, 3, -21.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(-2, 1, 2, 0, 0, -29.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, 0, 2, -2, 4, -15.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-2, -2, 0, 2, 0, -20.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, -2, 4, 0, 28.0, 0.0, 0.0, 0.0, 0.0, -2.0), new NutationModel(0, -2, -2, 2, 0, 17.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 2, 0, -2, 1, -22.0, 0.0, 0.0, 12.0, 0.0, 0.0), new NutationModel(3, 0, 0, -4, 1, -14.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(-1, 1, 2, -2, 2, 24.0, 0.0, 0.0, -11.0, 0.0, 0.0), new NutationModel(1, -1, 2, -4, 1, 11.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(1, 1, 0, -2, 2, 14.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 0, 0, 24.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 0, 2, 18.0, 0.0, 0.0, -8.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 1, 0, -38.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 1, 0, -31.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 2, 1, -16.0, 0.0, 0.0, 8.0, 0.0, 0.0), new NutationModel(-1, -1, -2, 2, 0, 29.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, -4, 1, -18.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(2, 1, 0, -4, 1, -10.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(0, 2, 0, -2, 1, -17.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(1, 0, 0, -3, 1, 9.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(-2, 0, 2, -2, 2, 16.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 0, 1, 22.0, 0.0, 0.0, -12.0, 0.0, 0.0), new NutationModel(-4, 0, 0, 2, 0, 20.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 1, 0, -4, 1, -13.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(-1, 0, 2, -4, 1, -17.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(0, 0, 4, -4, 1, -14.0, 0.0, 0.0, 8.0, 0.0, 0.0), new NutationModel(0, 3, 2, -2, 2, 0.0, 0.0, 0.0, -7.0, 0.0, 0.0), new NutationModel(-3, -1, 0, 4, 0, 14.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 4, 1, 19.0, 0.0, 0.0, -10.0, 0.0, 0.0), new NutationModel(1, -1, -2, 2, 0, -34.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 2, 2, -20.0, 0.0, 0.0, 8.0, 0.0, 0.0), new NutationModel(1, -2, 0, 0, 1, 9.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(1, -1, 0, 0, 2, -18.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(0, 0, 0, 1, 2, 13.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 0, 0, 17.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -2, 2, -2, 2, -12.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(0, -1, 2, -1, 1, 15.0, 0.0, 0.0, -8.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 0, 3, -11.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(1, 1, 0, 0, 2, 13.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 0, 0, -18.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 2, 0, 0, 0, -35.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 2, 2, 0, 2, 9.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(-1, 0, 4, -2, 1, -19.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(3, 0, 2, -4, 2, -26.0, 0.0, 0.0, 11.0, 0.0, 0.0), new NutationModel(1, 2, 2, -2, 1, 8.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(1, 0, 4, -4, 2, -10.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 4, 1, 10.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(0, -1, 0, 2, 2, -21.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(-2, 1, 0, 4, 0, -15.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 2, 1, 9.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(2, 0, -2, 2, 0, -29.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 0, 1, 1, -19.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(0, 1, 0, 2, 2, 12.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(1, -1, 2, -1, 2, 22.0, 0.0, 0.0, -9.0, 0.0, 0.0), new NutationModel(-2, 0, 4, 0, 1, -10.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(2, 1, 0, 0, 1, -20.0, 0.0, 0.0, 11.0, 0.0, 0.0), new NutationModel(0, 1, 2, 0, 0, -20.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, -1, 4, -2, 2, -17.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(0, 0, 4, -2, 4, 15.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(0, 2, 2, 0, 1, 8.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 6, 0, 14.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 4, 1, -12.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(1, -2, 0, 2, 0, 25.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 4, 2, -13.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(-1, -2, 2, 2, 1, -14.0, 0.0, 0.0, 8.0, 0.0, 0.0), new NutationModel(-1, 0, 0, -2, 2, 13.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(1, 0, -2, -2, 1, -17.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(0, 0, -2, -2, 1, -12.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(-2, 0, -2, 0, 1, -10.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(0, 0, 0, 3, 1, 10.0, 0.0, 0.0, -6.0, 0.0, 0.0), new NutationModel(0, 0, 0, 3, 0, -15.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 4, 0, -22.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 2, 0, 28.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 3, 2, 15.0, 0.0, 0.0, -7.0, 0.0, 0.0), new NutationModel(1, 0, 0, 2, 2, 23.0, 0.0, 0.0, -10.0, 0.0, 0.0), new NutationModel(0, -1, 2, 1, 2, 12.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(3, -1, 0, 0, 0, 29.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(2, 0, 0, 1, 0, -25.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(1, -1, 2, 0, 0, 22.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, 1, 0, -18.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, 0, 3, 15.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(3, 1, 0, 0, 0, -23.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(3, -1, 2, -2, 2, 12.0, 0.0, 0.0, -5.0, 0.0, 0.0), new NutationModel(2, 0, 2, -1, 1, -8.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(1, 1, 2, 0, 0, -19.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 4, -1, 2, -10.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(1, 2, 2, 0, 2, 21.0, 0.0, 0.0, -9.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 6, 0, 23.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, -1, 0, 4, 1, -16.0, 0.0, 0.0, 8.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 4, 1, -19.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(0, -2, 2, 2, 1, -22.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(0, -1, 2, 2, 0, 27.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 3, 1, 16.0, 0.0, 0.0, -8.0, 0.0, 0.0), new NutationModel(-2, 1, 2, 4, 2, 19.0, 0.0, 0.0, -8.0, 0.0, 0.0), new NutationModel(2, 0, 0, 2, 2, 9.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(2, -2, 2, 0, 2, -9.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 3, 2, -9.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(3, 0, 2, -1, 2, -8.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(4, 0, 2, -2, 1, 18.0, 0.0, 0.0, -9.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 6, 0, 16.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-1, -2, 2, 4, 2, -10.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 6, 2, -23.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 4, 0, 16.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(3, 0, 0, 2, 1, -12.0, 0.0, 0.0, 6.0, 0.0, 0.0), new NutationModel(3, -1, 2, 0, 1, -8.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(3, 0, 2, 0, 0, 30.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(1, 0, 4, 0, 2, 24.0, 0.0, 0.0, -10.0, 0.0, 0.0), new NutationModel(5, 0, 2, -2, 2, 10.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(0, -1, 2, 4, 1, -16.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(2, -1, 2, 2, 1, -16.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(0, 1, 2, 4, 2, 17.0, 0.0, 0.0, -7.0, 0.0, 0.0), new NutationModel(1, -1, 2, 4, 2, -24.0, 0.0, 0.0, 10.0, 0.0, 0.0), new NutationModel(3, -1, 2, 2, 2, -12.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(3, 0, 2, 2, 1, -24.0, 0.0, 0.0, 11.0, 0.0, 0.0), new NutationModel(5, 0, 2, 0, 2, -23.0, 0.0, 0.0, 9.0, 0.0, 0.0), new NutationModel(0, 0, 2, 6, 2, -13.0, 0.0, 0.0, 5.0, 0.0, 0.0), new NutationModel(4, 0, 2, 2, 2, -15.0, 0.0, 0.0, 7.0, 0.0, 0.0), new NutationModel(0, -1, 1, -1, 1, 0.0, 0.0, -1988.0, 0.0, 0.0, -1679.0), new NutationModel(-1, 0, 1, 0, 3, 0.0, 0.0, -63.0, 0.0, 0.0, -27.0), new NutationModel(0, -2, 2, -2, 3, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, -1, 0, 1, 0.0, 0.0, 5.0, 0.0, 0.0, 4.0), new NutationModel(2, -2, 0, -2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-1, 0, 1, 0, 2, 0.0, 0.0, 364.0, 0.0, 0.0, 176.0), new NutationModel(-1, 0, 1, 0, 1, 0.0, 0.0, -1044.0, 0.0, 0.0, -891.0), new NutationModel(-1, -1, 2, -1, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-2, 2, 0, 2, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 0, 1, 0, 0, 0.0, 0.0, 330.0, 0.0, 0.0, 0.0), new NutationModel(-4, 1, 2, 2, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 1, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 0, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(1, 0, -2, 1, 1, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, -1, -2, 0, 1, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-4, 0, 2, 2, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 1, 0, 3, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, -1, 2, 0, 0.0, 0.0, 5.0, 0.0, 0.0, 0.0), new NutationModel(0, -2, 0, 0, 2, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(0, -2, 0, 0, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 3, 0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 2, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 3, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-4, 0, 0, 4, 0, -12.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 1, -2, 0, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(2, -1, 0, -2, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, 0, 1, -1, 0, -5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 2, 0, 1, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 1, 2, 0, 2, -7.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(1, 1, 0, -1, 1, 7.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(1, 0, 1, -2, 1, 0.0, 0.0, -12.0, 0.0, 0.0, -10.0), new NutationModel(0, 2, 0, 0, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(1, -1, 2, -3, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 1, 2, -1, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, 0, 4, -2, 2, -7.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-2, 0, 4, -2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, -2, 0, 2, 1, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-2, 0, -2, 4, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 2, 2, -4, 1, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(1, 1, 2, -4, 2, 7.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-1, 2, 2, -2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, 0, 0, -3, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 2, 0, 0, 1, -5.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(0, 0, 0, -2, 0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 2, -2, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 0, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 0, 0, -1, 2, -8.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-2, 1, 0, 1, 0, 9.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -2, 0, -2, 1, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(1, 0, -2, 0, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-3, 1, 0, 2, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 1, -2, 2, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 0, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 2, 0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, -1, 0, 2, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, -6, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 1, 2, -4, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 0, 0, -4, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-2, 1, 2, -2, 1, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, -1, 2, -4, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 1, 0, -2, 2, 9.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-1, 0, 0, -2, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, -2, -2, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-4, 0, 2, 0, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, -1, 0, -1, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, -2, 0, 2, 9.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 1, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 1, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, -2, 2, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 0, -4, 2, 0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, -1, -2, 2, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, -6, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 0, 2, -4, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(1, 0, 0, -4, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(2, 1, 2, -4, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(2, 1, 2, -4, 1, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(0, 1, 4, -4, 4, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 4, -4, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-1, -1, -2, 4, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -3, 0, 2, 0, 9.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, -2, 4, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 3, 0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 3, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 3, 1, -5.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(0, -1, 0, 1, 0, -13.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 2, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 1, -2, 2, 0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 2, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(1, -2, 2, -2, 1, 10.0, 0.0, 13.0, 6.0, 0.0, -5.0), new NutationModel(0, 0, 1, 0, 2, 0.0, 0.0, 30.0, 0.0, 0.0, 14.0), new NutationModel(0, 0, 1, 0, 1, 0.0, 0.0, -162.0, 0.0, 0.0, -138.0), new NutationModel(0, 0, 1, 0, 0, 0.0, 0.0, 75.0, 0.0, 0.0, 0.0), new NutationModel(-1, 2, 0, 2, 1, -7.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(0, 0, 2, 0, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 0, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 0, 0, -1, 1, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(3, 0, 0, -2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(1, 0, 2, -2, 3, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 2, 0, 0, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, 0, 2, -3, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 1, 4, -2, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, -2, 0, 4, 0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, -3, 0, 2, 0, 9.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 4, 0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 3, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 4, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 3, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, -2, 0, 0, 0, 7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -1, 0, 1, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 2, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, -2, 2, 0, 1, -6.0, 0.0, -3.0, 3.0, 0.0, 1.0), new NutationModel(-1, 0, 1, 2, 1, 0.0, 0.0, -3.0, 0.0, 0.0, -2.0), new NutationModel(-1, 1, 0, 3, 0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 1, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, -1, 2, 0, 0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 1, 2, 2, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, -2, 2, -2, 2, -1.0, 0.0, 3.0, 3.0, 0.0, -1.0), new NutationModel(1, 1, 0, 1, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(1, 0, 1, 0, 1, 0.0, 0.0, -13.0, 0.0, 0.0, -11.0), new NutationModel(1, 0, 1, 0, 0, 3.0, 0.0, 6.0, 0.0, 0.0, 0.0), new NutationModel(0, 2, 0, 2, 0, -7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, -1, 2, -2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(0, -1, 4, -2, 1, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(0, 0, 4, -2, 3, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 4, -2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(4, 0, 2, -4, 2, -7.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(2, 2, 2, -2, 2, 8.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(2, 0, 4, -4, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, -2, 0, 4, 0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, -3, 2, 2, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 4, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-3, 0, 2, -2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, -1, 0, -2, 1, 8.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(-3, 0, 0, 0, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-3, 0, -2, 2, 0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, -4, 1, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-2, 1, 0, -2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-4, 0, 0, 0, 1, -8.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(-1, 0, 0, -4, 1, -7.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-3, 0, 0, -2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 0, 3, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-1, 1, 0, 4, 1, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(1, -2, 2, 0, 1, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(0, 1, 0, 3, 0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 2, 3, 6.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(0, 0, 2, 2, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 2, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 2, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(3, 0, 0, 0, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, 1, 0, 1, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, -1, 2, -1, 2, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(0, 0, 2, 0, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 3, 0, 3, 0.0, 0.0, -26.0, 0.0, 0.0, -11.0), new NutationModel(0, 0, 3, 0, 2, 0.0, 0.0, -10.0, 0.0, 0.0, -5.0), new NutationModel(-1, 2, 2, 2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-1, 0, 4, 0, 0, -13.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 2, 2, 0, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(3, 1, 2, -2, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(1, 1, 4, -2, 2, 7.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-2, -1, 0, 6, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, -2, 0, 4, 0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 0, 6, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, -2, 2, 4, 2, -6.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, -3, 2, 2, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 0, 4, 2, -7.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 3, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 4, 0, 13.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, -1, 0, 2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(1, 0, 0, 3, 0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, 4, 1, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 1, 0, 4, 0, -11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -1, 2, 1, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 0, 2, 2, 3, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, 2, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 2, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-2, 0, 4, 2, 1, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(2, 1, 0, 2, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 1, 0, 2, 0, -12.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, -1, 2, 0, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, 1, 0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, 2, 0, -4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, 0, 3, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(3, 0, 2, 0, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(1, 0, 2, 0, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(1, 0, 3, 0, 3, 0.0, 0.0, -5.0, 0.0, 0.0, -2.0), new NutationModel(1, 1, 2, 1, 1, -7.0, 0.0, 0.0, 4.0, 0.0, 0.0), new NutationModel(0, 2, 2, 2, 2, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(2, 1, 2, 0, 0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 4, -2, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(4, 1, 2, -2, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 6, 0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-3, -1, 2, 6, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 6, 1, -5.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-3, 0, 2, 6, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(1, -1, 0, 4, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(1, -1, 0, 4, 0, 12.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 5, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(1, -2, 2, 2, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(3, -1, 0, 2, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, -1, 2, 2, 0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, 3, 1, 5.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(-1, 1, 2, 4, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(0, 1, 2, 3, 2, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-1, 0, 4, 2, 1, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 0, 2, 1, 1, 6.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(5, 0, 0, 0, 0, 6.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 1, 2, 1, 2, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(1, 0, 4, 0, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(3, 1, 2, 0, 1, 7.0, 0.0, 0.0, -4.0, 0.0, 0.0), new NutationModel(3, 0, 4, -2, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-2, -1, 2, 6, 2, -5.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 0, 6, 0, 5.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, -2, 2, 4, 2, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 6, 1, -6.0, 0.0, 0.0, 3.0, 0.0, 0.0), new NutationModel(2, 0, 0, 4, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(2, 0, 0, 4, 0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, -2, 2, 2, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(0, 0, 2, 4, 0, 7.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, 3, 2, 7.0, 0.0, 0.0, -3.0, 0.0, 0.0), new NutationModel(4, 0, 0, 2, 0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, 2, 0, 11.0, 0.0, 0.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 4, 2, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(4, -1, 2, 0, 2, -6.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(3, 0, 2, 1, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(2, 1, 2, 2, 1, 3.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(4, 1, 2, 0, 2, 5.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(-1, -1, 2, 6, 2, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(-1, 0, 2, 6, 1, -4.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(1, -1, 2, 4, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0), new NutationModel(1, 1, 2, 4, 2, 4.0, 0.0, 0.0, -2.0, 0.0, 0.0), new NutationModel(3, 1, 2, 2, 2, 3.0, 0.0, 0.0, -1.0, 0.0, 0.0), new NutationModel(5, 0, 2, 0, 1, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(2, -1, 2, 4, 2, -3.0, 0.0, 0.0, 1.0, 0.0, 0.0), new NutationModel(2, 0, 2, 4, 1, -3.0, 0.0, 0.0, 2.0, 0.0, 0.0)};
        int NLS = xls.length;
        final class PlanetaryNutModel {
            final int nl;
            final int nf;
            final int nd;
            final int nom;
            final int nme;
            final int nve;
            final int nea;
            final int nma;
            final int nju;
            final int nsa;
            final int nur;
            final int nne;
            final int npa;
            final int sp;
            final int cp;
            final int se;
            final int ce;

            public PlanetaryNutModel(int nl, int nf, int nd, int nom, int nme, int nve, int nea, int nma, int nju, int nsa, int nur, int nne, int npa, int sp, int cp, int se, int ce) {
                this.nl = nl;
                this.nf = nf;
                this.nd = nd;
                this.nom = nom;
                this.nme = nme;
                this.nve = nve;
                this.nea = nea;
                this.nma = nma;
                this.nju = nju;
                this.nsa = nsa;
                this.nur = nur;
                this.nne = nne;
                this.npa = npa;
                this.sp = sp;
                this.cp = cp;
                this.se = se;
                this.ce = ce;
            }
        }
        PlanetaryNutModel[] xpl = new PlanetaryNutModel[]{new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 8, -16, 4, 5, 0, 0, 0, 1440, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -8, 16, -4, -5, 0, 0, 2, 56, -117, -42, -40), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 8, -16, 4, 5, 0, 0, 2, 125, -43, 0, -54), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 2, 2, 0, 5, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 8, -1, -5, 0, 0, 2, 3, -7, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 1, 3, 0, 0, -2), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, 3, -8, 3, 0, 0, 0, 0, -114, 0, 0, 61), new PlanetaryNutModel(-1, 0, 0, 0, 0, 10, -3, 0, 0, 0, 0, 0, 0, -219, 89, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, -2, 6, -3, 0, 2, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, -462, 1604, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -5, 8, -3, 0, 0, 0, 0, 99, 0, 0, -53), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 8, -3, 0, 0, 0, 1, -3, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -8, 1, 5, 0, 0, 2, 0, 6, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 6, 4, 0, 0, 0, 0, 2, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 2, -12, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 1, 14, -218, 117, 8), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 2, -5, 0, 0, 0, 31, -481, -257, -17), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 0, -491, 128, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -2, 5, 0, 0, 0, -3084, 5123, 2735, 1647), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, -2, 5, 0, 0, 1, -1444, 2409, -1286, -771), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, -2, 5, 0, 0, 2, 11, -24, -11, -9), new PlanetaryNutModel(2, -1, -1, 0, 0, 0, 3, -7, 0, 0, 0, 0, 0, 26, -9, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 19, -21, 3, 0, 0, 0, 0, 0, 103, -60, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 2, -4, 0, -3, 0, 0, 0, 0, 0, -13, -7, 0), new PlanetaryNutModel(1, 0, -1, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0, -26, -29, -16, 14), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -4, 10, 0, 0, 0, 9, -27, -14, -5), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 2, 0, 0, -5, 0, 0, 0, 12, 0, 0, -6), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -7, 4, 0, 0, 0, 0, 0, -7, 0, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 1, -1, 0, 0, 0, 0, 24, 0, 0), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 2, 0, -2, 0, 0, 0, 0, 284, 0, 0, -151), new PlanetaryNutModel(-1, 0, 0, 0, 0, 18, -16, 0, 0, 0, 0, 0, 0, 226, 101, 0, 0), new PlanetaryNutModel(-2, 1, 1, 2, 0, 0, 1, 0, -2, 0, 0, 0, 0, 0, -8, -2, 0), new PlanetaryNutModel(-1, 1, -1, 1, 0, 18, -17, 0, 0, 0, 0, 0, 0, 0, -6, -3, 0), new PlanetaryNutModel(-1, 0, 1, 1, 0, 0, 2, -2, 0, 0, 0, 0, 0, 5, 0, 0, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 13, 0, 0, 0, 0, 0, 2, -41, 175, 76, 17), new PlanetaryNutModel(0, 2, -2, 2, 0, -8, 11, 0, 0, 0, 0, 0, 0, 0, 15, 6, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 13, 0, 0, 0, 0, 0, 1, 425, 212, -133, 269), new PlanetaryNutModel(0, 1, -1, 1, 0, -8, 12, 0, 0, 0, 0, 0, 0, 1200, 598, 319, -641), new PlanetaryNutModel(0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, 0, 235, 334, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 8, -14, 0, 0, 0, 0, 0, 0, 11, -12, -7, -6), new PlanetaryNutModel(0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, 1, 5, -6, 3, 3), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 2, 0, -4, 5, 0, 0, 0, -5, 0, 0, 3), new PlanetaryNutModel(-2, 0, 2, 2, 0, 3, -3, 0, 0, 0, 0, 0, 0, 6, 0, 0, -3), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -3, 1, 0, 0, 0, 15, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 3, -5, 0, 2, 0, 0, 0, 0, 13, 0, 0, -7), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -4, 3, 0, 0, 0, -6, -9, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 266, -78, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -1, 2, 0, 0, 0, 0, 0, -460, -435, -232, 246), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -2, 2, 0, 0, 0, 0, 0, 0, 15, 7, 0), new PlanetaryNutModel(-1, 1, 0, 1, 0, 3, -5, 0, 0, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(-1, 0, 1, 0, 0, 3, -4, 0, 0, 0, 0, 0, 0, 0, 131, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -2, -2, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(-2, 2, 0, 2, 0, 0, -5, 9, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 0, -1, 0, 0, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 0, 0, 2, 0, -17, -19, -10, 9), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, -9, -11, 6, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, -6, 0, 0, 3), new PlanetaryNutModel(-1, 0, 1, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, -16, 8, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 0, 2, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, 0, 2, 0, 0, 0, 11, 24, 11, -5), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -9, 17, 0, 0, 0, 0, 0, -3, -4, -2, 1), new PlanetaryNutModel(0, 0, 0, 2, 0, -3, 5, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -1, 2, 0, 0, 0, 0, -8, -4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 17, -16, 0, -2, 0, 0, 0, 0, 0, 5, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 1, -3, 0, 0, 0, 0, 3, 2, 0), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 5, -6, 0, 0, 0, 0, 0, -6, 4, 2, 3), new PlanetaryNutModel(0, -2, 2, 0, 0, 0, 9, -13, 0, 0, 0, 0, 0, -3, -5, 0, 0), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, 0, 1, 0, 0, 0, -5, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 4, 24, 13, -2), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, -42, 20, 0, 0), new PlanetaryNutModel(0, -2, 2, 0, 0, 5, -6, 0, 0, 0, 0, 0, 0, -10, 233, 0, 0), new PlanetaryNutModel(0, -1, 1, 1, 0, 5, -7, 0, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(-2, 0, 2, 0, 0, 6, -8, 0, 0, 0, 0, 0, 0, 78, -18, 0, 0), new PlanetaryNutModel(2, 1, -3, 1, 0, -6, 7, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -3, -1, 0), new PlanetaryNutModel(0, -1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, -4, -2, 1), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 0, 2, 0, 0, 0, -8, -4, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 0, -5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, -7, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -8, 15, 0, 0, 0, 0, 2, -14, 8, 3, 6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -8, 15, 0, 0, 0, 0, 1, 0, 8, -4, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -9, 15, 0, 0, 0, 0, 0, 0, 19, 10, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 8, -15, 0, 0, 0, 0, 0, 45, -22, 0, 0), new PlanetaryNutModel(1, -1, -1, 0, 0, 0, 8, -15, 0, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(2, 0, -2, 0, 0, 2, -5, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -5, 5, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(2, 0, -2, 1, 0, 0, -6, 8, 0, 0, 0, 0, 0, 3, 5, 3, -2), new PlanetaryNutModel(2, 0, -2, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0, 89, -16, -9, -48), new PlanetaryNutModel(-2, 1, 1, 0, 0, 0, 1, 0, -3, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(-2, 1, 1, 1, 0, 0, 1, 0, -3, 0, 0, 0, 0, -3, 7, 4, 2), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0, -349, -62, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 6, -8, 0, 0, 0, 0, 0, -15, 22, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -1, -5, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(-1, 0, 1, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, -53, 0, 0, 0), new PlanetaryNutModel(-1, 1, 1, 1, 0, -20, 20, 0, 0, 0, 0, 0, 0, 5, 0, 0, -3), new PlanetaryNutModel(1, 0, -2, 0, 0, 20, -21, 0, 0, 0, 0, 0, 0, 0, -8, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 8, -15, 0, 0, 0, 0, 0, 15, -7, -4, -8), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -10, 15, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, -21, -78, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 20, -70, -37, -11), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, 6, 3, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -2, 4, 0, 0, 0, 5, 3, 2, -2), new PlanetaryNutModel(2, 0, -2, 1, 0, -6, 8, 0, 0, 0, 0, 0, 0, -17, -4, -2, 9), new PlanetaryNutModel(0, -2, 2, 1, 0, 5, -6, 0, 0, 0, 0, 0, 0, 0, 6, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 1, 32, 15, -8, 17), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, -1, 0, 0, 0, 174, 84, 45, -93), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 11, 56, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 1, 0, 0, 0, -66, -12, -6, 35), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 47, 8, 4, -25), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 8, 4, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -9, 13, 0, 0, 0, 0, 0, 10, -22, -12, -5), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 7, -13, 0, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, -24, 12, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 9, -17, 0, 0, 0, 0, 0, 5, -6, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -9, 17, 0, 0, 0, 0, 2, 3, 0, 0, -2), new PlanetaryNutModel(1, 0, -1, 1, 0, 0, -3, 4, 0, 0, 0, 0, 0, 4, 3, 1, -2), new PlanetaryNutModel(1, 0, -1, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0, 0, 29, 15, 0), new PlanetaryNutModel(0, 0, 0, 2, 0, 0, -1, 2, 0, 0, 0, 0, 0, -5, -4, -2, 2), new PlanetaryNutModel(0, -1, 1, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 8, -3, -1, -5), new PlanetaryNutModel(0, -2, 2, 0, 1, 0, -2, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -5, 0, 2, 0, 0, 0, 0, 10, 0, 0, 0), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 2, 0, -3, 1, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(-2, 0, 2, 1, 0, 3, -3, 0, 0, 0, 0, 0, 0, -5, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 1, 0, 8, -13, 0, 0, 0, 0, 0, 0, 46, 66, 35, -25), new PlanetaryNutModel(0, -1, 1, 0, 0, 8, -12, 0, 0, 0, 0, 0, 0, -14, 7, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, -8, 11, 0, 0, 0, 0, 0, 0, 0, 3, 2, 0), new PlanetaryNutModel(-1, 0, 1, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, -5, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 1, 0, 18, -16, 0, 0, 0, 0, 0, 0, -68, -34, -18, 36), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -1, 1, 0, 0, 0, 0, 14, 7, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 3, -7, 4, 0, 0, 0, 0, 0, 10, -6, -3, -5), new PlanetaryNutModel(-2, 1, 1, 1, 0, 0, -3, 7, 0, 0, 0, 0, 0, -5, -4, -2, 3), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, -2, 5, 0, 0, 0, -3, 5, 2, 1), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, -2, 5, 0, 0, 0, 76, 17, 9, -41), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -4, 8, -3, 0, 0, 0, 0, 84, 298, 159, -45), new PlanetaryNutModel(1, 0, 0, 1, 0, -10, 3, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -2, 0, 0, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(-1, 0, 0, 1, 0, 10, -3, 0, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 4, -8, 3, 0, 0, 0, 0, -82, 292, 156, 44), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, 2, -5, 0, 0, 0, -73, 17, 9, 39), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 2, -5, 0, 0, 0, -9, -16, 0, 0), new PlanetaryNutModel(2, -1, -1, 1, 0, 0, 3, -7, 0, 0, 0, 0, 0, 3, 0, -1, -2), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, 0, -5, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -3, 7, -4, 0, 0, 0, 0, 0, -9, -5, -3, 5), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, -439, 0, 0, 0), new PlanetaryNutModel(1, 0, 0, 1, 0, -18, 16, 0, 0, 0, 0, 0, 0, 57, -28, -15, -30), new PlanetaryNutModel(-2, 1, 1, 1, 0, 0, 1, 0, -2, 0, 0, 0, 0, 0, -6, -3, 0), new PlanetaryNutModel(0, 1, -1, 2, 0, -8, 12, 0, 0, 0, 0, 0, 0, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 1, 0, -8, 13, 0, 0, 0, 0, 0, 0, -40, 57, 30, 21), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 1, 23, 7, 3, -13), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, 0, -2, 0, 0, 0, 0, 0, 273, 80, 43, -146), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, -449, 430, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -2, 2, 0, 0, 0, 0, 0, -8, -47, -25, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 2, 0, 0, 0, 0, 1, 6, 47, 25, -3), new PlanetaryNutModel(-1, 0, 1, 1, 0, 3, -4, 0, 0, 0, 0, 0, 0, 0, 23, 13, 0), new PlanetaryNutModel(-1, 0, 1, 1, 0, 0, 3, -4, 0, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, -2, 0, 0, 0, 3, -4, -2, -2), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 2, 0, 0, 0, -48, -110, -59, 26), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 51, 114, 61, -27), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, -133, 0, 0, 57), new PlanetaryNutModel(0, 1, -1, 0, 0, 3, -6, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -3, 5, 0, 0, 0, 0, 0, 0, -21, -6, -3, 11), new PlanetaryNutModel(0, 1, -1, 2, 0, -3, 4, 0, 0, 0, 0, 0, 0, 0, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -2, 4, 0, 0, 0, 0, 0, -11, -21, -11, 6), new PlanetaryNutModel(0, 2, -2, 1, 0, -5, 6, 0, 0, 0, 0, 0, 0, -18, -436, -233, 9), new PlanetaryNutModel(0, -1, 1, 0, 0, 5, -7, 0, 0, 0, 0, 0, 0, 35, -7, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 5, -8, 0, 0, 0, 0, 0, 0, 0, 5, 3, 0), new PlanetaryNutModel(-2, 0, 2, 1, 0, 6, -8, 0, 0, 0, 0, 0, 0, 11, -3, -1, -6), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -8, 15, 0, 0, 0, 0, 0, -5, -3, -1, 3), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 2, 0, -3, 0, 0, 0, 0, -53, -9, -5, 28), new PlanetaryNutModel(-2, 0, 2, 1, 0, 0, 6, -8, 0, 0, 0, 0, 0, 0, 3, 2, 1), new PlanetaryNutModel(1, 0, -1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, -1, 0, 0, 0, 0, -50, 194, 103, 27), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 1, -13, 52, 28, 7), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, -91, 248, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 6, 49, 26, -3), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, -6, -47, -25, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 52, 23, 10, -23), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, 0, -1, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 5, 3, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -7, 13, 0, 0, 0, 0, 2, -4, 8, 3, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -13, 0, 0, 0, 0, 0, 10, 0, 0, 0), new PlanetaryNutModel(2, 0, -2, 1, 0, 0, -5, 6, 0, 0, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -8, 11, 0, 0, 0, 0, 0, 0, 8, 4, 0), new PlanetaryNutModel(0, 2, -2, 1, -1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 4, 1), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 0, 3, 0, 0, 0, -8, 4, 2, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1, 8, -4, -2, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 2, 0, 15, 7, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0, -138, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0, 0, -7, -3, 0), new PlanetaryNutModel(0, 0, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, -7, -3, 0), new PlanetaryNutModel(2, 0, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0, 54, 0, 0, -29), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, 2, 0, 0, 0, 0, 0, 10, 4, 0), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, 0, -2, 0, 0, 0, 0, 0, -7, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 1, -2, 0, 0, 0, 0, 0, -37, 35, 19, 20), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 4, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, 0, -2, 0, 0, 0, -4, 9, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -2, 0, 0, 2, 0, 0, 0, 8, 0, 0, -4), new PlanetaryNutModel(0, 1, -1, 1, 0, 3, -6, 0, 0, 0, 0, 0, 0, -9, -14, -8, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, 1, -3, -9, -5, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, 0, -145, 47, 0, 0), new PlanetaryNutModel(0, 1, -1, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0, -10, 40, 21, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 5, 0, 0, 0, 0, 0, 1, 11, -49, -26, -7), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 5, 0, 0, 0, 0, 0, 2, -2150, 0, 0, 932), new PlanetaryNutModel(0, 2, -2, 2, 0, -3, 3, 0, 0, 0, 0, 0, 0, -12, 0, 0, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 5, 0, 0, 0, 0, 0, 2, 85, 0, 0, -37), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 1, 4, 0, 0, -2), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, 1, -4, 0, 0, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0, -86, 153, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 4, 0, 0, 0, 0, 1, -6, 9, 5, 3), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -3, 4, 0, 0, 0, 0, 0, 9, -13, -7, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 4, 0, 0, 0, 0, 1, -8, 12, 6, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 4, 0, 0, 0, 0, 2, -51, 0, 0, 22), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 8, 0, 0, 0, 0, 0, 2, -11, -268, -116, 5), new PlanetaryNutModel(0, 2, -2, 2, 0, -5, 6, 0, 0, 0, 0, 0, 0, 0, 12, 5, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 8, 0, 0, 0, 0, 0, 2, 0, 7, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 8, 0, 0, 0, 0, 0, 1, 31, 6, 3, -17), new PlanetaryNutModel(0, 1, -1, 1, 0, -5, 7, 0, 0, 0, 0, 0, 0, 140, 27, 14, -75), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 8, 0, 0, 0, 0, 0, 1, 57, 11, 6, -30), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0, 0, -14, -39, 0, 0), new PlanetaryNutModel(0, 1, -1, 2, 0, 0, -1, 0, -1, 0, 0, 0, 0, 0, -6, -2, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 4, 15, 8, -2), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 0, 4, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -2, 0, 1, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 11, 0, 0, 0, 0, 2, 0, 11, 5, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -11, 0, 0, 0, 0, 0, 9, 6, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, -1, 0, 4, 0, 0, 0, 0, 0, 2, -4, 10, 4, 2), new PlanetaryNutModel(0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 0, 0, 0, 5, 3, 0, 0), new PlanetaryNutModel(2, 0, -2, 1, 0, -3, 3, 0, 0, 0, 0, 0, 0, 16, 0, 0, -9), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -7, 9, 0, 0, 0, 0, 0, 0, 3, 2, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 2, 7, 0, 0, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, -25, 22, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 42, 223, 119, -22), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0, -27, -143, -77, 14), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 9, 49, 26, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, -1166, 0, 0, 505), new PlanetaryNutModel(0, 2, -2, 2, 0, 0, -2, 0, 2, 0, 0, 0, 0, -5, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 2, -6, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 1, 0, 3, -5, 0, 0, 0, 0, 0, 0, -8, 0, 1, 4), new PlanetaryNutModel(0, -1, 1, 0, 0, 3, -4, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, -3, 3, 0, 0, 0, 0, 0, 0, 117, 0, 0, -63), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 2, -4, 0, 0, 0, 0, 0, -4, 8, 4, 2), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -4, 4, 0, 0, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(0, 1, -1, 2, 0, -5, 7, 0, 0, 0, 0, 0, 0, -5, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0, 0, 31, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 6, 0, 0, 0, 0, 1, -5, 0, 1, 3), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -4, 6, 0, 0, 0, 0, 0, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 6, 0, 0, 0, 0, 1, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 6, 0, 0, 0, 0, 2, -24, -13, -6, 10), new PlanetaryNutModel(0, -1, 1, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 2, -3, 0, 0, 0, 0, 0, 0, 0, -32, -17, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 9, 0, 0, 0, 0, 2, 8, 12, 5, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 9, 0, 0, 0, 0, 1, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -9, 0, 0, 0, 0, 0, 7, 13, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 0, 1, 0, -2, 0, 0, 0, 0, -3, 16, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0, 50, 0, 0, -27), new PlanetaryNutModel(-2, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -5, -3, 0), new PlanetaryNutModel(0, -2, 2, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 10, 0, 0, 0, 0, 0, 1, 0, 5, 3, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 10, 0, 0, 0, 0, 0, 2, 24, 5, 2, -11), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 3, 0, 0, 0, 0, 0, 2, 5, -11, -5, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 3, 0, 0, 0, 0, 0, 1, 30, -3, -2, -16), new PlanetaryNutModel(0, 1, -1, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0, 18, 0, 0, -9), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, 0, 8, 614, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, 1, 3, -3, -1, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 6, 17, 9, -3), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, -1, 0, 3, 0, 0, 0, 0, -3, -9, -5, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 6, 3, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, -127, 21, 9, 55), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -8, 0, 0, 0, 0, 0, 3, 5, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 8, 0, 0, 0, 0, 2, -6, -10, -4, 3), new PlanetaryNutModel(0, -2, 2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, 5, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 7, 0, 0, 0, 0, 2, 16, 9, 4, -7), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 7, 0, 0, 0, 0, 1, 3, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, 0, 0, 22, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -2, 3, 0, 0, 0, 0, 0, 0, 0, 19, 10, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0, 7, 0, 0, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 10, 0, 0, 0, 0, 2, 0, -5, -2, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 2, -9, 3, 1, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 5, 0, 0, 0, 0, 2, 17, 0, 0, -7), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 5, 0, 0, 0, 0, 1, 0, -3, -2, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, -20, 34, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, 1, -10, 0, 1, 5), new PlanetaryNutModel(0, 1, -1, 1, 0, 1, -3, 0, 0, 0, 0, 0, 0, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, 0, 22, -87, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 2, 0, 0, 0, 0, 0, 1, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 2, 0, 0, 0, 0, 0, 2, -3, -6, -2, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 11, 0, 0, 0, 0, 0, 2, -16, -3, -1, 7), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 11, 0, 0, 0, 0, 0, 1, 0, -3, -2, 0), new PlanetaryNutModel(0, -2, 2, 0, 0, 4, -4, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, -68, 39, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, -4, 4, 0, 0, 0, 0, 0, 0, 27, 0, 0, -14), new PlanetaryNutModel(0, -1, 1, 0, 0, 4, -5, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, -25, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 7, 0, 0, 0, 0, 0, 1, -12, -3, -2, 6), new PlanetaryNutModel(0, 1, -1, 1, 0, -4, 6, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 7, 0, 0, 0, 0, 0, 2, 3, 66, 29, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 6, 0, 0, 0, 0, 0, 2, 490, 0, 0, -213), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 6, 0, 0, 0, 0, 0, 1, -22, 93, 49, 12), new PlanetaryNutModel(0, 1, -1, 1, 0, -4, 5, 0, 0, 0, 0, 0, 0, -7, 28, 15, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 6, 0, 0, 0, 0, 0, 1, -3, 13, 7, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0, 0, -46, 14, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 2, 1, 0, 0), new PlanetaryNutModel(0, -1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 1, -1, 0, 0, 0, 0, 0, 0, -28, 0, 0, 15), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 5, 0, 0, 0, 2, 5, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 3, 0, 0, 0, 0, 2, -11, 0, 0, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -7, 12, 0, 0, 0, 0, 2, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 1, 25, 106, 57, -13), new PlanetaryNutModel(0, 1, -1, 1, 0, -1, 0, 0, 0, 0, 0, 0, 0, 5, 21, 11, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, 1485, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 1, -7, -32, -17, 4), new PlanetaryNutModel(0, 1, -1, 1, 0, 1, -2, 0, 0, 0, 0, 0, 0, 0, 5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 5, 0, 0, 0, 0, 2, -6, -3, -2, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 4, 0, 0, 0, 2, 30, -6, -2, -13), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 0, -4, 4, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -1, 1, 0, 0, 0, 0, 0, 0, -19, 0, 0, 10), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 10, 0, 0, 0, 0, 2, 0, 4, 2, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 10, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -3, 0, 3, 0, 0, 0, 0, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 7, 0, 0, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 4, -4, 0, 0, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 8, 0, 0, 0, 0, 2, 5, 3, 1, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0, 0, 11, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 3, 0, 0, 0, 2, 118, 0, 0, -52), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 3, 0, 0, 0, 1, 0, -5, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -3, 0, 0, 0, 0, -28, 36, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0, 0, 5, -5, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 4, 0, 0, 0, 0, 0, 1, 14, -59, -31, -8), new PlanetaryNutModel(0, 1, -1, 1, 0, -2, 3, 0, 0, 0, 0, 0, 0, 0, 9, 5, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 4, 0, 0, 0, 0, 0, 2, -458, 0, 0, 198), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 9, 0, 0, 0, 0, 0, 2, 0, -45, -20, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 9, 0, 0, 0, 0, 0, 1, 9, 0, 0, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 1, 0, -2, 0, 0, 0, 0, 0, -4, -2, -1), new PlanetaryNutModel(0, 2, -2, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0, 11, 0, 0, -6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -4, 6, 0, 0, 0, 0, 2, 6, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0, -16, 23, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 3, -4, 0, 0, 0, 0, 0, 0, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 2, 0, 0, 0, 2, -5, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -2, 0, 0, 0, 0, -166, 269, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 1, 0, -1, 0, 0, 0, 0, 15, 0, 0, -8), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 9, 0, 0, 0, 0, 0, 2, 10, 0, 0, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, -78, 45, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 4, 0, 0, 0, 0, 0, 2, 0, -5, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 4, 0, 0, 0, 0, 0, 1, 7, 0, 0, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, 0, -5, 328, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, 1, 3, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 2, -2, 0, 0, 0, 0, 0, 5, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, -3, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 1, -5, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 0, 0, 1, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, -1223, -26, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 1, 0, 7, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -3, 5, 0, 0, 0, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0, 0, 3, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, -2, 0, 0, 0, -6, 20, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, -368, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0, -75, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 11, 0, 0, -6), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, -2, 2, 0, 0, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 14, 0, 0, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 2, -5, 0, 0, 0, -13, -30, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -8, 3, 0, 0, 0, 0, 21, 3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -8, 3, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 1, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 8, -27, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -8, 3, 0, 0, 0, 0, -19, -11, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 8, -3, 0, 0, 0, 2, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, -2, 5, 0, 0, 2, 0, 5, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 12, 0, 0, 0, 0, 0, 2, -6, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 12, 0, 0, 0, 0, 0, 0, -8, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 1, -2, 0, 0, 0, -1, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 2, -14, 0, 0, 6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 6, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2, -74, 0, 0, 32), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, -5, 5, 0, 0, 0, 0, 0, 0, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 8, 11, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 3, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2, -262, 0, 0, 114), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 6, 0, 0, 0, 0, 0, 1, -7, 0, 0, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 6, 0, 0, 0, 0, 0, 2, 0, -27, -12, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 4, 0, 0, 0, 0, 2, -19, -8, -4, 8), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 7, 0, 0, 0, 0, 0, 2, 202, 0, 0, -87), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 7, 0, 0, 0, 0, 0, 1, -8, 35, 19, 5), new PlanetaryNutModel(0, 1, -1, 1, 0, -5, 6, 0, 0, 0, 0, 0, 0, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0, 0, 16, -5, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0, 5, 0, 0, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, -1, 0, 3, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 2, -35, -48, -21, 15), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 6, 0, 0, 0, 0, 2, -3, -5, -2, 1), new PlanetaryNutModel(0, 0, 0, 1, 0, 2, -2, 0, 0, 0, 0, 0, 0, 6, 0, 0, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 9, 0, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0, 0, -5, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 2, 0, 0, 0, 0, 0, 1, 12, 55, 29, -6), new PlanetaryNutModel(0, 1, -1, 1, 0, -2, 1, 0, 0, 0, 0, 0, 0, 0, 5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, -598, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 1, -3, -13, -7, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 2, -5, -7, -3, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 7, 0, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0, 5, -7, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0, 16, -6, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0, 0, 8, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 3, 0, 0, 0, 0, 0, 1, 8, -31, -16, -4), new PlanetaryNutModel(0, 1, -1, 1, 0, -1, 2, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 3, 0, 0, 0, 0, 0, 2, 113, 0, 0, -49), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 10, 0, 0, 0, 0, 0, 2, 0, -24, -10, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 10, 0, 0, 0, 0, 0, 1, 4, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 27, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 8, 0, 0, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 5, 0, 0, 0, 0, 0, 2, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 5, 0, 0, 0, 0, 0, 1, 5, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 2, -13, 0, 0, 6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 0, 5, 0, 0, 0, 2, 5, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 2, -18, -10, -4, 8), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -4, -28, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2, -5, 6, 3, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 13, 0, 0, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 5, 0, 0, 0, 0, 2, -5, -9, -4, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 0, 4, 0, 0, 0, 2, 17, 0, 0, -7), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -4, 0, 0, 0, 0, 11, 4, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 7, 0, 0, 0, 0, 2, 0, -6, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0, 83, 15, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 5, 0, 0, 0, 0, 0, 1, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 5, 0, 0, 0, 0, 0, 2, 0, -114, -49, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 8, 0, 0, 0, 0, 0, 2, 117, 0, 0, -51), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 8, 0, 0, 0, 0, 0, 1, -5, 19, 10, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -8, 0, 0, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 1, 0, 0, 2, 0, -2, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 9, 0, 0, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 2, 0, -6, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, 393, 3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 1, -4, 21, 11, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 2, -6, 0, -1, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 10, 0, 0, 0, 0, 0, 2, -3, 8, 4, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 8, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 2, 18, -29, -13, -8), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 3, 0, 0, 0, 0, 0, 1, 8, 34, 18, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0, 89, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 1, 3, 12, 6, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 2, 54, -15, -7, -24), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, -3, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 13, 0, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -1, 0, 0, 0, 0, 0, 35, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -1, 0, 0, 0, 2, -154, -30, -13, 67), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0, 15, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 1, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 9, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 2, 80, -71, -31, -35), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, -1, 0, 0, 2, 0, -20, -9, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 15, 0, 0, 0, 0, 2, 11, 5, 2, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 15, 0, 0, 0, 0, 0, 2, 61, -96, -42, -27), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 9, -4, 0, 0, 0, 0, 2, 14, 9, 4, -6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 2, -5, 0, 0, 2, -11, -6, -3, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 8, -1, -5, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -8, 3, 0, 0, 0, 2, 123, -415, -180, -53), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, -35), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 7, -32, -17, -4), new PlanetaryNutModel(0, 1, -1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -9, -5, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1, 0, -4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2, -89, 0, 0, 38), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -6, 16, -4, -5, 0, 0, 2, 0, -86, -19, -6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 8, -3, 0, 0, 0, 2, 0, 0, -19, 6), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -2, 8, -3, 0, 0, 0, 2, -123, -416, -180, 53), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -8, 1, 5, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -2, 5, 0, 0, 2, 12, -6, -3, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -5, 4, 0, 0, 0, 0, 2, -13, 9, 4, 6), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 11, 0, 0, 0, 0, 0, 2, 0, -15, -7, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 11, 0, 0, 0, 0, 0, 1, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 11, 0, 0, 0, 0, 0, 2, -62, -97, -42, 27), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 2, -11, 5, 2, 5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 2, 0, -19, -8, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -3, 0, 2, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, 4, 2, 0), new PlanetaryNutModel(0, 1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, -4, 8, -3, 0, 0, 0, 0, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 2, -85, -70, -31, 37), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 2, 163, -12, -5, -72), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 7, 0, 0, 0, 0, 0, 2, -63, -16, -7, 28), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 2, -21, -32, -14, 9), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 6, 0, 0, 0, 0, 0, 2, 0, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 6, 0, 0, 0, 0, 0, 1, 3, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, 2, 3, 10, 4, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 6, 0, 0, 0, 0, 2, 0, -7, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -9, 0, 0, 0, 0, 2, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0, 6, 19, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, 2, 5, -173, -75, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -7, 0, 0, 0, 0, 2, 0, -7, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 2, 7, -12, -5, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 4, 0, 0, 0, 0, 0, 1, -3, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -1, 4, 0, 0, 0, 0, 0, 2, 3, -4, -2, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 9, 0, 0, 0, 0, 0, 2, 74, 0, 0, -32), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 9, 0, 0, 0, 0, 0, 1, -3, 12, 6, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -3, 0, 0, 0, 0, 2, 26, -14, -6, -11), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 2, 19, 0, 0, -8), new PlanetaryNutModel(0, 0, 0, 0, 0, -4, 4, 0, 0, 0, 0, 0, 1, 6, 24, 13, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 1, 0, -10, -5, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 2, 11, -3, -1, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 2, 3, 0, 1, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -3, 0, 5, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 5, -23, -12, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 2, -339, 0, 0, 147), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 12, 0, 0, 0, 0, 0, 2, 0, -10, -5, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -4, 0, 0, 0, 0, 5, 0, 0, 0), new PlanetaryNutModel(0, 2, -2, 1, 0, 1, -1, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -8, 0, 0, 0, 0, 2, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -3, 0, 0, 0, 0, 18, -3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -3, 0, 0, 0, 2, 9, -11, -5, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, -2, 6, 0, 0, 0, 0, 0, 2, -8, 0, 0, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 7, 0, 0, 0, 0, 0, 1, 3, 0, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -7, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 2, 6, -9, -4, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -2, 0, 0, 0, 0, -4, -12, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -2, 0, 0, 0, 2, 67, -91, -39, -29), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -4, 0, 0, 0, 0, 2, 30, -18, -8, -13), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0, 2, 0, -114, -50, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -1, 0, 0, 0, 2, 0, 0, 0, 23), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, -1, 0, 0, 0, 2, 517, 16, 7, -224), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, 0, -2, 0, 0, 2, 0, -7, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 2, 143, -3, -1, -62), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, 0, -1, 0, 0, 2, 29, 0, 0, -13), new PlanetaryNutModel(0, 2, -2, 1, 0, 0, 1, 0, -1, 0, 0, 0, 0, -4, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 16, 0, 0, 0, 0, 0, 2, -6, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, 2, -5, 0, 0, 2, 5, 12, 5, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -8, 3, 0, 0, 0, 2, -25, 0, 0, 11), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -5, 16, -4, -5, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 2, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, -1, 8, -3, 0, 0, 0, 2, -22, 12, 5, 10), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 10, 0, 0, 0, 0, 0, 2, 50, 0, 0, -22), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 10, 0, 0, 0, 0, 0, 1, 0, 7, 4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 10, 0, 0, 0, 0, 0, 2, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 2, -4, 4, 2, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 3, 0, 1, 0, 0, 0, 2, -5, -11, -5, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, -3, 8, 0, 0, 0, 0, 0, 2, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -5, 5, 0, 0, 0, 0, 0, 1, 4, 17, 9, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 1, 0, -4, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 2, -8, 0, 0, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1, 4, -15, -8, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 2, 370, -8, 0, -160), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 2, 0, 0, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 2, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -5, 0, 0, 0, 0, 2, -6, 3, 1, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 7, -8, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 2, -10, 0, 0, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -3, 0, 0, 0, 0, 0, 2, 0, 9, 4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 2, 4, 17, 7, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 11, 0, 0, 0, 0, 0, 2, 34, 0, 0, -15), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 11, 0, 0, 0, 0, 0, 1, 0, 5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, -4, 0, 0, 0, 2, -5, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, -3, 0, 0, 0, 2, -37, -7, -3, 16), new PlanetaryNutModel(0, 0, 0, 0, 0, -6, 6, 0, 0, 0, 0, 0, 1, 3, 13, 7, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 0, 1, 0, -3, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, -2, 0, 0, 0, 2, -184, -3, -1, 80), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, -4, 0, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 1, 0, -10, -6, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 2, 31, -6, 0, -13), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, -1, 0, 0, 0, 2, -3, -32, -14, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, 0, -2, 0, 0, 2, -7, 0, 0, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, -2, 0, 0, 0, 0, 2, 0, -8, -4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 3, -4, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 8, -9, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -4, 0, 0, 0, 0, 0, 2, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 2, 19, -23, -10, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, -10), new PlanetaryNutModel(0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 1, 0, 3, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -7, 7, 0, 0, 0, 0, 0, 1, 0, 9, 5, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 1, 0, -7, -4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 2, 8, -4, 0, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 0, 0, 0, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, 0, -4, 0, 0, 0, 2, -3, 0, 0, 1), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, 0, -3, 0, 0, 0, 2, -9, 0, 1, 4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 5, 0, -2, 0, 0, 0, 2, 3, 12, 5, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 2, 17, -3, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -8, 8, 0, 0, 0, 0, 0, 1, 0, 7, 4, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 8, -8, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 0, 1, 0, -5, -3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 0, 2, 14, -3, 0, -1), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 9, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 9, 0, 0, 0, 0, 0, 1, 0, 0, 0, -5), new PlanetaryNutModel(0, 0, 0, 0, 0, -9, 9, 0, 0, 0, 0, 0, 1, 0, 5, 3, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 9, -9, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 6, -4, 0, 0, 0, 0, 0, 1, 0, -3, -2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 2, 2, 9, 4, 3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1, 0, 4, 2, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 2, 6, 0, 0, -3), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 2, 5, 0, 0, -2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 0, -1), new PlanetaryNutModel(1, 0, -2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 7, 0, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, 6, 0, 0, 0), new PlanetaryNutModel(-1, 0, 2, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(1, 0, -2, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(-2, 0, 2, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, 5, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, -5, 0, 0, 0), new PlanetaryNutModel(-1, 0, 2, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(1, -1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0), new PlanetaryNutModel(-1, 0, 2, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0, 13, 0, 0, 0), new PlanetaryNutModel(-2, 0, 0, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0, 21, 11, 0, 0), new PlanetaryNutModel(1, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, -5, 0, 0), new PlanetaryNutModel(-1, 1, -1, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -5, -2, 0), new PlanetaryNutModel(1, 1, -1, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 5, 3, 0), new PlanetaryNutModel(-1, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, -5, 0, 0), new PlanetaryNutModel(-1, 0, 2, 1, 0, 0, 2, 0, -2, 0, 0, 0, 0, -3, 0, 0, 2), new PlanetaryNutModel(0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, 20, 10, 0, 0), new PlanetaryNutModel(-1, 0, 2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, -34, 0, 0, 0), new PlanetaryNutModel(-1, 0, 2, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0, -19, 0, 0, 0), new PlanetaryNutModel(1, 0, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0, 3, 0, 0, -2), new PlanetaryNutModel(1, 2, -2, 2, 0, -3, 3, 0, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(1, 2, -2, 2, 0, 0, -2, 0, 2, 0, 0, 0, 0, -6, 0, 0, 3), new PlanetaryNutModel(1, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0, -4, 0, 0, 0), new PlanetaryNutModel(1, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, -2, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0), new PlanetaryNutModel(0, 0, -2, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0, 4, 0, 0, 0), new PlanetaryNutModel(0, 2, 0, 2, 0, -2, 2, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 2, 0, 2, 0, 0, -1, 0, 1, 0, 0, 0, 0, 6, 0, 0, -3), new PlanetaryNutModel(0, 2, 0, 2, 0, -1, 1, 0, 0, 0, 0, 0, 0, -8, 0, 0, 3), new PlanetaryNutModel(0, 2, 0, 2, 0, -2, 3, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 0, 2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0, -3, 0, 0, 0), new PlanetaryNutModel(0, 1, 1, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -3, -2, 0), new PlanetaryNutModel(1, 2, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 126, -63, -27, -55), new PlanetaryNutModel(-1, 2, 0, 2, 0, 10, -3, 0, 0, 0, 0, 0, 0, -5, 0, 1, 2), new PlanetaryNutModel(0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -3, 28, 15, 2), new PlanetaryNutModel(1, 2, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 5, 0, 1, -2), new PlanetaryNutModel(0, 2, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, 9, 4, 1), new PlanetaryNutModel(0, 2, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0, 0, 9, 4, -1), new PlanetaryNutModel(-1, 2, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0, -126, -63, -27, 55), new PlanetaryNutModel(2, 2, -2, 2, 0, 0, -2, 0, 3, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(1, 2, 0, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0, 21, -11, -6, -11), new PlanetaryNutModel(0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, -4, 0, 0), new PlanetaryNutModel(-1, 2, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -21, -11, -6, 11), new PlanetaryNutModel(-2, 2, 2, 2, 0, 0, 2, 0, -2, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(0, 2, 0, 2, 0, 2, -3, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(0, 2, 0, 2, 0, 1, -1, 0, 0, 0, 0, 0, 0, 8, 0, 0, -4), new PlanetaryNutModel(0, 2, 0, 2, 0, 0, 1, 0, -1, 0, 0, 0, 0, -6, 0, 0, 3), new PlanetaryNutModel(0, 2, 0, 2, 0, 2, -2, 0, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(-1, 2, 2, 2, 0, 0, -1, 0, 1, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(1, 2, 0, 2, 0, -1, 1, 0, 0, 0, 0, 0, 0, -3, 0, 0, 1), new PlanetaryNutModel(-1, 2, 2, 2, 0, 0, 2, 0, -3, 0, 0, 0, 0, -5, 0, 0, 2), new PlanetaryNutModel(2, 2, 0, 2, 0, 0, 2, 0, -3, 0, 0, 0, 0, 24, -12, -5, -11), new PlanetaryNutModel(1, 2, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(1, 2, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0, 0, 3, 1, 0), new PlanetaryNutModel(1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 2, 0), new PlanetaryNutModel(0, 2, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, -24, -12, -5, 10), new PlanetaryNutModel(2, 2, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 4, 0, -1, -2), new PlanetaryNutModel(-1, 2, 2, 2, 0, 0, 2, 0, -2, 0, 0, 0, 0, 13, 0, 0, -6), new PlanetaryNutModel(-1, 2, 2, 2, 0, 3, -3, 0, 0, 0, 0, 0, 0, 7, 0, 0, -3), new PlanetaryNutModel(1, 2, 0, 2, 0, 1, -1, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1), new PlanetaryNutModel(0, 2, 2, 2, 0, 0, 2, 0, -2, 0, 0, 0, 0, 3, 0, 0, -1)};
        int NPL = xpl.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double el = JSOFA.jauFal03(t);
        double elp = JSOFA.fmod(1287104.79305 + t * (1.295965810481E8 + t * (-0.5532 + t * (1.36E-4 + t * -1.149E-5))), 1296000.0) * 4.84813681109536E-6;
        double f = JSOFA.jauFaf03(t);
        double d = JSOFA.fmod(1072260.70369 + t * (1.602961601209E9 + t * (-6.3706 + t * (0.006593 + t * -3.169E-5))), 1296000.0) * 4.84813681109536E-6;
        double om = JSOFA.jauFaom03(t);
        double dp = 0.0;
        double de = 0.0;
        for (i = NLS - 1; i >= 0; --i) {
            arg = JSOFA.fmod((double)xls[i].nl * el + (double)xls[i].nlp * elp + (double)xls[i].nf * f + (double)xls[i].nd * d + (double)xls[i].nom * om, Math.PI * 2);
            sarg = StrictMath.sin(arg);
            carg = StrictMath.cos(arg);
            dp += (xls[i].sp + xls[i].spt * t) * sarg + xls[i].cp * carg;
            de += (xls[i].ce + xls[i].cet * t) * carg + xls[i].se * sarg;
        }
        double dpsils = dp * 4.848136811095359E-13;
        double depsls = de * 4.848136811095359E-13;
        double al = JSOFA.fmod(2.35555598 + 8328.6914269554 * t, Math.PI * 2);
        double af = JSOFA.fmod(1.627905234 + 8433.466158131 * t, Math.PI * 2);
        double ad = JSOFA.fmod(5.198466741 + 7771.3771468121 * t, Math.PI * 2);
        double aom = JSOFA.fmod(2.1824392 - 33.757045 * t, Math.PI * 2);
        double apa = JSOFA.jauFapa03(t);
        double alme = JSOFA.jauFame03(t);
        double alve = JSOFA.jauFave03(t);
        double alea = JSOFA.jauFae03(t);
        double alma = JSOFA.jauFama03(t);
        double alju = JSOFA.jauFaju03(t);
        double alsa = JSOFA.jauFasa03(t);
        double alur = JSOFA.jauFaur03(t);
        double alne = JSOFA.fmod(5.321159 + 3.8127774 * t, Math.PI * 2);
        dp = 0.0;
        de = 0.0;
        for (i = NPL - 1; i >= 0; --i) {
            arg = JSOFA.fmod((double)xpl[i].nl * al + (double)xpl[i].nf * af + (double)xpl[i].nd * ad + (double)xpl[i].nom * aom + (double)xpl[i].nme * alme + (double)xpl[i].nve * alve + (double)xpl[i].nea * alea + (double)xpl[i].nma * alma + (double)xpl[i].nju * alju + (double)xpl[i].nsa * alsa + (double)xpl[i].nur * alur + (double)xpl[i].nne * alne + (double)xpl[i].npa * apa, Math.PI * 2);
            sarg = StrictMath.sin(arg);
            carg = StrictMath.cos(arg);
            dp += (double)xpl[i].sp * sarg + (double)xpl[i].cp * carg;
            de += (double)xpl[i].se * sarg + (double)xpl[i].ce * carg;
        }
        double dpsipl = dp * 4.848136811095359E-13;
        double depspl = de * 4.848136811095359E-13;
        return new NutationTerms(dpsils + dpsipl, depsls + depspl);
    }

    public static NutationTerms jauNut00b(double date1, double date2) {
        double U2R = 4.848136811095359E-13;
        double DPPLAN = -6.544984694978736E-10;
        double DEPLAN = 1.881077082705E-9;
        final class LSNutationModel {
            final int nl;
            final int nlp;
            final int nf;
            final int nd;
            final int nom;
            final double ps;
            final double pst;
            final double pc;
            final double ec;
            final double ect;
            final double es;

            public LSNutationModel(int nl, int nlp, int nf, int nd, int nom, double ps, double pst, double pc, double ec, double ect, double es) {
                this.nl = nl;
                this.nlp = nlp;
                this.nf = nf;
                this.nd = nd;
                this.nom = nom;
                this.ps = ps;
                this.pst = pst;
                this.pc = pc;
                this.ec = ec;
                this.ect = ect;
                this.es = es;
            }
        }
        LSNutationModel[] x = new LSNutationModel[]{new LSNutationModel(0, 0, 0, 0, 1, -1.72064161E8, -174666.0, 33386.0, 9.2052331E7, 9086.0, 15377.0), new LSNutationModel(0, 0, 2, -2, 2, -1.3170906E7, -1675.0, -13696.0, 5730336.0, -3015.0, -4587.0), new LSNutationModel(0, 0, 2, 0, 2, -2276413.0, -234.0, 2796.0, 978459.0, -485.0, 1374.0), new LSNutationModel(0, 0, 0, 0, 2, 2074554.0, 207.0, -698.0, -897492.0, 470.0, -291.0), new LSNutationModel(0, 1, 0, 0, 0, 1475877.0, -3633.0, 11817.0, 73871.0, -184.0, -1924.0), new LSNutationModel(0, 1, 2, -2, 2, -516821.0, 1226.0, -524.0, 224386.0, -677.0, -174.0), new LSNutationModel(1, 0, 0, 0, 0, 711159.0, 73.0, -872.0, -6750.0, 0.0, 358.0), new LSNutationModel(0, 0, 2, 0, 1, -387298.0, -367.0, 380.0, 200728.0, 18.0, 318.0), new LSNutationModel(1, 0, 2, 0, 2, -301461.0, -36.0, 816.0, 129025.0, -63.0, 367.0), new LSNutationModel(0, -1, 2, -2, 2, 215829.0, -494.0, 111.0, -95929.0, 299.0, 132.0), new LSNutationModel(0, 0, 2, -2, 1, 128227.0, 137.0, 181.0, -68982.0, -9.0, 39.0), new LSNutationModel(-1, 0, 2, 0, 2, 123457.0, 11.0, 19.0, -53311.0, 32.0, -4.0), new LSNutationModel(-1, 0, 0, 2, 0, 156994.0, 10.0, -168.0, -1235.0, 0.0, 82.0), new LSNutationModel(1, 0, 0, 0, 1, 63110.0, 63.0, 27.0, -33228.0, 0.0, -9.0), new LSNutationModel(-1, 0, 0, 0, 1, -57976.0, -63.0, -189.0, 31429.0, 0.0, -75.0), new LSNutationModel(-1, 0, 2, 2, 2, -59641.0, -11.0, 149.0, 25543.0, -11.0, 66.0), new LSNutationModel(1, 0, 2, 0, 1, -51613.0, -42.0, 129.0, 26366.0, 0.0, 78.0), new LSNutationModel(-2, 0, 2, 0, 1, 45893.0, 50.0, 31.0, -24236.0, -10.0, 20.0), new LSNutationModel(0, 0, 0, 2, 0, 63384.0, 11.0, -150.0, -1220.0, 0.0, 29.0), new LSNutationModel(0, 0, 2, 2, 2, -38571.0, -1.0, 158.0, 16452.0, -11.0, 68.0), new LSNutationModel(0, -2, 2, -2, 2, 32481.0, 0.0, 0.0, -13870.0, 0.0, 0.0), new LSNutationModel(-2, 0, 0, 2, 0, -47722.0, 0.0, -18.0, 477.0, 0.0, -25.0), new LSNutationModel(2, 0, 2, 0, 2, -31046.0, -1.0, 131.0, 13238.0, -11.0, 59.0), new LSNutationModel(1, 0, 2, -2, 2, 28593.0, 0.0, -1.0, -12338.0, 10.0, -3.0), new LSNutationModel(-1, 0, 2, 0, 1, 20441.0, 21.0, 10.0, -10758.0, 0.0, -3.0), new LSNutationModel(2, 0, 0, 0, 0, 29243.0, 0.0, -74.0, -609.0, 0.0, 13.0), new LSNutationModel(0, 0, 2, 0, 0, 25887.0, 0.0, -66.0, -550.0, 0.0, 11.0), new LSNutationModel(0, 1, 0, 0, 1, -14053.0, -25.0, 79.0, 8551.0, -2.0, -45.0), new LSNutationModel(-1, 0, 0, 2, 1, 15164.0, 10.0, 11.0, -8001.0, 0.0, -1.0), new LSNutationModel(0, 2, 2, -2, 2, -15794.0, 72.0, -16.0, 6850.0, -42.0, -5.0), new LSNutationModel(0, 0, -2, 2, 0, 21783.0, 0.0, 13.0, -167.0, 0.0, 13.0), new LSNutationModel(1, 0, 0, -2, 1, -12873.0, -10.0, -37.0, 6953.0, 0.0, -14.0), new LSNutationModel(0, -1, 0, 0, 1, -12654.0, 11.0, 63.0, 6415.0, 0.0, 26.0), new LSNutationModel(-1, 0, 2, 2, 1, -10204.0, 0.0, 25.0, 5222.0, 0.0, 15.0), new LSNutationModel(0, 2, 0, 0, 0, 16707.0, -85.0, -10.0, 168.0, -1.0, 10.0), new LSNutationModel(1, 0, 2, 2, 2, -7691.0, 0.0, 44.0, 3268.0, 0.0, 19.0), new LSNutationModel(-2, 0, 2, 0, 0, -11024.0, 0.0, -14.0, 104.0, 0.0, 2.0), new LSNutationModel(0, 1, 2, 0, 2, 7566.0, -21.0, -11.0, -3250.0, 0.0, -5.0), new LSNutationModel(0, 0, 2, 2, 1, -6637.0, -11.0, 25.0, 3353.0, 0.0, 14.0), new LSNutationModel(0, -1, 2, 0, 2, -7141.0, 21.0, 8.0, 3070.0, 0.0, 4.0), new LSNutationModel(0, 0, 0, 2, 1, -6302.0, -11.0, 2.0, 3272.0, 0.0, 4.0), new LSNutationModel(1, 0, 2, -2, 1, 5800.0, 10.0, 2.0, -3045.0, 0.0, -1.0), new LSNutationModel(2, 0, 2, -2, 2, 6443.0, 0.0, -7.0, -2768.0, 0.0, -4.0), new LSNutationModel(-2, 0, 0, 2, 1, -5774.0, -11.0, -15.0, 3041.0, 0.0, -5.0), new LSNutationModel(2, 0, 2, 0, 1, -5350.0, 0.0, 21.0, 2695.0, 0.0, 12.0), new LSNutationModel(0, -1, 2, -2, 1, -4752.0, -11.0, -3.0, 2719.0, 0.0, -3.0), new LSNutationModel(0, 0, 0, -2, 1, -4940.0, -11.0, -21.0, 2720.0, 0.0, -9.0), new LSNutationModel(-1, -1, 0, 2, 0, 7350.0, 0.0, -8.0, -51.0, 0.0, 4.0), new LSNutationModel(2, 0, 0, -2, 1, 4065.0, 0.0, 6.0, -2206.0, 0.0, 1.0), new LSNutationModel(1, 0, 0, 2, 0, 6579.0, 0.0, -24.0, -199.0, 0.0, 2.0), new LSNutationModel(0, 1, 2, -2, 1, 3579.0, 0.0, 5.0, -1900.0, 0.0, 1.0), new LSNutationModel(1, -1, 0, 0, 0, 4725.0, 0.0, -6.0, -41.0, 0.0, 3.0), new LSNutationModel(-2, 0, 2, 0, 2, -3075.0, 0.0, -2.0, 1313.0, 0.0, -1.0), new LSNutationModel(3, 0, 2, 0, 2, -2904.0, 0.0, 15.0, 1233.0, 0.0, 7.0), new LSNutationModel(0, -1, 0, 2, 0, 4348.0, 0.0, -10.0, -81.0, 0.0, 2.0), new LSNutationModel(1, -1, 2, 0, 2, -2878.0, 0.0, 8.0, 1232.0, 0.0, 4.0), new LSNutationModel(0, 0, 0, 1, 0, -4230.0, 0.0, 5.0, -20.0, 0.0, -2.0), new LSNutationModel(-1, -1, 2, 2, 2, -2819.0, 0.0, 7.0, 1207.0, 0.0, 3.0), new LSNutationModel(-1, 0, 2, 0, 0, -4056.0, 0.0, 5.0, 40.0, 0.0, -2.0), new LSNutationModel(0, -1, 2, 2, 2, -2647.0, 0.0, 11.0, 1129.0, 0.0, 5.0), new LSNutationModel(-2, 0, 0, 0, 1, -2294.0, 0.0, -10.0, 1266.0, 0.0, -4.0), new LSNutationModel(1, 1, 2, 0, 2, 2481.0, 0.0, -7.0, -1062.0, 0.0, -3.0), new LSNutationModel(2, 0, 0, 0, 1, 2179.0, 0.0, -2.0, -1129.0, 0.0, -2.0), new LSNutationModel(-1, 1, 0, 1, 0, 3276.0, 0.0, 1.0, -9.0, 0.0, 0.0), new LSNutationModel(1, 1, 0, 0, 0, -3389.0, 0.0, 5.0, 35.0, 0.0, -2.0), new LSNutationModel(1, 0, 2, 0, 0, 3339.0, 0.0, -13.0, -107.0, 0.0, 1.0), new LSNutationModel(-1, 0, 2, -2, 1, -1987.0, 0.0, -6.0, 1073.0, 0.0, -2.0), new LSNutationModel(1, 0, 0, 0, 2, -1981.0, 0.0, 0.0, 854.0, 0.0, 0.0), new LSNutationModel(-1, 0, 0, 1, 0, 4026.0, 0.0, -353.0, -553.0, 0.0, -139.0), new LSNutationModel(0, 0, 2, 1, 2, 1660.0, 0.0, -5.0, -710.0, 0.0, -2.0), new LSNutationModel(-1, 0, 2, 4, 2, -1521.0, 0.0, 9.0, 647.0, 0.0, 4.0), new LSNutationModel(-1, 1, 0, 1, 1, 1314.0, 0.0, 0.0, -700.0, 0.0, 0.0), new LSNutationModel(0, -2, 2, -2, 1, -1283.0, 0.0, 0.0, 672.0, 0.0, 0.0), new LSNutationModel(1, 0, 2, 2, 1, -1331.0, 0.0, 8.0, 663.0, 0.0, 4.0), new LSNutationModel(-2, 0, 2, 2, 2, 1383.0, 0.0, -2.0, -594.0, 0.0, -2.0), new LSNutationModel(-1, 0, 0, 0, 2, 1405.0, 0.0, 4.0, -610.0, 0.0, 2.0), new LSNutationModel(1, 1, 2, -2, 2, 1290.0, 0.0, 0.0, -556.0, 0.0, 0.0)};
        int NLS = x.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double el = JSOFA.fmod(485868.249036 + 1.7179159232178E9 * t, 1296000.0) * 4.84813681109536E-6;
        double elp = JSOFA.fmod(1287104.79305 + 1.295965810481E8 * t, 1296000.0) * 4.84813681109536E-6;
        double f = JSOFA.fmod(335779.526232 + 1.7395272628478E9 * t, 1296000.0) * 4.84813681109536E-6;
        double d = JSOFA.fmod(1072260.70369 + 1.602961601209E9 * t, 1296000.0) * 4.84813681109536E-6;
        double om = JSOFA.fmod(450160.398036 + -6962890.5431 * t, 1296000.0) * 4.84813681109536E-6;
        double dp = 0.0;
        double de = 0.0;
        for (int i = NLS - 1; i >= 0; --i) {
            double arg = JSOFA.fmod((double)x[i].nl * el + (double)x[i].nlp * elp + (double)x[i].nf * f + (double)x[i].nd * d + (double)x[i].nom * om, Math.PI * 2);
            double sarg = StrictMath.sin(arg);
            double carg = StrictMath.cos(arg);
            dp += (x[i].ps + x[i].pst * t) * sarg + x[i].pc * carg;
            de += (x[i].ec + x[i].ect * t) * carg + x[i].es * sarg;
        }
        double dpsils = dp * 4.848136811095359E-13;
        double depsls = de * 4.848136811095359E-13;
        double dpsipl = -6.544984694978736E-10;
        double depspl = 1.881077082705E-9;
        return new NutationTerms(dpsils + dpsipl, depsls + depspl);
    }

    public static NutationTerms jauNut06a(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double fj2 = -2.7774E-6 * t;
        NutationTerms nt = JSOFA.jauNut00a(date1, date2);
        return new NutationTerms(nt.dpsi + nt.dpsi * (4.697E-7 + fj2), nt.deps + nt.deps * fj2);
    }

    public static NutationTerms jauNut80(double date1, double date2) {
        double U2R = 4.84813681109536E-10;
        final class NutationModel {
            final int nl;
            final int nlp;
            final int nf;
            final int nd;
            final int nom;
            final double sp;
            final double spt;
            final double ce;
            final double cet;

            public NutationModel(int nl, int nlp, int nf, int nd, int nom, double sp, double spt, double ce, double cet) {
                this.nl = nl;
                this.nlp = nlp;
                this.nf = nf;
                this.nd = nd;
                this.nom = nom;
                this.sp = sp;
                this.spt = spt;
                this.ce = ce;
                this.cet = cet;
            }
        }
        NutationModel[] x = new NutationModel[]{new NutationModel(0, 0, 0, 0, 1, -171996.0, -174.2, 92025.0, 8.9), new NutationModel(0, 0, 0, 0, 2, 2062.0, 0.2, -895.0, 0.5), new NutationModel(-2, 0, 2, 0, 1, 46.0, 0.0, -24.0, 0.0), new NutationModel(2, 0, -2, 0, 0, 11.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 0, 2, -3.0, 0.0, 1.0, 0.0), new NutationModel(1, -1, 0, -1, 0, -3.0, 0.0, 0.0, 0.0), new NutationModel(0, -2, 2, -2, 1, -2.0, 0.0, 1.0, 0.0), new NutationModel(2, 0, -2, 0, 1, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, -2, 2, -13187.0, -1.6, 5736.0, -3.1), new NutationModel(0, 1, 0, 0, 0, 1426.0, -3.4, 54.0, -0.1), new NutationModel(0, 1, 2, -2, 2, -517.0, 1.2, 224.0, -0.6), new NutationModel(0, -1, 2, -2, 2, 217.0, -0.5, -95.0, 0.3), new NutationModel(0, 0, 2, -2, 1, 129.0, 0.1, -70.0, 0.0), new NutationModel(2, 0, 0, -2, 0, 48.0, 0.0, 1.0, 0.0), new NutationModel(0, 0, 2, -2, 0, -22.0, 0.0, 0.0, 0.0), new NutationModel(0, 2, 0, 0, 0, 17.0, -0.1, 0.0, 0.0), new NutationModel(0, 1, 0, 0, 1, -15.0, 0.0, 9.0, 0.0), new NutationModel(0, 2, 2, -2, 2, -16.0, 0.1, 7.0, 0.0), new NutationModel(0, -1, 0, 0, 1, -12.0, 0.0, 6.0, 0.0), new NutationModel(-2, 0, 0, 2, 1, -6.0, 0.0, 3.0, 0.0), new NutationModel(0, -1, 2, -2, 1, -5.0, 0.0, 3.0, 0.0), new NutationModel(2, 0, 0, -2, 1, 4.0, 0.0, -2.0, 0.0), new NutationModel(0, 1, 2, -2, 1, 4.0, 0.0, -2.0, 0.0), new NutationModel(1, 0, 0, -1, 0, -4.0, 0.0, 0.0, 0.0), new NutationModel(2, 1, 0, -2, 0, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 2, 1, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, -2, 2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, 0, 2, 1.0, 0.0, 0.0, 0.0), new NutationModel(-1, 0, 0, 1, 1, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, -2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, 0, 2, -2274.0, -0.2, 977.0, -0.5), new NutationModel(1, 0, 0, 0, 0, 712.0, 0.1, -7.0, 0.0), new NutationModel(0, 0, 2, 0, 1, -386.0, -0.4, 200.0, 0.0), new NutationModel(1, 0, 2, 0, 2, -301.0, 0.0, 129.0, -0.1), new NutationModel(1, 0, 0, -2, 0, -158.0, 0.0, -1.0, 0.0), new NutationModel(-1, 0, 2, 0, 2, 123.0, 0.0, -53.0, 0.0), new NutationModel(0, 0, 0, 2, 0, 63.0, 0.0, -2.0, 0.0), new NutationModel(1, 0, 0, 0, 1, 63.0, 0.1, -33.0, 0.0), new NutationModel(-1, 0, 0, 0, 1, -58.0, -0.1, 32.0, 0.0), new NutationModel(-1, 0, 2, 2, 2, -59.0, 0.0, 26.0, 0.0), new NutationModel(1, 0, 2, 0, 1, -51.0, 0.0, 27.0, 0.0), new NutationModel(0, 0, 2, 2, 2, -38.0, 0.0, 16.0, 0.0), new NutationModel(2, 0, 0, 0, 0, 29.0, 0.0, -1.0, 0.0), new NutationModel(1, 0, 2, -2, 2, 29.0, 0.0, -12.0, 0.0), new NutationModel(2, 0, 2, 0, 2, -31.0, 0.0, 13.0, 0.0), new NutationModel(0, 0, 2, 0, 0, 26.0, 0.0, -1.0, 0.0), new NutationModel(-1, 0, 2, 0, 1, 21.0, 0.0, -10.0, 0.0), new NutationModel(-1, 0, 0, 2, 1, 16.0, 0.0, -8.0, 0.0), new NutationModel(1, 0, 0, -2, 1, -13.0, 0.0, 7.0, 0.0), new NutationModel(-1, 0, 2, 2, 1, -10.0, 0.0, 5.0, 0.0), new NutationModel(1, 1, 0, -2, 0, -7.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, 0, 2, 7.0, 0.0, -3.0, 0.0), new NutationModel(0, -1, 2, 0, 2, -7.0, 0.0, 3.0, 0.0), new NutationModel(1, 0, 2, 2, 2, -8.0, 0.0, 3.0, 0.0), new NutationModel(1, 0, 0, 2, 0, 6.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, -2, 2, 6.0, 0.0, -3.0, 0.0), new NutationModel(0, 0, 0, 2, 1, -6.0, 0.0, 3.0, 0.0), new NutationModel(0, 0, 2, 2, 1, -7.0, 0.0, 3.0, 0.0), new NutationModel(1, 0, 2, -2, 1, 6.0, 0.0, -3.0, 0.0), new NutationModel(0, 0, 0, -2, 1, -5.0, 0.0, 3.0, 0.0), new NutationModel(1, -1, 0, 0, 0, 5.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, 0, 1, -5.0, 0.0, 3.0, 0.0), new NutationModel(0, 1, 0, -2, 0, -4.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, -2, 0, 0, 4.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 0, 1, 0, -4.0, 0.0, 0.0, 0.0), new NutationModel(1, 1, 0, 0, 0, -3.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, 0, 0, 3.0, 0.0, 0.0, 0.0), new NutationModel(1, -1, 2, 0, 2, -3.0, 0.0, 1.0, 0.0), new NutationModel(-1, -1, 2, 2, 2, -3.0, 0.0, 1.0, 0.0), new NutationModel(-2, 0, 0, 0, 1, -2.0, 0.0, 1.0, 0.0), new NutationModel(3, 0, 2, 0, 2, -3.0, 0.0, 1.0, 0.0), new NutationModel(0, -1, 2, 2, 2, -3.0, 0.0, 1.0, 0.0), new NutationModel(1, 1, 2, 0, 2, 2.0, 0.0, -1.0, 0.0), new NutationModel(-1, 0, 2, -2, 1, -2.0, 0.0, 1.0, 0.0), new NutationModel(2, 0, 0, 0, 1, 2.0, 0.0, -1.0, 0.0), new NutationModel(1, 0, 0, 0, 2, -2.0, 0.0, 1.0, 0.0), new NutationModel(3, 0, 0, 0, 0, 2.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, 1, 2, 2.0, 0.0, -1.0, 0.0), new NutationModel(-1, 0, 0, 0, 2, 1.0, 0.0, -1.0, 0.0), new NutationModel(1, 0, 0, -4, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(-2, 0, 2, 2, 2, 1.0, 0.0, -1.0, 0.0), new NutationModel(-1, 0, 2, 4, 2, -2.0, 0.0, 1.0, 0.0), new NutationModel(2, 0, 0, -4, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(1, 1, 2, -2, 2, 1.0, 0.0, -1.0, 0.0), new NutationModel(1, 0, 2, 2, 1, -1.0, 0.0, 1.0, 0.0), new NutationModel(-2, 0, 2, 4, 2, -1.0, 0.0, 1.0, 0.0), new NutationModel(-1, 0, 4, 0, 2, 1.0, 0.0, 0.0, 0.0), new NutationModel(1, -1, 0, -2, 0, 1.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 2, -2, 1, 1.0, 0.0, -1.0, 0.0), new NutationModel(2, 0, 2, 2, 2, -1.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 0, 2, 1, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 4, -2, 2, 1.0, 0.0, 0.0, 0.0), new NutationModel(3, 0, 2, -2, 2, 1.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, 2, -2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 2, 0, 1, 1.0, 0.0, 0.0, 0.0), new NutationModel(-1, -1, 0, 2, 1, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, -2, 0, 1, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, -1, 2, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, 2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, -2, -2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, -1, 2, 0, 1, -1.0, 0.0, 0.0, 0.0), new NutationModel(1, 1, 0, -2, 1, -1.0, 0.0, 0.0, 0.0), new NutationModel(1, 0, -2, 2, 0, -1.0, 0.0, 0.0, 0.0), new NutationModel(2, 0, 0, 2, 0, 1.0, 0.0, 0.0, 0.0), new NutationModel(0, 0, 2, 4, 2, -1.0, 0.0, 0.0, 0.0), new NutationModel(0, 1, 0, 1, 0, 1.0, 0.0, 0.0, 0.0)};
        int NT = x.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double el = JSOFA.jauAnpm((485866.733 + (715922.633 + (31.31 + 0.064 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(1325.0 * t, 1.0) * (Math.PI * 2));
        double elp = JSOFA.jauAnpm((1287099.804 + (1292581.224 + (-0.577 - 0.012 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(99.0 * t, 1.0) * (Math.PI * 2));
        double f = JSOFA.jauAnpm((335778.877 + (295263.137 + (-13.257 + 0.011 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(1342.0 * t, 1.0) * (Math.PI * 2));
        double d = JSOFA.jauAnpm((1072261.307 + (1105601.328 + (-6.891 + 0.019 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(1236.0 * t, 1.0) * (Math.PI * 2));
        double om = JSOFA.jauAnpm((450160.28 + (-482890.539 + (7.455 + 0.008 * t) * t) * t) * 4.84813681109536E-6 + JSOFA.fmod(-5.0 * t, 1.0) * (Math.PI * 2));
        double dp = 0.0;
        double de = 0.0;
        for (int j = NT - 1; j >= 0; --j) {
            double arg = (double)x[j].nl * el + (double)x[j].nlp * elp + (double)x[j].nf * f + (double)x[j].nd * d + (double)x[j].nom * om;
            double s = x[j].sp + x[j].spt * t;
            double c = x[j].ce + x[j].cet * t;
            if (s != 0.0) {
                dp += s * StrictMath.sin(arg);
            }
            if (c == 0.0) continue;
            de += c * StrictMath.cos(arg);
        }
        return new NutationTerms(dp * 4.84813681109536E-10, de * 4.84813681109536E-10);
    }

    public static double[][] jauNutm80(double date1, double date2) {
        NutationTerms nt = JSOFA.jauNut80(date1, date2);
        double epsa = JSOFA.jauObl80(date1, date2);
        double[][] rmatn = JSOFA.jauNumat(epsa, nt.dpsi, nt.deps);
        return rmatn;
    }

    public static double jauObl06(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double eps0 = (84381.406 + (-46.836769 + (-1.831E-4 + (0.0020034 + (-5.76E-7 + -4.34E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        return eps0;
    }

    public static double jauObl80(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double eps0 = 4.84813681109536E-6 * (84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * t) * t) * t);
        return eps0;
    }

    public static PrecessionAngles jauP06e(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double eps0 = 0.4090926006005829;
        double psia = (5038.481507 + (-1.0790069 + (-0.00114045 + (1.32851E-4 + -9.51E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double oma = eps0 + (-0.025754 + (0.0512623 + (-0.00772503 + (-4.67E-7 + 3.337E-7 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double bpa = (4.199094 + (0.1939873 + (-2.2466E-4 + (-9.12E-7 + 1.2E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double bqa = (-46.811015 + (0.0510283 + (5.2413E-4 + (-6.46E-7 + -1.72E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double pia = (46.998973 + (-0.0334926 + (-1.2559E-4 + (1.13E-7 + -2.2E-9 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double bpia = (629546.7936 + (-867.95758 + (0.157992 + (-5.371E-4 + (-4.797E-5 + 7.2E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double epsa = JSOFA.jauObl06(date1, date2);
        double chia = (10.556403 + (-2.3814292 + (-0.00121197 + (1.70663E-4 + -5.6E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double za = (-2.650545 + (2306.077181 + (1.0927348 + (0.01826837 + (-2.8596E-5 + -2.904E-7 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double zetaa = (2.650545 + (2306.083227 + (0.2988499 + (0.01801828 + (-5.971E-6 + -3.173E-7 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double thetaa = (2004.191903 + (-0.4294934 + (-0.04182264 + (-7.089E-6 + -1.274E-7 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double pa = (5028.796195 + (1.1054348 + (7.964E-5 + (-2.3857E-5 + 3.83E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double gam = (10.556403 + (0.4932044 + (-3.1238E-4 + (-2.788E-6 + 2.6E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double phi = eps0 + (-46.811015 + (0.0511269 + (5.3289E-4 + (-4.4E-7 + -1.76E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        double psi = (5038.481507 + (1.5584176 + (-1.8522E-4 + (-2.6452E-5 + -1.48E-8 * t) * t) * t) * t) * t * 4.84813681109536E-6;
        return new PrecessionAngles(eps0, psia, oma, bpa, bqa, pia, bpia, epsa, chia, za, zetaa, thetaa, pa, gam, phi, psi);
    }

    public static double[][] jauP2pv(double[] p) {
        double[][] pv = new double[3][3];
        JSOFA.jauCp(p, pv[0]);
        JSOFA.jauZp(pv[1]);
        return pv;
    }

    public static SphericalPosition jauP2s(double[] p) {
        SphericalCoordinate sc = JSOFA.jauC2s(p);
        double r = JSOFA.jauPm(p);
        return new SphericalPosition(sc.alpha, sc.delta, r);
    }

    public static double jauPap(double[] a, double[] b) {
        double ct;
        double st;
        double[] au = new double[3];
        double[] eta = new double[3];
        double[] xi = new double[3];
        double[] a2b = new double[3];
        NormalizedVector nv = JSOFA.jauPn(a);
        double am = nv.r;
        au = nv.u;
        double bm = JSOFA.jauPm(b);
        if (am == 0.0 || bm == 0.0) {
            st = 0.0;
            ct = 1.0;
        } else {
            double xa = a[0];
            double ya = a[1];
            double za = a[2];
            eta[0] = -xa * za;
            eta[1] = -ya * za;
            eta[2] = xa * xa + ya * ya;
            xi = JSOFA.jauPxp(eta, au);
            a2b = JSOFA.jauPmp(b, a);
            st = JSOFA.jauPdp(a2b, xi);
            ct = JSOFA.jauPdp(a2b, eta);
            if (st == 0.0 && ct == 0.0) {
                ct = 1.0;
            }
        }
        double pa = StrictMath.atan2(st, ct);
        return pa;
    }

    public static double jauPas(double al, double ap, double bl, double bp) {
        double dl = bl - al;
        double y = StrictMath.sin(dl) * StrictMath.cos(bp);
        double x = StrictMath.sin(bp) * StrictMath.cos(ap) - StrictMath.cos(bp) * StrictMath.sin(ap) * StrictMath.cos(dl);
        double pa = x != 0.0 || y != 0.0 ? StrictMath.atan2(y, x) : 0.0;
        return pa;
    }

    public static EulerAngles jauPb06(double date1, double date2) {
        double[][] r = new double[3][3];
        r = JSOFA.jauPmat06(date1, date2);
        double bz = StrictMath.atan2(r[1][2], r[0][2]);
        JSOFA.jauRz(bz, r);
        double bzeta = StrictMath.atan2(r[1][0], r[1][1]);
        double r31 = r[2][0];
        double r32 = r[2][1];
        double btheta = StrictMath.atan2(-JSOFA.dsign(StrictMath.sqrt(r31 * r31 + r32 * r32), r[0][2]), r[2][2]);
        return new EulerAngles(bzeta, bz, btheta);
    }

    public static double jauPdp(double[] a, double[] b) {
        double w = a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
        return w;
    }

    public static FWPrecessionAngles jauPfw06(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double gamb = (-0.052928 + (10.556378 + (0.4932044 + (-3.1238E-4 + (-2.788E-6 + 2.6E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double phib = (84381.412819 + (-46.811016 + (0.0511268 + (5.3289E-4 + (-4.4E-7 + -1.76E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double psib = (-0.041775 + (5038.481484 + (1.5584175 + (-1.8522E-4 + (-2.6452E-5 + -1.48E-8 * t) * t) * t) * t) * t) * 4.84813681109536E-6;
        double epsa = JSOFA.jauObl06(date1, date2);
        return new FWPrecessionAngles(gamb, phib, psib, epsa);
    }

    public static int jauPlan94(double date1, double date2, int np, double[][] pv) {
        int jstat;
        double GK = 0.01720209895;
        double SINEPS = 0.3977771559319137;
        double COSEPS = 0.9174820620691818;
        int KMAX = 10;
        double[] amas = new double[]{6023600.0, 408523.5, 328900.5, 3098710.0, 1047.355, 3498.5, 22869.0, 19314.0};
        double[][] a = new double[][]{{0.3870983098, 0.0, 0.0}, {0.72332982, 0.0, 0.0}, {1.0000010178, 0.0, 0.0}, {1.5236793419, 3.0E-10, 0.0}, {5.2026032092, 1.9132E-6, -3.9E-9}, {9.5549091915, -2.13896E-5, 4.44E-8}, {19.2184460618, -3.716E-7, 9.79E-8}, {30.1103868694, -1.6635E-6, 6.86E-8}};
        double[][] dlm = new double[][]{{252.25090552, 5.38101628688982E9, -1.92789}, {181.97980085, 2.10664136433548E9, 0.59381}, {100.46645683, 1.29597742283429E9, -2.04411}, {355.43299958, 6.8905077493988E8, 0.94264}, {34.35151874, 1.0925660377991E8, -30.60378}, {50.0774443, 4.399609855732E7, 75.61614}, {314.05500511, 1.542481193933E7, -1.75083}, {304.34866548, 7865503.20744, 0.21103}};
        double[][] e = new double[][]{{0.2056317526, 2.040653E-4, -2.8349E-6}, {0.0067719164, -4.776521E-4, 9.8127E-6}, {0.0167086342, -4.203654E-4, -1.26734E-5}, {0.0934006477, 9.048438E-4, -8.0641E-6}, {0.0484979255, 0.0016322542, -4.71366E-5}, {0.0555481426, -0.0034664062, -6.43639E-5}, {0.0463812221, -2.729293E-4, 7.8913E-6}, {0.009455747, 6.03263E-5, 0.0}};
        double[][] pi = new double[][]{{77.45611904, 5719.1159, -4.83016}, {131.563703, 175.4864, -498.48184}, {102.93734808, 11612.3529, 53.27577}, {336.06023395, 15980.45908, -62.328}, {14.33120687, 7758.75163, 259.95938}, {93.05723748, 20395.49439, 190.25952}, {173.00529106, 3215.56238, -34.09288}, {48.12027554, 1050.71912, 27.39717}};
        double[][] dinc = new double[][]{{7.00498625, -214.25629, 0.28977}, {3.39466189, -30.84437, -11.67836}, {0.0, 469.97289, -3.35053}, {1.84972648, -293.31722, -8.1183}, {1.30326698, -71.5589, 11.95297}, {2.48887878, 91.85195, -17.66225}, {0.77319689, -60.72723, 1.25759}, {1.76995259, 8.12333, 0.08135}};
        double[][] omega = new double[][]{{48.33089304, -4515.21727, -31.79892}, {76.67992019, -10008.48154, -51.32614}, {174.87317577, -8679.27034, 15.34191}, {49.55809321, -10620.90088, -230.57416}, {100.46440702, 6362.03561, 326.52178}, {113.66550252, -9240.19942, -66.23743}, {74.00595701, 2669.15033, 145.93964}, {131.78405702, -221.94322, -0.78728}};
        double[][] kp = new double[][]{{69613.0, 75645.0, 88306.0, 59899.0, 15746.0, 71087.0, 142173.0, 3086.0, 0.0}, {21863.0, 32794.0, 26934.0, 10931.0, 26250.0, 43725.0, 53867.0, 28939.0, 0.0}, {16002.0, 21863.0, 32004.0, 10931.0, 14529.0, 16368.0, 15318.0, 32794.0, 0.0}, {6345.0, 7818.0, 15636.0, 7077.0, 8184.0, 14163.0, 1107.0, 4872.0, 0.0}, {1760.0, 1454.0, 1167.0, 880.0, 287.0, 2640.0, 19.0, 2047.0, 1454.0}, {574.0, 0.0, 880.0, 287.0, 19.0, 1760.0, 1167.0, 306.0, 574.0}, {204.0, 0.0, 177.0, 1265.0, 4.0, 385.0, 200.0, 208.0, 204.0}, {0.0, 102.0, 106.0, 4.0, 98.0, 1367.0, 487.0, 204.0, 0.0}};
        double[][] ca = new double[][]{{4.0, -13.0, 11.0, -9.0, -9.0, -3.0, -1.0, 4.0, 0.0}, {-156.0, 59.0, -42.0, 6.0, 19.0, -20.0, -10.0, -12.0, 0.0}, {64.0, -152.0, 62.0, -8.0, 32.0, -41.0, 19.0, -11.0, 0.0}, {124.0, 621.0, -145.0, 208.0, 54.0, -57.0, 30.0, 15.0, 0.0}, {-23437.0, -2634.0, 6601.0, 6259.0, -1507.0, -1821.0, 2620.0, -2115.0, -1489.0}, {62911.0, -119919.0, 79336.0, 17814.0, -24241.0, 12068.0, 8306.0, -4893.0, 8902.0}, {389061.0, -262125.0, -44088.0, 8387.0, -22976.0, -2093.0, -615.0, -9720.0, 6633.0}, {-412235.0, -157046.0, -31430.0, 37817.0, -9740.0, -13.0, -7449.0, 9644.0, 0.0}};
        double[][] sa = new double[][]{{-29.0, -1.0, 9.0, 6.0, -6.0, 5.0, 4.0, 0.0, 0.0}, {-48.0, -125.0, -26.0, -37.0, 18.0, -13.0, -20.0, -2.0, 0.0}, {-150.0, -46.0, 68.0, 54.0, 14.0, 24.0, -28.0, 22.0, 0.0}, {-621.0, 532.0, -694.0, -20.0, 192.0, -94.0, 71.0, -73.0, 0.0}, {-14614.0, -19828.0, -5869.0, 1881.0, -4372.0, -2255.0, 782.0, 930.0, 913.0}, {139737.0, 0.0, 24667.0, 51123.0, -5102.0, 7429.0, -4095.0, -1976.0, -9566.0}, {-138081.0, 0.0, 37205.0, -49039.0, -41901.0, -33872.0, -27037.0, -12474.0, 18797.0}, {0.0, 28492.0, 133236.0, 69654.0, 52322.0, -49577.0, -26430.0, -3593.0, 0.0}};
        double[][] kq = new double[][]{{3086.0, 15746.0, 69613.0, 59899.0, 75645.0, 88306.0, 12661.0, 2658.0, 0.0, 0.0}, {21863.0, 32794.0, 10931.0, 73.0, 4387.0, 26934.0, 1473.0, 2157.0, 0.0, 0.0}, {10.0, 16002.0, 21863.0, 10931.0, 1473.0, 32004.0, 4387.0, 73.0, 0.0, 0.0}, {10.0, 6345.0, 7818.0, 1107.0, 15636.0, 7077.0, 8184.0, 532.0, 10.0, 0.0}, {19.0, 1760.0, 1454.0, 287.0, 1167.0, 880.0, 574.0, 2640.0, 19.0, 1454.0}, {19.0, 574.0, 287.0, 306.0, 1760.0, 12.0, 31.0, 38.0, 19.0, 574.0}, {4.0, 204.0, 177.0, 8.0, 31.0, 200.0, 1265.0, 102.0, 4.0, 204.0}, {4.0, 102.0, 106.0, 8.0, 98.0, 1367.0, 487.0, 204.0, 4.0, 102.0}};
        double[][] cl = new double[][]{{21.0, -95.0, -157.0, 41.0, -5.0, 42.0, 23.0, 30.0, 0.0, 0.0}, {-160.0, -313.0, -235.0, 60.0, -74.0, -76.0, -27.0, 34.0, 0.0, 0.0}, {-325.0, -322.0, -79.0, 232.0, -52.0, 97.0, 55.0, -41.0, 0.0, 0.0}, {2268.0, -979.0, 802.0, 602.0, -668.0, -33.0, 345.0, 201.0, -55.0, 0.0}, {7610.0, -4997.0, -7689.0, -5841.0, -2617.0, 1115.0, -748.0, -607.0, 6074.0, 354.0}, {-18549.0, 30125.0, 20012.0, -730.0, 824.0, 23.0, 1289.0, -352.0, -14767.0, -2062.0}, {-135245.0, -14594.0, 4197.0, -4030.0, -5630.0, -2898.0, 2540.0, -306.0, 2939.0, 1986.0}, {89948.0, 2103.0, 8963.0, 2695.0, 3682.0, 1648.0, 866.0, -154.0, -1963.0, -283.0}};
        double[][] sl = new double[][]{{-342.0, 136.0, -23.0, 62.0, 66.0, -52.0, -33.0, 17.0, 0.0, 0.0}, {524.0, -149.0, -35.0, 117.0, 151.0, 122.0, -71.0, -62.0, 0.0, 0.0}, {-105.0, -137.0, 258.0, 35.0, -116.0, -88.0, -112.0, -80.0, 0.0, 0.0}, {854.0, -205.0, -936.0, -240.0, 140.0, -341.0, -97.0, -232.0, 536.0, 0.0}, {-56980.0, 8016.0, 1012.0, 1448.0, -3024.0, -3710.0, 318.0, 503.0, 3767.0, 577.0}, {138606.0, -13478.0, -4964.0, 1441.0, -1319.0, -1482.0, 427.0, 1236.0, -9167.0, -1918.0}, {71234.0, -41116.0, 5334.0, -4935.0, -1848.0, 66.0, 434.0, -1748.0, 3780.0, -701.0}, {-47645.0, 11647.0, 2166.0, 3194.0, 679.0, 0.0, -244.0, -419.0, -2531.0, 48.0}};
        if (np < 1 || np > 8) {
            jstat = -1;
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 3; ++i) {
                    pv[k][i] = 0.0;
                }
            }
        } else {
            double argl;
            double arga;
            int k;
            double t = (date1 - 2451545.0 + date2) / 365250.0;
            jstat = StrictMath.abs(t) <= 1.0 ? 0 : 1;
            double da = a[--np][0] + (a[np][1] + a[np][2] * t) * t;
            double dl = (3600.0 * dlm[np][0] + (dlm[np][1] + dlm[np][2] * t) * t) * 4.84813681109536E-6;
            double de = e[np][0] + (e[np][1] + e[np][2] * t) * t;
            double dp = JSOFA.jauAnpm((3600.0 * pi[np][0] + (pi[np][1] + pi[np][2] * t) * t) * 4.84813681109536E-6);
            double di = (3600.0 * dinc[np][0] + (dinc[np][1] + dinc[np][2] * t) * t) * 4.84813681109536E-6;
            double dom = JSOFA.jauAnpm((3600.0 * omega[np][0] + (omega[np][1] + omega[np][2] * t) * t) * 4.84813681109536E-6);
            double dmu = 0.3595362 * t;
            for (k = 0; k < 8; ++k) {
                arga = kp[np][k] * dmu;
                argl = kq[np][k] * dmu;
                da += (ca[np][k] * StrictMath.cos(arga) + sa[np][k] * StrictMath.sin(arga)) * 1.0E-7;
                dl += (cl[np][k] * StrictMath.cos(argl) + sl[np][k] * StrictMath.sin(argl)) * 1.0E-7;
            }
            arga = kp[np][8] * dmu;
            da += t * (ca[np][8] * StrictMath.cos(arga) + sa[np][8] * StrictMath.sin(arga)) * 1.0E-7;
            for (k = 8; k < 10; ++k) {
                argl = kq[np][k] * dmu;
                dl += t * (cl[np][k] * StrictMath.cos(argl) + sl[np][k] * StrictMath.sin(argl)) * 1.0E-7;
            }
            dl = JSOFA.fmod(dl, Math.PI * 2);
            double am = dl - dp;
            double ae = am + de * StrictMath.sin(am);
            k = 0;
            double dae = 1.0;
            while (k < 10 && StrictMath.abs(dae) > 1.0E-12) {
                dae = (am - ae + de * StrictMath.sin(ae)) / (1.0 - de * StrictMath.cos(ae));
                ae += dae;
                if (++k != 9) continue;
                jstat = 2;
            }
            double ae2 = ae / 2.0;
            double at = 2.0 * StrictMath.atan2(StrictMath.sqrt((1.0 + de) / (1.0 - de)) * StrictMath.sin(ae2), StrictMath.cos(ae2));
            double r = da * (1.0 - de * StrictMath.cos(ae));
            double v = 0.01720209895 * StrictMath.sqrt((1.0 + 1.0 / amas[np]) / (da * da * da));
            double si2 = StrictMath.sin(di / 2.0);
            double xq = si2 * StrictMath.cos(dom);
            double xp = si2 * StrictMath.sin(dom);
            double tl = at + dp;
            double xsw = StrictMath.sin(tl);
            double xcw = StrictMath.cos(tl);
            double xm2 = 2.0 * (xp * xcw - xq * xsw);
            double xf = da / StrictMath.sqrt(1.0 - de * de);
            double ci2 = StrictMath.cos(di / 2.0);
            double xms = (de * StrictMath.sin(dp) + xsw) * xf;
            double xmc = (de * StrictMath.cos(dp) + xcw) * xf;
            double xpxq2 = 2.0 * xp * xq;
            double x = r * (xcw - xm2 * xp);
            double y = r * (xsw + xm2 * xq);
            double z = r * (-xm2 * ci2);
            pv[0][0] = x;
            pv[0][1] = y * 0.9174820620691818 - z * 0.3977771559319137;
            pv[0][2] = y * 0.3977771559319137 + z * 0.9174820620691818;
            x = v * ((-1.0 + 2.0 * xp * xp) * xms + xpxq2 * xmc);
            y = v * ((1.0 - 2.0 * xq * xq) * xmc - xpxq2 * xms);
            z = v * (2.0 * ci2 * (xp * xms + xq * xmc));
            pv[1][0] = x;
            pv[1][1] = y * 0.9174820620691818 - z * 0.3977771559319137;
            pv[1][2] = y * 0.3977771559319137 + z * 0.9174820620691818;
        }
        return jstat;
    }

    public static double jauPm(double[] p) {
        double w = StrictMath.sqrt(p[0] * p[0] + p[1] * p[1] + p[2] * p[2]);
        return w;
    }

    public static double[][] jauPmat00(double date1, double date2) {
        double[][] rb = new double[3][3];
        double[][] rp = new double[3][3];
        double[][] rbp = new double[3][3];
        JSOFA.jauBp00(date1, date2, rb, rp, rbp);
        return rbp;
    }

    public static double[][] jauPmat06(double date1, double date2) {
        FWPrecessionAngles fw = JSOFA.jauPfw06(date1, date2);
        double[][] rbp = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib, fw.epsa);
        return rbp;
    }

    public static double[][] jauPmat76(double date1, double date2) {
        double[][] wmat = new double[3][3];
        double[][] rmatp = new double[3][3];
        EulerAngles euler = JSOFA.jauPrec76(2451545.0, 0.0, date1, date2);
        JSOFA.jauIr(wmat);
        JSOFA.jauRz(-euler.zeta, wmat);
        JSOFA.jauRy(euler.theta, wmat);
        JSOFA.jauRz(-euler.z, wmat);
        JSOFA.jauCr(wmat, rmatp);
        return rmatp;
    }

    public static double[] jauPmp(double[] a, double[] b) {
        double[] amb = new double[]{a[0] - b[0], a[1] - b[1], a[2] - b[2]};
        return amb;
    }

    public static NormalizedVector jauPn(double[] p) {
        double w = JSOFA.jauPm(p);
        NormalizedVector nv = new NormalizedVector(w, new double[3]);
        if (w == 0.0) {
            JSOFA.jauZp(nv.u);
        } else {
            nv.u = JSOFA.jauSxp(1.0 / w, p);
        }
        return nv;
    }

    public static PrecessionNutation jauPn00(double date1, double date2, double dpsi, double deps) {
        double[][] rbpw = new double[3][3];
        double[][] rnw = new double[3][3];
        double[][] rb = new double[3][3];
        double[][] rp = new double[3][3];
        double[][] rbp = new double[3][3];
        double[][] rn = new double[3][3];
        double[][] rbpn = new double[3][3];
        PrecessionDeltaTerms nut = JSOFA.jauPr00(date1, date2);
        double epsa = JSOFA.jauObl80(date1, date2) + nut.depspr;
        JSOFA.jauBp00(date1, date2, rb, rp, rbpw);
        JSOFA.jauCr(rbpw, rbp);
        rnw = JSOFA.jauNumat(epsa, dpsi, deps);
        JSOFA.jauCr(rnw, rn);
        rbpn = JSOFA.jauRxr(rnw, rbpw);
        return new PrecessionNutation(dpsi, deps, epsa, rb, rp, rbp, rn, rbpn);
    }

    public static PrecessionNutation jauPn00a(double date1, double date2) {
        NutationTerms nut = JSOFA.jauNut00a(date1, date2);
        return JSOFA.jauPn00(date1, date2, nut.dpsi, nut.deps);
    }

    public static PrecessionNutation jauPn00b(double date1, double date2) {
        NutationTerms nut = JSOFA.jauNut00b(date1, date2);
        return JSOFA.jauPn00(date1, date2, nut.dpsi, nut.deps);
    }

    public static PrecessionNutation jauPn06(double date1, double date2, double dpsi, double deps) {
        double[][] rb = new double[3][3];
        double[][] rbp = new double[3][3];
        double[][] rbpn = new double[3][3];
        FWPrecessionAngles fw = JSOFA.jauPfw06(2400000.5, 51544.5);
        double[][] r1 = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib, fw.epsa);
        JSOFA.jauCr(r1, rb);
        fw = JSOFA.jauPfw06(date1, date2);
        double[][] r2 = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib, fw.epsa);
        JSOFA.jauCr(r2, rbp);
        double[][] rt = JSOFA.jauTr(r1);
        double[][] rp = JSOFA.jauRxr(r2, rt);
        r1 = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib + dpsi, fw.epsa + deps);
        JSOFA.jauCr(r1, rbpn);
        rt = JSOFA.jauTr(r2);
        double[][] rn = JSOFA.jauRxr(r1, rt);
        double epsa = fw.epsa;
        return new PrecessionNutation(dpsi, deps, epsa, rb, rp, rbp, rn, rbpn);
    }

    public static PrecessionNutation jauPn06a(double date1, double date2) {
        NutationTerms nut = JSOFA.jauNut06a(date1, date2);
        return JSOFA.jauPn06(date1, date2, nut.dpsi, nut.deps);
    }

    public static double[][] jauPnm00a(double date1, double date2) {
        PrecessionNutation pn = JSOFA.jauPn00a(date1, date2);
        return pn.rbpn;
    }

    public static double[][] jauPnm00b(double date1, double date2) {
        PrecessionNutation pn = JSOFA.jauPn00b(date1, date2);
        return pn.rbpn;
    }

    public static double[][] jauPnm06a(double date1, double date2) {
        FWPrecessionAngles fw = JSOFA.jauPfw06(date1, date2);
        NutationTerms nut = JSOFA.jauNut06a(date1, date2);
        double[][] rnpb = JSOFA.jauFw2m(fw.gamb, fw.phib, fw.psib + nut.dpsi, fw.epsa + nut.deps);
        return rnpb;
    }

    public static double[][] jauPnm80(double date1, double date2) {
        double[][] rmatp = new double[3][3];
        double[][] rmatn = new double[3][3];
        rmatp = JSOFA.jauPmat76(date1, date2);
        rmatn = JSOFA.jauNutm80(date1, date2);
        double[][] rmatpn = JSOFA.jauRxr(rmatn, rmatp);
        return rmatpn;
    }

    public static double[][] jauPom00(double xp, double yp, double sp) {
        double[][] rpom = new double[3][3];
        JSOFA.jauIr(rpom);
        JSOFA.jauRz(sp, rpom);
        JSOFA.jauRy(-xp, rpom);
        JSOFA.jauRx(-yp, rpom);
        return rpom;
    }

    public static double[] jauPpp(double[] a, double[] b) {
        double[] apb = new double[]{a[0] + b[0], a[1] + b[1], a[2] + b[2]};
        return apb;
    }

    static double[] jauPpsp(double[] a, double s, double[] b) {
        double[] sb = new double[3];
        sb = JSOFA.jauSxp(s, b);
        double[] apsb = JSOFA.jauPpp(a, sb);
        return apsb;
    }

    static PrecessionDeltaTerms jauPr00(double date1, double date2) {
        double PRECOR = -1.4527441954447247E-6;
        double OBLCOR = -1.2236697311204688E-7;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double dpsipr = -1.4527441954447247E-6 * t;
        double depspr = -1.2236697311204688E-7 * t;
        return new PrecessionDeltaTerms(dpsipr, depspr);
    }

    static EulerAngles jauPrec76(double ep01, double ep02, double ep11, double ep12) {
        double t0 = (ep01 - 2451545.0 + ep02) / 36525.0;
        double t = (ep11 - ep01 + (ep12 - ep02)) / 36525.0;
        double tas2r = t * 4.84813681109536E-6;
        double w = 2306.2181 + (1.39656 - 1.39E-4 * t0) * t0;
        double zeta = (w + (0.30188 - 3.44E-4 * t0 + 0.017998 * t) * t) * tas2r;
        double z = (w + (1.09468 + 6.6E-5 * t0 + 0.018203 * t) * t) * tas2r;
        double theta = (2004.3109 + (-0.8533 - 2.17E-4 * t0) * t0 + (-0.42665 - 2.17E-4 * t0 - 0.041833 * t) * t) * tas2r;
        return new EulerAngles(zeta, z, theta);
    }

    public static double[] jauPv2p(double[][] pv) {
        double[] p = new double[3];
        JSOFA.jauCp(pv[0], p);
        return p;
    }

    public static SphericalPositionVelocity jauPv2s(double[][] pv) {
        double pd;
        double td;
        double phi;
        double theta;
        double rtrue;
        double x = pv[0][0];
        double y = pv[0][1];
        double z = pv[0][2];
        double xd = pv[1][0];
        double yd = pv[1][1];
        double zd = pv[1][2];
        double rxy2 = x * x + y * y;
        double r2 = rxy2 + z * z;
        double rw = rtrue = StrictMath.sqrt(r2);
        if (rtrue == 0.0) {
            x = xd;
            y = yd;
            z = zd;
            rxy2 = x * x + y * y;
            r2 = rxy2 + z * z;
            rw = StrictMath.sqrt(r2);
        }
        double rxy = StrictMath.sqrt(rxy2);
        double xyp = x * xd + y * yd;
        if (rxy2 != 0.0) {
            theta = StrictMath.atan2(y, x);
            phi = StrictMath.atan2(z, rxy);
            td = (x * yd - y * xd) / rxy2;
            pd = (zd * rxy2 - z * xyp) / (r2 * rxy);
        } else {
            theta = 0.0;
            phi = z != 0.0 ? StrictMath.atan2(z, rxy) : 0.0;
            td = 0.0;
            pd = 0.0;
        }
        double r = rtrue;
        double rd = rw != 0.0 ? (xyp + z * zd) / rw : 0.0;
        return new SphericalPositionVelocity(theta, phi, r, td, pd, rd);
    }

    public static double[] jauPvdpv(double[][] a, double[][] b) {
        double[] adb = new double[2];
        adb[0] = JSOFA.jauPdp(a[0], b[0]);
        double adbd = JSOFA.jauPdp(a[0], b[1]);
        double addb = JSOFA.jauPdp(a[1], b[0]);
        adb[1] = adbd + addb;
        return adb;
    }

    public static PVModulus jauPvm(double[][] pv) {
        double r = JSOFA.jauPm(pv[0]);
        double s = JSOFA.jauPm(pv[1]);
        return new PVModulus(r, s);
    }

    public static double[][] jauPvmpv(double[][] a, double[][] b) {
        double[][] amb = new double[2][3];
        amb[0] = JSOFA.jauPmp(a[0], b[0]);
        amb[1] = JSOFA.jauPmp(a[1], b[1]);
        return amb;
    }

    public static double[][] jauPvppv(double[][] a, double[][] b) {
        double[][] apb = new double[2][3];
        apb[0] = JSOFA.jauPpp(a[0], b[0]);
        apb[1] = JSOFA.jauPpp(a[1], b[1]);
        return apb;
    }

    public static CatalogCoords jauPvstar(double[][] pv) throws JSOFAInternalError {
        double[] x = new double[3];
        double[] ur = new double[3];
        double[] ut = new double[3];
        double[] usr = new double[3];
        double[] ust = new double[3];
        NormalizedVector nv = JSOFA.jauPn(pv[0]);
        x = nv.u;
        double vr = JSOFA.jauPdp(x, pv[1]);
        ur = JSOFA.jauSxp(vr, x);
        ut = JSOFA.jauPmp(pv[1], ur);
        double vt = JSOFA.jauPm(ut);
        double bett = vt / 173.1446333113497;
        double betr = vr / 173.1446333113497;
        double d = 1.0 + betr;
        double w = 1.0 - betr * betr - bett * bett;
        if (d == 0.0 || w < 0.0) {
            throw new JSOFAInternalError("Superluminal speed", -1);
        }
        double del = StrictMath.sqrt(w) - 1.0;
        w = betr != 0.0 ? (betr - del) / (betr * d) : 1.0;
        usr = JSOFA.jauSxp(w, ur);
        ust = JSOFA.jauSxp(1.0 / d, ut);
        pv[1] = JSOFA.jauPpp(usr, ust);
        SphericalPositionVelocity pvs = JSOFA.jauPv2s(pv);
        if (pvs.pos.r == 0.0) {
            throw new JSOFAInternalError("null position vector", -2);
        }
        double ra = JSOFA.jauAnp(pvs.pos.theta);
        double pmr = pvs.vel.theta * 365.25;
        double pmd = pvs.vel.phi * 365.25;
        double px = 206264.80624709636 / pvs.pos.r;
        double rv = 0.001 * pvs.vel.r * 1.4959787E11 / 86400.0;
        return new CatalogCoords(ra, pvs.pos.phi, pmr, pmd, px, rv);
    }

    public static double[][] jauPvu(double dt, double[][] pv) {
        double[][] upv = new double[2][3];
        upv[0] = JSOFA.jauPpsp(pv[0], dt, pv[1]);
        JSOFA.jauCp(pv[1], upv[1]);
        return upv;
    }

    public static double[] jauPvup(double dt, double[][] pv) {
        double[] p = new double[]{pv[0][0] + dt * pv[1][0], pv[0][1] + dt * pv[1][1], pv[0][2] + dt * pv[1][2]};
        return p;
    }

    public static double[][] jauPvxpv(double[][] a, double[][] b) {
        double[][] wa = new double[2][3];
        double[][] wb = new double[2][3];
        double[] axbd = new double[3];
        double[] adxb = new double[3];
        double[][] axb = new double[2][3];
        JSOFA.jauCpv(a, wa);
        JSOFA.jauCpv(b, wb);
        axb[0] = JSOFA.jauPxp(wa[0], wb[0]);
        axbd = JSOFA.jauPxp(wa[0], wb[1]);
        adxb = JSOFA.jauPxp(wa[1], wb[0]);
        axb[1] = JSOFA.jauPpp(axbd, adxb);
        return axb;
    }

    public static double[] jauPxp(double[] a, double[] b) {
        double[] axb = new double[3];
        double xa = a[0];
        double ya = a[1];
        double za = a[2];
        double xb = b[0];
        double yb = b[1];
        double zb = b[2];
        axb[0] = ya * zb - za * yb;
        axb[1] = za * xb - xa * zb;
        axb[2] = xa * yb - ya * xb;
        return axb;
    }

    public static double[] jauRm2v(double[][] r) {
        double[] w = new double[3];
        double x = r[1][2] - r[2][1];
        double y = r[2][0] - r[0][2];
        double z = r[0][1] - r[1][0];
        double s2 = StrictMath.sqrt(x * x + y * y + z * z);
        if (s2 > 0.0) {
            double c2 = r[0][0] + r[1][1] + r[2][2] - 1.0;
            double phi = StrictMath.atan2(s2, c2);
            double f = phi / s2;
            w[0] = x * f;
            w[1] = y * f;
            w[2] = z * f;
        } else {
            w[0] = 0.0;
            w[1] = 0.0;
            w[2] = 0.0;
        }
        return w;
    }

    public static double[][] jauRv2m(double[] w) {
        double[][] r = new double[3][3];
        double x = w[0];
        double y = w[1];
        double z = w[2];
        double phi = StrictMath.sqrt(x * x + y * y + z * z);
        double s = StrictMath.sin(phi);
        double c = StrictMath.cos(phi);
        double f = 1.0 - c;
        if (phi > 0.0) {
            x /= phi;
            y /= phi;
            z /= phi;
        }
        r[0][0] = x * x * f + c;
        r[0][1] = x * y * f + z * s;
        r[0][2] = x * z * f - y * s;
        r[1][0] = y * x * f - z * s;
        r[1][1] = y * y * f + c;
        r[1][2] = y * z * f + x * s;
        r[2][0] = z * x * f + y * s;
        r[2][1] = z * y * f - x * s;
        r[2][2] = z * z * f + c;
        return r;
    }

    public static void jauRx(double phi, double[][] r) {
        double[][] a = new double[3][3];
        double s = StrictMath.sin(phi);
        double c = StrictMath.cos(phi);
        JSOFA.jauIr(a);
        a[1][1] = c;
        a[2][1] = -s;
        a[1][2] = s;
        a[2][2] = c;
        double[][] w = JSOFA.jauRxr(a, r);
        JSOFA.jauCr(w, r);
    }

    public static double[] jauRxp(double[][] r, double[] p) {
        double[] wrp = new double[3];
        for (int j = 0; j < 3; ++j) {
            double w = 0.0;
            for (int i = 0; i < 3; ++i) {
                w += r[j][i] * p[i];
            }
            wrp[j] = w;
        }
        return wrp;
    }

    public static double[][] jauRxpv(double[][] r, double[][] pv) {
        double[][] rpv = new double[2][0];
        rpv[0] = JSOFA.jauRxp(r, pv[0]);
        rpv[1] = JSOFA.jauRxp(r, pv[1]);
        return rpv;
    }

    public static double[][] jauRxr(double[][] a, double[][] b) {
        double[][] wm = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double w = 0.0;
                for (int k = 0; k < 3; ++k) {
                    w += a[i][k] * b[k][j];
                }
                wm[i][j] = w;
            }
        }
        return wm;
    }

    public static void jauRy(double theta, double[][] r) {
        double[][] a = new double[3][3];
        double s = StrictMath.sin(theta);
        double c = StrictMath.cos(theta);
        JSOFA.jauIr(a);
        a[0][0] = c;
        a[2][0] = s;
        a[0][2] = -s;
        a[2][2] = c;
        double[][] w = JSOFA.jauRxr(a, r);
        JSOFA.jauCr(w, r);
    }

    public static void jauRz(double psi, double[][] r) {
        double[][] a = new double[3][3];
        double s = StrictMath.sin(psi);
        double c = StrictMath.cos(psi);
        JSOFA.jauIr(a);
        a[0][0] = c;
        a[1][0] = -s;
        a[0][1] = s;
        a[1][1] = c;
        double[][] w = JSOFA.jauRxr(a, r);
        JSOFA.jauCr(w, r);
    }

    public static double jauS00(double date1, double date2, double x, double y) {
        int j;
        double a;
        int i;
        double[] fa = new double[8];
        double[] sp = new double[]{9.4E-5, 0.00380835, -1.1994E-4, -0.07257409, 2.77E-5, 1.561E-5};
        TERM[] s0 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, -0.00264073, 3.9E-7), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -6.353E-5, 2.0E-8), new TERM(new int[]{0, 0, 2, -2, 3, 0, 0, 0}, -1.175E-5, -1.0E-8), new TERM(new int[]{0, 0, 2, -2, 1, 0, 0, 0}, -1.121E-5, -1.0E-8), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, 4.57E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 3, 0, 0, 0}, -2.02E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 1, 0, 0, 0}, -1.98E-6, 0.0), new TERM(new int[]{0, 0, 0, 0, 3, 0, 0, 0}, 1.72E-6, 0.0), new TERM(new int[]{0, 1, 0, 0, 1, 0, 0, 0}, 1.41E-6, 1.0E-8), new TERM(new int[]{0, 1, 0, 0, -1, 0, 0, 0}, 1.26E-6, 1.0E-8), new TERM(new int[]{1, 0, 0, 0, -1, 0, 0, 0}, 6.3E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, 1, 0, 0, 0}, 6.3E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 3, 0, 0, 0}, -4.6E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 1, 0, 0, 0}, -4.5E-7, 0.0), new TERM(new int[]{0, 0, 4, -4, 4, 0, 0, 0}, -3.6E-7, 0.0), new TERM(new int[]{0, 0, 1, -1, 1, -8, 12, 0}, 2.4E-7, 1.2E-7), new TERM(new int[]{0, 0, 2, 0, 0, 0, 0, 0}, -3.2E-7, 0.0), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, -2.8E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 3, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 1, 0, 0, 0}, -2.6E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 0, 0, 0, 0}, 2.1E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -3, 0, 0, 0}, -1.9E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -1, 0, 0, 0}, -1.8E-7, 0.0), new TERM(new int[]{0, 0, 0, 0, 0, 8, -13, -1}, 1.0E-7, -5.0E-8), new TERM(new int[]{0, 0, 0, 2, 0, 0, 0, 0}, -1.5E-7, 0.0), new TERM(new int[]{2, 0, -2, 0, -1, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 2, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, 1, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, -1, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{0, 0, 4, -2, 4, 0, 0, 0}, -1.3E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 4, 0, 0, 0}, 1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -3, 0, 0, 0}, -1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -1, 0, 0, 0}, -1.1E-7, 0.0)};
        TERM[] s1 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -7.0E-8, 3.57E-6), new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 1.71E-6, -3.0E-8), new TERM(new int[]{0, 0, 2, -2, 3, 0, 0, 0}, 0.0, 4.8E-7)};
        TERM[] s2 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 7.4353E-4, -1.7E-7), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, 5.691E-5, 6.0E-8), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, 9.84E-6, -1.0E-8), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -8.85E-6, 1.0E-8), new TERM(new int[]{0, 1, 0, 0, 0, 0, 0, 0}, -6.38E-6, -5.0E-8), new TERM(new int[]{1, 0, 0, 0, 0, 0, 0, 0}, -3.07E-6, 0.0), new TERM(new int[]{0, 1, 2, -2, 2, 0, 0, 0}, 2.23E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 1, 0, 0, 0}, 1.67E-6, 0.0), new TERM(new int[]{1, 0, 2, 0, 2, 0, 0, 0}, 1.3E-6, 0.0), new TERM(new int[]{0, 1, -2, 2, -2, 0, 0, 0}, 9.3E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, 0, 0, 0, 0}, 6.8E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 1, 0, 0, 0}, -5.5E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -2, 0, 0, 0}, 5.3E-7, 0.0), new TERM(new int[]{0, 0, 0, 2, 0, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, 1, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, -2, -2, -2, 0, 0, 0}, -2.6E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, -1, 0, 0, 0}, -2.5E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 1, 0, 0, 0}, 2.2E-7, 0.0), new TERM(new int[]{2, 0, 0, -2, 0, 0, 0, 0}, -2.1E-7, 0.0), new TERM(new int[]{2, 0, -2, 0, -1, 0, 0, 0}, 2.0E-7, 0.0), new TERM(new int[]{0, 0, 2, 2, 2, 0, 0, 0}, 1.7E-7, 0.0), new TERM(new int[]{2, 0, 2, 0, 2, 0, 0, 0}, 1.3E-7, 0.0), new TERM(new int[]{2, 0, 0, 0, 0, 0, 0, 0}, -1.3E-7, 0.0), new TERM(new int[]{1, 0, 2, -2, 2, 0, 0, 0}, -1.2E-7, 0.0), new TERM(new int[]{0, 0, 2, 0, 0, 0, 0, 0}, -1.1E-7, 0.0)};
        TERM[] s3 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 3.0E-7, -2.351E-5), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, -3.0E-8, -1.39E-6), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, -1.0E-8, -2.4E-7), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, 0.0, 2.2E-7)};
        TERM[] s4 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, -2.6E-7, -1.0E-8)};
        int NS0 = s0.length;
        int NS1 = s1.length;
        int NS2 = s2.length;
        int NS3 = s3.length;
        int NS4 = s4.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        fa[0] = JSOFA.jauFal03(t);
        fa[1] = JSOFA.jauFalp03(t);
        fa[2] = JSOFA.jauFaf03(t);
        fa[3] = JSOFA.jauFad03(t);
        fa[4] = JSOFA.jauFaom03(t);
        fa[5] = JSOFA.jauFave03(t);
        fa[6] = JSOFA.jauFae03(t);
        fa[7] = JSOFA.jauFapa03(t);
        double w0 = sp[0];
        double w1 = sp[1];
        double w2 = sp[2];
        double w3 = sp[3];
        double w4 = sp[4];
        double w5 = sp[5];
        for (i = NS0 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s0[i].nfa[j] * fa[j];
            }
            w0 += s0[i].s * StrictMath.sin(a) + s0[i].c * StrictMath.cos(a);
        }
        for (i = NS1 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s1[i].nfa[j] * fa[j];
            }
            w1 += s1[i].s * StrictMath.sin(a) + s1[i].c * StrictMath.cos(a);
        }
        for (i = NS2 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s2[i].nfa[j] * fa[j];
            }
            w2 += s2[i].s * StrictMath.sin(a) + s2[i].c * StrictMath.cos(a);
        }
        for (i = NS3 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s3[i].nfa[j] * fa[j];
            }
            w3 += s3[i].s * StrictMath.sin(a) + s3[i].c * StrictMath.cos(a);
        }
        for (i = NS4 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s4[i].nfa[j] * fa[j];
            }
            w4 += s4[i].s * StrictMath.sin(a) + s4[i].c * StrictMath.cos(a);
        }
        double s = (w0 + (w1 + (w2 + (w3 + (w4 + w5 * t) * t) * t) * t) * t) * 4.84813681109536E-6 - x * y / 2.0;
        return s;
    }

    public static double jauS00a(double date1, double date2) {
        double[][] rbpn = JSOFA.jauPnm00a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS00(date1, date2, cip.x, cip.y);
        return s;
    }

    public static double jauS00b(double date1, double date2) {
        double[][] rbpn = new double[3][3];
        rbpn = JSOFA.jauPnm00b(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS00(date1, date2, cip.x, cip.y);
        return s;
    }

    public static double jauS06(double date1, double date2, double x, double y) {
        int j;
        double a;
        int i;
        double[] fa = new double[8];
        double[] sp = new double[]{9.4E-5, 0.00380865, -1.2268E-4, -0.07257411, 2.798E-5, 1.562E-5};
        TERM[] s0 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, -0.00264073, 3.9E-7), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -6.353E-5, 2.0E-8), new TERM(new int[]{0, 0, 2, -2, 3, 0, 0, 0}, -1.175E-5, -1.0E-8), new TERM(new int[]{0, 0, 2, -2, 1, 0, 0, 0}, -1.121E-5, -1.0E-8), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, 4.57E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 3, 0, 0, 0}, -2.02E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 1, 0, 0, 0}, -1.98E-6, 0.0), new TERM(new int[]{0, 0, 0, 0, 3, 0, 0, 0}, 1.72E-6, 0.0), new TERM(new int[]{0, 1, 0, 0, 1, 0, 0, 0}, 1.41E-6, 1.0E-8), new TERM(new int[]{0, 1, 0, 0, -1, 0, 0, 0}, 1.26E-6, 1.0E-8), new TERM(new int[]{1, 0, 0, 0, -1, 0, 0, 0}, 6.3E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, 1, 0, 0, 0}, 6.3E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 3, 0, 0, 0}, -4.6E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 1, 0, 0, 0}, -4.5E-7, 0.0), new TERM(new int[]{0, 0, 4, -4, 4, 0, 0, 0}, -3.6E-7, 0.0), new TERM(new int[]{0, 0, 1, -1, 1, -8, 12, 0}, 2.4E-7, 1.2E-7), new TERM(new int[]{0, 0, 2, 0, 0, 0, 0, 0}, -3.2E-7, 0.0), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, -2.8E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 3, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 1, 0, 0, 0}, -2.6E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 0, 0, 0, 0}, 2.1E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -3, 0, 0, 0}, -1.9E-7, 0.0), new TERM(new int[]{0, 1, -2, 2, -1, 0, 0, 0}, -1.8E-7, 0.0), new TERM(new int[]{0, 0, 0, 0, 0, 8, -13, -1}, 1.0E-7, -5.0E-8), new TERM(new int[]{0, 0, 0, 2, 0, 0, 0, 0}, -1.5E-7, 0.0), new TERM(new int[]{2, 0, -2, 0, -1, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{0, 1, 2, -2, 2, 0, 0, 0}, 1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, 1, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, -1, 0, 0, 0}, -1.4E-7, 0.0), new TERM(new int[]{0, 0, 4, -2, 4, 0, 0, 0}, -1.3E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 4, 0, 0, 0}, 1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -3, 0, 0, 0}, -1.1E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -1, 0, 0, 0}, -1.1E-7, 0.0)};
        TERM[] s1 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -7.0E-8, 3.57E-6), new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 1.73E-6, -3.0E-8), new TERM(new int[]{0, 0, 2, -2, 3, 0, 0, 0}, 0.0, 4.8E-7)};
        TERM[] s2 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 7.4352E-4, -1.7E-7), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, 5.691E-5, 6.0E-8), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, 9.84E-6, -1.0E-8), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, -8.85E-6, 1.0E-8), new TERM(new int[]{0, 1, 0, 0, 0, 0, 0, 0}, -6.38E-6, -5.0E-8), new TERM(new int[]{1, 0, 0, 0, 0, 0, 0, 0}, -3.07E-6, 0.0), new TERM(new int[]{0, 1, 2, -2, 2, 0, 0, 0}, 2.23E-6, 0.0), new TERM(new int[]{0, 0, 2, 0, 1, 0, 0, 0}, 1.67E-6, 0.0), new TERM(new int[]{1, 0, 2, 0, 2, 0, 0, 0}, 1.3E-6, 0.0), new TERM(new int[]{0, 1, -2, 2, -2, 0, 0, 0}, 9.3E-7, 0.0), new TERM(new int[]{1, 0, 0, -2, 0, 0, 0, 0}, 6.8E-7, 0.0), new TERM(new int[]{0, 0, 2, -2, 1, 0, 0, 0}, -5.5E-7, 0.0), new TERM(new int[]{1, 0, -2, 0, -2, 0, 0, 0}, 5.3E-7, 0.0), new TERM(new int[]{0, 0, 0, 2, 0, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, 1, 0, 0, 0}, -2.7E-7, 0.0), new TERM(new int[]{1, 0, -2, -2, -2, 0, 0, 0}, -2.6E-7, 0.0), new TERM(new int[]{1, 0, 0, 0, -1, 0, 0, 0}, -2.5E-7, 0.0), new TERM(new int[]{1, 0, 2, 0, 1, 0, 0, 0}, 2.2E-7, 0.0), new TERM(new int[]{2, 0, 0, -2, 0, 0, 0, 0}, -2.1E-7, 0.0), new TERM(new int[]{2, 0, -2, 0, -1, 0, 0, 0}, 2.0E-7, 0.0), new TERM(new int[]{0, 0, 2, 2, 2, 0, 0, 0}, 1.7E-7, 0.0), new TERM(new int[]{2, 0, 2, 0, 2, 0, 0, 0}, 1.3E-7, 0.0), new TERM(new int[]{2, 0, 0, 0, 0, 0, 0, 0}, -1.3E-7, 0.0), new TERM(new int[]{1, 0, 2, -2, 2, 0, 0, 0}, -1.2E-7, 0.0), new TERM(new int[]{0, 0, 2, 0, 0, 0, 0, 0}, -1.1E-7, 0.0)};
        TERM[] s3 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, 3.0E-7, -2.342E-5), new TERM(new int[]{0, 0, 2, -2, 2, 0, 0, 0}, -3.0E-8, -1.46E-6), new TERM(new int[]{0, 0, 2, 0, 2, 0, 0, 0}, -1.0E-8, -2.5E-7), new TERM(new int[]{0, 0, 0, 0, 2, 0, 0, 0}, 0.0, 2.3E-7)};
        TERM[] s4 = new TERM[]{new TERM(new int[]{0, 0, 0, 0, 1, 0, 0, 0}, -2.6E-7, -1.0E-8)};
        int NS0 = s0.length;
        int NS1 = s1.length;
        int NS2 = s2.length;
        int NS3 = s3.length;
        int NS4 = s4.length;
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        fa[0] = JSOFA.jauFal03(t);
        fa[1] = JSOFA.jauFalp03(t);
        fa[2] = JSOFA.jauFaf03(t);
        fa[3] = JSOFA.jauFad03(t);
        fa[4] = JSOFA.jauFaom03(t);
        fa[5] = JSOFA.jauFave03(t);
        fa[6] = JSOFA.jauFae03(t);
        fa[7] = JSOFA.jauFapa03(t);
        double w0 = sp[0];
        double w1 = sp[1];
        double w2 = sp[2];
        double w3 = sp[3];
        double w4 = sp[4];
        double w5 = sp[5];
        for (i = NS0 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s0[i].nfa[j] * fa[j];
            }
            w0 += s0[i].s * StrictMath.sin(a) + s0[i].c * StrictMath.cos(a);
        }
        for (i = NS1 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s1[i].nfa[j] * fa[j];
            }
            w1 += s1[i].s * StrictMath.sin(a) + s1[i].c * StrictMath.cos(a);
        }
        for (i = NS2 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s2[i].nfa[j] * fa[j];
            }
            w2 += s2[i].s * StrictMath.sin(a) + s2[i].c * StrictMath.cos(a);
        }
        for (i = NS3 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s3[i].nfa[j] * fa[j];
            }
            w3 += s3[i].s * StrictMath.sin(a) + s3[i].c * StrictMath.cos(a);
        }
        for (i = NS4 - 1; i >= 0; --i) {
            a = 0.0;
            for (j = 0; j < 8; ++j) {
                a += (double)s4[i].nfa[j] * fa[j];
            }
            w4 += s4[i].s * StrictMath.sin(a) + s4[i].c * StrictMath.cos(a);
        }
        double s = (w0 + (w1 + (w2 + (w3 + (w4 + w5 * t) * t) * t) * t) * t) * 4.84813681109536E-6 - x * y / 2.0;
        return s;
    }

    public static double jauS06a(double date1, double date2) {
        double[][] rnpb = new double[3][3];
        rnpb = JSOFA.jauPnm06a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rnpb);
        double s = JSOFA.jauS06(date1, date2, cip.x, cip.y);
        return s;
    }

    public static double[] jauS2c(double theta, double phi) {
        double[] c = new double[3];
        double cp = StrictMath.cos(phi);
        c[0] = StrictMath.cos(theta) * cp;
        c[1] = StrictMath.sin(theta) * cp;
        c[2] = StrictMath.sin(phi);
        return c;
    }

    public static double[] jauS2p(double theta, double phi, double r) {
        double[] u = new double[3];
        u = JSOFA.jauS2c(theta, phi);
        double[] p = JSOFA.jauSxp(r, u);
        return p;
    }

    public static double[][] jauS2pv(double theta, double phi, double r, double td, double pd, double rd) {
        double[][] pv = new double[2][3];
        double st = StrictMath.sin(theta);
        double ct = StrictMath.cos(theta);
        double sp = StrictMath.sin(phi);
        double cp = StrictMath.cos(phi);
        double rcp = r * cp;
        double x = rcp * ct;
        double y = rcp * st;
        double rpd = r * pd;
        double w = rpd * sp - cp * rd;
        pv[0][0] = x;
        pv[0][1] = y;
        pv[0][2] = r * sp;
        pv[1][0] = -y * td - w * ct;
        pv[1][1] = x * td - w * st;
        pv[1][2] = rpd * cp + sp * rd;
        return pv;
    }

    public static double[][] jauS2xpv(double s1, double s2, double[][] pv) {
        double[][] spv = new double[2][3];
        spv[0] = JSOFA.jauSxp(s1, pv[0]);
        spv[1] = JSOFA.jauSxp(s2, pv[1]);
        return spv;
    }

    public static double jauSepp(double[] a, double[] b) {
        double[] axb = new double[3];
        axb = JSOFA.jauPxp(a, b);
        double ss = JSOFA.jauPm(axb);
        double cs = JSOFA.jauPdp(a, b);
        double s = ss != 0.0 || cs != 0.0 ? StrictMath.atan2(ss, cs) : 0.0;
        return s;
    }

    public static double jauSeps(double al, double ap, double bl, double bp) {
        double[] ac = new double[3];
        double[] bc = new double[3];
        ac = JSOFA.jauS2c(al, ap);
        bc = JSOFA.jauS2c(bl, bp);
        double s = JSOFA.jauSepp(ac, bc);
        return s;
    }

    public static double jauSp00(double date1, double date2) {
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double sp = -4.7E-5 * t * 4.84813681109536E-6;
        return sp;
    }

    public static CatalogCoords jauStarpm(double ra1, double dec1, double pmr1, double pmd1, double px1, double rv1, double ep1a, double ep1b, double ep2a, double ep2b) throws JSOFAInternalError {
        double[][] pv1 = new double[2][3];
        double[][] pv = new double[2][3];
        double[][] pv2 = new double[2][3];
        JSOFA.jauStarpv(ra1, dec1, pmr1, pmd1, px1, rv1, pv1);
        double tl1 = JSOFA.jauPm(pv1[0]) / 173.1446333113497;
        double dt = ep2a - ep1a + (ep2b - ep1b);
        pv = JSOFA.jauPvu(dt + tl1, pv1);
        double r2 = JSOFA.jauPdp(pv[0], pv[0]);
        double rdv = JSOFA.jauPdp(pv[0], pv[1]);
        double v2 = JSOFA.jauPdp(pv[1], pv[1]);
        double c2mv2 = 29979.06404452175 - v2;
        if (c2mv2 <= 0.0) {
            throw new JSOFAInternalError("internal error", -1);
        }
        double tl2 = (-rdv + StrictMath.sqrt(rdv * rdv + c2mv2 * r2)) / c2mv2;
        pv2 = JSOFA.jauPvu(dt + (tl1 - tl2), pv1);
        CatalogCoords cat = JSOFA.jauPvstar(pv2);
        return cat;
    }

    public static int jauStarpv(double ra, double dec, double pmr, double pmd, double px, double rv, double[][] pv) {
        int i;
        double betst;
        int iwarn;
        double w;
        double PXMIN = 1.0E-7;
        double VMAX = 0.5;
        int IMAX = 100;
        double[] x = new double[3];
        double[] usr = new double[3];
        double[] ust = new double[3];
        double[] ur = new double[3];
        double[] ut = new double[3];
        double d = 0.0;
        double del = 0.0;
        double odd = 0.0;
        double oddel = 0.0;
        double od = 0.0;
        double odel = 0.0;
        if (px >= 1.0E-7) {
            w = px;
            iwarn = 0;
        } else {
            w = 1.0E-7;
            iwarn = 1;
        }
        double r = 206264.80624709636 / w;
        double rd = 86400.0 * rv * 1000.0 / 1.4959787E11;
        double rad = pmr / 365.25;
        double decd = pmd / 365.25;
        double[][] pvt = JSOFA.jauS2pv(ra, dec, r, rad, decd, rd);
        JSOFA.jauCpv(pvt, pv);
        double v = JSOFA.jauPm(pv[1]);
        if (v / 173.1446333113497 > 0.5) {
            JSOFA.jauZp(pv[1]);
            iwarn += 2;
        }
        NormalizedVector nv = JSOFA.jauPn(pv[0]);
        w = nv.r;
        x = nv.u;
        double vsr = JSOFA.jauPdp(x, pv[1]);
        usr = JSOFA.jauSxp(vsr, x);
        ust = JSOFA.jauPmp(pv[1], usr);
        double vst = JSOFA.jauPm(ust);
        double betsr = vsr / 173.1446333113497;
        double bett = betst = vst / 173.1446333113497;
        double betr = betsr;
        for (i = 0; i < 100; ++i) {
            d = 1.0 + betr;
            del = StrictMath.sqrt(1.0 - betr * betr - bett * bett) - 1.0;
            betr = d * betsr + del;
            bett = d * betst;
            if (i > 0) {
                double dd = StrictMath.abs(d - od);
                double ddel = StrictMath.abs(del - odel);
                if (i > 1 && dd >= odd && ddel >= oddel) break;
                odd = dd;
                oddel = ddel;
            }
            od = d;
            odel = del;
        }
        if (i >= 100) {
            iwarn += 4;
        }
        w = betsr != 0.0 ? d + del / betsr : 1.0;
        ur = JSOFA.jauSxp(w, usr);
        ut = JSOFA.jauSxp(d, ust);
        pv[1] = JSOFA.jauPpp(ur, ut);
        return iwarn;
    }

    public static double[] jauSxp(double s, double[] p) {
        double[] sp = new double[]{s * p[0], s * p[1], s * p[2]};
        return sp;
    }

    public static double[][] jauSxpv(double s, double[][] pv) {
        double[][] spv = JSOFA.jauS2xpv(s, s, pv);
        return spv;
    }

    public static JulianDate jauTaitt(double tai1, double tai2) {
        double tt2;
        double tt1;
        double dtat = 3.7249999999999995E-4;
        if (tai1 > tai2) {
            tt1 = tai1;
            tt2 = tai2 + 3.7249999999999995E-4;
        } else {
            tt1 = tai1 + 3.7249999999999995E-4;
            tt2 = tai2;
        }
        return new JulianDate(tt1, tt2);
    }

    public static JulianDate jauTaiut1(double tai1, double tai2, double dta) {
        double ut12;
        double ut11;
        double dtad = dta / 86400.0;
        if (tai1 > tai2) {
            ut11 = tai1;
            ut12 = tai2 + dtad;
        } else {
            ut11 = tai1 + dtad;
            ut12 = tai2;
        }
        return new JulianDate(ut11, ut12);
    }

    public static JulianDate jauTaiutc(double tai1, double tai2) throws JSOFAIllegalParameter, JSOFAInternalError {
        double utc2;
        double utc1;
        double a2;
        double a1;
        boolean big1;
        double datd = 0.0;
        boolean bl = big1 = tai1 >= tai2;
        if (big1) {
            a1 = tai1;
            a2 = tai2;
        } else {
            a1 = tai2;
            a2 = tai1;
        }
        double d1 = a1;
        double dats1 = 0.0;
        for (int i = -1; i <= 3; ++i) {
            double d2 = a2 + (double)i;
            Calendar dt = JSOFA.jauJd2cal(d1, d2);
            double dats2 = JSOFA.jauDat(dt.iy, dt.im, dt.id, 0.0);
            if (i == -1) {
                dats1 = dats2;
            }
            double ddats = dats2 - dats1;
            datd = dats1 / 86400.0;
            if (StrictMath.abs(ddats) >= 0.5) {
                JulianDate jd = JSOFA.jauCal2jd(dt.iy, dt.im, dt.id);
                d1 = jd.djm0;
                d2 = jd.djm1;
                double as1 = d1;
                double as2 = d2 - 1.0 + datd;
                double da = a1 - as1;
                if (!((da += a2 - as2) > 0.0)) break;
                double fd = da * 86400.0 / (86400.0 + ddats);
                datd += ddats * (fd <= 1.0 ? fd : 1.0) / 86400.0;
                break;
            }
            dats1 = dats2;
        }
        a2 -= datd;
        if (big1) {
            utc1 = a1;
            utc2 = a2;
        } else {
            utc1 = a2;
            utc2 = a1;
        }
        return new JulianDate(utc1, utc2);
    }

    public static JulianDate jauTcbtdb(double tcb1, double tcb2) {
        double tdb2;
        double tdb1;
        double t77td = 2443144.5;
        double t77tf = 3.7249999999999995E-4;
        double tdb0 = -7.581018518518519E-10;
        if (tcb1 > tcb2) {
            double d = tcb1 - 2443144.5;
            tdb1 = tcb1;
            tdb2 = tcb2 + -7.581018518518519E-10 - (d + (tcb2 - 3.7249999999999995E-4)) * 1.550519768E-8;
        } else {
            double d = tcb2 - 2443144.5;
            tdb1 = tcb1 + -7.581018518518519E-10 - (d + (tcb1 - 3.7249999999999995E-4)) * 1.550519768E-8;
            tdb2 = tcb2;
        }
        return new JulianDate(tdb1, tdb2);
    }

    public static JulianDate jauTcgtt(double tcg1, double tcg2) {
        double tt2;
        double tt1;
        double t77t = 43144.0003725;
        if (tcg1 > tcg2) {
            tt1 = tcg1;
            tt2 = tcg2 - (tcg1 - 2400000.5 + (tcg2 - 43144.0003725)) * 6.969290134E-10;
        } else {
            tt1 = tcg1 - (tcg2 - 2400000.5 + (tcg1 - 43144.0003725)) * 6.969290134E-10;
            tt2 = tcg2;
        }
        return new JulianDate(tt1, tt2);
    }

    public static JulianDate jauTdbtcb(double tdb1, double tdb2) {
        double tcb2;
        double tcb1;
        double t77td = 2443144.5;
        double t77tf = 3.7249999999999995E-4;
        double tdb0 = -7.581018518518519E-10;
        double elbb = 1.550519792041116E-8;
        if (tdb1 > tdb2) {
            double d = 2443144.5 - tdb1;
            double f = tdb2 - -7.581018518518519E-10;
            tcb1 = tdb1;
            tcb2 = f - (d - (f - 3.7249999999999995E-4)) * 1.550519792041116E-8;
        } else {
            double d = 2443144.5 - tdb2;
            double f = tdb1 - -7.581018518518519E-10;
            tcb1 = f + (d - (f - 3.7249999999999995E-4)) * 1.550519792041116E-8;
            tcb2 = tdb2;
        }
        return new JulianDate(tcb1, tcb2);
    }

    public static JulianDate jauTdbtt(double tdb1, double tdb2, double dtr) {
        double tt2;
        double tt1;
        double dtrd = dtr / 86400.0;
        if (tdb1 > tdb2) {
            tt1 = tdb1;
            tt2 = tdb2 - dtrd;
        } else {
            tt1 = tdb1 - dtrd;
            tt2 = tdb2;
        }
        return new JulianDate(tt1, tt2);
    }

    public static double jauTf2a(char s, int ihour, int imin, double sec) throws JSOFAIllegalParameter {
        double rad = (s == '-' ? -1.0 : 1.0) * (60.0 * (60.0 * (double)StrictMath.abs(ihour) + (double)StrictMath.abs(imin)) + StrictMath.abs(sec)) * 7.27220521664304E-5;
        if (ihour < 0 || ihour > 23) {
            throw new JSOFAIllegalParameter("bad hour", 1);
        }
        if (imin < 0 || imin > 59) {
            throw new JSOFAIllegalParameter("bad minute", 2);
        }
        if (sec < 0.0 || sec >= 60.0) {
            throw new JSOFAIllegalParameter("bad second", 3);
        }
        return rad;
    }

    public static double jauTf2d(char s, int ihour, int imin, double sec) throws JSOFAIllegalParameter {
        double days = (s == '-' ? -1.0 : 1.0) * (60.0 * (60.0 * (double)StrictMath.abs(ihour) + (double)StrictMath.abs(imin)) + StrictMath.abs(sec)) / 86400.0;
        if (ihour < 0 || ihour > 23) {
            throw new JSOFAIllegalParameter("bad hour", 1);
        }
        if (imin < 0 || imin > 59) {
            throw new JSOFAIllegalParameter("bad minute", 2);
        }
        if (sec < 0.0 || sec >= 60.0) {
            throw new JSOFAIllegalParameter("bad second", 3);
        }
        return days;
    }

    public static double[][] jauTr(double[][] r) {
        double[][] wm = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                wm[i][j] = r[j][i];
            }
        }
        return wm;
    }

    public static double[] jauTrxp(double[][] r, double[] p) {
        double[][] tr = JSOFA.jauTr(r);
        double[] trp = JSOFA.jauRxp(tr, p);
        return trp;
    }

    public static double[][] jauTrxpv(double[][] r, double[][] pv) {
        double[][] tr = JSOFA.jauTr(r);
        double[][] trpv = JSOFA.jauRxpv(tr, pv);
        return trpv;
    }

    /*
     * Opcode count of 16330 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void init_mfals() {
        mfals = new int[][]{{0, 0, 0, 0, 1}, {0, 0, 2, -2, 2}, {0, 0, 2, 0, 2}, {0, 0, 0, 0, 2}, {0, 1, 0, 0, 0}, {0, 1, 2, -2, 2}, {1, 0, 0, 0, 0}, {0, 0, 2, 0, 1}, {1, 0, 2, 0, 2}, {0, 1, -2, 2, -2}, {0, 0, 2, -2, 1}, {1, 0, -2, 0, -2}, {1, 0, 0, -2, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 0, -1}, {1, 0, -2, -2, -2}, {1, 0, 2, 0, 1}, {2, 0, -2, 0, -1}, {0, 0, 0, 2, 0}, {0, 0, 2, 2, 2}, {2, 0, 0, -2, 0}, {0, 2, -2, 2, -2}, {2, 0, 2, 0, 2}, {1, 0, 2, -2, 2}, {1, 0, -2, 0, -1}, {2, 0, 0, 0, 0}, {0, 0, 2, 0, 0}, {0, 1, 0, 0, 1}, {1, 0, 0, -2, -1}, {0, 2, 2, -2, 2}, {0, 0, 2, -2, 0}, {1, 0, 0, -2, 1}, {0, 1, 0, 0, -1}, {0, 2, 0, 0, 0}, {1, 0, -2, -2, -1}, {1, 0, 2, 2, 2}, {0, 1, 2, 0, 2}, {2, 0, -2, 0, 0}, {0, 0, 2, 2, 1}, {0, 1, -2, 0, -2}, {0, 0, 0, 2, 1}, {1, 0, 2, -2, 1}, {2, 0, 0, -2, -1}, {2, 0, 2, -2, 2}, {2, 0, 2, 0, 1}, {0, 0, 0, 2, -1}, {0, 1, -2, 2, -1}, {1, 1, 0, -2, 0}, {2, 0, 0, -2, 1}, {1, 0, 0, 2, 0}, {0, 1, 2, -2, 1}, {1, -1, 0, 0, 0}, {0, 1, -1, 1, -1}, {2, 0, -2, 0, -2}, {0, 1, 0, -2, 0}, {1, 0, 0, -1, 0}, {3, 0, 2, 0, 2}, {0, 0, 0, 1, 0}, {1, -1, 2, 0, 2}, {1, 1, -2, -2, -2}, {1, 0, -2, 0, 0}, {2, 0, 0, 0, -1}, {0, 1, -2, -2, -2}, {1, 1, 2, 0, 2}, {2, 0, 0, 0, 1}, {1, 1, 0, 0, 0}, {1, 0, -2, 2, -1}, {1, 0, 2, 0, 0}, {1, -1, 0, -1, 0}, {1, 0, 0, 0, 2}, {1, 0, -1, 0, -1}, {0, 0, 2, 1, 2}, {1, 0, -2, -4, -2}, {1, -1, 0, -1, -1}, {1, 0, 2, 2, 1}, {0, 2, -2, 2, -1}, {1, 0, 0, 0, -2}, {2, 0, -2, -2, -2}, {1, 1, 2, -2, 2}, {2, 0, -2, -4, -2}, {1, 0, -4, 0, -2}, {2, 0, 2, -2, 1}, {1, 0, 0, -1, -1}, {2, 0, 2, 2, 2}, {3, 0, 0, 0, 0}, {1, 0, 0, 2, 1}, {0, 0, 2, -2, -1}, {3, 0, 2, -2, 2}, {0, 0, 4, -2, 2}, {1, 0, 0, -4, 0}, {0, 1, 2, 0, 1}, {2, 0, 0, -4, 0}, {1, 1, 0, -2, -1}, {2, 0, -2, 0, 1}, {0, 0, 2, 0, -1}, {0, 1, -2, 0, -1}, {0, 1, 0, 0, 2}, {0, 0, 2, -1, 2}, {0, 0, 2, 4, 2}, {2, 1, 0, -2, 0}, {1, 1, 0, -2, 1}, {1, -1, 0, -2, 0}, {1, -1, 0, -1, -2}, {1, -1, 0, 0, 1}, {0, 1, -2, 2, 0}, {0, 1, 0, 0, -2}, {1, -1, 2, 2, 2}, {1, 0, 0, 2, -1}, {1, -1, -2, -2, -2}, {3, 0, 2, 0, 1}, {0, 1, 2, 2, 2}, {1, 0, 2, -2, 0}, {1, 1, -2, -2, -1}, {1, 0, 2, -4, 1}, {0, 1, -2, -2, -1}, {2, -1, 2, 0, 2}, {0, 0, 0, 2, 2}, {1, -1, 2, 0, 1}, {1, -1, -2, 0, -2}, {0, 1, 0, 2, 0}, {0, 1, 2, -2, 0}, {0, 0, 0, 1, 1}, {1, 0, -2, -2, 0}, {0, 3, 2, -2, 2}, {2, 1, 2, 0, 2}, {1, 1, 0, 0, 1}, {2, 0, 0, 2, 0}, {1, 1, 2, 0, 1}, {1, 0, 0, -2, -2}, {1, 0, -2, 2, 0}, {1, 0, -1, 0, -2}, {0, 1, 0, -2, 1}, {0, 1, 0, 1, 0}, {0, 0, 0, 1, -1}, {1, 0, -2, 2, -2}, {1, -1, 0, 0, -1}, {0, 0, 0, 4, 0}, {1, -1, 0, 2, 0}, {1, 0, 2, 1, 2}, {1, 0, 2, -1, 2}, {0, 0, 2, 1, 1}, {1, 0, 0, -2, 2}, {1, 0, -2, 0, 1}, {1, 0, -2, -4, -1}, {0, 0, 2, 2, 0}, {1, 1, 2, -2, 1}, {1, 0, -2, 1, -1}, {0, 0, 1, 0, 1}, {2, 0, -2, -2, -1}, {4, 0, 2, 0, 2}, {2, -1, 0, 0, 0}, {2, 1, 2, -2, 2}, {0, 1, 2, 1, 2}, {1, 0, 4, -2, 2}, {1, 1, 0, 0, -1}, {2, 0, 2, 0, 0}, {2, 0, -2, -4, -1}, {1, 0, -1, 0, 0}, {1, 0, 0, 1, 0}, {0, 1, 0, 2, 1}, {1, 0, -4, 0, -1}, {1, 0, 0, -4, -1}, {2, 0, 2, 2, 1}, {2, 1, 0, 0, 0}, {0, 0, 2, -3, 2}, {1, 2, 0, -2, 0}, {0, 3, 0, 0, 0}, {0, 0, 4, 0, 2}, {0, 0, 2, -4, 1}, {2, 0, 0, -2, -2}, {1, 1, -2, -4, -2}, {0, 1, 0, -2, -1}, {0, 0, 0, 4, 1}, {3, 0, 2, -2, 1}, {1, 0, 2, 4, 2}, {1, 1, -2, 0, -2}, {0, 0, 4, -2, 1}, {2, -2, 0, -2, 0}, {2, 1, 0, -2, -1}, {0, 2, 0, -2, 0}, {1, 0, 0, -1, 1}, {1, 1, 2, 2, 2}, {3, 0, 0, 0, -1}, {2, 0, 0, -4, -1}, {3, 0, 2, 2, 2}, {0, 0, 2, 4, 1}, {0, 2, -2, -2, -2}, {1, -1, 0, -2, -1}, {0, 0, 2, -1, 1}, {2, 0, 0, 2, 1}, {1, -1, -2, 2, -1}, {0, 0, 0, 2, -2}, {2, 0, 0, -4, 1}, {1, 0, 0, -4, 1}, {2, 0, 2, -4, 1}, {4, 0, 2, -2, 2}, {2, 1, -2, 0, -1}, {2, 1, -2, -4, -2}, {3, 0, 0, -4, 0}, {1, -1, 2, 2, 1}, {1, -1, -2, 0, -1}, {0, 2, 0, 0, 1}, {1, 2, -2, -2, -2}, {1, 1, 0, -4, 0}, {2, 0, 0, -2, 2}, {0, 2, 2, -2, 1}, {1, 0, 2, 0, -1}, {2, 1, 0, -2, 1}, {2, -1, -2, 0, -1}, {1, -1, -2, -2, -1}, {0, 1, -2, 1, -2}, {1, 0, -4, 2, -2}, {0, 1, 2, 2, 1}, {3, 0, 0, 0, 1}, {2, -1, 2, 2, 2}, {0, 1, -2, -4, -2}, {1, 0, -2, -3, -2}, {2, 0, 0, 0, 2}, {1, -1, 0, -2, -2}, {2, 0, -2, 2, -1}, {0, 2, -2, 0, -2}, {3, 0, -2, 0, -1}, {2, -1, 2, 0, 1}, {1, 0, -2, -1, -2}, {0, 0, 2, 0, 3}, {2, 0, -4, 0, -2}, {2, 1, 0, -4, 0}, {1, 1, -2, 1, -1}, {0, 2, 2, 0, 2}, {1, -1, 2, -2, 2}, {1, -1, 0, -2, 1}, {2, 1, 2, 0, 1}, {1, 0, 2, -4, 2}, {1, 1, -2, 0, -1}, {1, 1, 0, 2, 0}, {1, 0, 0, -3, 0}, {2, 0, 2, -1, 2}, {0, 2, 0, 0, -1}, {2, -1, 0, -2, 0}, {4, 0, 0, 0, 0}, {2, 1, -2, -2, -2}, {0, 2, -2, 2, 0}, {1, 0, 2, 1, 1}, {1, 0, -1, 0, -3}, {3, -1, 2, 0, 2}, {2, 0, 2, -2, 0}, {1, -2, 0, 0, 0}, {2, 0, 0, 0, -2}, {1, 0, 0, 4, 0}, {0, 1, 0, 1, 1}, {1, 0, 2, 2, 0}, {0, 1, 0, 2, -1}, {0, 1, 0, 1, -1}, {0, 0, 2, -2, 3}, {3, 1, 2, 0, 2}, {1, 1, 2, 1, 2}, {1, 1, -2, 2, -1}, {2, -1, 2, -2, 2}, {1, -2, 2, 0, 2}, {1, 0, 2, -4, 0}, {0, 0, 1, 0, 0}, {1, 0, 2, -3, 1}, {1, -2, 0, -2, 0}, {2, 0, 0, 2, -1}, {1, 1, 2, -4, 1}, {4, 0, 2, 0, 1}, {0, 1, 2, 1, 1}, {1, 2, 2, -2, 2}, {2, 0, 2, 1, 2}, {2, 1, 2, -2, 1}, {1, 0, 2, -1, 1}, {1, 0, 4, -2, 1}, {1, -1, 2, -2, 1}, {0, 1, 0, -4, 0}, {3, 0, -2, -2, -2}, {0, 0, 4, -4, 2}, {2, 0, -4, -2, -2}, {2, -2, 0, -2, -1}, {1, 0, 2, -2, -1}, {2, 0, -2, -6, -2}, {1, 0, -2, 1, -2}, {1, 0, -2, 2, 1}, {1, -1, 0, 2, -1}, {1, 0, -2, 1, 0}, {2, -1, 0, -2, 1}, {1, -1, 0, 2, 1}, {2, 0, -2, -2, 0}, {1, 0, 2, -3, 2}, {0, 0, 0, 4, -1}, {2, -1, 0, 0, 1}, {2, 0, 4, -2, 2}, {0, 0, 2, 3, 2}, {0, 1, 4, -2, 2}, {0, 1, -2, 2, 1}, {1, 1, 0, 2, 1}, {1, 0, 0, 4, 1}, {0, 0, 4, 0, 1}, {2, 0, 0, -3, 0}, {1, 0, 0, -1, -2}, {1, -2, -2, -2, -2}, {3, 0, 0, 2, 0}, {2, 0, 2, -4, 2}, {1, 1, -2, -4, -1}, {1, 0, -2, -6, -2}, {2, -1, 0, 0, -1}, {2, -1, 0, 2, 0}, {0, 1, 2, -2, -1}, {1, 1, 0, 1, 0}, {1, 2, 0, -2, -1}, {1, 0, 0, 1, -1}, {0, 0, 1, 0, 2}, {3, 1, 2, -2, 2}, {1, 0, -4, -2, -2}, {1, 0, 2, 4, 1}, {1, -2, 2, 2, 2}, {1, -1, -2, -4, -2}, {0, 0, 2, -4, 2}, {0, 0, 2, -3, 1}, {2, 1, -2, 0, 0}, {3, 0, -2, -2, -1}, {2, 0, 2, 4, 2}, {0, 0, 0, 0, 3}, {2, -1, -2, -2, -2}, {2, 0, 0, -1, 0}, {3, 0, 2, -4, 2}, {2, 1, 2, 2, 2}, {0, 0, 3, 0, 3}, {1, 1, 2, 2, 1}, {2, 1, 0, 0, -1}, {1, 2, 0, -2, 1}, {3, 0, 2, 2, 1}, {1, -1, -2, 2, -2}, {1, 1, 0, -1, 0}, {1, 2, 0, 0, 0}, {1, 0, 4, 0, 2}, {1, -1, 2, 4, 2}, {2, 1, 0, 0, 1}, {1, 0, 0, 2, 2}, {1, -1, -2, 2, 0}, {0, 2, -2, -2, -1}, {2, 0, -2, 0, 2}, {5, 0, 2, 0, 2}, {3, 0, -2, -6, -2}, {1, -1, 2, -1, 2}, {3, 0, 0, -4, -1}, {1, 0, 0, 1, 1}, {1, 0, -4, 2, -1}, {0, 1, 2, -4, 1}, {1, 2, 2, 0, 2}, {0, 1, 0, -2, -2}, {0, 0, 2, -1, 0}, {1, 0, 1, 0, 1}, {0, 2, 0, -2, 1}, {3, 0, 2, 0, 0}, {1, 1, -2, 1, 0}, {2, 1, -2, -4, -1}, {3, -1, 0, 0, 0}, {2, -1, -2, 0, 0}, {4, 0, 2, -2, 1}, {2, 0, -2, 2, 0}, {1, 1, 2, -2, 0}, {1, 0, -2, 4, -1}, {1, 0, -2, -2, 1}, {2, 0, 2, -4, 0}, {1, 1, 0, -2, -2}, {1, 1, -2, -2, 0}, {1, 0, 1, -2, 1}, {2, -1, -2, -4, -2}, {3, 0, -2, 0, -2}, {0, 1, -2, -2, 0}, {3, 0, 0, -2, -1}, {1, 0, -2, -3, -1}, {0, 1, 0, -4, -1}, {1, -2, 2, -2, 1}, {0, 1, -2, 1, -1}, {1, -1, 0, 0, 2}, {2, 0, 0, 1, 0}, {1, -2, 0, 2, 0}, {1, 2, -2, -2, -1}, {0, 0, 4, -4, 1}, {0, 1, 2, 4, 2}, {0, 1, -4, 2, -2}, {3, 0, -2, 0, 0}, {2, -1, 2, 2, 1}, {0, 1, -2, -4, -1}, {4, 0, 2, 2, 2}, {2, 0, -2, -3, -2}, {2, 0, 0, -6, 0}, {1, 0, 2, 0, 3}, {3, 1, 0, 0, 0}, {3, 0, 0, -4, 1}, {1, -1, 2, 0, 0}, {1, -1, 0, -4, 0}, {2, 0, -2, 2, -2}, {1, 1, 0, -2, 2}, {4, 0, 0, -2, 0}, {2, 2, 0, -2, 0}, {0, 1, 2, 0, 0}, {1, 1, 0, -4, 1}, {1, 0, 0, -4, -2}, {0, 0, 0, 1, 2}, {3, 0, 0, 2, 1}, {1, 1, 0, -4, -1}, {0, 0, 2, 2, -1}, {1, 1, 2, 0, 0}, {1, -1, 2, -4, 1}, {1, 1, 0, 0, 2}, {0, 0, 2, 6, 2}, {4, 0, -2, -2, -1}, {2, 1, 0, -4, -1}, {0, 0, 0, 3, 1}, {1, -1, -2, 0, 0}, {0, 0, 2, 1, 0}, {1, 0, 0, 2, -2}, {3, -1, 2, 2, 2}, {3, -1, 2, -2, 2}, {1, 0, 0, -1, 2}, {1, -2, 2, -2, 2}, {0, 1, 0, 2, 2}, {0, 1, -2, -1, -2}, {1, 1, -2, 0, 0}, {0, 2, 2, -2, 0}, {3, -1, -2, -1, -2}, {1, 0, 0, -6, 0}, {1, 0, -2, -4, 0}, {2, 1, 0, -4, 1}, {2, 0, 2, 0, -1}, {2, 0, -4, 0, -1}, {0, 0, 3, 0, 2}, {2, 1, -2, -2, -1}, {1, -2, 0, 0, 1}, {2, -1, 0, -4, 0}, {0, 0, 0, 3, 0}, {5, 0, 2, -2, 2}, {1, 2, -2, -4, -2}, {1, 0, 4, -4, 2}, {0, 0, 4, -1, 2}, {3, 1, 0, -4, 0}, {3, 0, 0, -6, 0}, {2, 0, 0, 2, 2}, {2, -2, 2, 0, 2}, {1, 0, 0, -3, 1}, {1, -2, -2, 0, -2}, {1, -1, -2, -3, -2}, {0, 0, 2, -2, -2}, {2, 0, -2, -4, 0}, {1, 0, -4, 0, 0}, {0, 1, 0, -1, 0}, {4, 0, 0, 0, -1}, {3, 0, 2, -1, 2}, {3, -1, 2, 0, 1}, {2, 0, 2, -1, 1}, {1, 2, 2, -2, 1}, {1, 1, 0, 2, -1}, {0, 2, 2, 0, 1}, {3, 1, 2, 0, 1}, {1, 1, 2, 1, 1}, {1, 1, 0, -1, 1}, {1, -2, 0, -2, -1}, {4, 0, 0, -4, 0}, {2, 1, 0, 2, 0}, {1, -1, 0, 4, 0}, {0, 1, 0, -2, 2}, {0, 0, 2, 0, -2}, {1, 0, -1, 0, 1}, {3, 0, 2, -2, 0}, {2, 0, 2, 2, 0}, {1, 2, 0, -4, 0}, {1, -1, 0, -3, 0}, {0, 1, 0, 4, 0}, {0, 1, -2, 0, 0}, {2, 2, 2, -2, 2}, {0, 0, 0, 1, -2}, {0, 2, -2, 0, -1}, {4, 0, 2, -4, 2}, {2, 0, -4, 2, -2}, {2, -1, -2, 0, -2}, {1, 1, 4, -2, 2}, {1, 1, 2, -4, 2}, {1, 0, 2, 3, 2}, {1, 0, 0, 4, -1}, {0, 0, 0, 4, 2}, {2, 0, 0, 4, 0}, {1, 1, -2, 2, 0}, {2, 1, 2, 1, 2}, {2, 1, 2, -4, 1}, {2, 0, 2, 1, 1}, {2, 0, -4, -2, -1}, {2, 0, -2, -6, -1}, {2, -1, 2, -1, 2}, {1, -2, 2, 0, 1}, {1, -2, 0, -2, 1}, {1, -1, 0, -4, -1}, {0, 2, 2, 2, 2}, {0, 2, -2, -4, -2}, {0, 1, 2, 3, 2}, {0, 1, 0, -4, 1}, {3, 0, 0, -2, 1}, {2, 1, -2, 0, 1}, {2, 0, 4, -2, 1}, {2, 0, 0, -3, -1}, {2, -2, 0, -2, 1}, {2, -1, 2, -2, 1}, {1, 0, 0, -6, -1}, {1, -2, 0, 0, -1}, {1, -2, -2, -2, -1}, {0, 1, 4, -2, 1}, {0, 0, 2, 3, 1}, {2, -1, 0, -1, 0}, {1, 3, 0, -2, 0}, {0, 3, 0, -2, 0}, {2, -2, 2, -2, 2}, {0, 0, 4, -2, 0}, {4, -1, 2, 0, 2}, {2, 2, -2, -4, -2}, {4, 1, 2, 0, 2}, {4, -1, -2, -2, -2}, {2, 1, 0, -2, -2}, {2, 1, -2, -6, -2}, {2, 0, 0, -1, 1}, {2, -1, -2, 2, -1}, {1, 1, -2, 2, -2}, {1, 1, -2, -3, -2}, {1, 0, 3, 0, 3}, {1, 0, -2, 1, 1}, {1, 0, -2, 0, 2}, {1, -1, 2, 1, 2}, {1, -1, 0, 0, -2}, {1, -1, -4, 2, -2}, {0, 3, -2, -2, -2}, {0, 1, 0, 4, 1}, {0, 0, 4, 2, 2}, {3, 0, -2, -2, 0}, {2, -2, 0, 0, 0}, {1, 1, 2, -4, 0}, {1, 1, 0, -3, 0}, {1, 0, 2, -3, 0}, {1, -1, 2, -2, 0}, {0, 2, 0, 2, 0}, {0, 0, 2, 4, 0}, {1, 0, 1, 0, 0}, {3, 1, 2, -2, 1}, {3, 0, 4, -2, 2}, {3, 0, 2, 1, 2}, {3, 0, 0, 2, -1}, {3, 0, 0, 0, 2}, {3, 0, -2, 2, -1}, {2, 0, 4, -4, 2}, {2, 0, 2, -3, 2}, {2, 0, 0, 4, 1}, {2, 0, 0, -3, 1}, {2, 0, -4, 2, -1}, {2, 0, -2, -2, 1}, {2, -2, 2, 2, 2}, {2, -2, 0, -2, -2}, {2, -1, 0, 2, 1}, {2, -1, 0, 2, -1}, {1, 1, 2, 4, 2}, {1, 1, 0, 1, 1}, {1, 1, 0, 1, -1}, {1, 1, -2, -6, -2}, {1, 0, 0, -3, -1}, {1, 0, -4, -2, -1}, {1, 0, -2, -6, -1}, {1, -2, 2, 2, 1}, {1, -2, -2, 2, -1}, {1, -1, -2, -4, -1}, {0, 2, 0, 0, 2}, {0, 1, 2, -4, 2}, {0, 1, -2, 4, -1}, {5, 0, 0, 0, 0}, {3, 0, 0, -3, 0}, {2, 2, 0, -4, 0}, {1, -1, 2, 2, 0}, {0, 1, 0, 3, 0}, {4, 0, -2, 0, -1}, {3, 0, -2, -6, -1}, {3, 0, -2, -1, -1}, {2, 1, 2, 2, 1}, {2, 1, 0, 2, 1}, {2, 0, 2, 4, 1}, {2, 0, 2, -6, 1}, {2, 0, 2, -2, -1}, {2, 0, 0, -6, -1}, {2, -1, -2, -2, -1}, {1, 2, 2, 0, 1}, {1, 2, 0, 0, 1}, {1, 0, 4, 0, 1}, {1, 0, 2, -6, 1}, {1, 0, 2, -4, -1}, {1, 0, -1, -2, -1}, {1, -1, 2, 4, 1}, {1, -1, 2, -3, 1}, {1, -1, 0, 4, 1}, {1, -1, -2, 1, -1}, {0, 1, 2, -2, 3}, {3, 0, 0, -2, 0}, {1, 0, 1, -2, 0}, {0, 2, 0, -4, 0}, {0, 0, 2, -4, 0}, {0, 0, 1, -1, 0}, {0, 0, 0, 6, 0}, {0, 2, 0, 0, -2}, {0, 1, -2, 2, -3}, {4, 0, 0, 2, 0}, {3, 0, 0, -1, 0}, {3, -1, 0, 2, 0}, {2, 1, 0, 1, 0}, {2, 1, 0, -6, 0}, {2, -1, 2, 0, 0}, {1, 0, 2, -1, 0}, {1, -1, 0, 1, 0}, {1, -1, -2, -2, 0}, {0, 1, 2, 2, 0}, {0, 0, 2, -3, 0}, {2, 2, 0, -2, -1}, {2, -1, -2, 0, 1}, {1, 2, 2, -4, 1}, {0, 1, 4, -4, 2}, {0, 0, 0, 3, 2}, {5, 0, 2, 0, 1}, {4, 1, 2, -2, 2}, {4, 0, -2, -2, 0}, {3, 1, 2, 2, 2}, {3, 1, 0, -2, 0}, {3, 1, -2, -6, -2}, {3, 0, 0, 0, -2}, {3, 0, -2, -4, -2}, {3, -1, 0, -3, 0}, {3, -1, 0, -2, 0}, {2, 1, 2, 0, 0}, {2, 1, 2, -4, 2}, {2, 1, 2, -2, 0}, {2, 1, 0, -3, 0}, {2, 1, -2, 0, -2}, {2, 0, 0, -4, 2}, {2, 0, 0, -4, -2}, {2, 0, -2, -5, -2}, {2, -1, 2, 4, 2}, {2, -1, 0, -2, 2}, {1, 3, -2, -2, -2}, {1, 1, 0, 0, -2}, {1, 1, 0, -6, 0}, {1, 1, -2, 1, -2}, {1, 1, -2, -1, -2}, {1, 0, 2, 1, 0}, {1, 0, 0, 3, 0}, {1, 0, 0, -4, 2}, {1, 0, -2, 4, -2}, {1, -2, 0, -1, 0}, {0, 1, -4, 2, -1}, {1, 0, -2, 0, -3}, {0, 0, 4, -4, 4}};
    }

    public static JulianDate jauTttai(double tt1, double tt2) {
        double tai2;
        double tai1;
        double dtat = 3.7249999999999995E-4;
        if (tt1 > tt2) {
            tai1 = tt1;
            tai2 = tt2 - 3.7249999999999995E-4;
        } else {
            tai1 = tt1 - 3.7249999999999995E-4;
            tai2 = tt2;
        }
        return new JulianDate(tai1, tai2);
    }

    public static JulianDate jauTttcg(double tt1, double tt2) {
        double tcg2;
        double tcg1;
        double t77t = 43144.0003725;
        double elgg = 6.9692901388571E-10;
        if (tt1 > tt2) {
            tcg1 = tt1;
            tcg2 = tt2 + (tt1 - 2400000.5 + (tt2 - 43144.0003725)) * 6.9692901388571E-10;
        } else {
            tcg1 = tt1 + (tt2 - 2400000.5 + (tt1 - 43144.0003725)) * 6.9692901388571E-10;
            tcg2 = tt2;
        }
        return new JulianDate(tcg1, tcg2);
    }

    public static JulianDate jauTttdb(double tt1, double tt2, double dtr) {
        double tdb2;
        double tdb1;
        double dtrd = dtr / 86400.0;
        if (tt1 > tt2) {
            tdb1 = tt1;
            tdb2 = tt2 + dtrd;
        } else {
            tdb1 = tt1 + dtrd;
            tdb2 = tt2;
        }
        return new JulianDate(tdb1, tdb2);
    }

    public static JulianDate jauTtut1(double tt1, double tt2, double dt) {
        double ut12;
        double ut11;
        double dtd = dt / 86400.0;
        if (tt1 > tt2) {
            ut11 = tt1;
            ut12 = tt2 - dtd;
        } else {
            ut11 = tt1 - dtd;
            ut12 = tt2;
        }
        return new JulianDate(ut11, ut12);
    }

    public static JulianDate jauUt1tai(double ut11, double ut12, double dta) {
        double tai2;
        double tai1;
        double dtad = dta / 86400.0;
        if (ut11 > ut12) {
            tai1 = ut11;
            tai2 = ut12 - dtad;
        } else {
            tai1 = ut11 - dtad;
            tai2 = ut12;
        }
        return new JulianDate(tai1, tai2);
    }

    public static JulianDate jauUt1tt(double ut11, double ut12, double dt) {
        double tt2;
        double tt1;
        double dtd = dt / 86400.0;
        if (ut11 > ut12) {
            tt1 = ut11;
            tt2 = ut12 + dtd;
        } else {
            tt1 = ut11 + dtd;
            tt2 = ut12;
        }
        return new JulianDate(tt1, tt2);
    }

    public static JulianDate jauUt1utc(double ut11, double ut12, double dut1) throws JSOFAIllegalParameter, JSOFAInternalError {
        double utc2;
        double utc1;
        double u2;
        double u1;
        boolean big1;
        double duts = dut1;
        boolean bl = big1 = ut11 >= ut12;
        if (big1) {
            u1 = ut11;
            u2 = ut12;
        } else {
            u1 = ut12;
            u2 = ut11;
        }
        double d1 = u1;
        double dats1 = 0.0;
        for (int i = -1; i <= 3; ++i) {
            double ddats;
            double d2 = u2 + (double)i;
            Calendar dt = JSOFA.jauJd2cal(d1, d2);
            double dats2 = JSOFA.jauDat(dt.iy, dt.im, dt.id, 0.0);
            if (i == -1) {
                dats1 = dats2;
            }
            if (StrictMath.abs(ddats = dats2 - dats1) >= 0.5) {
                if (ddats * duts >= 0.0) {
                    duts -= ddats;
                }
                JulianDate jd = JSOFA.jauCal2jd(dt.iy, dt.im, dt.id);
                d1 = jd.djm0;
                d2 = jd.djm1;
                double us1 = d1;
                double us2 = d2 - 1.0 + duts / 86400.0;
                double du = u1 - us1;
                if (!((du += u2 - us2) > 0.0)) break;
                double fd = du * 86400.0 / (86400.0 + ddats);
                duts += ddats * (fd <= 1.0 ? fd : 1.0);
                break;
            }
            dats1 = dats2;
        }
        u2 -= duts / 86400.0;
        if (big1) {
            utc1 = u1;
            utc2 = u2;
        } else {
            utc1 = u2;
            utc2 = u1;
        }
        return new JulianDate(utc1, utc2);
    }

    public static JulianDate jauUtctai(double utc1, double utc2) throws JSOFAIllegalParameter, JSOFAInternalError {
        double tai2;
        double tai1;
        double u2;
        double u1;
        boolean big1;
        boolean bl = big1 = utc1 >= utc2;
        if (big1) {
            u1 = utc1;
            u2 = utc2;
        } else {
            u1 = utc2;
            u2 = utc1;
        }
        Calendar dt = JSOFA.jauJd2cal(u1, u2);
        double dats = JSOFA.jauDat(dt.iy, dt.im, dt.id, dt.fd);
        double fd = dt.fd;
        Calendar dtt = JSOFA.jauJd2cal(u1 + 1.5, u2 - fd);
        double datst = JSOFA.jauDat(dtt.iy, dtt.im, dtt.id, dtt.fd);
        double ddat = datst - dats;
        if (StrictMath.abs(ddat) > 0.5) {
            fd += fd * ddat / 86400.0;
        }
        JulianDate jd = JSOFA.jauCal2jd(dt.iy, dt.im, dt.id);
        double a2 = jd.djm0 - u1;
        a2 += jd.djm1;
        a2 += fd + dats / 86400.0;
        if (big1) {
            tai1 = u1;
            tai2 = a2;
        } else {
            tai1 = a2;
            tai2 = u1;
        }
        return new JulianDate(tai1, tai2);
    }

    public static JulianDate jauUtcut1(double utc1, double utc2, double dut1) throws JSOFAIllegalParameter, JSOFAInternalError {
        Calendar dt = JSOFA.jauJd2cal(utc1, utc2);
        double dat = JSOFA.jauDat(dt.iy, dt.im, dt.id, 0.0);
        double dta = dut1 - dat;
        JulianDate tai = JSOFA.jauUtctai(utc1, utc2);
        return JSOFA.jauTaiut1(tai.djm0, tai.djm1, dta);
    }

    /*
     * Opcode count of 24974 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static CelestialIntermediatePole jauXy06(double date1, double date2) {
        int jsc;
        int ia;
        int m;
        int i;
        double arg;
        int ifreq;
        int j;
        int jxy;
        int jpt;
        double[][] xyp = new double[][]{{-0.016617, 2004.191898, -0.4297829, -0.19861834, 7.578E-6, 5.9285E-6}, {-0.006951, -0.025896, -22.4072747, 0.00190059, 0.001112526, 1.358E-7}};
        int NFLS = mfals.length;
        int NFPL = mfapl.length;
        int[] nc = new int[]{1, 21, 37, 51, 65, 79, 91, 103, 115, 127, 139, 151, 163, 172, 184, 196, 207, 219, 231, 240, 252, 261, 273, 285, 297, 309, 318, 327, 339, 351, 363, 372, 384, 396, 405, 415, 423, 435, 444, 452, 460, 467, 474, 482, 490, 498, 506, 513, 521, 528, 536, 543, 551, 559, 566, 574, 582, 590, 597, 605, 613, 620, 628, 636, 644, 651, 658, 666, 674, 680, 687, 695, 702, 710, 717, 725, 732, 739, 746, 753, 760, 767, 774, 782, 790, 798, 805, 812, 819, 826, 833, 840, 846, 853, 860, 867, 874, 881, 888, 895, 901, 908, 914, 921, 928, 934, 941, 948, 955, 962, 969, 976, 982, 989, 996, 1003, 1010, 1017, 1024, 1031, 1037, 1043, 1050, 1057, 1064, 1071, 1078, 1084, 1091, 1098, 1104, 1112, 1118, 1124, 1131, 1138, 1145, 1151, 1157, 1164, 1171, 1178, 1185, 1192, 1199, 1205, 1212, 1218, 1226, 1232, 1239, 1245, 1252, 1259, 1266, 1272, 1278, 1284, 1292, 1298, 1304, 1310, 1316, 1323, 1329, 1335, 1341, 1347, 1353, 1359, 1365, 1371, 1377, 1383, 1389, 1396, 1402, 1408, 1414, 1420, 1426, 1434, 1440, 1446, 1452, 1459, 1465, 1471, 1477, 1482, 1488, 1493, 1499, 1504, 1509, 1514, 1520, 1527, 1532, 1538, 1543, 1548, 1553, 1558, 1564, 1569, 1574, 1579, 1584, 1589, 1594, 1596, 1598, 1600, 1602, 1605, 1608, 1610, 1612, 1617, 1619, 1623, 1625, 1627, 1629, 1632, 1634, 1640, 1642, 1644, 1646, 1648, 1650, 1652, 1654, 1658, 1660, 1662, 1664, 1668, 1670, 1672, 1673, 1675, 1679, 1681, 1683, 1684, 1686, 1688, 1690, 1693, 1695, 1697, 1701, 1703, 1705, 1707, 1709, 1711, 1712, 1715, 1717, 1721, 1723, 1725, 1727, 1729, 1731, 1733, 1735, 1737, 1739, 1741, 1743, 1745, 1747, 1749, 1751, 1753, 1755, 1757, 1759, 1761, 1762, 1764, 1766, 1768, 1769, 1771, 1773, 1775, 1777, 1779, 1781, 1783, 1785, 1787, 1788, 1790, 1792, 1794, 1796, 1798, 1800, 1802, 1804, 1806, 1807, 1809, 1811, 1815, 1817, 1819, 1821, 1823, 1825, 1827, 1829, 1831, 1833, 1835, 1837, 1839, 1840, 1842, 1844, 1848, 1850, 1852, 1854, 1856, 1858, 1859, 1860, 1862, 1864, 1866, 1868, 1869, 1871, 1873, 1875, 1877, 1879, 1881, 1883, 1885, 1887, 1889, 1891, 1892, 1896, 1898, 1900, 1901, 1903, 1905, 1907, 1909, 1910, 1911, 1913, 1915, 1919, 1921, 1923, 1927, 1929, 1931, 1933, 1935, 1937, 1939, 1943, 1945, 1947, 1948, 1949, 1951, 1953, 1955, 1957, 1958, 1960, 1962, 1964, 1966, 1968, 1970, 1971, 1973, 1974, 1975, 1977, 1979, 1980, 1981, 1982, 1984, 1986, 1988, 1990, 1992, 1994, 1995, 1997, 1999, 2001, 2003, 2005, 2007, 2008, 2009, 2011, 2013, 2015, 2017, 2019, 2021, 2023, 2024, 2025, 2027, 2029, 2031, 2033, 2035, 2037, 2041, 2043, 2045, 2046, 2047, 2049, 2051, 2053, 2055, 2056, 2057, 2059, 2061, 2063, 2065, 2067, 2069, 2070, 2071, 2072, 2074, 2076, 2078, 2080, 2082, 2084, 2086, 2088, 2090, 2092, 2094, 2095, 2096, 2097, 2099, 2101, 2105, 2106, 2107, 2108, 2109, 2110, 2111, 2113, 2115, 2119, 2121, 2123, 2125, 2127, 2129, 2131, 2133, 2135, 2136, 2137, 2139, 2141, 2143, 2145, 2147, 2149, 2151, 2153, 2155, 2157, 2159, 2161, 2163, 2165, 2167, 2169, 2171, 2173, 2175, 2177, 2179, 2181, 2183, 2185, 2186, 2187, 2188, 2192, 2193, 2195, 2197, 2199, 2201, 2203, 2205, 2207, 2209, 2211, 2213, 2217, 2219, 2221, 2223, 2225, 2227, 2229, 2231, 2233, 2234, 2235, 2236, 2237, 2238, 2239, 2240, 2241, 2244, 2246, 2248, 2250, 2252, 2254, 2256, 2258, 2260, 2262, 2264, 2266, 2268, 2270, 2272, 2274, 2276, 2278, 2280, 2282, 2284, 2286, 2288, 2290, 2292, 2294, 2296, 2298, 2300, 2302, 2303, 2304, 2305, 2306, 2307, 2309, 2311, 2313, 2315, 2317, 2319, 2321, 2323, 2325, 2327, 2329, 2331, 2333, 2335, 2337, 2341, 2343, 2345, 2347, 2349, 2351, 2352, 2355, 2356, 2357, 2358, 2359, 2361, 2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 2374, 2376, 2378, 2380, 2382, 2384, 2385, 2386, 2387, 2388, 2389, 2390, 2391, 2392, 2393, 2394, 2395, 2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406, 2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2417, 2418, 2430, 2438, 2445, 2453, 2460, 2468, 2474, 2480, 2488, 2496, 2504, 2512, 2520, 2527, 2535, 2543, 2550, 2558, 2566, 2574, 2580, 2588, 2596, 2604, 2612, 2619, 2627, 2634, 2642, 2648, 2656, 2664, 2671, 2679, 2685, 2693, 2701, 2709, 2717, 2725, 2733, 2739, 2747, 2753, 2761, 2769, 2777, 2785, 2793, 2801, 2809, 2817, 2825, 2833, 2841, 2848, 2856, 2864, 2872, 2878, 2884, 2892, 2898, 2906, 2914, 2922, 2930, 2938, 2944, 2952, 2958, 2966, 2974, 2982, 2988, 2996, 3001, 3009, 3017, 3025, 3032, 3039, 3045, 3052, 3059, 3067, 3069, 3076, 3083, 3090, 3098, 3105, 3109, 3111, 3113, 3120, 3124, 3128, 3132, 3136, 3140, 3144, 3146, 3150, 3158, 3161, 3165, 3166, 3168, 3172, 3176, 3180, 3182, 3185, 3189, 3193, 3194, 3197, 3200, 3204, 3208, 3212, 3216, 3219, 3221, 3222, 3226, 3230, 3234, 3238, 3242, 3243, 3247, 3251, 3254, 3258, 3262, 3266, 3270, 3274, 3275, 3279, 3283, 3287, 3289, 3293, 3296, 3300, 3303, 3307, 3311, 3315, 3319, 3321, 3324, 3327, 3330, 3334, 3338, 3340, 3342, 3346, 3350, 3354, 3358, 3361, 3365, 3369, 3373, 3377, 3381, 3385, 3389, 3393, 3394, 3398, 3402, 3406, 3410, 3413, 3417, 3421, 3425, 3429, 3433, 3435, 3439, 3443, 3446, 3450, 3453, 3457, 3458, 3461, 3464, 3468, 3472, 3476, 3478, 3481, 3485, 3489, 3493, 3497, 3501, 3505, 3507, 3511, 3514, 3517, 3521, 3524, 3525, 3527, 3529, 3533, 3536, 3540, 3541, 3545, 3548, 3551, 3555, 3559, 3563, 3567, 3569, 3570, 3574, 3576, 3578, 3582, 3586, 3590, 3593, 3596, 3600, 3604, 3608, 3612, 3616, 3620, 3623, 3626, 3630, 3632, 3636, 3640, 3643, 3646, 3648, 3652, 3656, 3660, 3664, 3667, 3669, 3671, 3675, 3679, 3683, 3687, 3689, 3693, 3694, 3695, 3699, 3703, 3705, 3707, 3710, 3713, 3717, 3721, 3725, 3729, 3733, 3736, 3740, 3744, 3748, 3752, 3754, 3757, 3759, 3763, 3767, 3770, 3773, 3777, 3779, 3783, 3786, 3790, 3794, 3798, 3801, 3805, 3809, 3813, 3817, 3821, 3825, 3827, 3831, 3835, 3836, 3837, 3840, 3844, 3848, 3852, 3856, 3859, 3863, 3867, 3869, 3871, 3875, 3879, 3883, 3887, 3890, 3894, 3898, 3901, 3905, 3909, 3913, 3917, 3921, 3922, 3923, 3924, 3926, 3930, 3932, 3936, 3938, 3940, 3944, 3948, 3952, 3956, 3959, 3963, 3965, 3969, 3973, 3977, 3979, 3981, 3982, 3986, 3989, 3993, 3997, 4001, 4004, 4006, 4009, 4012, 4016, 4020, 4024, 4026, 4028, 4032, 4036, 4040, 4044, 4046, 4050, 4054, 4058, 4060, 4062, 4063, 4064, 4068, 4071, 4075, 4077, 4081, 4083, 4087, 4089, 4091, 4095, 4099, 4101, 4103, 4105, 4107, 4111, 4115, 4119, 4123, 4127, 4129, 4131, 4135, 4139, 4141, 4143, 4145, 4149, 4153, 4157, 4161, 4165, 4169, 4173, 4177, 4180, 4183, 4187, 4191, 4195, 4198, 4201, 4205, 4209, 4212, 4213, 4216, 4217, 4221, 4223, 4226, 4230, 4234, 4236, 4240, 4244, 4248, 4252, 4256, 4258, 4262, 4264, 4266, 4268, 4270, 4272, 4276, 4279, 4283, 4285, 4287, 4289, 4293, 4295, 4299, 4300, 4301, 4305, 4309, 4313, 4317, 4319, 4323, 4325, 4329, 4331, 4333, 4335, 4337, 4341, 4345, 4349, 4351, 4353, 4357, 4361, 4365, 4367, 4369, 4373, 4377, 4381, 4383, 4387, 4389, 4391, 4395, 4399, 4403, 4407, 4411, 4413, 4414, 4415, 4418, 4419, 4421, 4423, 4427, 4429, 4431, 4433, 4435, 4437, 4439, 4443, 4446, 4450, 4452, 4456, 4458, 4460, 4462, 4466, 4469, 4473, 4477, 4481, 4483, 4487, 4489, 4491, 4493, 4497, 4499, 4501, 4504, 4506, 4510, 4513, 4514, 4515, 4518, 4521, 4522, 4525, 4526, 4527, 4530, 4533, 4534, 4537, 4541, 4542, 4543, 4544, 4545, 4546, 4547, 4550, 4553, 4554, 4555, 4558, 4561, 4564, 4567, 4568, 4571, 4574, 4575, 4578, 4581, 4582, 4585, 4586, 4588, 4590, 4592, 4596, 4598, 4602, 4604, 4608, 4612, 4613, 4616, 4619, 4622, 4623, 4624, 4625, 4626, 4629, 4632, 4633, 4636, 4639, 4640, 4641, 4642, 4643, 4644, 4645, 4648, 4649, 4650, 4651, 4652, 4653, 4656, 4657, 4660, 4661, 4664, 4667, 4670, 4671, 4674, 4675, 4676, 4677, 4678, 4681, 4682, 4683, 4684, 4687, 4688, 4689, 4692, 4693, 4696, 4697, 4700, 4701, 4702, 4703, 4704, 4707, 4708, 4711, 4712, 4715, 4716, 4717, 4718, 4719, 4720, 4721, 4722, 4723, 4726, 4729, 4730, 4733, 4736, 4737, 4740, 4741, 4742, 4745, 4746, 4749, 4752, 4753};
        double[] a = new double[]{-6844318.44, 9205236.26, 1328.67, 1538.18, 205833.11, 153041.79, -3309.73, 853.32, 2037.98, -2301.27, 81.46, 120.56, -20.39, -15.22, 1.73, -1.61, -0.1, 0.11, -0.02, -0.02, -523908.04, 573033.42, -544.75, -458.66, 12814.01, 11714.49, 198.97, -290.91, 155.74, -143.27, -2.75, -1.03, -1.27, -1.16, 0.0, -0.01, -90552.22, 97846.69, 111.23, 137.41, 2187.91, 2024.68, 41.44, -51.26, 26.92, -24.46, -0.46, -0.28, -0.22, -0.2, 82168.76, -89618.24, -27.64, -29.05, -2004.36, -1837.32, -36.07, 48.0, -24.43, 22.41, 0.47, 0.24, 0.2, 0.18, 58707.02, 7387.02, 470.05, -192.4, 164.33, -1312.21, -179.73, -28.93, -17.36, -1.83, -0.5, 3.57, 0.0, 0.13, -20557.78, 22438.42, -20.84, -17.4, 501.82, 459.68, 59.2, -67.3, 6.08, -5.61, -1.36, -1.19, 28288.28, -674.99, -34.69, 35.8, -15.07, -632.54, -11.19, 0.78, -8.41, 0.17, 0.01, 0.07, -15406.85, 20069.5, 15.12, 31.8, 448.76, 344.5, -5.77, 1.41, 4.59, -5.02, 0.17, 0.24, -11991.74, 12902.66, 32.46, 36.7, 288.49, 268.14, 5.7, -7.06, 3.57, -3.23, -0.06, -0.04, -8584.95, -9592.72, 4.42, -13.2, -214.5, 192.06, 23.87, 29.83, 2.54, 2.4, 0.6, -0.48, 5095.5, -6918.22, 7.19, 3.92, -154.91, -113.94, 2.86, -1.04, -1.52, 1.73, -0.07, -0.1, -4910.93, -5331.13, 0.76, 0.4, -119.21, 109.81, 2.16, 3.2, 1.46, 1.33, 0.04, -0.02, -6245.02, -123.48, -6.68, -8.2, -2.76, 139.64, 2.71, 0.15, 1.86, 2511.85, -3323.89, 1.07, -0.9, -74.33, -56.17, 1.16, -0.01, -0.75, 0.83, -0.02, -0.04, 2307.58, 3143.98, -7.52, 7.5, 70.31, -51.6, 1.46, 0.16, -0.69, -0.79, 0.02, -0.05, 2372.58, 2554.51, 5.93, -6.6, 57.12, -53.05, -0.96, -1.24, -0.71, -0.64, -0.01, -2053.16, 2636.13, 5.13, 7.8, 58.94, 45.91, -0.42, -0.12, 0.61, -0.66, 0.02, 0.03, -1825.49, -2423.59, 1.23, -2.0, -54.19, 40.82, -1.07, -1.02, 0.54, 0.61, -0.04, 0.04, 2521.07, -122.28, -5.97, 2.9, -2.73, -56.37, -0.82, 0.13, -0.75, -1534.09, 1645.01, 6.29, 6.8, 36.78, 34.3, 0.92, -1.25, 0.46, -0.41, -0.02, -0.01, 1898.27, 47.7, -0.72, 2.5, 1.07, -42.45, -0.94, 0.02, -0.56, -1292.02, -1387.0, 0.0, 0.0, -31.01, 28.89, 0.68, 0.0, 0.38, 0.35, -0.01, -0.01, -1234.96, 1323.81, 5.21, 5.9, 29.6, 27.61, 0.74, -1.22, 0.37, -0.33, -0.02, -0.01, 1137.48, -1233.89, -0.04, -0.3, -27.59, -25.43, -0.61, 1.0, -0.34, 0.31, 0.01, 0.01, -813.13, -1075.6, 0.4, 0.3, -24.05, 18.18, -0.4, -0.01, 0.24, 0.27, -0.01, 0.01, 1163.22, -60.9, -2.94, 1.3, -1.36, -26.01, -0.58, 0.07, -0.35, 1029.7, -55.55, -2.63, 1.1, -1.25, -23.02, -0.52, 0.06, -0.31, -556.26, 852.85, 3.16, -4.48, 19.06, 12.44, -0.81, -0.27, 0.17, -0.21, 0.0, 0.02, -603.52, -800.34, 0.44, 0.1, -17.9, 13.49, -0.08, -0.01, 0.18, 0.2, -0.01, 0.01, -628.24, 684.99, -0.64, -0.5, 15.32, 14.05, 3.18, -4.19, 0.19, -0.17, -0.09, -0.07, -866.48, -16.26, 0.52, -1.3, -0.36, 19.37, 0.43, -0.01, 0.26, -512.37, 695.54, -1.47, -1.4, 15.55, 11.46, -0.16, 0.03, 0.15, -0.17, 0.01, 0.01, 506.65, 643.75, 2.54, -2.62, 14.4, -11.33, -0.77, -0.06, -0.15, -0.16, 0.0, 0.01, 664.57, 16.81, -0.4, 1.0, 0.38, -14.86, -3.71, -0.09, -0.2, 405.91, 522.11, 0.99, -1.5, 11.67, -9.08, -0.25, -0.02, -0.12, -0.13, -305.78, 326.6, 1.75, 1.9, 7.3, 6.84, 0.2, -0.04, 300.99, -325.03, -0.44, -0.5, -7.27, -6.73, -1.01, 0.01, 0.0, 0.08, 0.0, 0.02, 438.51, 10.47, -0.56, -0.2, 0.24, -9.81, -0.24, 0.01, -0.13, -264.02, 335.24, 0.99, 1.4, 7.49, 5.9, -0.27, -0.02, 284.09, 307.03, 0.32, -0.4, 6.87, -6.35, -0.99, -0.01, -250.54, 327.11, 0.08, 0.4, 7.31, 5.6, -0.3, 230.72, -304.46, 0.08, -0.1, -6.81, -5.16, 0.27, 229.78, 304.17, -0.6, 0.5, 6.8, -5.14, 0.33, 0.01, 256.3, -276.81, -0.28, -0.4, -6.19, -5.73, -0.14, 0.01, -212.82, 269.45, 0.84, 1.2, 6.02, 4.76, 0.14, -0.02, 196.64, 272.05, -0.84, 0.9, 6.08, -4.4, 0.35, 0.02, 188.95, 272.22, -0.12, 0.3, 6.09, -4.22, 0.34, -292.37, -5.1, -0.32, -0.4, -0.11, 6.54, 0.14, 0.01, 161.79, -220.67, 0.24, 0.1, -4.93, -3.62, -0.08, 261.54, -19.94, -0.95, 0.2, -0.45, -5.85, -0.13, 0.02, 142.16, -190.79, 0.2, 0.1, -4.27, -3.18, -0.07, 187.95, -4.11, -0.24, 0.3, -0.09, -4.2, -0.09, 0.01, 0.0, 0.0, -79.08, 167.9, 0.04, 0.0, 3.75, 1.77, 121.98, 131.04, -0.08, 0.1, 2.93, -2.73, -0.06, -172.95, -8.11, -0.4, -0.2, -0.18, 3.87, 0.09, 0.01, -160.15, -55.3, -14.04, 13.9, -1.23, 3.58, 0.4, 0.31, -115.4, 123.2, 0.6, 0.7, 2.75, 2.58, 0.08, -0.01, -168.26, -2.0, 0.2, -0.2, -0.04, 3.76, 0.08, -114.49, 123.2, 0.32, 0.4, 2.75, 2.56, 0.07, -0.01, 112.14, 120.7, 0.28, -0.3, 2.7, -2.51, -0.07, -0.01, 161.34, 4.03, 0.2, 0.2, 0.09, -3.61, -0.08, 91.31, 126.64, -0.4, 0.4, 2.83, -2.04, -0.04, 0.01, 105.29, 112.9, 0.44, -0.5, 2.52, -2.35, -0.07, -0.01, 98.69, -106.2, -0.28, -0.3, -2.37, -2.21, -0.06, 0.01, 86.74, -112.94, -0.08, -0.2, -2.53, -1.94, -0.05, -134.81, 3.51, 0.2, -0.2, 0.08, 3.01, 0.07, 79.03, 107.31, -0.24, 0.2, 2.4, -1.77, -0.04, 0.01, 132.81, -10.77, -0.52, 0.1, -0.24, -2.97, -0.07, 0.01, -130.31, -0.9, 0.04, 0.0, 0.0, 2.91, -78.56, 85.32, 0.0, 0.0, 1.91, 1.76, 0.04, 0.0, 0.0, -41.53, 89.1, 0.02, 0.0, 1.99, 0.93, 66.03, -71.0, -0.2, -0.2, -1.59, -1.48, -0.04, 60.5, 64.7, 0.36, -0.4, 1.45, -1.35, -0.04, -0.01, -52.27, -70.01, 0.0, 0.0, -1.57, 1.17, 0.03, -52.95, 66.29, 0.32, 0.4, 1.48, 1.18, 0.04, -0.01, 51.02, 67.25, 0.0, 0.0, 1.5, -1.14, -0.03, -55.66, -60.92, 0.16, -0.2, -1.36, 1.24, 0.03, -54.81, -59.2, -0.08, 0.2, -1.32, 1.23, 0.03, 51.32, -55.6, 0.0, 0.0, -1.24, -1.15, -0.03, 48.29, 51.8, 0.2, -0.2, 1.16, -1.08, -0.03, -45.59, -49.0, -0.12, 0.1, -1.1, 1.02, 0.03, 40.54, -52.69, -0.04, -0.1, -1.18, -0.91, -0.02, -40.58, -49.51, -1.0, 1.0, -1.11, 0.91, 0.04, 0.02, -43.76, 46.5, 0.36, 0.4, 1.04, 0.98, 0.03, -0.01, 62.65, -5.0, -0.24, 0.0, -0.11, -1.4, -0.03, 0.01, -38.57, 49.59, 0.08, 0.1, 1.11, 0.86, 0.02, -33.22, -44.04, 0.08, -0.1, -0.98, 0.74, 0.02, 37.15, -39.9, -0.12, -0.1, -0.89, -0.83, -0.02, 36.68, -39.5, -0.04, -0.1, -0.88, -0.82, -0.02, -53.22, -3.91, -0.2, 0.0, -0.09, 1.19, 0.03, 32.43, -42.19, -0.04, -0.1, -0.94, -0.73, -0.02, -51.0, -2.3, -0.12, -0.1, 0.0, 1.14, -29.53, -39.11, 0.04, 0.0, -0.87, 0.66, 0.02, 28.5, -38.92, -0.08, -0.1, -0.87, -0.64, -0.02, 26.54, 36.95, -0.12, 0.1, 0.83, -0.59, -0.01, 26.54, 34.59, 0.04, -0.1, 0.77, -0.59, -0.02, 28.35, -32.55, -0.16, 0.2, -0.73, -0.63, -0.01, -28.0, 30.4, 0.0, 0.0, 0.68, 0.63, 0.01, -27.61, 29.4, 0.2, 0.2, 0.66, 0.62, 0.02, 40.33, 0.4, -0.04, 0.1, 0.0, -0.9, -23.28, 31.61, -0.08, -0.1, 0.71, 0.52, 0.01, 37.75, 0.8, 0.04, 0.1, 0.0, -0.84, 23.66, 25.8, 0.0, 0.0, 0.58, -0.53, -0.01, 21.01, -27.91, 0.0, 0.0, -0.62, -0.47, -0.01, -34.81, 2.89, 0.04, 0.0, 0.0, 0.78, -23.49, -25.31, 0.0, 0.0, -0.57, 0.53, 0.01, -23.47, 25.2, 0.16, 0.2, 0.56, 0.52, 0.02, 19.58, 27.5, -0.12, 0.1, 0.62, -0.44, -0.01, -22.67, -24.4, -0.08, 0.1, -0.55, 0.51, 0.01, -19.97, 25.0, 0.12, 0.2, 0.56, 0.45, 0.01, 21.28, -22.8, -0.08, -0.1, -0.51, -0.48, -0.01, -30.47, 0.91, 0.04, 0.0, 0.0, 0.68, 18.58, 24.0, 0.04, -0.1, 0.54, -0.42, -0.01, -18.02, 24.4, -0.04, -0.1, 0.55, 0.4, 0.01, 17.74, 22.5, 0.08, -0.1, 0.5, -0.4, -0.01, -19.41, 20.7, 0.08, 0.1, 0.46, 0.43, 0.01, -18.64, 20.11, 0.0, 0.0, 0.45, 0.42, 0.01, -16.75, 21.6, 0.04, 0.1, 0.48, 0.37, 0.01, -18.42, -20.0, 0.0, 0.0, -0.45, 0.41, 0.01, -26.77, 1.41, 0.08, 0.0, 0.0, 0.6, -26.17, -0.19, 0.0, 0.0, 0.0, 0.59, -15.52, 20.51, 0.0, 0.0, 0.46, 0.35, 0.01, -25.42, -1.91, -0.08, 0.0, -0.04, 0.57, 0.45, -17.42, 18.1, 0.0, 0.0, 0.4, 0.39, 0.01, 16.39, -17.6, -0.08, -0.1, -0.39, -0.37, -0.01, -14.37, 18.91, 0.0, 0.0, 0.42, 0.32, 0.01, 23.39, -2.4, -0.12, 0.0, 0.0, -0.52, 14.32, -18.5, -0.04, -0.1, -0.41, -0.32, -0.01, 15.69, 17.08, 0.0, 0.0, 0.38, -0.35, -0.01, -22.99, 0.5, 0.04, 0.0, 0.0, 0.51, 0.0, 0.0, 14.47, -17.6, -0.01, 0.0, -0.39, -0.32, -13.33, 18.4, -0.04, -0.1, 0.41, 0.3, 22.47, -0.6, -0.04, 0.0, 0.0, -0.5, -12.78, -17.41, 0.04, 0.0, -0.39, 0.29, 0.01, -14.1, -15.31, 0.04, 0.0, -0.34, 0.32, 0.01, 11.98, 16.21, -0.04, 0.0, 0.36, -0.27, -0.01, 19.65, -1.9, -0.08, 0.0, 0.0, -0.44, 19.61, -1.5, -0.08, 0.0, 0.0, -0.44, 13.41, -14.3, -0.04, -0.1, -0.32, -0.3, -0.01, -13.29, 14.4, 0.0, 0.0, 0.32, 0.3, 0.01, 11.14, -14.4, -0.04, 0.0, -0.32, -0.25, -0.01, 12.24, -13.38, 0.04, 0.0, -0.3, -0.27, -0.01, 10.07, -13.81, 0.04, 0.0, -0.31, -0.23, -0.01, 10.46, 13.1, 0.08, -0.1, 0.29, -0.23, -0.01, 16.55, -1.71, -0.08, 0.0, 0.0, -0.37, 9.75, -12.8, 0.0, 0.0, -0.29, -0.22, -0.01, 9.11, 12.8, 0.0, 0.0, 0.29, -0.2, 0.0, 0.0, -6.44, -13.8, 0.0, 0.0, -0.31, 0.14, -9.19, -12.0, 0.0, 0.0, -0.27, 0.21, -10.3, 10.9, 0.08, 0.1, 0.24, 0.23, 0.01, 14.92, -0.8, -0.04, 0.0, 0.0, -0.33, 10.02, -10.8, 0.0, 0.0, -0.24, -0.22, -0.01, -9.75, 10.4, 0.04, 0.0, 0.23, 0.22, 0.01, 9.67, -10.4, -0.04, 0.0, -0.23, -0.22, -0.01, -8.28, -11.2, 0.04, 0.0, -0.25, 0.19, 13.32, -1.41, -0.08, 0.0, 0.0, -0.3, 8.27, 10.5, 0.04, 0.0, 0.23, -0.19, 0.0, 0.0, 13.13, 0.0, 0.0, 0.0, 0.0, -0.29, -12.93, 0.7, 0.04, 0.0, 0.0, 0.29, 7.91, -10.2, 0.0, 0.0, -0.23, -0.18, -7.84, -10.0, -0.04, 0.0, -0.22, 0.18, 7.44, 9.6, 0.0, 0.0, 0.21, -0.17, -7.64, 9.4, 0.08, 0.1, 0.21, 0.17, 0.01, -11.38, 0.6, 0.04, 0.0, 0.0, 0.25, -7.48, 8.3, 0.0, 0.0, 0.19, 0.17, -10.98, -0.2, 0.0, 0.0, 0.0, 0.25, 10.98, 0.2, 0.0, 0.0, 0.0, -0.25, 7.4, -7.9, -0.04, 0.0, -0.18, -0.17, -6.09, 8.4, -0.04, 0.0, 0.19, 0.14, -6.94, -7.49, 0.0, 0.0, -0.17, 0.16, 6.92, 7.5, 0.04, 0.0, 0.17, -0.15, 6.2, 8.09, 0.0, 0.0, 0.18, -0.14, -6.12, 7.8, 0.04, 0.0, 0.17, 0.14, 5.85, -7.5, 0.0, 0.0, -0.17, -0.13, -6.48, 6.9, 0.08, 0.1, 0.15, 0.14, 0.01, 6.32, 6.9, 0.0, 0.0, 0.15, -0.14, 5.61, -7.2, 0.0, 0.0, -0.16, -0.13, 9.07, 0.0, 0.0, 0.0, 0.0, -0.2, 5.25, 6.9, 0.0, 0.0, 0.15, -0.12, -8.47, -0.4, 0.0, 0.0, 0.0, 0.19, 6.32, -5.39, -1.11, 1.1, -0.12, -0.14, 0.02, 0.02, 5.73, -6.1, -0.04, 0.0, -0.14, -0.13, 4.7, 6.6, -0.04, 0.0, 0.15, -0.11, -4.9, -6.4, 0.0, 0.0, -0.14, 0.11, -5.33, 5.6, 0.04, 0.1, 0.13, 0.12, 0.01, -4.81, 6.0, 0.04, 0.0, 0.13, 0.11, 5.13, 5.5, 0.04, 0.0, 0.12, -0.11, 4.5, 5.9, 0.0, 0.0, 0.13, -0.1, -4.22, 6.1, 0.0, 0.0, 0.14, -4.53, 5.7, 0.0, 0.0, 0.13, 0.1, 4.18, 5.7, 0.0, 0.0, 0.13, -4.75, -5.19, 0.0, 0.0, -0.12, 0.11, -4.06, 5.6, 0.0, 0.0, 0.13, -3.98, 5.6, -0.04, 0.0, 0.13, 4.02, -5.4, 0.0, 0.0, -0.12, 4.49, -4.9, -0.04, 0.0, -0.11, -0.1, -3.62, -5.4, -0.16, 0.2, -0.12, 0.0, 0.01, 4.38, 4.8, 0.0, 0.0, 0.11, -6.4, -0.1, 0.0, 0.0, 0.0, 0.14, -3.98, 5.0, 0.04, 0.0, 0.11, -3.82, -5.0, 0.0, 0.0, -0.11, -3.71, 5.07, 0.0, 0.0, 0.11, 4.14, 4.4, 0.0, 0.0, 0.1, -6.01, -0.5, -0.04, 0.0, 0.0, 0.13, -4.04, 4.39, 0.0, 0.0, 0.1, 3.45, -4.72, 0.0, 0.0, -0.11, 3.31, 4.71, 0.0, 0.0, 0.11, 3.26, -4.5, 0.0, 0.0, -0.1, -3.26, -4.5, 0.0, 0.0, -0.1, -3.34, -4.4, 0.0, 0.0, -0.1, -3.74, -4.0, 3.7, 4.0, 3.34, -4.3, 3.3, -4.3, -3.66, 3.9, 0.04, 3.66, 3.9, 0.04, -3.62, -3.9, -3.61, 3.9, -0.2, 5.3, 0.0, 0.0, 0.12, 3.06, 4.3, 3.3, 4.0, 0.4, 0.2, 3.1, 4.1, -3.06, 3.9, -3.3, -3.6, -3.3, 3.36, 0.01, 3.14, 3.4, -4.57, -0.2, 0.0, 0.0, 0.0, 0.1, -2.7, -3.6, 2.94, -3.2, -2.9, 3.2, 2.47, -3.4, 2.55, -3.3, 2.8, -3.08, 2.51, 3.3, -4.1, 0.3, -0.12, -0.1, 4.1, 0.2, -2.74, 3.0, 2.46, 3.23, -3.66, 1.2, -0.2, 0.2, 3.74, -0.4, -2.51, -2.8, -3.74, 2.27, -2.9, 0.0, 0.0, -2.5, 2.7, -2.51, 2.6, -3.5, 0.2, 3.38, -2.22, -2.5, 3.26, -0.4, 1.95, -2.6, 3.22, -0.4, -0.04, -1.79, -2.6, 1.91, 2.5, 0.74, 3.05, -0.04, 0.08, 2.11, -2.3, -2.11, 2.2, -1.87, -2.4, 2.03, -2.2, -2.03, 2.2, 2.98, 0.0, 0.0, 2.98, -1.71, 2.4, 2.94, -0.1, -0.12, 0.1, 1.67, 2.4, -1.79, 2.3, -1.79, 2.2, -1.67, 2.2, 1.79, -2.0, 1.87, -1.9, 1.63, -2.1, -1.59, 2.1, 1.55, -2.1, -1.55, 2.1, -2.59, -0.2, -1.75, -1.9, -1.75, 1.9, -1.83, -1.8, 1.51, 2.0, -1.51, -2.0, 1.71, 1.8, 1.31, 2.1, -1.43, 2.0, 1.43, 2.0, -2.43, -1.51, 1.9, -1.47, 1.9, 2.39, 0.2, -2.39, 1.39, 1.9, 1.39, -1.8, 1.47, -1.6, 1.47, -1.6, 1.43, -1.5, -1.31, 1.6, 1.27, -1.6, -1.27, 1.6, 1.27, -1.6, 2.03, 1.35, 1.5, -1.39, -1.4, 1.95, -0.2, -1.27, 1.49, 1.19, 1.5, 1.27, 1.4, 1.15, 1.5, 1.87, -0.1, -1.12, -1.5, 1.87, -1.11, -1.5, -1.11, -1.5, 0.0, 0.0, 1.19, 1.4, 1.27, -1.3, -1.27, -1.3, -1.15, 1.4, -1.23, 1.3, -1.23, -1.3, 1.22, -1.29, 1.07, -1.4, 1.75, -0.2, -1.03, -1.4, -1.07, 1.2, -1.03, 1.15, 1.07, 1.1, 1.51, -1.03, 1.1, 1.03, -1.1, 0.0, 0.0, -1.03, -1.1, 0.91, -1.2, -0.88, -1.2, -0.88, 1.2, -0.95, 1.1, -0.95, -1.1, 1.43, -1.39, 0.95, -1.0, -0.95, 1.0, -0.8, 1.1, 0.91, -1.0, -1.35, 0.88, 1.0, -0.83, 1.0, -0.91, 0.9, 0.91, 0.9, 0.88, -0.9, -0.76, -1.0, -0.76, 1.0, 0.76, 1.0, -0.72, 1.0, 0.84, -0.9, 0.84, 0.9, 1.23, 0.0, 0.0, -0.52, -1.1, -0.68, 1.0, 1.19, -0.2, 1.19, 0.76, 0.9, 1.15, -0.1, 1.15, -0.1, 0.72, -0.9, -1.15, -1.15, 0.68, 0.9, -0.68, 0.9, -1.11, 0.0, 0.0, 0.2, 0.79, 0.8, -1.11, -0.1, 0.0, 0.0, -0.48, -1.0, -0.76, -0.8, -0.72, -0.8, -1.07, -0.1, 0.64, 0.8, -0.64, -0.8, 0.64, 0.8, 0.4, 0.6, 0.52, -0.5, -0.6, -0.8, -0.71, 0.7, -0.99, 0.99, 0.56, 0.8, -0.56, 0.8, 0.68, -0.7, 0.68, 0.7, -0.95, -0.64, 0.7, 0.64, 0.7, -0.6, 0.7, -0.6, -0.7, -0.91, -0.1, -0.51, 0.76, -0.91, -0.56, 0.7, 0.88, 0.88, -0.63, -0.6, 0.55, -0.6, -0.8, 0.8, -0.8, -0.52, 0.6, 0.52, 0.6, 0.52, -0.6, -0.48, 0.6, 0.48, 0.6, 0.48, 0.6, -0.76, 0.44, -0.6, 0.52, -0.5, -0.52, 0.5, 0.4, 0.6, -0.4, -0.6, 0.4, -0.6, 0.72, -0.72, -0.51, -0.5, -0.48, 0.5, 0.48, -0.5, -0.48, 0.5, -0.48, 0.5, 0.48, -0.5, -0.48, -0.5, -0.68, -0.68, 0.44, 0.5, -0.64, -0.1, -0.64, -0.1, -0.4, 0.5, 0.4, 0.5, 0.4, 0.5, 0.0, 0.0, -0.4, -0.5, -0.36, -0.5, 0.36, -0.5, 0.6, -0.6, 0.4, -0.4, 0.4, 0.4, -0.4, 0.4, -0.4, 0.4, -0.56, -0.56, 0.36, -0.4, -0.36, 0.4, 0.36, -0.4, -0.36, -0.4, 0.36, 0.4, 0.36, 0.4, -0.52, 0.52, 0.52, 0.32, 0.4, -0.32, 0.4, -0.32, 0.4, -0.32, 0.4, 0.32, -0.4, -0.32, -0.4, 0.32, -0.4, 0.28, -0.4, -0.28, 0.4, 0.28, -0.4, 0.28, 0.4, 0.48, -0.48, 0.48, 0.36, -0.3, -0.36, -0.3, 0.0, 0.0, 0.2, 0.4, -0.44, 0.44, -0.44, -0.44, -0.44, -0.44, 0.32, -0.3, 0.32, 0.3, 0.24, 0.3, -0.12, -0.1, -0.28, 0.3, 0.28, 0.3, 0.28, 0.3, 0.28, -0.3, 0.28, -0.3, 0.28, -0.3, 0.28, 0.3, -0.28, 0.3, 0.4, 0.4, -0.24, 0.3, 0.24, -0.3, 0.24, -0.3, -0.24, -0.3, 0.24, 0.3, 0.24, -0.3, -0.24, 0.3, 0.24, -0.3, -0.24, -0.3, 0.24, -0.3, 0.24, 0.3, -0.24, 0.3, -0.24, 0.3, 0.2, -0.3, 0.2, -0.3, 0.2, -0.3, 0.2, 0.3, 0.2, -0.3, 0.2, -0.3, 0.2, 0.3, 0.2, 0.3, -0.2, -0.3, 0.2, -0.3, 0.2, -0.3, -0.36, -0.36, -0.36, -0.04, 0.3, 0.12, -0.1, -0.32, -0.24, 0.2, 0.24, 0.2, 0.2, -0.2, -0.2, -0.2, -0.2, -0.2, 0.2, 0.2, 0.2, -0.2, 0.2, 0.2, 0.2, 0.2, -0.2, -0.2, 0.0, 0.0, -0.2, -0.2, -0.2, 0.2, -0.2, 0.2, 0.2, -0.2, -0.2, -0.2, 0.2, 0.2, 0.2, 0.2, 0.2, -0.2, 0.2, -0.2, 0.28, 0.28, 0.28, 0.28, 0.28, 0.28, -0.28, 0.28, 0.12, 0.0, 0.24, 0.16, -0.2, 0.16, -0.2, 0.16, -0.2, 0.16, 0.2, -0.16, 0.2, 0.16, 0.2, -0.16, 0.2, -0.16, 0.2, -0.16, 0.2, 0.16, -0.2, 0.16, 0.2, 0.16, -0.2, -0.16, 0.2, -0.16, -0.2, -0.16, 0.2, 0.16, 0.2, 0.16, -0.2, 0.16, -0.2, 0.16, 0.2, 0.16, 0.2, 0.16, 0.2, -0.16, -0.2, 0.16, 0.2, -0.16, 0.2, 0.16, 0.2, -0.16, -0.2, 0.16, -0.2, 0.16, -0.2, -0.16, -0.2, 0.24, -0.24, -0.24, 0.24, 0.24, 0.12, 0.2, 0.12, 0.2, -0.12, -0.2, 0.12, -0.2, 0.12, -0.2, -0.12, 0.2, -0.12, 0.2, -0.12, -0.2, 0.12, 0.2, 0.12, 0.2, 0.12, -0.2, -0.12, 0.2, 0.12, -0.2, -0.12, 0.2, 0.12, 0.2, 0.0, 0.0, -0.12, 0.2, -0.12, 0.2, 0.12, -0.2, -0.12, 0.2, 0.12, 0.2, 0.0, -0.21, -0.2, 0.0, 0.0, 0.2, -0.2, -0.2, -0.2, 0.2, -0.16, -0.1, 0.0, 0.17, 0.16, 0.16, 0.16, 0.16, -0.16, 0.16, 0.16, -0.16, 0.16, -0.16, 0.16, 0.12, 0.1, 0.12, -0.1, -0.12, 0.1, -0.12, 0.1, 0.12, -0.1, -0.12, 0.12, -0.12, 0.12, -0.12, 0.12, -0.12, -0.12, -0.12, -0.12, -0.12, -0.12, -0.12, 0.12, 0.12, 0.12, 0.12, -0.12, -0.12, 0.12, 0.12, 0.12, -0.12, 0.12, -0.12, -0.12, -0.12, 0.12, -0.12, -0.12, 0.12, 0.0, 0.11, 0.11, -122.67, 164.7, 203.78, 273.5, 3.58, 2.74, 6.18, -4.56, 0.0, -0.04, 0.0, -0.07, 57.44, -77.1, 95.82, 128.6, -1.77, -1.28, 2.85, -2.14, 82.14, 89.5, 0.0, 0.0, 2.0, -1.84, -0.04, 47.73, -64.1, 23.79, 31.9, -1.45, -1.07, 0.69, -0.53, -46.38, 50.5, 0.0, 0.0, 1.13, 1.04, 0.02, -18.38, 0.0, 63.8, 0.0, 0.0, 0.41, 0.0, -1.43, 59.07, 0.0, 0.0, 0.0, 0.0, -1.32, 57.28, 0.0, 0.0, 0.0, 0.0, -1.28, -48.65, 0.0, -1.15, 0.0, 0.0, 1.09, 0.0, 0.03, -18.3, 24.6, -17.3, -23.2, 0.56, 0.41, -0.51, 0.39, -16.91, 26.9, 8.43, 13.3, 0.6, 0.38, 0.31, -0.19, 1.23, -1.7, -19.13, -25.7, -0.03, -0.03, -0.58, 0.43, -0.72, 0.9, -17.34, -23.3, 0.03, 0.02, -0.52, 0.39, -19.49, -21.3, 0.0, 0.0, -0.48, 0.44, 0.01, 20.57, -20.1, 0.64, 0.7, -0.45, -0.46, 0.0, -0.01, 4.89, 5.9, -16.55, 19.9, 0.14, -0.11, 0.44, 0.37, 18.22, 19.8, 0.0, 0.0, 0.44, -0.41, -0.01, 4.89, -5.3, -16.51, -18.0, -0.11, -0.11, -0.41, 0.37, -17.86, 0.0, 17.1, 0.0, 0.0, 0.4, 0.0, -0.38, 0.32, 0.0, 24.42, 0.0, 0.0, -0.01, 0.0, -0.55, -23.79, 0.0, 0.0, 0.0, 0.0, 0.53, 14.72, -16.0, -0.32, 0.0, -0.36, -0.33, -0.01, 0.01, 3.34, -4.5, 11.86, 15.9, -0.11, -0.07, 0.35, -0.27, -3.26, 4.4, 11.62, 15.6, 0.09, 0.07, 0.35, -0.26, -19.53, 0.0, 5.09, 0.0, 0.0, 0.44, 0.0, -0.11, -13.48, 14.7, 0.0, 0.0, 0.33, 0.3, 0.01, 10.86, -14.6, 3.18, 4.3, -0.33, -0.24, 0.09, -0.07, -11.3, -15.1, 0.0, 0.0, -0.34, 0.25, 0.01, 2.03, -2.7, 10.82, 14.5, -0.07, -0.05, 0.32, -0.24, 17.46, 0.0, 0.0, 0.0, 0.0, -0.39, 16.43, 0.0, 0.52, 0.0, 0.0, -0.37, 0.0, -0.01, 9.35, 0.0, 13.29, 0.0, 0.0, -0.21, 0.0, -0.3, -10.42, 11.4, 0.0, 0.0, 0.25, 0.23, 0.01, 0.44, 0.5, -10.38, 11.3, 0.02, -0.01, 0.25, 0.23, -14.64, 0.0, 0.0, 0.0, 0.0, 0.33, 0.56, 0.8, -8.67, 11.7, 0.02, -0.01, 0.26, 0.19, 13.88, 0.0, -2.47, 0.0, 0.0, -0.31, 0.0, 0.06, -1.99, 2.7, 7.72, 10.3, 0.06, 0.04, 0.23, -0.17, -0.2, 0.0, 13.05, 0.0, 0.0, 0.0, 0.0, -0.29, 6.92, -9.3, 3.34, 4.5, -0.21, -0.15, 0.1, -0.07, -6.6, 0.0, 10.7, 0.0, 0.0, 0.15, 0.0, -0.24, -8.04, -8.7, 0.0, 0.0, -0.19, 0.18, -10.58, 0.0, -3.1, 0.0, 0.0, 0.24, 0.0, 0.07, -7.32, 8.0, -0.12, -0.1, 0.18, 0.16, 1.63, 1.7, 6.96, -7.6, 0.03, -0.04, -0.17, -0.16, -3.62, 0.0, 9.86, 0.0, 0.0, 0.08, 0.0, -0.22, 0.2, -0.2, -6.88, -7.5, 0.0, 0.0, -0.17, 0.15, -8.99, 0.0, 4.02, 0.0, 0.0, 0.2, 0.0, -0.09, -1.07, 1.4, -5.69, -7.7, 0.03, 0.02, -0.17, 0.13, 6.48, -7.2, -0.48, -0.5, -0.16, -0.14, -0.01, 0.01, 5.57, -7.5, 1.07, 1.4, -0.17, -0.12, 0.03, -0.02, 8.71, 0.0, 3.54, 0.0, 0.0, -0.19, 0.0, -0.08, 0.4, 0.0, 9.27, 0.0, 0.0, -0.01, 0.0, -0.21, -6.13, 6.7, -1.19, -1.3, 0.15, 0.14, -0.03, 0.03, 5.21, -5.7, -2.51, -2.6, -0.13, -0.12, -0.06, 0.06, 5.69, -6.2, -0.12, -0.1, -0.14, -0.13, -0.01, 2.03, -2.7, 4.53, 6.1, -0.06, -0.05, 0.14, -0.1, 5.01, 5.5, -2.51, 2.7, 0.12, -0.11, 0.06, 0.06, -1.91, 2.6, -4.38, -5.9, 0.06, 0.04, -0.13, 0.1, 4.65, -6.3, 0.0, 0.0, -0.14, -0.1, -5.29, 5.7, 0.0, 0.0, 0.13, 0.12, -2.23, -4.0, -4.65, 4.2, -0.09, 0.05, 0.1, 0.1, -4.53, 6.1, 0.0, 0.0, 0.14, 0.1, 2.47, 2.7, -4.46, 4.9, 0.06, -0.06, 0.11, 0.1, -5.05, 5.5, 0.84, 0.9, 0.12, 0.11, 0.02, -0.02, 4.97, -5.4, -1.71, 0.0, -0.12, -0.11, 0.0, 0.04, -0.99, -1.3, 4.22, -5.7, -0.03, 0.02, -0.13, -0.09, 0.99, 1.4, 4.22, -5.6, 0.03, -0.02, -0.13, -0.09, -4.69, -5.2, 0.0, 0.0, -0.12, 0.1, -3.42, 0.0, 6.09, 0.0, 0.0, 0.08, 0.0, -0.14, -4.65, -5.1, 0.0, 0.0, -0.11, 0.1, 0.0, 0.0, -4.53, -5.0, 0.0, 0.0, -0.11, 0.1, -2.43, -2.7, -3.82, 4.2, -0.06, 0.05, 0.1, 0.09, 0.0, 0.0, -4.53, 4.9, 0.0, 0.0, 0.11, 0.1, -4.49, -4.9, 0.0, 0.0, -0.11, 0.1, 2.67, -2.9, -3.62, -3.9, -0.06, -0.06, -0.09, 0.08, 3.94, -5.3, 0.0, 0.0, -0.12, -3.38, 3.7, -2.78, -3.1, 0.08, 0.08, -0.07, 0.06, 3.18, -3.5, -2.82, -3.1, -0.08, -0.07, -0.07, 0.06, -5.77, 0.0, 1.87, 0.0, 0.0, 0.13, 0.0, -0.04, 3.54, -4.8, -0.64, -0.9, -0.11, 0.0, -0.02, -3.5, -4.7, 0.68, -0.9, -0.11, 0.0, -0.02, 5.49, 0.0, 0.0, 0.0, 0.0, -0.12, 1.83, -2.5, 2.63, 3.5, -0.06, 0.0, 0.08, 3.02, -4.1, 0.68, 0.9, -0.09, 0.0, 0.02, 0.0, 0.0, 5.21, 0.0, 0.0, 0.0, 0.0, -0.12, -3.54, 3.8, 2.7, 3.6, -1.35, 1.8, 0.08, 0.0, 0.04, -2.9, 3.9, 0.68, 0.9, 0.09, 0.0, 0.02, 0.8, -1.1, -2.78, -3.7, -0.02, 0.0, -0.08, 4.1, 0.0, -2.39, 0.0, 0.0, -0.09, 0.0, 0.05, -1.59, 2.1, 2.27, 3.0, 0.05, 0.0, 0.07, -2.63, 3.5, -0.48, -0.6, -2.94, -3.2, -2.94, 3.2, 2.27, -3.0, -1.11, -1.5, -0.07, 0.0, -0.03, -0.56, -0.8, -2.35, 3.1, 0.0, -0.6, -3.42, 1.9, -0.12, -0.1, 2.63, -2.9, 2.51, 2.8, -0.64, 0.7, -0.48, -0.6, 2.19, -2.9, 0.24, -0.3, 2.15, 2.9, 2.15, -2.9, 0.52, 0.7, 2.07, -2.8, -3.1, 0.0, 1.79, 0.0, 0.0, 0.07, 0.0, -0.04, 0.88, 0.0, -3.46, 2.11, 2.8, -0.36, 0.5, 3.54, -0.2, -3.5, -1.39, 1.5, -1.91, -2.1, -1.47, 2.0, 1.39, 1.9, 2.07, -2.3, 0.91, 1.0, 1.99, -2.7, 3.3, 0.0, 0.6, -0.44, -0.7, -1.95, 2.6, 2.15, -2.4, -0.6, -0.7, 3.3, 0.84, 0.0, -3.1, -3.1, 0.0, -0.72, -0.32, 0.4, -1.87, -2.5, 1.87, -2.5, 0.32, 0.4, -0.24, 0.3, -1.87, -2.5, -0.24, -0.3, 1.87, -2.5, -2.7, 0.0, 1.55, 2.03, 2.2, -2.98, -1.99, -2.2, 0.12, -0.1, -0.4, 0.5, 1.59, 2.1, 0.0, 0.0, -1.79, 2.0, -1.03, 1.4, -1.15, -1.6, 0.32, 0.5, 1.39, -1.9, 2.35, -1.27, 1.7, 0.6, 0.8, -0.32, -0.4, 1.35, -1.8, 0.44, 0.0, 2.23, -0.84, 0.9, -1.27, -1.4, -1.47, 1.6, -0.28, -0.3, -0.28, 0.4, -1.27, -1.7, 0.28, -0.4, -1.43, -1.5, 0.0, 0.0, -1.27, -1.7, 2.11, -0.32, -0.4, -1.23, 1.6, 1.19, -1.3, -0.72, -0.8, 0.72, -0.8, -1.15, -1.3, -1.35, -1.5, -1.19, -1.6, -0.12, 0.2, 1.79, 0.0, -0.88, -0.28, 0.4, 1.11, 1.5, -1.83, 0.0, 0.56, -0.12, 0.1, -1.27, -1.4, 0.0, 0.0, 1.15, 1.5, -0.12, 0.2, 1.11, 1.5, 0.36, -0.5, -1.07, -1.4, -1.11, 1.5, 1.67, 0.0, 0.8, -1.11, 0.0, 1.43, 1.23, -1.3, -0.24, -1.19, -1.3, -0.24, 0.2, -0.44, -0.9, -0.95, 1.1, 1.07, -1.4, 1.15, -1.3, 1.03, -1.1, -0.56, -0.6, -0.68, 0.9, -0.76, -1.0, -0.24, -0.3, 0.95, -1.3, 0.56, 0.7, 0.84, -1.1, -0.56, 0.0, -1.55, 0.91, -1.3, 0.28, 0.3, 0.16, -0.2, 0.95, 1.3, 0.4, -0.5, -0.88, -1.2, 0.95, -1.1, -0.48, -0.5, 0.0, 0.0, -1.07, 1.2, 0.44, -0.5, 0.95, 1.1, 0.0, 0.0, 0.92, -1.3, 0.95, 1.0, -0.52, 0.6, 1.59, 0.24, -0.4, 0.91, 1.2, 0.84, -1.1, -0.44, -0.6, 0.84, 1.1, -0.44, 0.6, -0.44, 0.6, -0.84, -1.1, -0.8, 0.0, 1.35, 0.76, 0.2, -0.91, -1.0, 0.2, -0.3, -0.91, -1.2, -0.95, 1.0, -0.48, -0.5, 0.88, 1.0, 0.48, -0.5, -0.95, -1.1, 0.2, -0.2, -0.99, 1.1, -0.84, 1.1, -0.24, -0.3, 0.2, -0.3, 0.84, 1.1, -1.39, 0.0, -0.28, -0.16, 0.2, 0.84, 1.1, 0.0, 0.0, 1.39, 0.0, 0.0, -0.95, 1.0, 1.35, -0.99, 0.0, 0.88, -0.52, 0.0, -1.19, 0.2, 0.2, 0.76, -1.0, 0.0, 0.0, 0.76, 1.0, 0.0, 0.0, 0.76, 1.0, -0.76, 1.0, 0.0, 0.0, 1.23, 0.76, 0.8, -0.32, 0.4, -0.72, 0.8, -0.4, -0.4, 0.0, 0.0, -0.8, -0.9, -0.68, 0.9, -0.16, -0.2, -0.16, -0.2, 0.68, -0.9, -0.36, 0.5, -0.56, -0.8, 0.72, -0.9, 0.44, -0.6, -0.48, -0.7, -0.16, 0.0, -1.11, 0.32, 0.0, -1.07, 0.6, -0.8, -0.28, -0.4, -0.64, 0.0, 0.91, 1.11, 0.64, -0.9, 0.76, -0.8, 0.0, 0.0, -0.76, -0.8, 1.03, 0.0, -0.36, -0.64, -0.7, 0.36, -0.4, 1.07, 0.36, -0.5, -0.52, -0.7, 0.6, 0.0, 0.88, 0.95, 0.0, 0.48, 0.16, -0.2, 0.6, 0.8, 0.16, -0.2, -0.6, -0.8, 0.0, -1.0, 0.12, 0.2, 0.16, -0.2, 0.68, 0.7, 0.59, -0.8, -0.99, -0.56, -0.6, 0.36, -0.4, -0.68, -0.7, -0.68, -0.7, -0.36, -0.5, -0.44, 0.6, 0.64, 0.7, -0.12, 0.1, -0.52, 0.6, 0.36, 0.4, 0.0, 0.0, 0.95, -0.84, 0.0, 0.44, 0.56, 0.6, 0.32, -0.3, 0.0, 0.0, 0.6, 0.7, 0.0, 0.0, 0.6, 0.7, -0.12, -0.2, 0.52, -0.7, 0.0, 0.0, 0.56, 0.7, -0.12, 0.1, -0.52, -0.7, 0.0, 0.0, 0.88, -0.76, 0.0, -0.44, 0.0, 0.0, -0.52, -0.7, 0.52, -0.7, 0.36, -0.4, -0.44, -0.5, 0.0, 0.0, 0.6, 0.6, 0.84, 0.0, 0.12, -0.24, 0.0, 0.8, -0.56, 0.6, -0.32, -0.3, 0.48, -0.5, 0.28, -0.3, -0.48, -0.5, 0.12, 0.2, 0.48, -0.6, 0.48, 0.6, -0.12, 0.2, 0.24, 0.0, 0.76, -0.52, -0.6, -0.52, 0.6, 0.48, -0.5, -0.24, -0.3, 0.12, -0.1, 0.48, 0.6, 0.52, -0.2, 0.36, 0.4, -0.44, 0.5, -0.24, -0.3, -0.48, -0.6, -0.44, -0.6, -0.12, 0.1, 0.76, 0.76, 0.2, -0.2, 0.48, 0.5, 0.4, -0.5, -0.24, -0.3, 0.44, -0.6, 0.44, -0.6, 0.36, 0.0, -0.64, 0.72, 0.0, -0.12, 0.0, -0.1, -0.4, -0.6, -0.2, -0.2, -0.44, 0.5, -0.44, 0.5, 0.2, 0.2, -0.44, -0.5, 0.2, -0.2, -0.2, 0.2, -0.44, -0.5, 0.64, 0.0, 0.32, -0.36, 0.5, -0.2, -0.3, 0.12, -0.1, 0.48, 0.5, -0.12, 0.3, -0.36, -0.5, 0.0, 0.0, 0.48, 0.5, -0.48, 0.5, 0.68, 0.0, -0.12, 0.56, -0.4, 0.44, -0.5, -0.12, -0.1, 0.24, 0.3, -0.4, 0.4, 0.64, 0.0, -0.24, 0.64, 0.0, -0.2, 0.0, 0.0, 0.44, -0.5, 0.44, 0.5, -0.12, 0.2, -0.36, -0.5, 0.12, 0.0, 0.64, -0.4, 0.5, 0.0, 0.1, 0.0, 0.0, -0.4, 0.5, 0.0, 0.0, -0.4, -0.5, 0.56, 0.0, 0.28, 0.0, 0.1, 0.36, 0.5, 0.0, -0.1, 0.36, -0.5, 0.36, 0.5, 0.0, -0.1, 0.24, -0.2, -0.36, -0.4, 0.16, 0.2, 0.4, -0.4, 0.0, 0.0, -0.36, -0.5, -0.36, -0.5, -0.32, -0.5, -0.12, 0.1, 0.2, 0.2, -0.36, 0.4, -0.6, 0.6, 0.28, 0.0, 0.52, 0.12, -0.1, 0.4, 0.4, 0.0, -0.5, 0.2, -0.2, -0.32, 0.4, 0.16, 0.2, -0.16, 0.2, 0.32, 0.4, 0.56, 0.0, -0.12, 0.32, -0.4, -0.16, -0.2, 0.0, 0.0, 0.4, 0.4, -0.4, -0.4, -0.4, 0.4, -0.36, 0.4, 0.12, 0.1, 0.0, 0.1, 0.36, 0.4, 0.0, -0.1, 0.36, 0.4, -0.36, 0.4, 0.0, 0.1, 0.32, 0.0, 0.44, 0.12, 0.2, 0.28, -0.4, 0.0, 0.0, 0.36, 0.4, 0.32, -0.4, -0.16, 0.12, 0.1, 0.32, -0.4, 0.2, 0.3, -0.24, 0.3, 0.0, 0.1, 0.32, 0.4, 0.0, -0.1, -0.32, -0.4, -0.32, 0.4, 0.0, 0.1, -0.52, -0.52, 0.52, 0.32, -0.4, 0.0, 0.0, 0.32, 0.4, 0.32, -0.4, 0.0, 0.0, -0.32, -0.4, -0.32, 0.4, 0.32, 0.4, 0.0, 0.0, 0.32, 0.4, 0.0, 0.0, -0.32, -0.4, 0.0, 0.0, 0.32, 0.4, 0.16, 0.2, 0.32, -0.3, -0.16, 0.0, -0.48, -0.2, 0.2, -0.28, -0.3, 0.28, -0.4, 0.0, 0.0, 0.28, -0.4, 0.0, 0.0, 0.28, -0.4, 0.0, 0.0, -0.28, -0.4, 0.28, 0.4, -0.28, -0.4, -0.48, -0.2, 0.2, 0.24, 0.3, 0.44, 0.0, 0.16, 0.24, 0.3, 0.16, -0.2, 0.24, 0.3, -0.12, 0.2, 0.2, 0.3, -0.16, 0.2, 0.0, 0.0, 0.44, -0.32, 0.3, 0.24, 0.0, -0.36, 0.36, 0.0, 0.24, 0.12, -0.2, 0.2, 0.3, -0.12, 0.0, -0.28, 0.3, -0.24, 0.3, 0.12, 0.1, -0.28, -0.3, -0.28, 0.3, 0.0, 0.0, -0.28, -0.3, 0.0, 0.0, -0.28, -0.3, 0.0, 0.0, 0.28, 0.3, 0.0, 0.0, -0.28, -0.3, -0.28, 0.3, 0.0, 0.0, -0.28, -0.3, 0.0, 0.0, 0.28, 0.3, 0.0, 0.0, -0.28, 0.3, 0.28, -0.3, -0.28, 0.3, 0.4, 0.4, -0.24, 0.3, 0.0, -0.1, 0.16, 0.0, 0.36, -0.2, 0.3, -0.12, -0.1, -0.24, -0.3, 0.0, 0.0, -0.24, 0.3, -0.24, 0.3, 0.0, 0.0, -0.24, 0.3, -0.24, 0.3, 0.24, -0.3, 0.0, 0.0, 0.24, -0.3, 0.0, 0.0, 0.24, 0.3, 0.24, -0.3, 0.24, 0.3, -0.24, 0.3, -0.24, 0.3, -0.2, 0.2, -0.16, -0.2, 0.0, 0.0, -0.32, 0.2, 0.0, 0.1, 0.2, -0.3, 0.2, -0.2, 0.12, 0.2, -0.16, 0.2, 0.16, 0.2, 0.2, 0.3, 0.2, 0.3, 0.0, 0.0, -0.2, 0.3, 0.0, 0.0, 0.2, 0.3, -0.2, -0.3, -0.2, -0.3, 0.2, -0.3, 0.0, 0.0, 0.2, 0.3, 0.0, 0.0, 0.2, 0.3, 0.0, 0.0, 0.2, 0.3, 0.0, 0.0, 0.2, 0.3, 0.0, 0.0, 0.2, -0.3, 0.0, 0.0, -0.2, -0.3, 0.0, 0.0, -0.2, 0.3, 0.0, 0.0, -0.2, 0.3, 0.0, 0.0, 0.36, 0.0, 0.0, 0.36, 0.12, 0.1, -0.24, 0.2, 0.12, -0.2, -0.16, -0.2, -0.13, 0.1, 0.22, 0.21, 0.2, 0.0, -0.28, 0.32, 0.0, -0.12, -0.2, -0.2, 0.12, -0.1, 0.12, 0.1, -0.2, 0.2, 0.0, 0.0, -0.32, 0.32, 0.0, 0.0, 0.32, 0.32, 0.0, 0.0, -0.24, -0.2, 0.24, 0.2, 0.2, 0.0, -0.24, 0.0, 0.0, -0.24, -0.2, 0.0, 0.0, 0.24, 0.2, -0.24, -0.2, 0.0, 0.0, -0.24, 0.2, 0.16, -0.2, 0.12, 0.1, 0.2, 0.2, 0.0, -0.1, -0.12, 0.1, -0.16, -0.2, -0.12, -0.1, -0.16, 0.2, 0.2, 0.2, 0.0, 0.0, -0.2, 0.2, -0.2, 0.2, -0.2, 0.2, -0.2, 0.2, 0.2, -0.2, -0.2, -0.2, 0.0, 0.0, -0.2, 0.2, 0.2, 0.0, -0.2, 0.0, 0.0, -0.2, 0.2, -0.2, 0.2, -0.2, -0.2, -0.2, -0.2, 0.0, 0.0, 0.2, 0.2, 0.2, 0.2, 0.12, -0.2, -0.12, -0.1, 0.28, -0.28, 0.16, -0.2, 0.0, -0.1, 0.0, 0.1, -0.16, 0.2, 0.0, -0.1, -0.16, -0.2, 0.0, -0.1, 0.16, -0.2, 0.16, -0.2, 0.0, 0.0, 0.16, 0.2, -0.16, 0.2, 0.0, 0.0, 0.16, 0.2, 0.16, -0.2, 0.16, -0.2, -0.16, 0.2, 0.16, -0.2, 0.0, 0.0, 0.16, 0.2, 0.0, 0.0, 0.16, 0.2, 0.0, 0.0, -0.16, -0.2, 0.16, -0.2, -0.16, -0.2, 0.0, 0.0, -0.16, -0.2, 0.0, 0.0, -0.16, 0.2, 0.0, 0.0, 0.16, -0.2, 0.16, 0.2, 0.16, 0.2, 0.0, 0.0, -0.16, -0.2, 0.0, 0.0, -0.16, -0.2, 0.0, 0.0, 0.16, 0.2, 0.16, 0.2, 0.0, 0.0, 0.16, 0.2, 0.16, -0.2, 0.16, 0.2, 0.0, 0.0, -0.16, 0.2, 0.0, 0.1, 0.12, -0.2, 0.12, -0.2, 0.0, -0.1, 0.0, -0.1, 0.12, 0.2, 0.0, -0.1, -0.12, 0.2, -0.15, 0.2, -0.24, 0.24, 0.0, 0.0, 0.24, 0.24, 0.12, -0.2, -0.12, -0.2, 0.0, 0.0, 0.12, 0.2, 0.12, -0.2, 0.12, 0.2, 0.12, 0.2, 0.12, 0.2, 0.12, -0.2, -0.12, 0.2, 0.0, 0.0, 0.12, 0.2, 0.12, 0.0, -0.2, 0.0, 0.0, -0.12, -0.2, 0.12, -0.2, 0.0, 0.0, 0.12, 0.2, -0.12, 0.2, -0.12, 0.2, 0.12, -0.2, 0.0, 0.0, 0.12, 0.2, 0.2, 0.0, 0.12, 0.0, 0.0, -0.12, 0.2, 0.0, 0.0, -0.12, -0.2, 0.0, 0.0, -0.12, -0.2, -0.12, -0.2, 0.0, 0.0, 0.12, -0.2, 0.12, -0.2, 0.12, 0.2, -0.12, -0.2, 0.0, 0.0, 0.12, -0.2, 0.12, -0.2, 0.12, 0.2, 0.12, 0.0, 0.2, -0.12, -0.2, 0.0, 0.0, 0.12, 0.2, -0.16, 0.0, 0.16, -0.2, 0.2, 0.0, 0.0, -0.2, 0.0, 0.0, -0.2, 0.2, 0.0, 0.0, 0.2, 0.2, -0.2, 0.0, 0.0, -0.2, 0.12, 0.0, -0.16, 0.2, 0.0, 0.0, 0.2, 0.12, -0.1, 0.0, 0.1, 0.16, -0.16, -0.16, -0.16, -0.16, -0.16, 0.0, 0.0, -0.16, 0.0, 0.0, -0.16, -0.16, -0.16, 0.0, 0.0, -0.16, 0.0, 0.0, 0.16, 0.0, 0.0, 0.16, 0.0, 0.0, 0.16, 0.16, 0.0, 0.0, -0.16, 0.0, 0.0, -0.16, -0.16, 0.0, 0.0, 0.16, 0.0, 0.0, -0.16, -0.16, 0.0, 0.0, -0.16, -0.16, 0.12, 0.1, 0.12, -0.1, 0.12, 0.1, 0.0, 0.0, 0.12, 0.1, -0.12, 0.1, 0.0, 0.0, 0.12, 0.1, 0.12, -0.1, 0.0, 0.0, -0.12, -0.1, 0.0, 0.0, 0.12, 0.1, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, -0.12, 0.0, 0.0, 0.12, 0.12, 0.12, 0.12, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, 0.12, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, 0.12, -0.12, -0.12, 0.12, 0.12, -0.12, -0.12, 0.0, 0.0, 0.12, -0.12, 0.12, 0.12, -0.12, -0.12, 0.0, 0.0, -0.12, -0.12, 0.0, 0.0, -0.12, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, 0.12, -0.12, 0.0, 0.0, -0.12, 0.12, -0.12, -0.12, 0.12, 0.0, 0.0, 0.12, 0.12, 0.12, -0.12, 0.0, 0.0, -0.12, -0.12, -0.12, 0.0, 0.0, -0.12, -0.12, 0.0, 0.0, 0.12, 0.12, 0.0, 0.0, -0.12, -0.12, -0.12, -0.12, 0.12, 0.0, 0.0, 0.12, -0.12, 0.0, 0.0, -0.12, -0.12, 0.0, 0.0, 0.12, -0.12, -0.12, -0.12, -0.12, 0.12, 0.12, -0.12, -0.12, 0.0, 0.0, -0.12, 0.0, 0.0, -0.12, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, -0.12, -0.12, 0.0, 0.0, -0.12, -0.12, 0.12, 0.0, 0.0, 0.12, 0.12, 0.0, 0.0, 0.12, 0.0, 0.0, 0.12, 0.12, 0.08, 0.0, 0.04};
        int NA = a.length;
        int[] jaxy = new int[]{0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
        int[] jasc = new int[]{0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 0};
        int[] japt = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4};
        double[] pt = new double[6];
        double[] fa = new double[14];
        double[] xypr = new double[2];
        double[] xypl = new double[2];
        double[] xyls = new double[2];
        double[] sc = new double[2];
        double t = (date1 - 2451545.0 + date2) / 36525.0;
        double w = 1.0;
        for (jpt = 0; jpt <= 5; ++jpt) {
            pt[jpt] = w;
            w *= t;
        }
        for (jxy = 0; jxy < 2; ++jxy) {
            xypr[jxy] = 0.0;
            xyls[jxy] = 0.0;
            xypl[jxy] = 0.0;
        }
        fa[0] = JSOFA.jauFal03(t);
        fa[1] = JSOFA.jauFalp03(t);
        fa[2] = JSOFA.jauFaf03(t);
        fa[3] = JSOFA.jauFad03(t);
        fa[4] = JSOFA.jauFaom03(t);
        fa[5] = JSOFA.jauFame03(t);
        fa[6] = JSOFA.jauFave03(t);
        fa[7] = JSOFA.jauFae03(t);
        fa[8] = JSOFA.jauFama03(t);
        fa[9] = JSOFA.jauFaju03(t);
        fa[10] = JSOFA.jauFasa03(t);
        fa[11] = JSOFA.jauFaur03(t);
        fa[12] = JSOFA.jauFane03(t);
        fa[13] = JSOFA.jauFapa03(t);
        for (jxy = 0; jxy < 2; ++jxy) {
            for (j = 5; j >= 0; --j) {
                int n = jxy;
                xypr[n] = xypr[n] + xyp[jxy][j] * pt[j];
            }
        }
        int ialast = NA;
        for (ifreq = NFPL - 1; ifreq >= 0; --ifreq) {
            arg = 0.0;
            for (i = 0; i < 14; ++i) {
                m = mfapl[ifreq][i];
                if (m == 0) continue;
                arg += (double)m * fa[i];
            }
            sc[0] = StrictMath.sin(arg);
            sc[1] = StrictMath.cos(arg);
            ia = nc[ifreq + NFLS];
            for (i = ialast; i >= ia; --i) {
                j = i - ia;
                jxy = jaxy[j];
                jsc = jasc[j];
                jpt = japt[j];
                int n = jxy;
                xypl[n] = xypl[n] + a[i - 1] * sc[jsc] * pt[jpt];
            }
            ialast = ia - 1;
        }
        for (ifreq = NFLS - 1; ifreq >= 0; --ifreq) {
            arg = 0.0;
            for (i = 0; i < 5; ++i) {
                m = mfals[ifreq][i];
                if (m == 0) continue;
                arg += (double)m * fa[i];
            }
            sc[0] = StrictMath.sin(arg);
            sc[1] = StrictMath.cos(arg);
            ia = nc[ifreq];
            for (i = ialast; i >= ia; --i) {
                j = i - ia;
                jxy = jaxy[j];
                jsc = jasc[j];
                jpt = japt[j];
                int n = jxy;
                xyls[n] = xyls[n] + a[i - 1] * sc[jsc] * pt[jpt];
            }
            ialast = ia - 1;
        }
        double x = 4.84813681109536E-6 * (xypr[0] + (xyls[0] + xypl[0]) / 1000000.0);
        double y = 4.84813681109536E-6 * (xypr[1] + (xyls[1] + xypl[1]) / 1000000.0);
        return new CelestialIntermediatePole(x, y);
    }

    public static ICRFrame jauXys00a(double date1, double date2) {
        double[][] rbpn = JSOFA.jauPnm00a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS00(date1, date2, cip.x, cip.y);
        return new ICRFrame(cip, s);
    }

    public static ICRFrame jauXys00b(double date1, double date2) {
        double[][] rbpn = new double[3][3];
        rbpn = JSOFA.jauPnm00b(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS00(date1, date2, cip.x, cip.y);
        return new ICRFrame(cip, s);
    }

    public static ICRFrame jauXys06a(double date1, double date2) {
        double[][] rbpn = new double[3][3];
        rbpn = JSOFA.jauPnm06a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(rbpn);
        double s = JSOFA.jauS06(date1, date2, cip.x, cip.y);
        return new ICRFrame(cip, s);
    }

    public static void jauZp(double[] p) {
        p[0] = 0.0;
        p[1] = 0.0;
        p[2] = 0.0;
    }

    public static void jauZpv(double[][] pv) {
        JSOFA.jauZp(pv[0]);
        JSOFA.jauZp(pv[1]);
    }

    public static void jauZr(double[][] r) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                r[i][j] = 0.0;
            }
        }
    }

    private static double fmod(double d, double d2) {
        return d % d2;
    }

    public static double[] jauAb(double[] pnat, double[] v, double s, double bm1) {
        int i;
        double[] p = new double[3];
        double[] ppr = new double[3];
        double pdv = JSOFA.jauPdp(pnat, v);
        double w1 = 1.0 + pdv / (1.0 + bm1);
        double w2 = 1.97412574336E-8 / s;
        double r2 = 0.0;
        for (i = 0; i < 3; ++i) {
            double w;
            p[i] = w = pnat[i] * bm1 + w1 * v[i] + w2 * (v[i] - pdv * pnat[i]);
            r2 += w * w;
        }
        double r = StrictMath.sqrt(r2);
        for (i = 0; i < 3; ++i) {
            ppr[i] = p[i] / r;
        }
        return ppr;
    }

    public static void jauApcg(double date1, double date2, double[][] ebpv, double[] ehp, Astrom astrom) {
        double[][] pv = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};
        JSOFA.jauApcs(date1, date2, pv, ebpv, ehp, astrom);
    }

    public static void jauApcg13(double date1, double date2, Astrom astrom) {
        double[][] ehpv = new double[2][3];
        double[][] ebpv = new double[2][3];
        JSOFA.jauEpv00(date1, date2, ehpv, ebpv);
        JSOFA.jauApcg(date1, date2, ebpv, ehpv[0], astrom);
    }

    public static void jauApci(double date1, double date2, double[][] ebpv, double[] ehp, double x, double y, double s, Astrom astrom) {
        JSOFA.jauApcg(date1, date2, ebpv, ehp, astrom);
        astrom.bpn = JSOFA.jauC2ixys(x, y, s);
    }

    public static double jauApci13(double date1, double date2, Astrom astrom) {
        double[][] ehpv = new double[2][3];
        double[][] ebpv = new double[2][3];
        JSOFA.jauEpv00(date1, date2, ehpv, ebpv);
        double[][] r = JSOFA.jauPnm06a(date1, date2);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(r);
        double s = JSOFA.jauS06(date1, date2, cip.x, cip.y);
        JSOFA.jauApci(date1, date2, ebpv, ehpv[0], cip.x, cip.y, s, astrom);
        return JSOFA.jauEors(r, s);
    }

    public static void jauApco(double date1, double date2, double[][] ebpv, double[] ehp, double x, double y, double s, double theta, double elong, double phi, double hm, double xp, double yp, double sp, double refa, double refb, Astrom astrom) throws JSOFAIllegalParameter, JSOFAInternalError {
        astrom.along = elong + sp;
        double sl = StrictMath.sin(astrom.along);
        double cl = StrictMath.cos(astrom.along);
        astrom.xpl = xp * cl - yp * sl;
        astrom.ypl = xp * sl + yp * cl;
        astrom.sphi = StrictMath.sin(phi);
        astrom.cphi = StrictMath.cos(phi);
        astrom.refa = refa;
        astrom.refb = refb;
        JSOFA.jauAper(theta, astrom);
        astrom.diurab = 0.0;
        double[][] r = JSOFA.jauC2ixys(x, y, s);
        double[][] pvc = JSOFA.jauPvtob(elong, phi, hm, xp, yp, sp, theta);
        double[][] pv = JSOFA.jauTrxpv(r, pvc);
        JSOFA.jauApcs(date1, date2, pv, ebpv, ehp, astrom);
        JSOFA.jauCr(r, astrom.bpn);
    }

    public static double jauApco13(double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl, Astrom astrom) throws JSOFAIllegalParameter, JSOFAInternalError {
        double[][] ehpv = new double[2][3];
        double[][] ebpv = new double[2][3];
        JulianDate tai = JSOFA.jauUtctai(utc1, utc2);
        JulianDate tt = JSOFA.jauTaitt(tai.djm0, tai.djm1);
        JulianDate ut1 = JSOFA.jauUtcut1(utc1, utc2, dut1);
        JSOFA.jauEpv00(tt.djm0, tt.djm1, ehpv, ebpv);
        double[][] r = JSOFA.jauPnm06a(tt.djm0, tt.djm1);
        CelestialIntermediatePole cip = JSOFA.jauBpn2xy(r);
        double s = JSOFA.jauS06(tt.djm0, tt.djm1, cip.x, cip.y);
        double theta = JSOFA.jauEra00(ut1.djm0, ut1.djm1);
        double sp = JSOFA.jauSp00(tt.djm0, tt.djm1);
        RefCos ref = JSOFA.jauRefco(phpa, tc, rh, wl);
        JSOFA.jauApco(tt.djm0, tt.djm1, ebpv, ehpv[0], cip.x, cip.y, s, theta, elong, phi, hm, xp, yp, sp, ref.a, ref.b, astrom);
        double eo = JSOFA.jauEors(r, s);
        return eo;
    }

    public static void jauApcs(double date1, double date2, double[][] pv, double[][] ebpv, double[] ehp, Astrom astrom) {
        int i;
        double AUDMS = 1731456.8287037036;
        double CR = 0.005775518310185185;
        double[] pb = new double[3];
        double[] vb = new double[3];
        double[] ph = new double[3];
        astrom.pmt = (date1 - 2451545.0 + date2) / 365.25;
        for (i = 0; i < 3; ++i) {
            double dp = pv[0][i] / 1.4959787E11;
            double dv = pv[1][i] / 1731456.8287037036;
            pb[i] = ebpv[0][i] + dp;
            vb[i] = ebpv[1][i] + dv;
            ph[i] = ehp[i] + dp;
        }
        JSOFA.jauCp(pb, astrom.eb);
        NormalizedVector nv = JSOFA.jauPn(ph);
        astrom.em = nv.r;
        astrom.eh = nv.u;
        double v2 = 0.0;
        for (i = 0; i < 3; ++i) {
            double w;
            astrom.v[i] = w = vb[i] * 0.005775518310185185;
            v2 += w * w;
        }
        astrom.bm1 = StrictMath.sqrt(1.0 - v2);
        JSOFA.jauIr(astrom.bpn);
    }

    public static void jauApcs13(double date1, double date2, double[][] pv, Astrom astrom) {
        double[][] ehpv = new double[2][3];
        double[][] ebpv = new double[2][3];
        JSOFA.jauEpv00(date1, date2, ehpv, ebpv);
        JSOFA.jauApcs(date1, date2, pv, ebpv, ehpv[0], astrom);
    }

    public static void jauAper(double theta, Astrom astrom) {
        astrom.eral = theta + astrom.along;
    }

    public static void jauAper13(double ut11, double ut12, Astrom astrom) {
        JSOFA.jauAper(JSOFA.jauEra00(ut11, ut12), astrom);
    }

    public static void jauApio(double sp, double theta, double elong, double phi, double hm, double xp, double yp, double refa, double refb, Astrom astrom) throws JSOFAIllegalParameter, JSOFAInternalError {
        astrom.along = elong + sp;
        double sl = StrictMath.sin(astrom.along);
        double cl = StrictMath.cos(astrom.along);
        astrom.xpl = xp * cl - yp * sl;
        astrom.ypl = xp * sl + yp * cl;
        astrom.sphi = StrictMath.sin(phi);
        astrom.cphi = StrictMath.cos(phi);
        double[][] pv = JSOFA.jauPvtob(elong, phi, hm, xp, yp, sp, theta);
        astrom.diurab = StrictMath.sqrt(pv[1][0] * pv[1][0] + pv[1][1] * pv[1][1]) / 2.99792458E8;
        astrom.refa = refa;
        astrom.refb = refb;
        JSOFA.jauAper(theta, astrom);
    }

    public static void jauApio13(double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl, Astrom astrom) throws JSOFAIllegalParameter, JSOFAInternalError {
        JulianDate tai = JSOFA.jauUtctai(utc1, utc2);
        JulianDate tt = JSOFA.jauTaitt(tai.djm0, tai.djm1);
        JulianDate ut1 = JSOFA.jauUtcut1(utc1, utc2, dut1);
        double sp = JSOFA.jauSp00(tt.djm0, tt.djm1);
        double theta = JSOFA.jauEra00(ut1.djm0, ut1.djm1);
        RefCos refco = JSOFA.jauRefco(phpa, tc, rh, wl);
        JSOFA.jauApio(sp, theta, elong, phi, hm, xp, yp, refco.a, refco.b, astrom);
    }

    public static SphericalCoordinateEO jauAtci13(double rc, double dc, double pr, double pd, double px, double rv, double date1, double date2) {
        Astrom astrom = new Astrom();
        double eo = JSOFA.jauApci13(date1, date2, astrom);
        SphericalCoordinate co = JSOFA.jauAtciq(rc, dc, pr, pd, px, rv, astrom);
        return new SphericalCoordinateEO(co, eo);
    }

    public static SphericalCoordinate jauAtciq(double rc, double dc, double pr, double pd, double px, double rv, Astrom astrom) {
        double[] pco = JSOFA.jauPmpx(rc, dc, pr, pd, px, rv, astrom.pmt, astrom.eb);
        double[] pnat = JSOFA.jauLdsun(pco, astrom.eh, astrom.em);
        double[] ppr = JSOFA.jauAb(pnat, astrom.v, astrom.em, astrom.bm1);
        double[] pi = JSOFA.jauRxp(astrom.bpn, ppr);
        SphericalCoordinate co = JSOFA.jauC2s(pi);
        co.alpha = JSOFA.jauAnp(co.alpha);
        return co;
    }

    public static SphericalCoordinate jauAtciqn(double rc, double dc, double pr, double pd, double px, double rv, Astrom astrom, int n, Ldbody[] b) {
        double[] ppr = new double[3];
        double[] pi = new double[3];
        double[] pco = JSOFA.jauPmpx(rc, dc, pr, pd, px, rv, astrom.pmt, astrom.eb);
        double[] pnat = JSOFA.jauLdn(n, b, astrom.eb, pco);
        ppr = JSOFA.jauAb(pnat, astrom.v, astrom.em, astrom.bm1);
        pi = JSOFA.jauRxp(astrom.bpn, ppr);
        SphericalCoordinate co = JSOFA.jauC2s(pi);
        co.alpha = JSOFA.jauAnp(co.alpha);
        return co;
    }

    public static SphericalCoordinate jauAtciqz(double rc, double dc, Astrom astrom) {
        double[] ppr = new double[3];
        double[] pco = JSOFA.jauS2c(rc, dc);
        double[] pnat = JSOFA.jauLdsun(pco, astrom.eh, astrom.em);
        ppr = JSOFA.jauAb(pnat, astrom.v, astrom.em, astrom.bm1);
        double[] pi = JSOFA.jauRxp(astrom.bpn, ppr);
        SphericalCoordinate co = JSOFA.jauC2s(pi);
        co.alpha = JSOFA.jauAnp(co.alpha);
        return co;
    }

    public static ObservedPositionEO jauAtco13(double rc, double dc, double pr, double pd, double px, double rv, double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl) throws JSOFAIllegalParameter, JSOFAInternalError {
        Astrom astrom = new Astrom();
        double eo = JSOFA.jauApco13(utc1, utc2, dut1, elong, phi, hm, xp, yp, phpa, tc, rh, wl, astrom);
        SphericalCoordinate co = JSOFA.jauAtciq(rc, dc, pr, pd, px, rv, astrom);
        ObservedPosition obs = JSOFA.jauAtioq(co.alpha, co.delta, astrom);
        return new ObservedPositionEO(obs, eo);
    }

    public static SphericalCoordinateEO jauAtic13(double ri, double di, double date1, double date2) {
        Astrom astrom = new Astrom();
        double eo = JSOFA.jauApci13(date1, date2, astrom);
        SphericalCoordinate co = JSOFA.jauAticq(ri, di, astrom);
        return new SphericalCoordinateEO(co, eo);
    }

    public static SphericalCoordinate jauAticq(double ri, double di, Astrom astrom) {
        double[] after;
        double r;
        double w;
        int i;
        double r2;
        int j;
        double[] pnat = new double[3];
        double[] pco = new double[3];
        double[] d = new double[3];
        double[] before = new double[3];
        double[] pi = JSOFA.jauS2c(ri, di);
        double[] ppr = JSOFA.jauTrxp(astrom.bpn, pi);
        JSOFA.jauZp(d);
        for (j = 0; j < 2; ++j) {
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                before[i] = w = ppr[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n = i++;
                before[n] = before[n] / r;
            }
            after = JSOFA.jauAb(before, astrom.v, astrom.em, astrom.bm1);
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                d[i] = after[i] - before[i];
                pnat[i] = w = ppr[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n = i++;
                pnat[n] = pnat[n] / r;
            }
        }
        JSOFA.jauZp(d);
        for (j = 0; j < 5; ++j) {
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                before[i] = w = pnat[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n = i++;
                before[n] = before[n] / r;
            }
            after = JSOFA.jauLdsun(before, astrom.eh, astrom.em);
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                d[i] = after[i] - before[i];
                pco[i] = w = pnat[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n = i++;
                pco[n] = pco[n] / r;
            }
        }
        SphericalCoordinate co = JSOFA.jauC2s(pco);
        co.alpha = JSOFA.jauAnp(co.alpha);
        return co;
    }

    public static SphericalCoordinate jauAticqn(double ri, double di, Astrom astrom, int n, Ldbody[] b) {
        double[] after;
        double r;
        double w;
        int i;
        double r2;
        int j;
        double[] pnat = new double[3];
        double[] pco = new double[3];
        double[] d = new double[3];
        double[] before = new double[3];
        double[] pi = JSOFA.jauS2c(ri, di);
        double[] ppr = JSOFA.jauTrxp(astrom.bpn, pi);
        JSOFA.jauZp(d);
        for (j = 0; j < 2; ++j) {
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                before[i] = w = ppr[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n2 = i++;
                before[n2] = before[n2] / r;
            }
            after = JSOFA.jauAb(before, astrom.v, astrom.em, astrom.bm1);
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                d[i] = after[i] - before[i];
                pnat[i] = w = ppr[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n3 = i++;
                pnat[n3] = pnat[n3] / r;
            }
        }
        JSOFA.jauZp(d);
        for (j = 0; j < 5; ++j) {
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                before[i] = w = pnat[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n4 = i++;
                before[n4] = before[n4] / r;
            }
            after = JSOFA.jauLdn(n, b, astrom.eb, before);
            r2 = 0.0;
            for (i = 0; i < 3; ++i) {
                d[i] = after[i] - before[i];
                pco[i] = w = pnat[i] - d[i];
                r2 += w * w;
            }
            r = StrictMath.sqrt(r2);
            i = 0;
            while (i < 3) {
                int n5 = i++;
                pco[n5] = pco[n5] / r;
            }
        }
        SphericalCoordinate co = JSOFA.jauC2s(pco);
        co.alpha = JSOFA.jauAnp(co.alpha);
        return co;
    }

    public static ObservedPosition jauAtio13(double ri, double di, double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl) throws JSOFAIllegalParameter, JSOFAInternalError {
        Astrom astrom = new Astrom();
        JSOFA.jauApio13(utc1, utc2, dut1, elong, phi, hm, xp, yp, phpa, tc, rh, wl, astrom);
        return JSOFA.jauAtioq(ri, di, astrom);
    }

    public static ObservedPosition jauAtioq(double ri, double di, Astrom astrom) {
        double CELMIN = 1.0E-6;
        double SELMIN = 0.05;
        double[] v = new double[3];
        v = JSOFA.jauS2c(ri - astrom.eral, di);
        double x = v[0];
        double y = v[1];
        double z = v[2];
        double xhd = x + astrom.xpl * z;
        double yhd = y - astrom.ypl * z;
        double zhd = z - astrom.xpl * x + astrom.ypl * y;
        double f = 1.0 - astrom.diurab * yhd;
        double xhdt = f * xhd;
        double yhdt = f * (yhd + astrom.diurab);
        double zhdt = f * zhd;
        double xaet = astrom.sphi * xhdt - astrom.cphi * zhdt;
        double yaet = yhdt;
        double zaet = astrom.cphi * xhdt + astrom.sphi * zhdt;
        double azobs = xaet != 0.0 || yaet != 0.0 ? StrictMath.atan2(yaet, -xaet) : 0.0;
        double r = StrictMath.sqrt(xaet * xaet + yaet * yaet);
        r = r > 1.0E-6 ? r : 1.0E-6;
        z = zaet > 0.05 ? zaet : 0.05;
        double tz = r / z;
        double w = astrom.refb * tz * tz;
        double del = (astrom.refa + w) * tz / (1.0 + (astrom.refa + 3.0 * w) / (z * z));
        double cosdel = 1.0 - del * del / 2.0;
        f = cosdel - del * z / r;
        double xaeo = xaet * f;
        double yaeo = yaet * f;
        double zaeo = cosdel * zaet + del * r;
        double zdobs = StrictMath.atan2(StrictMath.sqrt(xaeo * xaeo + yaeo * yaeo), zaeo);
        v[0] = astrom.sphi * xaeo + astrom.cphi * zaeo;
        v[1] = yaeo;
        v[2] = -astrom.cphi * xaeo + astrom.sphi * zaeo;
        SphericalCoordinate co = JSOFA.jauC2s(v);
        double hmobs = co.alpha;
        double dcobs = co.delta;
        double raobs = astrom.eral + hmobs;
        return new ObservedPosition(JSOFA.jauAnp(azobs), zdobs, -hmobs, dcobs, JSOFA.jauAnp(raobs));
    }

    public static SphericalCoordinate jauAtoc13(String type, double ob1, double ob2, double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl) throws JSOFAIllegalParameter, JSOFAInternalError {
        Astrom astrom = new Astrom();
        JSOFA.jauApco13(utc1, utc2, dut1, elong, phi, hm, xp, yp, phpa, tc, rh, wl, astrom);
        SphericalCoordinate co = JSOFA.jauAtoiq(type, ob1, ob2, astrom);
        SphericalCoordinate icrs = JSOFA.jauAticq(co.alpha, co.delta, astrom);
        return icrs;
    }

    public static SphericalCoordinate jauAtoi13(String type, double ob1, double ob2, double utc1, double utc2, double dut1, double elong, double phi, double hm, double xp, double yp, double phpa, double tc, double rh, double wl) throws JSOFAIllegalParameter, JSOFAInternalError {
        Astrom astrom = new Astrom();
        JSOFA.jauApio13(utc1, utc2, dut1, elong, phi, hm, xp, yp, phpa, tc, rh, wl, astrom);
        SphericalCoordinate co = JSOFA.jauAtoiq(type, ob1, ob2, astrom);
        return co;
    }

    public static SphericalCoordinate jauAtoiq(String type, double ob1, double ob2, Astrom astrom) {
        double zaeo;
        double yaeo;
        double xaeo;
        double ce;
        double[] v = new double[3];
        int c = type.charAt(0);
        double c1 = ob1;
        double c2 = ob2;
        double sphi = astrom.sphi;
        double cphi = astrom.cphi;
        if ((c = c == 114 || c == 82 ? 82 : (c == 104 || c == 72 ? 72 : 65)) == 65) {
            ce = StrictMath.sin(c2);
            xaeo = -StrictMath.cos(c1) * ce;
            yaeo = StrictMath.sin(c1) * ce;
            zaeo = StrictMath.cos(c2);
        } else {
            if (c == 82) {
                c1 = astrom.eral - c1;
            }
            v = JSOFA.jauS2c(-c1, c2);
            double xmhdo = v[0];
            double ymhdo = v[1];
            double zmhdo = v[2];
            xaeo = sphi * xmhdo - cphi * zmhdo;
            yaeo = ymhdo;
            zaeo = cphi * xmhdo + sphi * zmhdo;
        }
        double az = xaeo != 0.0 || yaeo != 0.0 ? StrictMath.atan2(yaeo, xaeo) : 0.0;
        double sz = StrictMath.sqrt(xaeo * xaeo + yaeo * yaeo);
        double zdo = StrictMath.atan2(sz, zaeo);
        double refa = astrom.refa;
        double refb = astrom.refb;
        double tz = sz / zaeo;
        double dref = (refa + refb * tz * tz) * tz;
        double zdt = zdo + dref;
        ce = StrictMath.sin(zdt);
        double xaet = StrictMath.cos(az) * ce;
        double yaet = StrictMath.sin(az) * ce;
        double zaet = StrictMath.cos(zdt);
        double xmhda = sphi * xaet + cphi * zaet;
        double ymhda = yaet;
        double zmhda = -cphi * xaet + sphi * zaet;
        double f = 1.0 + astrom.diurab * ymhda;
        double xhd = f * xmhda;
        double yhd = f * (ymhda - astrom.diurab);
        double zhd = f * zmhda;
        double xpl = astrom.xpl;
        double ypl = astrom.ypl;
        double w = xpl * xhd - ypl * yhd + zhd;
        v[0] = xhd - xpl * w;
        v[1] = yhd + ypl * w;
        v[2] = w - (xpl * xpl + ypl * ypl) * zhd;
        SphericalCoordinate co = JSOFA.jauC2s(v);
        co.alpha = JSOFA.jauAnp(astrom.eral + co.alpha);
        return co;
    }

    public static double[] jauLd(double bm, double[] p, double[] q, double[] e, double em, double dlim) {
        int i;
        double[] qpe = new double[3];
        double[] p1 = new double[3];
        for (i = 0; i < 3; ++i) {
            qpe[i] = q[i] + e[i];
        }
        double qdqpe = JSOFA.jauPdp(q, qpe);
        double w = bm * 1.97412574336E-8 / em / StrictMath.max(qdqpe, dlim);
        double[] eq = JSOFA.jauPxp(e, q);
        double[] peq = JSOFA.jauPxp(p, eq);
        for (i = 0; i < 3; ++i) {
            p1[i] = p[i] + w * peq[i];
        }
        return p1;
    }

    public static double[] jauLdn(int n, Ldbody[] b, double[] ob, double[] sc) {
        double CR = 0.005775518310185185;
        double[] sn = new double[3];
        JSOFA.jauCp(sc, sn);
        for (int i = 0; i < n; ++i) {
            double[] v = JSOFA.jauPmp(ob, b[i].pv[0]);
            double dt = JSOFA.jauPdp(sn, v) * 0.005775518310185185;
            dt = StrictMath.min(dt, 0.0);
            double[] ev = JSOFA.jauPpsp(v, -dt, b[i].pv[1]);
            NormalizedVector nv = JSOFA.jauPn(ev);
            sn = JSOFA.jauLd(b[i].bm, sn, sn, nv.u, nv.r, b[i].dl);
        }
        return sn;
    }

    public static double[] jauLdsun(double[] p, double[] e, double em) {
        double em2 = em * em;
        if (em2 < 1.0) {
            em2 = 1.0;
        }
        double dlim = 1.0E-6 / (em2 > 1.0 ? em2 : 1.0);
        return JSOFA.jauLd(1.0, p, p, e, em, dlim);
    }

    public static double[] jauPmpx(double rc, double dc, double pr, double pd, double px, double rv, double pmt, double[] pob) {
        double z;
        double y;
        double x;
        double VF = 0.21094952755677604;
        double AULTY = 1.5812507351636374E-5;
        double[] p = new double[3];
        double[] pm = new double[3];
        double sr = StrictMath.sin(rc);
        double cr = StrictMath.cos(rc);
        double sd = StrictMath.sin(dc);
        double cd = StrictMath.cos(dc);
        p[0] = x = cr * cd;
        p[1] = y = sr * cd;
        p[2] = z = sd;
        double dt = pmt + JSOFA.jauPdp(p, pob) * 1.5812507351636374E-5;
        double pxr = px * 4.84813681109536E-6;
        double w = 0.21094952755677604 * rv * pxr;
        double pdz = pd * z;
        pm[0] = -pr * y - pdz * cr + w * x;
        pm[1] = pr * x - pdz * sr + w * y;
        pm[2] = pd * cd + w * z;
        for (int i = 0; i < 3; ++i) {
            int n = i;
            p[n] = p[n] + (dt * pm[i] - pxr * pob[i]);
        }
        NormalizedVector pco = JSOFA.jauPn(p);
        return pco.u;
    }

    public static CatalogCoords jauPmsafe(double ra1, double dec1, double pmr1, double pmd1, double px1, double rv1, double ep1a, double ep1b, double ep2a, double ep2b) throws JSOFAInternalError {
        double PXMIN = 5.0E-7;
        double F = 326.0;
        double pm = JSOFA.jauSeps(ra1, dec1, ra1 + pmr1, dec1 + pmd1);
        double px1a = px1;
        if (px1a < (pm *= 326.0)) {
            px1a = pm;
        }
        if (px1a < 5.0E-7) {
            px1a = 5.0E-7;
        }
        return JSOFA.jauStarpm(ra1, dec1, pmr1, pmd1, px1a, rv1, ep1a, ep1b, ep2a, ep2b);
    }

    public static double[][] jauPvtob(double elong, double phi, double hm, double xp, double yp, double sp, double theta) throws JSOFAIllegalParameter, JSOFAInternalError {
        double[] xyzm = JSOFA.jauGd2gc(1, elong, phi, hm);
        return JSOFA.jauPvtob(xyzm, xp, yp, sp, theta);
    }

    public static double[][] jauPvtob(double[] xyzm, double xp, double yp, double sp, double theta) throws JSOFAIllegalParameter, JSOFAInternalError {
        double OM = 7.29211514670698E-5;
        double[][] pv = new double[2][3];
        double[][] rpm = JSOFA.jauPom00(xp, yp, sp);
        double[] xyz = JSOFA.jauTrxp(rpm, xyzm);
        double x = xyz[0];
        double y = xyz[1];
        double z = xyz[2];
        double s = StrictMath.sin(theta);
        double c = StrictMath.cos(theta);
        pv[0][0] = c * x - s * y;
        pv[0][1] = s * x + c * y;
        pv[0][2] = z;
        pv[1][0] = 7.29211514670698E-5 * (-s * x - c * y);
        pv[1][1] = 7.29211514670698E-5 * (c * x - s * y);
        pv[1][2] = 0.0;
        return pv;
    }

    public static RefCos jauRefco(double phpa, double tc, double rh, double wl) {
        double gamma;
        double pw;
        boolean optic = wl <= 100.0;
        double t = StrictMath.max(tc, -150.0);
        t = StrictMath.min(t, 200.0);
        double p = StrictMath.max(phpa, 0.0);
        p = StrictMath.min(p, 10000.0);
        double r = StrictMath.max(rh, 0.0);
        r = StrictMath.min(r, 1.0);
        double w = StrictMath.max(wl, 0.1);
        w = StrictMath.min(w, 1000000.0);
        if (p > 0.0) {
            double ps = StrictMath.pow(10.0, (0.7859 + 0.03477 * t) / (1.0 + 0.00412 * t)) * (1.0 + p * (4.5E-6 + 6.0E-10 * t * t));
            pw = r * ps / (1.0 - (1.0 - r) * ps / p);
        } else {
            pw = 0.0;
        }
        double tk = t + 273.15;
        if (optic) {
            double wlsq = w * w;
            gamma = ((7.753484E-5 + (4.39108E-7 + 3.666E-9 / wlsq) / wlsq) * p - 1.12684E-5 * pw) / tk;
        } else {
            gamma = (7.7689E-5 * p - (6.3938E-6 - 0.375463 / tk) * pw) / tk;
        }
        double beta = 4.4474E-6 * tk;
        if (!optic) {
            beta -= 0.0074 * pw * beta;
        }
        return new RefCos(gamma * (1.0 - beta), -gamma * (beta - gamma / 2.0));
    }

    public static SphericalCoordinate jauG2icrs(double dl, double db) {
        double[][] r = new double[][]{{-0.05487556041621537, -0.873437090234885, -0.4838350155487132}, {0.49410942787558365, -0.4448296299600112, 0.7469822444972188}, {-0.8676661490190047, -0.19807637343120152, 0.4559837761750669}};
        double[] v1 = JSOFA.jauS2c(dl, db);
        double[] v2 = JSOFA.jauTrxp(r, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static SphericalCoordinate jauIcrs2g(double dr, double dd) {
        double[][] r = new double[][]{{-0.05487556041621537, -0.873437090234885, -0.4838350155487132}, {0.49410942787558365, -0.4448296299600112, 0.7469822444972188}, {-0.8676661490190047, -0.19807637343120152, 0.4559837761750669}};
        double[] v1 = JSOFA.jauS2c(dr, dd);
        double[] v2 = JSOFA.jauRxp(r, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static SphericalCoordinate jauEceq06(double date1, double date2, double dl, double db) {
        double[] v1 = JSOFA.jauS2c(dl, db);
        double[][] rm = JSOFA.jauEcm06(date1, date2);
        double[] v2 = JSOFA.jauTrxp(rm, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static double[][] jauEcm06(double date1, double date2) {
        double[][] e = new double[3][3];
        double ob = JSOFA.jauObl06(date1, date2);
        double[][] bp = JSOFA.jauPmat06(date1, date2);
        JSOFA.jauIr(e);
        JSOFA.jauRx(ob, e);
        return JSOFA.jauRxr(e, bp);
    }

    public static SphericalCoordinate jauEqec06(double date1, double date2, double dr, double dd) {
        double[] v1 = JSOFA.jauS2c(dr, dd);
        double[][] rm = JSOFA.jauEcm06(date1, date2);
        double[] v2 = JSOFA.jauRxp(rm, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static SphericalCoordinate jauLteceq(double epj, double dl, double db) {
        double[] v1 = JSOFA.jauS2c(dl, db);
        double[][] rm = JSOFA.jauLtecm(epj);
        double[] v2 = JSOFA.jauTrxp(rm, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static double[][] jauLtecm(double epj) {
        double[][] rm = new double[3][3];
        double dx = -8.056148938997159E-8;
        double de = -3.3060414542221477E-8;
        double dr = -7.078279744199226E-8;
        double[] p = JSOFA.jauLtpequ(epj);
        double[] z = JSOFA.jauLtpecl(epj);
        double[] w = JSOFA.jauPxp(p, z);
        NormalizedVector nv = JSOFA.jauPn(w);
        double[] x = nv.u;
        double[] y = JSOFA.jauPxp(z, x);
        rm[0][0] = x[0] - x[1] * -7.078279744199226E-8 + x[2] * -8.056148938997159E-8;
        rm[0][1] = x[0] * -7.078279744199226E-8 + x[1] + x[2] * -3.3060414542221477E-8;
        rm[0][2] = -x[0] * -8.056148938997159E-8 - x[1] * -3.3060414542221477E-8 + x[2];
        rm[1][0] = y[0] - y[1] * -7.078279744199226E-8 + y[2] * -8.056148938997159E-8;
        rm[1][1] = y[0] * -7.078279744199226E-8 + y[1] + y[2] * -3.3060414542221477E-8;
        rm[1][2] = -y[0] * -8.056148938997159E-8 - y[1] * -3.3060414542221477E-8 + y[2];
        rm[2][0] = z[0] - z[1] * -7.078279744199226E-8 + z[2] * -8.056148938997159E-8;
        rm[2][1] = z[0] * -7.078279744199226E-8 + z[1] + z[2] * -3.3060414542221477E-8;
        rm[2][2] = -z[0] * -8.056148938997159E-8 - z[1] * -3.3060414542221477E-8 + z[2];
        return rm;
    }

    public static SphericalCoordinate jauLteqec(double epj, double dr, double dd) {
        double[] v1 = JSOFA.jauS2c(dr, dd);
        double[][] rm = JSOFA.jauLtecm(epj);
        double[] v2 = JSOFA.jauRxp(rm, v1);
        SphericalCoordinate co = JSOFA.jauC2s(v2);
        co.alpha = JSOFA.jauAnp(co.alpha);
        co.delta = JSOFA.jauAnpm(co.delta);
        return co;
    }

    public static double[][] jauLtp(double epj) {
        double[][] rp = new double[3][3];
        double[] peqr = JSOFA.jauLtpequ(epj);
        double[] pecl = JSOFA.jauLtpecl(epj);
        double[] v = JSOFA.jauPxp(peqr, pecl);
        NormalizedVector nv = JSOFA.jauPn(v);
        v = JSOFA.jauPxp(peqr, nv.u);
        for (int i = 0; i < 3; ++i) {
            rp[0][i] = nv.u[i];
            rp[1][i] = v[i];
            rp[2][i] = peqr[i];
        }
        return rp;
    }

    public static double[][] jauLtpb(double epj) {
        double[][] rpb = new double[3][3];
        double dx = -8.056148938997159E-8;
        double de = -3.3060414542221477E-8;
        double dr = -7.078279744199226E-8;
        double[][] rp = JSOFA.jauLtp(epj);
        for (int i = 0; i < 3; ++i) {
            rpb[i][0] = rp[i][0] - rp[i][1] * -7.078279744199226E-8 + rp[i][2] * -8.056148938997159E-8;
            rpb[i][1] = rp[i][0] * -7.078279744199226E-8 + rp[i][1] + rp[i][2] * -3.3060414542221477E-8;
            rpb[i][2] = -rp[i][0] * -8.056148938997159E-8 - rp[i][1] * -3.3060414542221477E-8 + rp[i][2];
        }
        return rpb;
    }

    public static double[] jauLtpecl(double epj) {
        double c;
        double s;
        int i;
        double[] vec = new double[3];
        double eps0 = 0.4090926006005829;
        int NPOL = 4;
        double[][] pqpol = new double[][]{{5851.607687, -0.1189, -2.8913E-4, 1.01E-7}, {-1600.8863, 1.1689818, -2.0E-7, -4.37E-7}};
        double[][] pqper = new double[][]{{708.15, -5486.751211, -684.66156, 667.66673, -5523.863691}, {2309.0, -17.127623, 2446.28388, -2354.886252, -549.74745}, {1620.0, -617.517403, 399.671049, -428.152441, -310.998056}, {492.2, 413.44294, -356.652376, 376.202861, 421.535876}, {1183.0, 78.614193, -186.387003, 184.778874, -36.776172}, {622.0, -180.732815, -316.80007, 335.321713, -145.278396}, {882.0, -87.676083, 198.296701, -185.138669, -34.74445}, {547.0, 46.140315, 101.135679, -120.97283, 22.885731}};
        int NPER = pqper.length;
        double t = (epj - 2000.0) / 100.0;
        double p = 0.0;
        double q = 0.0;
        double w = Math.PI * 2 * t;
        for (i = 0; i < NPER; ++i) {
            double a = w / pqper[i][0];
            s = StrictMath.sin(a);
            c = StrictMath.cos(a);
            p += c * pqper[i][1] + s * pqper[i][3];
            q += c * pqper[i][2] + s * pqper[i][4];
        }
        w = 1.0;
        for (i = 0; i < 4; ++i) {
            p += pqpol[0][i] * w;
            q += pqpol[1][i] * w;
            w *= t;
        }
        w = (w = 1.0 - (p *= 4.84813681109536E-6) * p - (q *= 4.84813681109536E-6) * q) < 0.0 ? 0.0 : StrictMath.sqrt(w);
        s = StrictMath.sin(0.4090926006005829);
        c = StrictMath.cos(0.4090926006005829);
        vec[0] = p;
        vec[1] = -q * c - w * s;
        vec[2] = -q * s + w * c;
        return vec;
    }

    public static double[] jauLtpequ(double epj) {
        int i;
        double[] veq = new double[3];
        int NPOL = 4;
        double[][] xypol = new double[][]{{5453.282155, 0.4252841, -3.7173E-4, -1.52E-7}, {-73750.93035, -0.7675452, -1.8725E-4, 2.31E-7}};
        double[][] xyper = new double[][]{{256.75, -819.940624, 75004.344875, 81491.287984, 1558.515853}, {708.15, -8444.676815, 624.033993, 787.163481, 7774.939698}, {274.2, 2600.009459, 1251.136893, 1251.296102, -2219.534038}, {241.45, 2755.17563, -1102.212834, -1257.950837, -2523.969396}, {2309.0, -167.659835, -2660.66498, -2966.79973, 247.850422}, {492.2, 871.855056, 699.291817, 639.744522, -846.485643}, {396.1, 44.769698, 153.16722, 131.600209, -1393.124055}, {288.9, -512.313065, -950.865637, -445.040117, 368.526116}, {231.1, -819.415595, 499.754645, 584.522874, 749.045012}, {1610.0, -538.071099, -145.18821, -89.756563, 444.704518}, {620.0, -189.793622, 558.116553, 524.42963, 235.934465}, {157.87, -402.922932, -23.923029, -13.549067, 374.049623}, {220.3, 179.516345, -165.405086, -210.157124, -171.33018}, {1200.0, -9.814756, 9.344131, -44.919798, -22.899655}};
        int NPER = xyper.length;
        double t = (epj - 2000.0) / 100.0;
        double x = 0.0;
        double y = 0.0;
        double w = Math.PI * 2 * t;
        for (i = 0; i < NPER; ++i) {
            double a = w / xyper[i][0];
            double s = StrictMath.sin(a);
            double c = StrictMath.cos(a);
            x += c * xyper[i][1] + s * xyper[i][3];
            y += c * xyper[i][2] + s * xyper[i][4];
        }
        w = 1.0;
        for (i = 0; i < 4; ++i) {
            x += xypol[0][i] * w;
            y += xypol[1][i] * w;
            w *= t;
        }
        veq[0] = x *= 4.84813681109536E-6;
        veq[1] = y *= 4.84813681109536E-6;
        w = 1.0 - x * x - y * y;
        veq[2] = w < 0.0 ? 0.0 : StrictMath.sqrt(w);
        return veq;
    }

    /*
     * Opcode count of 40403 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        JSOFA.init_mfals();
        mfapl = new int[][]{{0, 0, 1, -1, 1, 0, 0, -1, 0, -2, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 1, 0, -8, 12, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 8, -16, 4, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -1, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 2, -5, 0, 0, 0}, {0, 0, 2, -2, 1, 0, -5, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -1, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, -8, 3, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 6, -8, 3, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 1, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 2}, {0, 0, 1, -1, 1, 0, 0, 0, -2, 0, 0, 0, 0, 0}, {2, 0, 0, -2, -1, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 1}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 0, 0, 0, 0, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, 0, -2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 0, 0, -18, 16, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 0, 0, 0, 2}, {0, 0, 1, -1, 1, 0, -5, 7, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, -10, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, -5, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -1, 0, 0, 0, 2}, {1, 0, 2, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1}, {1, 0, -2, 0, -2, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 2, 0, 0, 0}, {0, 0, 2, -2, 1, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 8, -16, 4, 5, 0, 0, -2}, {0, 0, 1, -1, 1, 0, 0, 3, -8, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -11, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 8, -16, 4, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -3, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -8, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 8, -15, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -2, 0, 0, 0, 2}, {0, 0, 1, -1, 1, 0, 0, -5, 8, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0, -1}, {2, 0, 0, -2, 0, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 8, -13, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, -2, 5, 0, 0, 0}, {1, 0, 0, -1, 0, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 2}, {1, 0, 0, 0, -1, 0, -18, 16, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 2, -5, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 19, -21, 3, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -8, 13, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -9, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 2}, {1, 0, 0, 0, 1, 0, -18, 16, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 6, -16, 4, 5, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 3, -7, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1}, {2, 0, 0, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, -1, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 2}, {0, 0, 0, 0, 1, 0, 0, 1, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2}, {0, 0, 2, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, -1, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, -6, 8, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -10, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0, -2}, {1, 0, 0, -1, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, 0, -3, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 1, 0, 2, -3, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -1, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 5, -4, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 9, -11, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 8, -15, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -4, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, 0, -1, 0, 0, 0, 2}, {1, 0, 0, -1, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, -4, 10, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, -2}, {0, 0, 2, -2, 1, 0, -4, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 0, -1, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -3, 0, 0, 0, 0, 2}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 0, 0, 2, 0}, {0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -9, 13, 0, 0, 0, 0, 0}, {2, 0, 2, 0, 2, 0, 0, 2, 0, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 2, 0, 0, -1, 0, 0, 2, 0, 0, 0}, {1, 0, 0, -1, -1, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1}, {1, 0, 2, 0, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {1, 0, -2, 0, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -2, 4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1}, {0, 0, 2, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -8, 3, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 6, -10, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 7, -8, 3, 0, 0, 0, 2}, {0, 0, 0, 0, 1, 0, -3, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, -5, 7, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -10, 0, 0, 0, 0, 0, -2}, {1, 0, 0, -2, 0, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 2, -5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -8, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 0, -9, 15, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -2, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -4, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, -1, 0, 0, 2}, {2, 0, 0, -2, 1, 0, -6, 8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 3, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 8, -14, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 8, -15, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 1, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 1, 0, 0, 2}, {2, 0, -1, -1, 0, 0, 0, 3, -7, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -3, 4, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -6, 8, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -5, 6, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 1, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -9, 4, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -4, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1}, {0, 0, 0, 0, 0, 0, 7, -11, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 3, -5, 4, 0, 0, 0, 0, 2}, {0, 0, 1, -1, 0, 0, 0, -1, 0, -1, 1, 0, 0, 0}, {2, 0, 0, 0, 0, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 8, -15, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 2, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 0, -1, 0, -1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -8, 3, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 2, -4, 0, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 3, -5, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -3, 0, 0, 0, 2}, {0, 0, 2, -2, 2, 0, -8, 11, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -8, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 5, -9, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 7, -9, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 2, -1, 0, 0, 0, 0, 0, 0}, {1, 0, -2, -2, -2, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -2, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 3, -3, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 2, -5, 0, 0, 2}, {2, 0, 0, -2, -1, 0, 0, -2, 0, 0, 5, 0, 0, 0}, {2, 0, 0, -2, -1, 0, -6, 8, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 2, -5, 0, 0, 2}, {0, 0, 0, 0, 1, 0, 3, -7, 4, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, -2, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 6, -15, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 0, 0, 0, 2}, {1, 0, 0, -1, 0, 0, 0, -3, 4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -3, 7, -4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, 0, -2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, 0, 1}, {0, 0, 2, -2, 2, 0, -5, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 2, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6, -11, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 3, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 9, -12, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0, 1}, {0, 0, 1, -1, 0, 0, -8, 12, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -2, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, -1, 0, 0, 0, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -5, 0, 0, 0, 0, -2}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 3, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -9, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 9, -9, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 3, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 2, -4, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 1}, {0, 0, 1, -1, 2, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -9, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 2}, {0, 0, 2, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, 0, -3, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0}, {2, 0, -1, -1, -1, 0, 0, -1, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, -3, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 5, -10, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 8, -13, 0, 0, 0, 0, 0, 1}, {0, 0, 2, -2, 1, -1, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 0, 2, 0, 0}, {0, 0, 0, 0, 1, 0, 3, -5, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 9, -9, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -8, 11, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -2, 0, 0, 2, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, -1, 2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 2, -6, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 8, -15, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 5, -2, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 7, -13, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 0, 0, 0, 2}, {0, 0, 2, -2, 1, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -8, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 8, -10, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -4, 0, 0, 0, 0}, {2, 0, 0, -2, -1, 0, 0, -5, 6, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 0, 0, -2}, {2, 0, -1, -1, -1, 0, 0, 3, -7, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, -1, 1, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 4, -3, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6, -11, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 1, 0, 0, -6, 8, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 1, 5, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 6, -5, 0, 0, 0, 0, 2}, {1, 0, -2, -2, -2, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, 0, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 0, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 6, -7, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, 0, 0, -2, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 0, -2, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 1, -6, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2}, {0, 0, 0, 0, 0, 0, 3, -5, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 7, -13, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -2, 0, 0, 0, 2}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 0, 2, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -8, 15, 0, 0, 0, 0, 0}, {2, 0, 0, -2, -2, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {2, 0, -1, -1, -1, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {1, 0, 2, -2, 2, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {1, 0, -1, 1, -1, 0, -18, 17, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 2, -2, -1, 0, -5, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 2, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -16, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2}, {0, 0, 0, 0, 2, 0, 0, -1, 2, 0, 0, 0, 0, 0}, {2, 0, -1, -1, -2, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -10, 0, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 1, 0, 0, -1, 0, -2, 4, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 0, 2}, {2, 0, 0, -2, -1, 0, 0, -2, 0, 4, -5, 0, 0, 0}, {2, 0, 0, -2, -1, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {2, 0, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0}, {1, 0, 1, -1, 1, 0, 0, -1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -1, -1, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {1, 0, -1, -1, -1, 0, 20, -20, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 1, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -2, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 5, -8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 9, -11, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 5, -3, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -3, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1}, {0, 0, 0, 0, 0, 0, 6, -7, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, -2}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, -2, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, -1, 0, -2, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -8, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, -6, 0, 0, 0, 0, -2}, {1, 0, 0, -2, 0, 0, 20, -21, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -12, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -4, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, -1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -12, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 9, -17, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 1, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -6, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, -7, 0, 0, 0, 0, -2}, {1, 0, 0, -1, 1, 0, 0, -3, 4, 0, 0, 0, 0, 0}, {1, 0, -2, 0, -2, 0, -10, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -9, 17, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -4, 0, 0, 0, 0, 0, -2}, {1, 0, -2, -2, -2, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {1, 0, -1, 1, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 2, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, -1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, -1, 2, 0, -5, 7, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 2, -2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -10, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 4, 0, -4, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, -5, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -5, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -2, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -2, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -3, 0, 0, 0, 0, 0, 1}, {1, 0, 0, -2, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -7, 4, 0, 0, 0, 0, 0}, {2, 0, 2, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, -1, 0, 0, -1, 0, -1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 1, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6, -10, 0, 0, 0, 0, -2}, {1, 0, 0, -1, 1, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -3, 0, 3, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, -5, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 1, -3, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -4, 6, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 0, 0, -1, 0, 0}, {0, 0, 1, -1, 1, 0, -5, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 3, -4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -10, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 5, -5, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 3, -8, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 2, -5, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 7, -9, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 7, -8, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 3, -8, 3, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, -2, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 2, -4, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, -1}, {2, 0, 0, -2, -1, 0, 0, -6, 8, 0, 0, 0, 0, 0}, {2, 0, -1, -1, 1, 0, 0, 3, -7, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -7, 9, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0, 0, -1}, {0, 0, 1, -1, 2, 0, -8, 12, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 2, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 1, 0, 0, -5, 6, 0, 0, 0, 0, 0}, {2, 0, 0, -2, -1, 0, 0, -2, 0, 3, -1, 0, 0, 0}, {1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 1, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {1, 0, 0, -2, -1, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {1, 0, 0, -1, -1, 0, 0, -3, 4, 0, 0, 0, 0, 0}, {1, 0, -1, 0, -1, 0, -3, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -4, 4, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, -8, 11, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, 0, -9, 13, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, 1, -4, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, 0, -1, 0, 1, -3, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 7, -13, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, 2, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 7, -11, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 6, -6, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 6, -4, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 4, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -4, 0, 0, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 1, -4, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 9, -17, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 7, -7, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 4, -8, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, -7, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -4, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, -1, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 17, -16, 0, -2, 0, 0, 0, 0}, {1, 0, 0, -1, 0, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -4, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, -2}, {0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 0, 0, 2}, {2, 0, 0, -2, 0, 0, 0, -4, 4, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 2, 2, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 0, 0, -4, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 3, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -2, 2, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 0, 1, 0, 0, 0}, {0, 0, 1, -1, 0, 0, -4, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 0, 0, -1, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 8, -9, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -6, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 3, -5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -2, 0, 0, 0}, {2, 0, -2, -2, -2, 0, 0, -2, 0, 2, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, -10, 3, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, -1, 0, -10, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 2, -3, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, 2, -2, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, -2, 3, 0, 0, 0, 0, 0, 0}, {0, 0, 2, 0, 2, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, 0, -1, 0, 2, 0, 0, 0, 0}, {2, 0, 2, -2, 2, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {2, 0, 1, -3, 1, 0, -6, 7, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 2, -5, 0, 0, 0, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 5, -5, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 1, 5, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 0, 5, 0, 0, 0}, {2, 0, 0, -2, 0, 0, 0, -2, 0, 0, 2, 0, 0, 0}, {2, 0, 0, -2, 0, 0, -4, 4, 0, 0, 0, 0, 0, 0}, {2, 0, -2, 0, -2, 0, 0, 5, -9, 0, 0, 0, 0, 0}, {2, 0, -1, -1, 0, 0, 0, -1, 0, 3, 0, 0, 0, 0}, {1, 0, 2, 0, 2, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {1, 0, 2, 0, 2, 0, 0, 4, -8, 3, 0, 0, 0, 0}, {1, 0, 2, 0, 2, 0, 0, -4, 8, -3, 0, 0, 0, 0}, {1, 0, 2, 0, 2, 0, -1, 1, 0, 0, 0, 0, 0, 0}, {1, 0, 2, -2, 2, 0, -3, 3, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, -2, 0, 3, 0, 0, 0, 0}, {1, 0, 0, -2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0}, {1, 0, -2, -2, -2, 0, 0, 1, 0, -1, 0, 0, 0, 0}, {1, 0, -1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 0, -1, -1, 0, 0, 0, 8, -15, 0, 0, 0, 0, 0}, {0, 0, 2, 2, 2, 0, 0, 2, 0, -2, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 1, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -2, 0, 1, 0, 0, 0, 0}, {0, 0, 2, -2, 1, 0, 0, -10, 15, 0, 0, 0, 0, 0}, {0, 0, 2, -2, 0, -1, 0, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 2, 0, 0, -1, 0, 0, -1, 0, 0, 0}, {0, 0, 1, -1, 2, 0, -3, 4, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -4, 6, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 1, 0, -1, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, 0, -1, 0, 0, -2, 0, 0, 0}, {0, 0, 1, -1, 0, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, -1, -1, 0, -5, 7, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 0, 0, 2, 0, -2, 0, 0, 0, 0}, {0, 0, 0, 2, 0, 0, -2, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 2, 0, -3, 5, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 1, 0, -1, 2, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 9, -13, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 8, -14, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 8, -11, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -8, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 6, -7, 0, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 5, -6, -4, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 5, -4, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 4, -8, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 4, -5, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 3, -3, 0, 2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 3, -1, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 1, -1, 0, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 7, -12, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 6, -9, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 6, -8, 1, 5, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 6, -4, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 6, -10, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, 0, -4, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 5, -9, 0, 0, 0, 0, -1}, {0, 0, 0, 0, 0, 0, 0, 5, -8, 3, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 5, -7, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 5, -6, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 5, -16, 4, 5, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 5, -13, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, 0, -5, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, -9, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 3, -7, 0, 0, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 2, 0, 0, -3, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 2, -8, 1, 5, 0, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, -5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 2, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 0, -3, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, -3, 5, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, -3, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 2, -6, 3, 0, -2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -2, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}};
    }

    public static class RefCos {
        public double a;
        public double b;

        public RefCos(double a, double b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class ObservedPositionEO {
        public ObservedPosition op;
        public double eo;

        public ObservedPositionEO(ObservedPosition op, double eo) {
            this.op = op;
            this.eo = eo;
        }
    }

    public static class ObservedPosition {
        public double aob;
        public double zob;
        public double hob;
        public double dob;
        public double rob;

        public ObservedPosition(double aob, double zob, double hob, double dob, double rob) {
            this.aob = aob;
            this.zob = zob;
            this.hob = hob;
            this.dob = dob;
            this.rob = rob;
        }
    }

    public static class Ldbody {
        public double bm;
        public double dl;
        public double[][] pv = new double[2][3];
    }

    public static class Astrom {
        public double pmt;
        public double[] eb = new double[3];
        public double[] eh = new double[3];
        public double em;
        public double[] v = new double[3];
        public double bm1;
        public double[][] bpn = new double[3][3];
        public double along;
        public double phi;
        public double xpl;
        public double ypl;
        public double sphi;
        public double cphi;
        public double diurab;
        public double eral;
        public double refa;
        public double refb;
    }

    public static class ICRFrame {
        public CelestialIntermediatePole cip;
        public double s;

        public ICRFrame(CelestialIntermediatePole cip, double s) {
            this.cip = cip;
            this.s = s;
        }
    }

    public static class CatalogCoords {
        public SphericalCoordinate pos;
        public SphericalCoordinate pm;
        public double px;
        public double rv;

        public CatalogCoords(double ra, double dec, double pmr, double pmd, double px, double rv) {
            this.pos = new SphericalCoordinate(ra, dec);
            this.pm = new SphericalCoordinate(pmr, pmd);
            this.px = px;
            this.rv = rv;
        }
    }

    public static class PVModulus {
        public double r;
        public double s;

        public PVModulus(double r, double s) {
            this.r = r;
            this.s = s;
        }
    }

    public static class SphericalPositionVelocity {
        public SphericalPosition pos;
        public SphericalPosition vel;

        public SphericalPositionVelocity(double theta, double phi, double r, double td, double pd, double rd) {
            this.pos = new SphericalPosition(theta, phi, r);
            this.vel = new SphericalPosition(td, pd, rd);
        }
    }

    public static class EulerAngles {
        public double zeta;
        public double z;
        public double theta;

        public EulerAngles(double zeta, double z, double theta) {
            this.zeta = zeta;
            this.z = z;
            this.theta = theta;
        }
    }

    public static class PrecessionDeltaTerms {
        public double dpsipr;
        public double depspr;

        public PrecessionDeltaTerms(double dpsipr, double depspr) {
            this.dpsipr = dpsipr;
            this.depspr = depspr;
        }
    }

    public static class PrecessionNutation {
        public NutationTerms nut;
        public double epsa;
        public double[][] rb;
        public double[][] rp;
        public double[][] rbp;
        public double[][] rn;
        public double[][] rbpn;

        public PrecessionNutation(double dpsi, double deps, double epsa, double[][] rb, double[][] rp, double[][] rbp, double[][] rn, double[][] rbpn) {
            this.nut = new NutationTerms(dpsi, deps);
            this.epsa = epsa;
            this.rb = rb;
            this.rp = rp;
            this.rbp = rbp;
            this.rn = rn;
            this.rbpn = rbpn;
        }
    }

    public static class NormalizedVector {
        public double r;
        public double[] u;

        public NormalizedVector(double r, double[] u) {
            this.r = r;
            this.u = u;
        }
    }

    public static class FWPrecessionAngles {
        public double gamb;
        public double phib;
        public double psib;
        public double epsa;

        public FWPrecessionAngles(double gamb, double phib, double psib, double epsa) {
            this.gamb = gamb;
            this.phib = phib;
            this.psib = psib;
            this.epsa = epsa;
        }
    }

    public static class SphericalPosition {
        public double theta;
        public double phi;
        public double r;

        public SphericalPosition(double theta, double phi, double r) {
            this.theta = theta;
            this.phi = phi;
            this.r = r;
        }
    }

    public static class PrecessionAngles {
        public double eps0;
        public double psia;
        public double oma;
        public double bpa;
        public double bqa;
        public double pia;
        public double bpia;
        public double epsa;
        public double chia;
        public double za;
        public double zetaa;
        public double thetaa;
        public double pa;
        public double gam;
        public double phi;
        public double psi;

        public PrecessionAngles(double eps0, double psia, double oma, double bpa, double bqa, double pia, double bpia, double epsa, double chia, double za, double zetaa, double thetaa, double pa, double gam, double phi, double psi) {
            this.eps0 = eps0;
            this.psia = psia;
            this.oma = oma;
            this.bpa = bpa;
            this.bqa = bqa;
            this.pia = pia;
            this.bpia = bpia;
            this.epsa = epsa;
            this.chia = chia;
            this.za = za;
            this.zetaa = zetaa;
            this.thetaa = thetaa;
            this.pa = pa;
            this.gam = gam;
            this.phi = phi;
            this.psi = psi;
        }
    }

    public static class NutationTerms {
        public double dpsi;
        public double deps;

        public NutationTerms(double dpsi, double deps) {
            this.dpsi = dpsi;
            this.deps = deps;
        }
    }

    public static class GeodeticCoord {
        public double elong;
        public double phi;
        public double height;

        public GeodeticCoord(double elong, double phi, double height) {
            this.elong = elong;
            this.phi = phi;
            this.height = height;
        }
    }

    public static class SphericalCoordinateEO {
        public SphericalCoordinate pos;
        public double eo;

        public SphericalCoordinateEO(SphericalCoordinate pos, double eo) {
            this.pos = pos;
            this.eo = eo;
        }
    }

    public static class SphericalCoordinate {
        public double alpha;
        public double delta;

        public SphericalCoordinate(double alpha, double delta) {
            this.alpha = alpha;
            this.delta = delta;
        }
    }

    private static class SSB {
        static final double[] s0x = new double[]{0.00495675753641, 3.741073751789, 0.5296909721118, 0.002718490072522, 4.016011511425, 0.2132990797783, 0.001546493974344, 2.170528330642, 0.0381329181312, 8.366855276341E-4, 2.339614075294, 0.0747816656905, 2.936777942117E-4, 0.0, 0.0, 1.201317439469E-4, 4.090736353305, 1.059381944224, 7.57855088723E-5, 3.24151808814, 0.4265981595566, 1.941787367773E-5, 1.01220206433, 0.2061856251104, 1.889227765991E-5, 3.89252041644, 0.2204125344462, 1.937896968613E-5, 4.797779441161, 0.149563331381, 1.434506110873E-5, 3.868960697933, 0.5225775174439, 1.40665991158E-5, 0.4759766557397, 0.5368044267797, 1.179022300202E-5, 0.7774961520598, 0.0762658362624, 8.085864460959E-6, 3.254654471465, 0.0366487475593, 7.622752967615E-6, 4.227633103489, 0.0396170887031, 6.209171139066E-6, 0.2791828325711, 0.0732974951186, 4.36643563397E-6, 4.440454875925, 1.589072916335, 3.792124889348E-6, 5.156393842356, 0.0071134546679, 3.154548963402E-6, 6.157005730093, 0.4194847048887, 3.088359882942E-6, 2.494567553163, 0.6398972393349, 2.788440902136E-6, 4.934318747989, 0.1102062672231, 3.039928456376E-6, 4.89507770264, 6.283075850446, 2.272258457679E-6, 5.278394064764, 0.1030928125552, 2.162007057957E-6, 5.802978019099, 0.3163918923335, 1.767632855737E-6, 0.03415346595193, 10.21328554739, 1.349413459362E-6, 2.001643230755, 0.0014841705719, 1.170141900476E-6, 2.42475049162, 0.632783784667, 1.05435526682E-6, 3.123311487576, 0.4337116142245, 9.80082246161E-7, 3.02625808813, 1.052268489556, 1.091203749931E-6, 3.157811670347, 1.162474756779, 6.960236715913E-7, 0.8219570542313, 1.066495398892, 5.689257296909E-7, 1.323052375236, 0.9491756770005, 6.613172135802E-7, 0.2765348881598, 0.8460828644453, 6.277702517571E-7, 5.794064466382, 0.1480791608091, 6.304884066699E-7, 0.7323555380787, 0.2243449970715, 4.897850467382E-7, 3.062464235399, 3.340612434717, 3.759148598786E-7, 4.588290469664, 0.0351645769874, 3.110520548195E-7, 1.374299536572, 0.0637357483973, 3.06470835978E-7, 4.222267485047, 0.0110459172932, 2.856347168241E-7, 3.714202944973, 0.1510475019529, 2.840945514288E-7, 2.847972875882, 0.041101259275, 2.378951599405E-7, 3.762072563388, 0.2275259891141, 2.714229481417E-7, 1.036049980031, 0.025350505, 2.323551717307E-7, 0.4682388599076, 0.0858275829837, 1.881790512219E-7, 4.790565425418, 2.118763888447, 2.261353968371E-7, 1.669144912212, 0.0718133245467, 2.214546389848E-7, 3.937717281614, 0.0029683411438, 2.184915594933E-7, 0.1129169845099, 0.0777500068343, 2.000164937936E-7, 4.030009638488, 0.209366617153, 1.966105136719E-7, 0.8745955786834, 0.2172315424036, 1.904742332624E-7, 5.919743598964, 0.2022531624851, 1.657399705031E-7, 2.549141484884, 0.7358765972222, 1.574070533987E-7, 5.27753302023, 0.7429900518901, 1.832261651039E-7, 3.064688127777, 0.3235053470014, 1.733615346569E-7, 3.011432799094, 0.1385174140878, 1.549124014496E-7, 4.005569132359, 0.515464062776, 1.637044713838E-7, 1.831375966632, 0.8531963191132, 1.123420082383E-7, 1.180270407578, 0.1990721704425, 1.08375416574E-7, 0.3414101320863, 0.5439178814476, 1.156638012655E-7, 0.6130479452594, 0.5257585094865, 1.142548785134E-7, 3.724761948846, 0.5336234347371, 7.921463895965E-8, 2.435425589361, 1.478866649112, 7.428600285231E-8, 3.542144398753, 0.2164800718209, 8.323211246747E-8, 3.525058072354, 1.692165728891, 7.257595116312E-8, 1.364299431982, 0.2101180877357, 7.111185833236E-8, 2.460478875808, 0.4155522422634, 6.868090383716E-8, 4.397327670704, 0.117319721891, 7.226419974175E-8, 4.042647308905, 1.265567569334, 6.955642383177E-8, 2.865047906085, 0.9562891316684, 7.492139296331E-8, 5.014278994215, 0.0142269093358, 6.598363128857E-8, 2.376730020492, 0.6470106940028, 7.381147293385E-8, 3.272990384244, 1.581959461667, 6.402909624032E-8, 5.302290955138, 0.0959793578873, 6.237454263857E-8, 5.444144425332, 0.0708492030652, 5.241198544016E-8, 4.215359579205, 0.5265099800692, 5.144463853918E-8, 0.1218916689916, 0.5328719641544, 5.868164772299E-8, 2.369402002213, 0.0787141283158, 6.233195669151E-8, 1.254922242403, 26.0879031406, 6.068463791422E-8, 5.679713760431, 0.1114304132498, 4.359361135065E-8, 0.6097219641646, 1.375773836557, 4.686510366826E-8, 4.786231041431, 0.1143987543936, 3.758977287225E-8, 1.167368068139, 1.596186371003, 4.282051974778E-8, 1.519471064319, 0.2770348281756, 5.153765386113E-8, 1.860532322984, 0.2228608264996, 4.575129387188E-8, 0.7632857887158, 0.1465949902372, 3.326844933286E-8, 1.298219485285, 0.05070101, 3.748617450984E-8, 1.046510321062, 0.4903339079539, 2.816756661499E-8, 3.43452234619, 0.299126662762, 3.412750405039E-8, 2.523766270318, 0.3518164938661, 2.655796761776E-8, 2.904422260194, 0.6256703299991, 2.963597929458E-8, 0.5923900431149, 0.1099462426779, 2.539523734781E-8, 4.851947722567, 12.56615170089, 2.283087914139E-8, 3.400498595496, 6.681224869435, 2.321309799331E-8, 5.789099148673, 0.0336804064155, 2.54965764975E-8, 0.03991856479792, 1.169588211447, 2.290462303977E-8, 2.788567577052, 1.045155034888, 1.945398522914E-8, 3.290896998176, 1.155361302111, 1.849171512638E-8, 2.698060129367, 0.0044525117157, 1.647199834254E-8, 3.016735644085, 0.4408250688924, 1.529530765273E-8, 5.573043116178, 0.0652199189692, 1.433199339978E-8, 1.481192356147, 0.9420622223326, 1.729134193602E-8, 1.422817538933, 0.2108507877249, 1.716463931346E-8, 3.469468901855, 0.2157473718317, 1.391206061378E-8, 6.122436220547, 0.4123712502208, 1.404746661924E-8, 1.647765641936, 0.0425854298469, 1.410452399455E-8, 5.989729161964, 0.2258291676434, 1.089828772168E-8, 2.833705509371, 0.4226656969313, 1.047374564948E-8, 0.5090690007331, 0.3092784376656, 1.358279126532E-8, 5.128990262836, 0.0792341774062, 1.020456476148E-8, 0.9632772880808, 0.1456308687557, 1.033428735328E-8, 3.223779318418, 1.795258541446, 1.41243584154E-8, 2.410271572721, 0.1525316725248, 9.722759371574E-9, 2.33353139569, 0.0843434124118, 9.657334084704E-9, 6.199270974168, 1.272681024002, 1.08364114869E-8, 2.864222292929, 0.0703291539748, 1.067318403838E-8, 0.5833458866568, 0.2123349582968, 1.062366201976E-8, 4.307753989494, 0.2142632012598, 1.236364149266E-8, 2.873917870593, 0.1847279083684, 1.092759489593E-8, 2.959887266733, 0.1370332435159, 8.912069362899E-9, 5.141213702562, 2.648454860559, 9.65646770797E-9, 4.532182462323, 0.4376440768498, 8.098386150135E-9, 2.268906338379, 0.2880807454688, 7.857714675E-9, 4.055544260745, 0.203737333057, 7.288455940646E-9, 5.357901655142, 0.1129145838217, 9.450595950552E-9, 4.264926963939, 0.5272426800584, 9.381718247537E-9, 0.07489366976576, 0.5321392641652, 7.079052646038E-9, 1.923311052874, 0.6288513220417, 9.259004415344E-9, 2.970256853438, 0.1606092486742, 8.259801499742E-9, 3.327056314697, 0.8389694097774, 6.476334355779E-9, 2.954925505727, 2.008557621224, 5.984021492007E-9, 0.9138753105829, 20.42657109477, 5.989546863181E-9, 3.244464082031, 2.111650433779, 6.233108606023E-9, 0.4995232638403, 0.4305306221819, 6.877299149965E-9, 2.834987233449, 0.0095617467213, 8.31123422719E-9, 2.202951835758, 0.3801276407308, 6.599472832414E-9, 4.478581462618, 1.063314406849, 6.160491096549E-9, 5.145858696411, 1.368660381889, 6.164772043891E-9, 0.3762976697911, 0.423417167514, 6.36324868445E-9, 3.162246718685, 0.0125300878651, 6.448587520999E-9, 3.442693302119, 0.5287268506303, 6.431662283977E-9, 0.8977549136606, 0.5306550935933, 6.351223158474E-9, 4.306447410369, 52.1758062812, 5.476721393451E-9, 3.888529177855, 2.221856701002, 5.341772572619E-9, 2.655560662512, 0.0746675969365, 5.337055758302E-9, 5.164990735946, 0.0748957344445, 5.373120816787E-9, 6.041214553456, 0.1274714967946, 5.392351705426E-9, 0.9177763485932, 1.055449481598, 6.688495850205E-9, 3.089608126937, 0.2213766559277, 5.072003660362E-9, 4.311316541553, 0.2132517061319, 5.070726650455E-9, 0.5790675464444, 0.2133464534247, 5.658012950032E-9, 2.703945510675, 0.7287631425543, 4.835509924854E-9, 2.975422976065, 0.0716006736479, 6.479821978012E-9, 1.324168733114, 0.0220918345864, 6.23063649498E-9, 2.860103632836, 0.3306188016693, 4.649239516213E-9, 4.832259763403, 0.0779626577331, 6.4873257927E-9, 2.726165825042, 0.3884652414254, 4.68282368277E-9, 0.6966602455408, 1.073608853559, 5.704230804976E-9, 5.669634104606, 0.0873117535556, 6.125413585489E-9, 1.513386538915, 0.076051515, 6.035825038187E-9, 1.983509168227, 0.9846002785331, 4.331123462303E-9, 2.782892992807, 0.4297791515992, 4.681107685143E-9, 5.337232886836, 0.2127790306879, 4.669105829655E-9, 5.83713379216, 0.2138191288687, 5.138823602365E-9, 3.080560200507, 0.0723333736371, 4.615856664534E-9, 1.661747897471, 0.8603097737811, 4.496916702197E-9, 2.112508027068, 0.073817544209, 4.278479042945E-9, 5.716528462627, 0.075745787172, 3.840525503932E-9, 0.6424172726492, 0.3407705765729, 4.866636509685E-9, 4.919244697715, 0.0772299577439, 3.526100639296E-9, 2.550821052734, 0.0622515778254, 3.939558488075E-9, 3.93933149171, 0.0526898311041, 4.041268772576E-9, 2.275337571218, 0.3503323232942, 3.948761842853E-9, 1.99932420079, 0.1451108196653, 3.258394550029E-9, 0.91210013782, 0.5296435984654, 3.257897048761E-9, 3.428428660869, 0.5297383457582, 3.842559031298E-9, 6.132927720035, 0.9098186128426, 3.109920095448E-9, 0.7693650193003, 0.0039324626253, 3.132237775119E-9, 3.621293854908, 0.234639443782, 3.94218942151E-9, 4.841863659733, 0.0031809920426, 3.79697228534E-9, 1.814174994268, 0.1862120789403, 3.995640233688E-9, 1.386990406091, 0.4549093064213, 2.875013727414E-9, 0.9178318587177, 1.905464808669, 3.073719932844E-9, 2.688923811835, 0.3628624111593, 2.731016580075E-9, 1.188259127584, 0.2131850110243, 2.729549896546E-9, 3.702160634273, 0.2134131485323, 3.339372892449E-9, 0.7199163960331, 0.2007689919132, 2.898833764204E-9, 1.916709364999, 0.5291709230214, 2.894536549362E-9, 2.424043195547, 0.5302110212022, 3.096872473843E-9, 4.445894977497, 0.2976424921901, 2.63567232681E-9, 3.814366984117, 1.48598010378, 3.649302697001E-9, 2.924200596084, 0.6044726378023, 3.127954585895E-9, 1.842251648327, 0.108462072106, 2.616040173947E-9, 4.155841921984, 1.258454114666, 2.59739585986E-9, 0.1158045978874, 0.2103781122809, 2.59328617221E-9, 4.771850408691, 0.2162200472757, 2.481823585747E-9, 0.4608842558889, 1.062562936266, 2.742219550725E-9, 1.538781127028, 0.5651155736444, 3.19955846961E-9, 0.3226647822878, 0.7036329877322, 2.666088542957E-9, 0.1967991731219, 0.1400015846597, 2.39706743058E-9, 3.707036669873, 0.2125476091956, 2.376570772738E-9, 1.182086628042, 0.214050550361, 2.547228007887E-9, 4.906256820629, 0.1534957940063, 2.265575594114E-9, 3.414949866857, 0.2235935264888, 2.464381430585E-9, 4.599122275378, 0.2091065926078, 2.433408527044E-9, 0.2830751145445, 0.2174915669488, 2.443605509076E-9, 4.212046432538, 0.1739420156204, 2.319779262465E-9, 0.988197840863, 0.0753017147809, 2.284622835465E-9, 0.5565347331588, 0.0742616166001, 2.467268750783E-9, 0.5655708150766, 0.2526561439362, 2.808513492782E-9, 1.418405053408, 0.5636314030725, 2.329528932532E-9, 4.069557545675, 1.056200952181, 9.698639532817E-10, 1.074134313634, 78.2637094218};
        static final double[] s0y = new double[]{0.004955392320126, 2.170467313679, 0.5296909721118, 0.002722325167392, 2.444433682196, 0.2132990797783, 0.001546579925346, 0.5992779281546, 0.0381329181312, 8.363140252966E-4, 0.7687356310801, 0.0747816656905, 3.385792683603E-4, 0.0, 0.0, 1.201192221613E-4, 2.520035601514, 1.059381944224, 7.587125720554E-5, 1.669954006449, 0.4265981595566, 1.96415536125E-5, 5.707743963343, 0.2061856251104, 1.891900364909E-5, 2.320960679937, 0.2204125344462, 1.937373433356E-5, 3.226940689555, 0.149563331381, 1.437139941351E-5, 2.301626908096, 0.5225775174439, 1.406267683099E-5, 5.188579265542, 0.5368044267797, 1.178703080346E-5, 5.489483248476, 0.0762658362624, 8.079835186041E-6, 1.683751835264, 0.0366487475593, 7.623253594652E-6, 2.656400462961, 0.0396170887031, 6.248667483971E-6, 4.992775362055, 0.0732974951186, 4.366353695038E-6, 2.869706279678, 1.589072916335, 3.829101568895E-6, 3.57213135995, 0.0071134546679, 3.175733773908E-6, 4.535372530045, 0.4194847048887, 3.092437902159E-6, 0.9230153317909, 0.6398972393349, 2.874168812154E-6, 3.363143761101, 0.1102062672231, 3.040119321826E-6, 3.324250895675, 6.283075850446, 2.699723308006E-6, 0.2917882441928, 0.1030928125552, 2.134832683534E-6, 4.220997202487, 0.3163918923335, 1.770412139433E-6, 4.747318496462, 10.21328554739, 1.377264209373E-6, 0.4305058462401, 0.0014841705719, 1.12781453896E-6, 0.853817724074, 0.632783784667, 1.05560809013E-6, 1.55180074258, 0.4337116142245, 9.80267386142E-7, 1.459646735377, 1.052268489556, 1.090329461951E-6, 1.587351228711, 1.162474756779, 6.95959002509E-7, 5.534442628766, 1.066495398892, 5.664914529542E-7, 6.030673003297, 0.9491756770005, 6.607787763599E-7, 4.989507233927, 0.8460828644453, 6.269725742838E-7, 4.222951804572, 0.1480791608091, 6.301889697863E-7, 5.444316669126, 0.2243449970715, 4.891042662861E-7, 1.490552839784, 3.340612434717, 3.45708312329E-7, 3.030475486049, 0.0351645769874, 3.032559967314E-7, 2.652038793632, 0.0110459172932, 2.841133988903E-7, 1.276744786829, 0.041101259275, 2.855564444432E-7, 2.143368674733, 0.1510475019529, 2.765157135038E-7, 5.444186109077, 0.0637357483973, 2.382312465034E-7, 2.190521137593, 0.2275259891141, 2.808060365077E-7, 5.735195064841, 0.025350505, 2.332175234405E-7, 0.09481985524859, 0.0718133245467, 2.322488199659E-7, 5.180499361533, 0.0858275829837, 1.881850258423E-7, 3.219788273885, 2.118763888447, 2.196111392808E-7, 2.366941159761, 0.0029683411438, 2.183810335519E-7, 4.825445110915, 0.0777500068343, 2.002733093326E-7, 2.457148995307, 0.209366617153, 1.967111767229E-7, 5.586291545459, 0.2172315424036, 1.568473250543E-7, 3.70800312332, 0.7429900518901, 1.8525283143E-7, 4.31063815156, 0.2022531624851, 1.832111226447E-7, 1.494665322656, 0.3235053470014, 1.74680550231E-7, 1.451378500784, 0.1385174140878, 1.55573096665E-7, 1.068040418198, 0.7358765972222, 1.554883462559E-7, 2.442579035461, 0.515464062776, 1.638380568746E-7, 0.2597913420625, 0.8531963191132, 1.15993859364E-7, 5.83451202128, 0.1990721704425, 1.083427965695E-7, 5.05403317795, 0.5439178814476, 1.156480369431E-7, 5.325677432457, 0.5257585094865, 1.141308860095E-7, 2.153403923857, 0.5336234347371, 7.913146470946E-8, 0.8642846847027, 1.478866649112, 7.439752463733E-8, 1.970628496213, 0.2164800718209, 7.280277104079E-8, 6.073307250609, 0.2101180877357, 8.319567719136E-8, 1.954371928334, 1.692165728891, 7.13770554929E-8, 0.8904989440909, 0.4155522422634, 6.900825396225E-8, 2.825717714977, 0.117319721891, 7.245757216635E-8, 2.481677513331, 1.265567569334, 6.961165696255E-8, 1.292955312978, 0.9562891316684, 7.57180445689E-8, 3.427517575069, 0.0142269093358, 6.605425721904E-8, 0.8052192701492, 0.6470106940028, 7.375477357248E-8, 1.705076390088, 1.581959461667, 7.04166495147E-8, 0.4848356967891, 0.0959793578873, 6.322199535763E-8, 3.878069473909, 0.0708492030652, 5.244380279191E-8, 2.645560544125, 0.5265099800692, 5.143125704988E-8, 4.83448610137, 0.5328719641544, 5.871866319373E-8, 0.79814725489, 0.0787141283158, 6.300822573871E-8, 5.979398788281, 26.0879031406, 6.062154271548E-8, 4.108655402756, 0.1114304132498, 4.361912339976E-8, 5.32262431928, 1.375773836557, 4.417005920067E-8, 6.240817359284, 0.2770348281756, 4.686806749936E-8, 3.214977301156, 0.1143987543936, 3.758892132305E-8, 5.879809634765, 1.596186371003, 5.151351332319E-8, 0.2893377688007, 0.2228608264996, 4.554683578572E-8, 5.475427144122, 0.1465949902372, 3.442381385338E-8, 5.99203479664, 0.05070101, 2.831093954933E-8, 5.367350273914, 0.3092784376656, 3.756267090084E-8, 5.75817128542, 0.4903339079539, 2.816374679892E-8, 1.863718700923, 0.299126662762, 3.419307025569E-8, 0.952434753413, 0.3518164938661, 2.904250494239E-8, 5.304471615602, 0.1099462426779, 2.471734511206E-8, 1.29706979353, 0.6256703299991, 2.539620831872E-8, 3.281126083375, 12.56615170089, 2.281017868007E-8, 1.829122133165, 6.681224869435, 2.275319473335E-8, 5.797198160181, 0.0039324626253, 2.547755368442E-8, 4.75269770833, 1.169588211447, 2.285979669317E-8, 1.223205292886, 1.045155034888, 1.913386560994E-8, 1.757532993389, 1.155361302111, 1.809020525147E-8, 4.246116108791, 0.0336804064155, 1.649213300201E-8, 1.445162890627, 0.4408250688924, 1.834972793932E-8, 1.126917567225, 0.0044525117157, 1.439550648138E-8, 6.160756834764, 0.9420622223326, 1.487645457041E-8, 4.358761931792, 0.4123712502208, 1.73172951666E-8, 6.134456753344, 0.2108507877249, 1.717747163567E-8, 1.898186084455, 0.2157473718317, 1.418190430374E-8, 4.180286741266, 0.0652199189692, 1.404844134873E-8, 0.07654053565412, 0.0425854298469, 1.409842846538E-8, 4.418612420312, 0.2258291676434, 1.090948346291E-8, 1.260615686131, 0.4226656969313, 1.357577323612E-8, 3.55824881869, 0.0792341774062, 1.01815406196E-8, 5.676087241256, 0.1456308687557, 1.412073972109E-8, 0.8394392632422, 0.1525316725248, 1.030938326496E-8, 1.653593274064, 1.795258541446, 1.180081567104E-8, 1.285802592036, 0.0703291539748, 9.70851057565E-9, 0.7631889488106, 0.0843434124118, 9.637689663447E-9, 4.630642649176, 1.272681024002, 1.068910429389E-8, 5.294934032165, 0.2123349582968, 1.063716179336E-8, 2.736266800832, 0.2142632012598, 1.234858713814E-8, 1.30289114657, 0.1847279083684, 8.912631189738E-9, 3.570415993621, 2.648454860559, 1.036378285534E-8, 4.236693440949, 0.1370332435159, 9.667798501561E-9, 2.960768892398, 0.4376440768498, 8.108314201902E-9, 0.6987781646841, 0.2880807454688, 7.648364324628E-9, 2.499017863863, 0.203737333057, 7.286136828406E-9, 3.787426951665, 0.1129145838217, 9.448237743913E-9, 2.694354332983, 0.5272426800584, 9.374276106428E-9, 4.787121277064, 0.5321392641652, 7.100226287462E-9, 0.3530238792101, 0.6288513220417, 9.253056659571E-9, 1.399478925664, 0.1606092486742, 6.636432145504E-9, 3.479575438447, 1.368660381889, 6.469975312932E-9, 1.3836699648, 2.008557621224, 7.335849729765E-9, 1.243698166898, 0.0095617467213, 8.743421205855E-9, 3.776164289301, 0.3801276407308, 5.993635744494E-9, 5.627122113596, 20.42657109477, 5.981008479693E-9, 1.674336636752, 2.111650433779, 6.188535145838E-9, 5.214925208672, 0.4305306221819, 6.596074017566E-9, 2.907653268124, 1.063314406849, 6.630815126226E-9, 2.127643669658, 0.8389694097774, 6.15677283004E-9, 5.082160803295, 0.423417167514, 6.446960563014E-9, 1.872100916905, 0.5287268506303, 6.429324424668E-9, 5.610276103577, 0.5306550935933, 6.302232396465E-9, 1.592152049607, 0.0125300878651, 6.399244436159E-9, 2.746214421532, 52.1758062812, 5.474965172558E-9, 2.317666374383, 2.221856701002, 5.339293190692E-9, 1.084724961156, 0.0746675969365, 5.334733683389E-9, 3.594106067745, 0.0748957344445, 5.39266578211E-9, 5.630254365606, 1.055449481598, 6.682075673789E-9, 1.518480041732, 0.2213766559277, 5.07913049596E-9, 2.739765115711, 0.2132517061319, 5.077759793261E-9, 5.290711290094, 0.2133464534247, 4.83203736831E-9, 1.4044732172, 0.0716006736479, 6.463279674802E-9, 6.03838169521, 0.0220918345864, 6.24059277156E-9, 1.290170653666, 0.3306188016693, 4.672013521493E-9, 3.261895939677, 0.0779626577331, 6.500650750348E-9, 1.154522312095, 0.3884652414254, 6.344161389053E-9, 6.206111545062, 0.076051515, 4.682518370646E-9, 5.409118796685, 1.073608853559, 5.329460015591E-9, 1.202985784864, 0.7287631425543, 5.701588675898E-9, 4.098715257064, 0.0873117535556, 6.030690867211E-9, 0.413203321846, 0.9846002785331, 4.336256312655E-9, 1.211415991827, 0.4297791515992, 4.688498808975E-9, 3.765479072409, 0.2127790306879, 4.675578609335E-9, 4.265540037226, 0.2138191288687, 4.225578112158E-9, 5.237566010676, 0.3407705765729, 5.139422230028E-9, 1.507173079513, 0.0723333736371, 4.619995093571E-9, 0.09023957449848, 0.8603097737811, 4.494776255461E-9, 0.5414930552139, 0.073817544209, 4.274026276788E-9, 4.145735303659, 0.075745787172, 5.018141789353E-9, 3.344408829055, 0.0031809920426, 4.866163952181E-9, 3.348534657607, 0.0772299577439, 4.111986020501E-9, 0.419882359722, 0.1451108196653, 3.35614278495E-9, 5.60914474718, 0.1274714967946, 4.070575554551E-9, 0.7028411059224, 0.3503323232942, 3.257451857278E-9, 5.624697983086, 0.5296435984654, 3.256973703026E-9, 1.857842076707, 0.5297383457582, 3.83077150864E-9, 4.562887279931, 0.9098186128426, 3.725024005962E-9, 0.2358058692652, 0.108462072106, 3.136763921756E-9, 2.049731526845, 0.234639443782, 3.795147256194E-9, 0.2432356296933, 0.1862120789403, 2.877342229911E-9, 5.631101279387, 1.905464808669, 3.076931798805E-9, 1.117615737392, 0.3628624111593, 2.734765945273E-9, 5.899826516955, 0.2131850110243, 2.733405296885E-9, 2.13056296407, 0.2134131485323, 2.89855235341E-9, 0.3462387048225, 0.5291709230214, 2.893736103681E-9, 0.8534352781543, 0.5302110212022, 3.095717734137E-9, 2.875061429041, 0.2976424921901, 2.636190425832E-9, 2.242512846659, 1.48598010378, 3.645512095537E-9, 1.354016903958, 0.6044726378023, 2.808173547723E-9, 0.06705114365631, 0.0622515778254, 2.625012866888E-9, 4.775705748482, 0.0526898311041, 2.572233995651E-9, 2.638924216139, 1.258454114666, 2.604238824792E-9, 4.826358927373, 0.2103781122809, 2.596886385239E-9, 3.200388483118, 0.2162200472757, 3.228057304264E-9, 5.384848409563, 0.2007689919132, 2.481601798252E-9, 5.173373487744, 1.062562936266, 2.745977498864E-9, 6.250966149853, 0.5651155736444, 2.669878833811E-9, 4.906001352499, 0.1400015846597, 3.203986611711E-9, 5.034333010005, 0.7036329877322, 3.354961227212E-9, 6.108262423137, 0.4549093064213, 2.400407324558E-9, 2.135399294955, 0.2125476091956, 2.379905859802E-9, 5.893721933961, 0.214050550361, 2.550844302187E-9, 3.331940762063, 0.1534957940063, 2.268824211001E-9, 1.843418461035, 0.2235935264888, 2.464700891204E-9, 3.02954854723, 0.2091065926078, 2.436814726024E-9, 4.994717970364, 0.2174915669488, 2.443623894745E-9, 2.645102591375, 0.1739420156204, 2.318701783838E-9, 5.700547397897, 0.0753017147809, 2.284448700256E-9, 5.268898905872, 0.0742616166001, 2.46884812351E-9, 5.276280575078, 0.2526561439362, 2.814052350303E-9, 6.130168623475, 0.5636314030725, 2.24366275522E-9, 0.6631692457995, 0.0888659032194, 2.330795855941E-9, 2.499435487702, 1.056200952181, 9.757679038404E-10, 5.796846023126, 78.2637094218};
        static final double[] s0z = new double[]{1.181255122986E-4, 0.4607918989164, 0.2132990797783, 1.127777651095E-4, 0.4169146331296, 0.5296909721118, 4.777754401806E-5, 4.58265700713, 0.0381329181312, 1.129354285772E-5, 5.75873514248, 0.0747816656905, -1.149543637123E-5, 0.0, 0.0, 3.298730512306E-6, 5.978801994625, 0.4265981595566, 2.733376706079E-6, 0.766541369104, 1.059381944224, 9.42638965727E-7, 3.710201265838, 0.2061856251104, 8.187517749552E-7, 0.3390675605802, 0.2204125344462, 4.080447871819E-7, 0.4552296640088, 0.5225775174439, 3.169973017028E-7, 3.445455899321, 0.5368044267797, 2.438098615549E-7, 5.664675150648, 0.0366487475593, 2.601897517235E-7, 1.931894095697, 0.149563331381, 2.314558080079E-7, 0.3666319115574, 0.0396170887031, 1.962549548002E-7, 3.16741169902, 0.0762658362624, 2.180518287925E-7, 1.54442074658, 0.0071134546679, 1.451382442868E-7, 1.58375674007, 0.1102062672231, 1.358439007389E-7, 5.23994175828, 0.6398972393349, 1.050585898028E-7, 2.266958352859, 0.3163918923335, 1.050029870186E-7, 2.711495250354, 0.4194847048887, 9.9349206798E-8, 1.116208151396, 1.589072916335, 1.04839533156E-7, 3.408619600206, 10.21328554739, 8.370147196668E-8, 3.810459401087, 0.025350505, 7.989856510998E-8, 3.769910473647, 0.0732974951186, 5.441221655233E-8, 2.416994903374, 0.1030928125552, 4.610812906784E-8, 5.858503336994, 0.4337116142245, 3.923022803444E-8, 0.3354170010125, 0.0014841705719, 2.610725582128E-8, 5.410600646324, 0.632783784667, 2.455279767721E-8, 6.120216681403, 1.162474756779, 2.375530706525E-8, 6.055443426143, 1.052268489556, 1.782967577553E-8, 3.146108708004, 0.8460828644453, 1.581687095238E-8, 0.6255496089819, 3.340612434717, 1.594657672461E-8, 3.782604300261, 1.066495398892, 1.56344861504E-8, 1.997775733196, 0.2022531624851, 1.463624258525E-8, 0.1736316792088, 0.0351645769874, 1.331585056673E-8, 4.331941830747, 0.9491756770005, 1.130634557637E-8, 6.152017751825, 0.0029683411438, 1.028949607145E-8, 0.2101792614637, 0.2275259891141, 1.024074971618E-8, 4.071833211074, 0.05070101, 8.826956060303E-9, 0.4861633688145, 0.209366617153, 8.572230171541E-9, 5.268190724302, 0.041101259275, 7.649332643544E-9, 5.134543417106, 26.0879031406, 8.581673291033E-9, 2.920218146681, 0.1480791608091, 8.430589300938E-9, 3.604576619108, 0.2172315424036, 7.776165501012E-9, 3.772942249792, 0.0637357483973, 8.311070234408E-9, 6.200412329888, 0.3235053470014, 6.927365212582E-9, 4.543353113437, 0.8531963191132, 6.791574208598E-9, 2.882188406238, 0.0718133245467, 5.593100811839E-9, 1.77664689278, 0.7429900518901, 4.553381853021E-9, 3.94961761124, 0.0777500068343, 5.758000450068E-9, 3.859251775075, 0.1990721704425, 4.281283457133E-9, 1.466294631206, 2.118763888447, 4.206935661097E-9, 5.421776011706, 0.0110459172932, 4.213751641837E-9, 3.412048993322, 0.2243449970715, 5.310506239878E-9, 0.5421641370995, 0.515464062776, 3.82745034132E-9, 0.8887314524995, 0.1510475019529, 4.292435241187E-9, 1.405043757194, 0.0142269093358, 3.189780702289E-9, 1.060049293445, 0.117319721891, 3.226611928069E-9, 6.270858897442, 0.2164800718209, 2.89389760883E-9, 5.117563223301, 0.6470106940028, 3.239852024578E-9, 4.079092237983, 0.2101180877357, 2.9568922222E-9, 1.594917021704, 0.3092784376656, 2.980177912437E-9, 5.258787667564, 0.4155522422634, 3.163725690776E-9, 3.854589225479, 0.0858275829837, 2.662262399118E-9, 3.561326430187, 0.5257585094865, 2.766689135729E-9, 0.318073208683, 0.1385174140878, 2.411600278464E-9, 3.324798335058, 0.5439178814476, 2.483527695131E-9, 0.4169069291947, 0.5336234347371, 7.78877727659E-10, 1.900569908215, 52.1758062812};
        static final double[] s1x = new double[]{-1.29631036152E-8, 0.0, 0.0, 8.975769009438E-9, 1.12889160925, 0.4265981595566, 7.771113441307E-9, 2.706039877077, 0.2061856251104, 7.538303866642E-9, 2.191281289498, 0.2204125344462, 6.061384579336E-9, 3.248167319958, 1.059381944224, 5.726994235594E-9, 5.56998139861, 0.5225775174439, 5.616492836424E-9, 5.057386614909, 0.5368044267797, 1.010881584769E-9, 3.473577116095, 0.0071134546679, 7.259606157626E-10, 0.3651858593665, 0.6398972393349, 8.755095026935E-10, 1.662835408338, 0.4194847048887, 5.370491182812E-10, 1.327673878077, 0.4337116142245, 5.743773887665E-10, 4.250200846687, 0.2132990797783, 4.4081031403E-10, 3.598752574277, 1.589072916335, 3.101892374445E-10, 4.887822983319, 1.052268489556, 3.209453713578E-10, 0.9702272295114, 0.5296909721118, 3.017228286064E-10, 5.484462275949, 1.066495398892, 3.200700038601E-10, 2.846613338643, 0.149563331381, 2.137637279911E-10, 0.5692163292729, 0.3163918923335, 1.899686386727E-10, 2.061077157189, 0.2275259891141, 1.401994545308E-10, 4.177771136967, 0.1102062672231, 1.578057810499E-10, 5.782460597335, 0.0762658362624, 1.237713253351E-10, 5.705900866881, 0.515464062776, 1.313076837395E-10, 5.163438179576, 0.0366487475593, 1.18496330486E-10, 3.054804427242, 0.632783784667, 1.238130878565E-10, 2.317292575962, 0.0396170887031, 1.015959527736E-10, 2.194643645526, 0.0732974951186, 9.017954423714E-11, 2.868603545435, 0.1990721704425, 8.668024955603E-11, 4.923849675082, 0.5439178814476, 7.756083930103E-11, 3.0143341352, 0.9491756770005, 7.536503401741E-11, 2.704886279769, 0.1030928125552, 5.483308679332E-11, 6.010983673799, 0.8531963191132, 5.184339620428E-11, 1.952704573291, 0.209366617153, 5.10865871203E-11, 2.958575786649, 0.2172315424036, 5.01942452465E-11, 1.736317621318, 0.2164800718209, 4.909312625978E-11, 3.167216416257, 0.2101180877357, 4.456638901107E-11, 0.7697579923471, 0.3235053470014, 4.227030350925E-11, 3.490910137928, 0.0637357483973, 4.095456040093E-11, 0.5178888984491, 0.6470106940028, 4.990537041422E-11, 3.323887668974, 0.0142269093358, 4.321170010845E-11, 4.288484987118, 0.7358765972222, 3.544072091802E-11, 6.021051579251, 0.5265099800692, 3.480198638687E-11, 4.600027054714, 0.5328719641544, 3.440287244435E-11, 4.349525970742, 0.0858275829837, 3.330628322713E-11, 2.347391505082, 0.0110459172932, 2.973060707184E-11, 4.7894092864, 0.5257585094865, 2.932606766089E-11, 5.831693799927, 0.5336234347371, 2.876972310953E-11, 2.692638514771, 0.117319721891, 2.827488278556E-11, 2.05605248796, 0.2022531624851, 2.515028239756E-11, 0.7411863262449, 0.0959793578873, 2.853033744415E-11, 3.948481024894, 2.118763888447};
        static final double[] s1y = new double[]{8.989047573576E-9, 5.840593672122, 0.4265981595566, 7.815938401048E-9, 1.129664707133, 0.2061856251104, 7.55092671328E-9, 0.6196589104845, 0.2204125344462, 6.056556925895E-9, 1.677494667846, 1.059381944224, 5.734142698204E-9, 4.000920852962, 0.5225775174439, 5.614341822459E-9, 3.486722577328, 0.5368044267797, 1.028678147656E-9, 1.877141024787, 0.0071134546679, 7.270792075266E-10, 5.077167301739, 0.6398972393349, 8.73414172604E-10, 0.09069550282609, 0.4194847048887, 5.377371402113E-10, 6.039381844671, 0.4337116142245, 4.729719431571E-10, 2.15308631176, 0.2132990797783, 4.458052820973E-10, 5.059830025565, 0.5296909721118, 4.406855467908E-10, 2.02797169263, 1.589072916335, 3.101659310977E-10, 3.31767798186, 1.052268489556, 3.016749232545E-10, 3.913703482532, 1.066495398892, 3.198541352656E-10, 1.275513098525, 0.149563331381, 2.142065389871E-10, 5.301351614597, 0.3163918923335, 1.902615247592E-10, 0.4894943352736, 0.2275259891141, 1.613410990871E-10, 2.449891130437, 0.1102062672231, 1.576992165097E-10, 4.211421447633, 0.0762658362624, 1.241637259894E-10, 4.140803368133, 0.515464062776, 1.313974830355E-10, 3.591920305503, 0.0366487475593, 1.181697118258E-10, 1.506314382788, 0.632783784667, 1.238239742779E-10, 0.7461405378404, 0.0396170887031, 1.010107068241E-10, 0.6271010795475, 0.0732974951186, 9.226316616509E-11, 1.259158839583, 0.1990721704425, 8.664946419555E-11, 3.353244696934, 0.5439178814476, 7.757230468978E-11, 1.447677295196, 0.9491756770005, 7.693168628139E-11, 1.120509896721, 0.1030928125552, 5.487897454612E-11, 4.439380426795, 0.8531963191132, 5.196118677218E-11, 0.3788856619137, 0.209366617153, 5.110853339935E-11, 1.386879372016, 0.2172315424036, 5.027804534813E-11, 0.1647881805466, 0.2164800718209, 4.922485922674E-11, 1.594315079862, 0.2101180877357, 6.1555995244E-11, 0.0, 0.0, 4.447147832161E-11, 5.480720918976, 0.3235053470014, 4.144691276422E-11, 1.93137103366, 0.0637357483973, 4.099950625452E-11, 5.229611294335, 0.6470106940028, 5.060541682953E-11, 1.731112486298, 0.0142269093358, 4.2936159463E-11, 2.714571038925, 0.7358765972222, 3.545659845763E-11, 4.451041444634, 0.5265099800692, 3.479112041196E-11, 3.029385448081, 0.5328719641544, 3.43851649357E-11, 2.778507143731, 0.0858275829837, 3.297341285033E-11, 0.7898709807584, 0.0110459172932, 2.972585818015E-11, 3.218785316973, 0.5257585094865, 2.931707295017E-11, 4.260731012098, 0.5336234347371, 2.897198149403E-11, 1.120753978101, 0.117319721891, 2.832293240878E-11, 0.4597682717827, 0.2022531624851, 2.864348326612E-11, 2.169939928448, 0.0959793578873, 2.852714675471E-11, 2.377659870578, 2.118763888447};
        static final double[] s1z = new double[]{5.444220475678E-9, 1.80382550931, 0.2132990797783, 3.883412695596E-9, 4.668616389392, 0.5296909721118, 1.334341434551E-9, 0.0, 0.0, 3.730001266883E-10, 5.401405918943, 0.2061856251104, 2.894929197956E-10, 4.932415609852, 0.2204125344462, 2.857950357701E-10, 3.154625362131, 0.0747816656905, 2.499226432292E-10, 3.657486128988, 0.4265981595566, 1.937705443593E-10, 5.740434679002, 1.059381944224, 1.37489439632E-10, 1.712857366891, 0.5368044267797, 1.217248678408E-10, 2.312090870932, 0.5225775174439, 7.96105274087E-11, 5.283368554163, 0.0381329181312, 4.979225949689E-11, 4.29829047186, 0.4194847048887, 4.388552286597E-11, 6.145515047406, 0.0071134546679, 2.58683521256E-11, 3.019448001809, 0.6398972393349};
        static final double[] s2x = new double[]{1.603551636587E-12, 4.404109410481, 0.2061856251104, 1.556935889384E-12, 0.4818040873603, 0.2204125344462, 1.182594414915E-12, 0.9935762734472, 0.5225775174439, 1.15879458318E-12, 3.35318096645, 0.5368044267797, 9.597358943932E-13, 5.567045358298, 0.2132990797783, 6.511516579605E-13, 5.630872420788, 0.4265981595566, 7.419792747688E-13, 2.156188581957, 0.5296909721118, 3.951972655848E-13, 1.981022541805, 1.059381944224, 4.478223877045E-13, 0.0, 0.0};
        static final double[] s2y = new double[]{1.609114495091E-12, 2.831096993481, 0.2061856251104, 1.560330784946E-12, 5.193058213906, 0.2204125344462, 1.183535479202E-12, 5.70700344389, 0.5225775174439, 1.158183066182E-12, 1.782400404928, 0.5368044267797, 1.032868027407E-12, 4.036925452011, 0.2132990797783, 6.540142847741E-13, 4.058241056717, 0.4265981595566, 7.305236491596E-13, 0.6175401942957, 0.5296909721118, -5.580725052968E-13, 0.0, 0.0, 3.946122651015E-13, 0.4108265279171, 1.059381944224};
        static final double[] s2z = new double[]{3.749920358054E-13, 3.230285558668, 0.2132990797783, 2.735037220939E-13, 6.154322683046, 0.5296909721118};

        private SSB() {
        }
    }

    private static final class Ephemeris
    extends SSB {
        static final double[] e0x = new double[]{0.9998292878132, 1.753485171504, 6.283075850446, 0.008352579567414, 1.710344404582, 12.56615170089, 0.005611445335148, 0.0, 0.0, 1.046664295572E-4, 1.66722541677, 18.84922755134, 3.110842534677E-5, 0.6687513390251, 83.99684731857, 2.55241350355E-5, 0.5830637358413, 0.5296909721118, 2.137207845781E-5, 1.092330954011, 1.577343543434, 1.680240182951E-5, 0.4955366134987, 6.279552690824, 1.679012370795E-5, 6.153014091901, 6.286599010068, 1.445526946777E-5, 3.472744100492, 2.352866153506, 1.091038246184E-5, 3.689845786119, 5.223693906222, 9.344399733932E-6, 6.073934645672, 12.03646072878, 8.993182910652E-6, 3.175705249069, 10.21328554739, 5.665546034116E-6, 2.152484672246, 1.059381944224, 6.844146703035E-6, 1.30696409975, 5.753384878334, 7.346610905565E-6, 4.354980070466, 0.3981490189893, 6.815396474414E-6, 2.218229211267, 4.705732307012, 6.112787253053E-6, 5.384788425458, 6.812766822558, 4.518120711239E-6, 6.087604012291, 5.884926831456, 4.521963430706E-6, 1.279424524906, 6.256777527156, 4.497426764085E-6, 5.369129144266, 6.309374173736, 4.062190566959E-6, 0.5436473303367, 6.681224869435, 5.412193480192E-6, 0.7867838528395, 0.775522610072, 5.469839049386E-6, 1.461440311134, 14.14349524433, 5.205264083477E-6, 4.432944696116, 7.86041939388, 2.149759935455E-6, 4.502237496846, 11.50676975667, 2.279109618501E-6, 1.239441308815, 7.058598460518, 2.259282939683E-6, 3.272430985331, 4.69400293411, 2.558950271319E-6, 2.265471086404, 12.1680026819, 2.561581447555E-6, 1.454740653245, 0.7099330490126, 1.78144111544E-6, 2.962068630206, 0.7962980379786, 1.612005874644E-6, 1.473255041006, 5.486777812467, 1.818630667105E-6, 0.3743903293447, 6.283008715021, 1.818601377529E-6, 6.274174354554, 6.28314298587, 1.554475925257E-6, 1.624110906816, 25.13230340178, 2.090948029241E-6, 5.852052276256, 11.79062909082, 2.00017634546E-6, 4.072093298513, 17.78984560711, 1.289535917759E-6, 5.217019331069, 7.079373888424, 1.281135307881E-6, 4.802054538934, 3.738761453707, 1.518229005692E-6, 0.8691914742502, 0.2132990797783, 9.450128579027E-7, 4.60185952995, 10.97707878456, 7.781119494996E-7, 1.844352816694, 8.827390247185, 7.733407759912E-7, 3.58279015475, 5.507553240374, 7.35064431812E-7, 2.69527778823, 1.589072916335, 6.535928827023E-7, 3.651327986142, 11.76985366291, 6.324624183656E-7, 2.241302375862, 6.262300422539, 6.298565300557E-7, 4.407122406081, 6.303851278352, 8.587037089179E-7, 3.024307223119, 167.2837615881, 8.299954491035E-7, 6.192539428237, 3.340612434717, 6.311263503401E-7, 2.014758795416, 0.0071134546679, 6.005646745452E-7, 3.399500503397, 4.136910472696, 7.917715109929E-7, 2.493386877837, 6.069776770667, 7.556958099685E-7, 4.159491740143, 6.496374930224, 6.773228244949E-7, 4.03416293423, 9.437762937313, 5.370708577847E-7, 1.562219163734, 1.194447056968, 5.710804266203E-7, 2.662730803386, 6.282095334605, 5.709824583726E-7, 3.985828430833, 6.284056366286, 5.143950896447E-7, 1.308144688689, 6.290189305114, 5.088010604546E-7, 5.352817214804, 6.275962395778, 4.960369085172E-7, 2.644267922349, 6.127655567643, 4.803137891183E-7, 4.00884419208, 6.438496133249, 5.731747768225E-7, 3.794550174597, 3.154687086868, 4.735947960579E-7, 6.107118308982, 3.128388763578, 4.808348796625E-7, 4.771458618163, 0.8018209333619, 4.115073743137E-7, 3.327111335159, 8.429241228195, 5.230575889287E-7, 5.305708551694, 13.36797263425, 5.133977889215E-7, 5.784230738814, 12.35285262111, 5.065815825327E-7, 2.052064793679, 11.85621865188, 4.339831593868E-7, 3.64499419583, 17.260154635, 3.952928638953E-7, 4.930376436758, 5.481254917084, 4.898498111942E-7, 0.4542084219731, 9.225539266174, 4.757490209328E-7, 3.161126388878, 5.856477690889, 4.727701669749E-7, 0.6214993845446, 2.544314396739, 3.800966681863E-7, 3.040132339297, 0.4265981595566, 3.257301077939E-7, 0.8064977360087, 3.93020969694, 3.255810528674E-7, 1.974147981034, 2.14616537775, 3.252029748187E-7, 2.845924913135, 4.164311961999, 3.255505635308E-7, 3.01790082412, 5.088628793478, 2.80134521199E-7, 6.109717793179, 12.56967486051, 3.68898774097E-7, 2.911550235289, 18.07370494127, 2.475153429458E-7, 2.179146025856, 0.0262983232899, 3.03345774915E-7, 1.994161050744, 4.535059491685, 2.18674376311E-7, 5.125687237936, 11.37170464392, 2.764777032774E-7, 0.4822646860252, 12.56262854127, 2.199028768592E-7, 4.637633293831, 12.55903824622, 2.04648282476E-7, 1.467038733093, 7.084896783808, 2.611209147507E-7, 0.3044718783485, 71.43069561767, 2.286079656818E-7, 4.764220356805, 8.031092209206, 1.855071202587E-7, 3.383637774428, 1.74801635876, 2.324669506784E-7, 6.189088449251, 18.31953657923, 1.709528015688E-7, 0.5874966729774, 4.933208510675, 2.168156875828E-7, 4.302994009132, 10.44738781244, 2.106675556535E-7, 3.800475419891, 7.477522907414, 1.430213830465E-7, 1.294660846502, 2.942463415728, 1.388396901944E-7, 4.594797202114, 8.635942003952, 1.92225884419E-7, 0.4943044543591, 17.29818233119, 1.888460058292E-7, 2.426943912028, 156.1374759853, 1.789449386107E-7, 0.1582973303499, 1.592596075957, 1.360803685374E-7, 5.197240440504, 13.095842673, 1.504038014709E-7, 3.120360916217, 16.49636139783, 1.382769533389E-7, 6.164702888205, 7.632943190217, 1.438059769079E-7, 1.437423770979, 20.42657109477, 1.326303260037E-7, 3.609688799679, 12.13955354133, 1.15924495054E-7, 5.463018167225, 5.331357529664, 1.433118149136E-7, 6.028909912097, 7.342457794669, 1.234623148594E-7, 3.109645574997, 6.2794855554, 1.233949875344E-7, 3.539359332866, 6.286666145492, 9.927196061299E-8, 1.259321569772, 7.234794171227, 1.242302191316E-7, 1.065949392609, 15.11046609763, 1.098402195201E-7, 2.192508743837, 10.98880815746, 1.158191395315E-7, 4.05441127865, 5.729506548653, 9.048475596241E-8, 5.429764748518, 9.623688285163, 8.889853269023E-8, 5.046586206575, 6.148010737701, 1.048694242164E-7, 2.628858030806, 6.836645152238, 1.112308378646E-7, 4.177292719907, 15.72083878776, 8.631729709901E-8, 1.601345232557, 6.41814096319, 8.527816951664E-8, 2.463888997513, 14.71231707864, 7.892139456991E-8, 3.154022088718, 2.118763888447, 1.051782905236E-7, 4.795035816088, 1.349867339771, 1.048219943164E-7, 2.95298339523, 5.999216516294, 7.435760775143E-8, 5.420547991464, 6.04034711426, 9.869574106949E-8, 3.695646753667, 6.566935184597, 9.156886364226E-8, 3.922675306609, 5.643178611111, 7.006834356188E-8, 1.233968624861, 6.525804586632, 9.806170182601E-8, 1.919542280684, 21.22839202813, 9.052289673607E-8, 4.615902724369, 4.690479774488, 7.554200867893E-8, 1.236863719072, 12.5398533776, 8.215741286498E-8, 0.3286800101559, 10.97355562493, 7.185178575397E-8, 5.880942158367, 6.245048154254, 7.13072647618E-8, 0.7674871987661, 6.321103546637, 6.650894461162E-8, 0.6987129150116, 5.327476111629, 7.396888823688E-8, 3.576824794443, 0.5368044267797, 7.420588884775E-8, 5.033615245369, 23.54323048545, 6.141181642908E-8, 0.9449927045673, 12.96430071988, 6.373557924058E-8, 6.206342280341, 0.9517183207817, 6.359474329261E-8, 5.036079095757, 1.990745094947, 5.740173582646E-8, 6.10510637135, 0.9555997388169, 7.019864084602E-8, 0.7237747359018, 0.5225775174439, 6.398054487042E-8, 3.976367969666, 24.07292145756, 7.797092650498E-8, 4.305423910623, 22.0039146382, 6.4667600009E-8, 3.5001368252, 5.23080736089, 7.52941704389E-8, 3.5147792461, 18.42262939178, 6.924571140892E-8, 2.743457928679, 0.1554202828031, 6.220798650222E-8, 2.242598118209, 18.45107853235, 5.870209391853E-8, 2.332832707527, 0.6398972393349, 6.263953473888E-8, 2.191105358956, 6.277552955062, 6.257781390012E-8, 4.457559396698, 6.288598745829, 5.697304945123E-8, 3.499234761404, 1.551045220144, 6.335438746791E-8, 0.6441691079251, 5.216580451554, 6.377258441152E-8, 2.252599151092, 5.650292065779, 6.484841818165E-8, 1.992812417646, 0.1030928125552, 4.73555148525E-8, 3.744672082942, 14.31416805965, 4.62859599617E-8, 1.334226211745, 0.5535693017924, 6.258152336933E-8, 4.395836159154, 26.0879031406, 6.196171366594E-8, 2.587043007997, 84.67247584405, 6.159556952126E-8, 4.782499769128, 239.4243902548, 4.987741172394E-8, 0.7312257619924, 77.71377146812, 5.459280703142E-8, 3.001376372532, 6.17998303789, 4.863461189999E-8, 3.767222128541, 90.27992316901, 5.349912093158E-8, 3.663594450273, 6.386168663001, 5.673725607806E-8, 4.331187919049, 6.915859635113, 4.745485060512E-8, 5.816195745518, 6.282970628506, 4.745379005326E-8, 0.8323672435672, 6.283181072386, 4.049002796321E-8, 3.785023976293, 6.254626709878, 4.247084014515E-8, 2.378220728783, 7.875671926403, 4.026912363055E-8, 2.864103423269, 6.311524991013, 4.062935011774E-8, 2.415408595975, 3.634620989887, 5.347771048509E-8, 3.343479309801, 25.15860172507, 4.829494136505E-8, 2.821742398262, 5.760498333002, 4.342554404599E-8, 5.624662458712, 7.238675589263, 4.021599184361E-8, 0.5557250275009, 11.01510648075, 4.104900474558E-8, 3.296691780005, 6.709674010002, 4.376532905131E-8, 3.814443999443, 6.80565336789, 3.31459048065E-8, 3.56022918925, 12.59245002418, 3.232421839643E-8, 5.185389180568, 1.066495398892, 3.541176318876E-8, 3.921381909679, 9.917696840332, 3.689831242681E-8, 4.190658955386, 11.92625446156, 3.890605376774E-8, 5.546023371097, 0.0747816656905, 3.03855933978E-8, 6.231032794494, 12.56621883632, 3.137083969782E-8, 6.20706341919, 4.292330755499, 4.024004081854E-8, 1.195257375713, 13.34167431096, 3.300234879283E-8, 1.804694240998, 10.57540660594, 3.635399155575E-8, 5.5978113435, 6.208294184755, 3.032668691356E-8, 3.19105936653, 18.05292951336, 2.809652069058E-8, 4.09434803257, 0.003523159621801, 3.696955383823E-8, 5.219282738794, 5.966683958112, 3.562894142503E-8, 1.037247544554, 6.357857516136, 3.510598524148E-8, 1.430020816116, 6.599467742779, 3.617736142953E-8, 3.002911403677, 6.019991944201, 2.62452491073E-8, 2.437046757292, 6.702560555334, 2.53582420449E-8, 1.581594689647, 31.41537925223, 3.519787226257E-8, 5.379863121521, 250.5706758577, 2.578406709982E-8, 4.904222639329, 16.73046366289, 3.423887981473E-8, 3.646448997315, 6.546159756691, 2.776083886467E-8, 3.307829300144, 12.72157198369, 3.379592818379E-8, 1.747541251125, 14.94531617769, 3.050255426284E-8, 0.01784689432607, 4.732030630302, 2.652378350236E-8, 4.42005527626, 5.863591145557, 2.374498173768E-8, 3.629773929208, 2.388894113936, 2.71645125514E-8, 3.07962370678, 12.02934727411, 3.038583699229E-8, 0.3312487903507, 12.56608456547, 2.22068122876E-8, 5.265520401774, 13.36244973887, 3.044156540912E-8, 4.76666408125, 29.08881142201, 2.731859923561E-8, 5.069146530691, 13.91601904066, 2.285603018171E-8, 5.954935112271, 6.076890225335, 2.025006454555E-8, 4.061789589267, 4.701116388778, 2.012597519804E-8, 2.485047705241, 6.262720680387, 2.003406962258E-8, 4.16377920932, 6.303431020504, 2.207863441371E-8, 0.6923839133828, 6.489261475556, 2.481374305624E-8, 5.944173595676, 12.04357418345, 2.13092328887E-8, 4.641013671967, 5.746271423666, 2.446370543391E-8, 6.125796518757, 0.149563331381, 1.932492759052E-8, 0.2234572324504, 13.52175143971, 2.600122568049E-8, 4.28101240544, 4.590910121555, 2.431754047488E-8, 0.142994387487, 1.162474756779, 1.875902869209E-8, 0.9781803816948, 6.27919443241, 1.874381139426E-8, 5.670368130173, 6.286957268481, 2.156696047173E-8, 2.008985006833, 18.13929450232, 1.965076182484E-8, 0.2566186202453, 4.686889479442, 2.334816372359E-8, 4.408121891493, 10.02183730415, 1.869937408802E-8, 5.272745038656, 0.2427287361862, 2.436236460883E-8, 4.407720479029, 95.14313292143, 1.761365216611E-8, 0.1943892315074, 13.51787002167, 2.156289480503E-8, 1.418570924545, 6.037244212485, 2.164748979255E-8, 4.72460343943, 23.01353951334, 2.222286670853E-8, 2.400266874598, 12.66924451345, 2.070901414929E-8, 5.230348028732, 6.528907488406, 1.79274517702E-8, 2.099190328945, 6.819880277225, 1.841802068445E-8, 0.3467527844848, 65.14761976723, 1.578401631718E-8, 0.709864235634, 0.0207754279066, 1.561690152531E-8, 5.943349620372, 6.272439236156, 1.558591045463E-8, 0.704065347898, 6.293712464735, 1.737356469576E-8, 4.487064760345, 17.65478049437, 1.434755619991E-8, 2.993391570995, 0.1102062672231, 1.482187806654E-8, 2.278049198251, 1.052268489556, 1.424812827089E-8, 1.682114725827, 13.11972100268, 1.380282448623E-8, 3.262668602579, 10.17725758696, 1.811481244566E-8, 3.187771221777, 18.87552587463, 1.504446185696E-8, 5.650162308647, 0.0762658362624, 1.740776154137E-8, 5.487068607507, 19.6510484847, 1.374339536251E-8, 5.745688172201, 6.016468784579, 1.761377477704E-8, 5.748060203659, 25.93412433514, 1.535138225795E-8, 6.22684850579, 9.411464614024, 1.788140543676E-8, 6.189318878563, 33.01902111895, 1.375002807996E-8, 5.371812884394, 0.632783784667, 1.242115758632E-8, 1.471687569712, 3.89418173651, 1.450977333938E-8, 4.143836662127, 12.77945078067, 1.297579575023E-8, 0.9003477661957, 6.549682916313, 1.462667934821E-8, 5.760505536428, 18.63592847156, 1.381774374799E-8, 1.085471729463, 2.379164476796, 1.682333169307E-8, 5.409870870133, 16.20077269078, 1.190812918837E-8, 1.397205174601, 11.499656302, 1.221434762106E-8, 0.9001804809095, 12.57326515556, 1.54993464486E-8, 4.262528275544, 18.209330312, 1.25213895305E-8, 1.411642012027, 6.993008899458, 1.237078905387E-8, 2.844472403615, 24.35678079171, 1.446953389615E-8, 5.295835522223, 0.0381329181312, 1.38844645717E-8, 4.969428135497, 0.2458316379602, 1.019339179228E-8, 2.491369561806, 6.112403035119, 1.258880815343E-8, 4.679426248976, 5.429879531333, 1.297768238261E-8, 1.074509953328, 12.4913700352, 9.913505718094E-9, 4.735097918224, 6.247047890016, 9.830453155969E-9, 4.158649187338, 6.453748665772, 1.192615865309E-8, 3.438208613699, 6.290122169689, 9.835874798277E-9, 1.913300781229, 6.319103810876, 9.639087569277E-9, 0.9487683644125, 8.273820945392, 1.175716107001E-8, 3.228141664287, 6.276029531202, 1.018926508678E-8, 2.2166078543, 12.54537627298, 9.500087869225E-9, 2.625116459733, 12.56517118505, 9.664192916575E-9, 5.860562449214, 6.259197520765, 9.612858712203E-9, 0.7885682917381, 6.306954180126, 1.117645675413E-8, 3.932148831189, 17.79695906178, 1.15886405216E-8, 0.9995605521691, 17.78273215245, 9.021043467028E-9, 5.263769742673, 6.172869583223, 8.836134773563E-9, 1.496843220365, 1.692165728891, 1.045872200691E-8, 0.7009039517214, 0.2204125344462, 1.211463487798E-8, 4.041544938511, 82.57698122054, 8.541990804094E-9, 1.447586692316, 6.393282117669, 1.038720703636E-8, 0.4594249718112, 15.50861511662, 1.126722351445E-8, 3.925550579036, 0.2061856251104, 8.697373859631E-9, 4.411341856037, 0.9491756770005, 8.869380028441E-9, 2.402659724813, 3.90391137365, 9.247014693258E-9, 1.401579743423, 6.267823317922, 9.20506293095E-9, 5.245978000814, 6.298328382969, 8.000745038049E-9, 3.590803356945, 2.648454860559, 9.168973650819E-9, 2.470150501679, 149.8544001348, 1.075444949238E-8, 1.32860616123, 36.94923081589, 7.817298525817E-9, 6.162256225998, 4.804209201333, 9.541469226356E-9, 3.942568967039, 12.56713221673, 9.821910122027E-9, 0.2360246287233, 11.40367694411, 9.897822023777E-9, 4.61980563428, 22.80573557157, 7.737289283765E-9, 3.784727847451, 7.83412107059, 9.26020403471E-9, 2.223352487601, 2.787043132925, 7.320252888486E-9, 1.288694636874, 6.282655592598, 7.319785780946E-9, 5.359869567774, 6.283496108294, 7.147219933778E-9, 5.516616675856, 17.25663147538, 7.946502829878E-9, 2.630459984567, 12.41073141809, 9.001711808932E-9, 2.849815827227, 6.281591679874, 8.994041507257E-9, 3.79524445075, 6.284560021018, 8.298582787358E-9, 0.5236413127363, 12.41658836951, 8.52659652071E-9, 4.794605424426, 10.98419223922, 8.209822103197E-9, 1.578752370328, 10.96996532989, 6.357049861094E-9, 5.708926113761, 1.596186371003, 7.370473179049E-9, 3.842402530241, 4.061219149443, 7.232154664726E-9, 3.067548981535, 161.0006857377, 6.328765494903E-9, 1.313930030069, 11.93336791622, 8.030064908595E-9, 3.488500408886, 0.8460828644453, 6.275464259232E-9, 1.532061626198, 0.8531963191132, 7.051897446325E-9, 3.285859929993, 5.849364236221, 6.161593705428E-9, 1.477341999464, 5.573142801433, 7.754683957278E-9, 1.586118663096, 8.662240327241, 5.889928990701E-9, 1.304887868803, 12.32342296471, 5.705756047075E-9, 4.55533358935, 12.5869271288, 5.964178808332E-9, 3.001762842062, 5.333900173445, 6.712446027467E-9, 4.886780007595, 11.71295538178, 5.941809275464E-9, 4.701509603824, 9.779108567966, 5.466993627395E-9, 4.588357817278, 18.84211409667, 6.34051209098E-9, 1.164543038893, 52.1758062812, 6.325505710045E-9, 3.919171259645, 10.41998632314, 6.164789509685E-9, 2.143828253542, 6.151533897323, 5.26333081243E-9, 6.066564434241, 18.85275071096, 5.597087780221E-9, 2.926316429472, 0.4337116142245, 5.396556236817E-9, 3.244303591505, 6.286362197481, 5.396615148223E-9, 3.404304703662, 6.27978950341, 7.091832443341E-9, 0.8532377803192, 4.907302013889, 6.572352589782E-9, 4.901966774419, 11.76433076753, 5.960236060795E-9, 1.874672315797, 0.0142269093358, 5.125480043511E-9, 3.735726064334, 12.45594543367, 5.92824186641E-9, 4.502033899935, 6.414617803568, 5.249600357424E-9, 4.372334799878, 11.51388321134, 6.059171276087E-9, 2.581617302908, 6.062663316, 5.295235081662E-9, 2.974811513158, 3.496032717521, 5.820561875933E-9, 0.1796073748244, 0.2838593341516, 4.75469660644E-9, 1.981998136973, 3.104930017775, 6.385053548955E-9, 0.2559174171605, 6.133512519065, 6.589828273941E-9, 2.750967106776, 40.87944051283, 5.383376567189E-9, 0.6325947523578, 22.48384854122, 5.928941683538E-9, 1.672304519067, 1.581959461667, 4.816060709794E-9, 3.512566172575, 9.388005868221, 6.003381586512E-9, 5.610932219189, 5.326786718777, 5.504225393105E-9, 4.037501131256, 6.503488384892, 5.353772620129E-9, 6.12277496824, 173.5668374386, 5.786253768544E-9, 5.527984999515, 0.1350651127443, 5.065706702002E-9, 0.9980765573624, 12.48988586463, 5.972838885276E-9, 6.044489493203, 26.73594526851, 5.323585877961E-9, 3.924265998147, 4.171425416666, 5.210772682858E-9, 6.220111376901, 24.60261242967, 4.726549040535E-9, 3.716043206862, 7.232251527446, 6.029425105059E-9, 0.8548704071116, 322.7113045244, 4.481542826513E-9, 1.426925072829, 5.547199253223, 5.836024505068E-9, 0.07135651752625, 72.8505617157, 4.137046613272E-9, 5.330767643283, 10.873985972, 5.171977473924E-9, 0.4494262335353, 18.84570439172, 5.694429833732E-9, 2.952369582215, 97.23862754494, 4.009158925298E-9, 3.500003416535, 6.244942932314, 4.784939596873E-9, 6.196709413181, 29.29661536378, 3.98372502261E-9, 5.103690031897, 4.274518229222, 3.870535232462E-9, 3.187569587401, 6.321208768577, 5.140501213951E-9, 1.668924357457, 12.32032006293, 3.849034819355E-9, 4.445722510309, 17.26726808967, 4.00238307506E-9, 5.226224152423, 7.018952447668, 3.890719543549E-9, 4.371166550274, 14.9190178544, 4.887084607881E-9, 5.973556689693, 1.478866649112, 3.739939287592E-9, 2.0890847146, 6.922973089781, 5.031925918209E-9, 4.658371936827, 17.15706182245, 4.387748764954E-9, 4.825580552819, 233.1413144044, 4.147398098865E-9, 3.739003524998, 13.76059875786, 3.719089993586E-9, 1.148941386536, 6.297302759782, 3.934238461056E-9, 1.559893008343, 7.872148766781, 3.672471375622E-9, 5.516145383612, 6.26884894111, 3.768911277583E-9, 6.116053700563, 4.157198507331, 4.033388417295E-9, 5.076821746017, 15.67108171867, 3.764194617832E-9, 0.8164676232075, 3.185192151914, 4.840628226284E-9, 1.360479453671, 12.52801878276, 4.949443923785E-9, 2.725622229926, 161.7106187867, 4.117393089971E-9, 0.6054459628492, 5.64219809527, 3.925754020428E-9, 0.857046213521, 21.39354194808, 3.630551757923E-9, 3.552067338279, 6.294805223347, 3.627274802357E-9, 3.096565085313, 6.271346477544, 3.806143885093E-9, 0.6367751709777, 17.25304118033, 4.433254641565E-9, 4.848461503937, 7.445550607224, 3.712319846576E-9, 1.331950643655, 0.4194847048887, 3.849847534783E-9, 0.4958368297746, 0.9562891316684, 3.483955430165E-9, 2.237215515707, 11.61697602389, 3.961912730982E-9, 3.332402188575, 22.77943724828, 3.419978244481E-9, 5.785600576016, 13.62553364512, 3.329417758177E-9, 0.09812676559709, 16.85848245639, 4.207206893193E-9, 0.9494780468236, 29.86433403208, 3.26854897641E-9, 0.1739332095686, 5.749861718712, 3.321880082685E-9, 1.423354800666, 6.27914338782, 4.503173010852E-9, 0.2314972675293, 1.385561574497, 4.316599090954E-9, 0.1012646782616, 4.1760413349, 3.28349332385E-9, 5.233306881265, 6.287008313071, 3.164033542343E-9, 4.005597257511, 20.99539292909, 4.159720956725E-9, 5.36567624202, 5.905702259363, 3.565176892217E-9, 4.284440620612, 0.0039324626253, 3.514440950221E-9, 4.270562636575, 7.335344340001, 3.540596871909E-9, 5.95355320106, 12.34573916645, 2.960769905118E-9, 1.115180417718, 26.70964694522, 2.962213739684E-9, 3.863811918186, 0.6408777551755, 3.883556700251E-9, 1.268617928302, 6.660449441528, 2.919225516346E-9, 4.908605223265, 1.375773836557, 3.11515886337E-9, 3.744519976885, 0.0380276961914, 4.099438144212E-9, 4.173244670532, 44.80965020977, 2.899531858964E-9, 5.91060142885, 20.5972439101, 3.289733429855E-9, 2.488050078239, 10.81813534213, 3.933075612875E-9, 1.122363652883, 0.3773735910827, 3.021403764467E-9, 4.951973724904, 29.82630633589, 2.798598949757E-9, 5.117057845513, 19.37891852345, 3.397421302707E-9, 6.104159180476, 6.923953605621, 3.720398002179E-9, 1.184933429829, 30.66615496545, 3.598484186267E-9, 3.505282086105, 6.147450479709, 3.69459402731E-9, 2.286651088141, 2.636725487657, 2.680444152969E-9, 0.1871816775482, 6.816289982179, 3.497574865641E-9, 3.143251755431, 6.418701221183, 3.130274129494E-9, 2.462167316018, 12.35996607578, 3.241119069551E-9, 4.256374004686, 16.52265972112, 2.601960842061E-9, 4.970362941425, 10.45450126711, 2.690601527504E-9, 2.372657824898, 0.3163918923335, 2.908688152664E-9, 4.232652627721, 28.28699048865, 3.120456131875E-9, 0.3925747001137, 21.95415756911, 3.148855423384E-9, 3.093478330445, 11.72006883645, 3.051044261017E-9, 5.560948248212, 6.055599646783, 2.82600687666E-9, 5.072790310072, 5.120601093667, 3.100034191711E-9, 4.998530231096, 17.99603123222, 2.398771640101E-9, 2.561739802176, 6.255674361143, 2.384002842728E-9, 4.087420284111, 6.310477339748, 2.842146517568E-9, 2.515048217955, 5.469525544182, 2.84767437134E-9, 5.235326497443, 10.34429499989, 2.903722140764E-9, 1.088200795797, 6.510552054109, 3.187610710605E-9, 4.710624424816, 169.3792562116, 3.048869992813E-9, 0.2857975896445, 8.390110365991, 2.860216950984E-9, 2.241619020815, 0.2243449970715, 2.701117683113E-9, 0.06651573305272, 6.129297044991, 2.509891590152E-9, 1.285135324585, 10.44027435778, 2.623200252223E-9, 0.298122983453, 6.436854655901, 2.622541669202E-9, 6.122470726189, 9.380959548977, 2.818435667099E-9, 4.251087148947, 5.93415139993, 2.365196797465E-9, 3.46507046079, 24.70570524223, 2.358704646143E-9, 5.79160381535, 8.671969964381, 2.38829948139E-9, 4.142483772941, 7.096626156709, 1.996041217224E-9, 2.101901889496, 17.2718840079, 2.687593060336E-9, 1.526689456959, 70.75506709219, 2.61891367081E-9, 2.397684236095, 6.632000300961, 2.571523050364E-9, 0.5751929456787, 6.206810014183, 2.582135006946E-9, 5.595464352926, 48.73985990671, 2.372530190361E-9, 5.092689490655, 15.90676413561, 2.357178484712E-9, 4.444363527851, 3.097883698531, 2.451590394723E-9, 3.108251687661, 0.6612329252343, 2.370045949608E-9, 2.608133861079, 34.59636466239, 2.268997267358E-9, 3.639717753384, 0.0284491405673, 1.731432137906E-9, 0.1741898445707, 20.19909489111, 1.629869741622E-9, 3.902225646724, 30.355997308, 2.206215801974E-9, 4.971131250731, 6.281667977667, 2.20546955468E-9, 1.67746235711, 6.284483723224, 2.148792362509E-9, 4.236259604006, 19.80482729015, 1.873733657847E-9, 5.926814998687, 28.76692439167, 2.026573758959E-9, 4.349643351962, 24.49240616245, 1.80777032511E-9, 5.700940482701, 20.45286941806, 1.881174408581E-9, 0.660128636343, 23.58125818164, 1.36802367169E-9, 2.211098592752, 24.73415438279, 1.72001791628E-9, 4.942488551129, 167.9593901136, 1.702427665131E-9, 1.452233856386, 333.8575901272, 1.414032510054E-9, 5.525357721439, 162.4205518357, 1.652626045364E-9, 4.108794283624, 89.56999012, 1.642957769686E-9, 0.7344335209984, 52.67006960365, 1.614952403624E-9, 3.541213951363, 33.32657872986, 1.535988291188E-9, 4.031094072151, 38.52657435933, 1.593193738177E-9, 4.185136203609, 228.2781046519, 1.074569126382E-9, 1.720485636868, 83.97383534231, 1.074408214509E-9, 2.758613420318, 84.01985929482, 9.700199670465E-10, 4.216686842097, 78.2637094218, 1.258433517061E-9, 0.2575068876639, 311.5650189215, 1.240303229539E-9, 0.4800844956756, 178.430047191, 9.018345948127E-10, 0.3896756361552, 58.86454391678, 1.135301432805E-9, 0.370080502355, 78.42370451713, 9.21588795137E-10, 4.364579276638, 101.4262087719, 1.055401054147E-9, 2.156564222111, 56.60027930059, 1.008725979831E-9, 5.454015785234, 42.45678405627, 7.217398104321E-10, 1.597772562175, 245.7074661053, 6.912033134447E-10, 5.824090621461, 167.9936946371, 6.833881523549E-10, 3.578778482835, 60.53048899753, 4.887304205142E-10, 3.724362812423, 96.56299901946, 5.173709754788E-10, 5.422427507933, 244.2876000072, 4.671353097145E-10, 2.396106924439, 143.5713242844, 5.65260843948E-10, 2.804028838685, 83.65903305582, 5.604061331253E-10, 1.638816006247, 84.33466158131, 4.7127233654E-10, 0.8979003224474, 316.4282286739, 4.909967465112E-10, 3.210426725516, 405.9982187939, 4.771358267658E-10, 5.308027211629, 180.5255418145, 3.943451445989E-10, 2.195145341074, 256.8537517081, 3.952109120244E-10, 5.081189491586, 244.9975330562, 3.788134594789E-10, 4.345171264441, 156.8131045107, 3.738330190479E-10, 2.613062847997, 394.851933191, 3.099866678136E-10, 2.846760817689, 154.7176098872, 2.002962716768E-10, 4.921360989412, 226.8582385539, 2.198291338754E-10, 0.1130360117454, 165.8638954901, 1.491958330784E-10, 4.228195232278, 221.9950288015, 1.475384076173E-10, 0.3005721811604, 305.281943071, 1.661626624624E-10, 0.7830125621203, 252.6661704812, 9.015823460025E-11, 3.807792942715, 417.1445043968};
        static final double[] e0y = new double[]{0.9998921098898, 0.1826583913846, 6.283075850446, -0.02442700893735, 0.0, 0.0, 0.008352929742915, 0.139527799868, 12.56615170089, 1.046697300177E-4, 0.09641423109763, 18.84922755134, 3.110841876663E-5, 5.381140401712, 83.99684731857, 2.570269094593E-5, 5.301016407128, 0.5296909721118, 2.14738962361E-5, 2.66251086985, 1.577343543434, 1.68034438405E-5, 5.207904119704, 6.279552690824, 1.679117312193E-5, 4.582187486968, 6.286599010068, 1.44051206844E-5, 1.900688517726, 2.352866153506, 1.135139664999E-5, 5.273108538556, 5.223693906222, 9.345482571018E-6, 4.503047687738, 12.03646072878, 9.007418719568E-6, 1.605621059637, 10.21328554739, 5.671536712314E-6, 0.5812849070861, 1.059381944224, 7.451401861666E-6, 2.807346794836, 0.3981490189893, 6.393470057114E-6, 6.029224133855, 5.753384878334, 6.814275881697E-6, 0.6472990145974, 4.705732307012, 6.113705628887E-6, 3.8138434197, 6.812766822558, 4.503851367273E-6, 4.527804370996, 5.884926831456, 4.522249141926E-6, 5.991783029224, 6.256777527156, 4.501794307018E-6, 3.798703844397, 6.309374173736, 5.51492748018E-6, 3.961257833388, 5.507553240374, 4.062862799995E-6, 5.256247296369, 6.681224869435, 5.414900429712E-6, 5.499032014097, 0.775522610072, 5.463153987424E-6, 6.173092454097, 14.14349524433, 5.071611859329E-6, 2.870244247651, 7.86041939388, 2.195112094455E-6, 2.952338617201, 11.50676975667, 2.279139233919E-6, 5.951775132933, 7.058598460518, 2.278386100876E-6, 4.845456398785, 4.69400293411, 2.559088003308E-6, 0.6945321117311, 12.1680026819, 2.561079286856E-6, 6.167224608301, 0.7099330490126, 1.792755796387E-6, 1.400122509632, 0.7962980379786, 1.818715656502E-6, 4.70334761183, 6.28314298587, 1.818744924791E-6, 5.086748900237, 6.283008715021, 1.55451879139E-6, 0.05331008042713, 25.13230340178, 2.063265737239E-6, 4.283680484178, 11.79062909082, 1.497613520041E-6, 6.074207826073, 5.486777812467, 2.000617940427E-6, 2.50142628145, 17.78984560711, 1.28973119558E-6, 3.646340599536, 7.079373888424, 1.282657998934E-6, 3.232864804902, 3.738761453707, 1.528915968658E-6, 5.581433416669, 0.2132990797783, 1.187304098432E-6, 5.453576453694, 9.437762937313, 7.842782928118E-7, 0.2823953922273, 8.827390247185, 7.352892280868E-7, 1.124369580175, 1.589072916335, 6.570189360797E-7, 2.08915404284, 11.76985366291, 6.32496759041E-7, 0.670485558123, 6.262300422539, 6.298289872283E-7, 2.83641485584, 6.303851278352, 6.476686465855E-7, 0.4852433866467, 0.0071134546679, 8.587034651234E-7, 1.453511005668, 167.2837615881, 8.068948788113E-7, 0.9224087798609, 6.069776770667, 8.353786011661E-7, 4.631707184895, 3.340612434717, 6.009324532132E-7, 1.829498827726, 4.136910472696, 7.558158559566E-7, 2.588596800317, 6.496374930224, 5.809279504503E-7, 0.5516818853476, 10.97707878456, 5.374131950254E-7, 6.27567473496, 1.194447056968, 5.711160507326E-7, 1.091905956872, 6.282095334605, 5.710183170746E-7, 2.41500163509, 6.284056366286, 5.14437359061E-7, 6.020336443438, 6.290189305114, 5.103108927267E-7, 3.775634564605, 6.275962395778, 4.960654697891E-7, 1.073450946756, 6.127655567643, 4.78638568928E-7, 2.43117801231, 6.438496133249, 6.109911263665E-7, 5.343356157914, 3.154687086868, 4.839898944024E-7, 0.05830833594047, 0.8018209333619, 4.734822623919E-7, 4.536080134821, 3.128388763578, 4.83474147329E-7, 0.2585090489754, 7.084896783808, 5.134858581156E-7, 4.213317172603, 12.35285262111, 5.064004264978E-7, 0.4814418806478, 11.85621865188, 3.753476772761E-7, 1.599953399788, 8.429241228195, 4.935264014283E-7, 2.157417556873, 2.544314396739, 3.950929600897E-7, 3.359394184254, 5.481254917084, 4.895849789777E-7, 5.165704376558, 9.225539266174, 4.215241688886E-7, 2.065368800993, 17.260154635, 3.796773731132E-7, 1.468606346612, 0.4265981595566, 3.114178142515E-7, 3.615638079474, 2.14616537775, 3.260664220838E-7, 4.417134922435, 4.164311961999, 3.976996123008E-7, 4.700866883004, 5.856477690889, 2.801459672924E-7, 4.538902060922, 12.56967486051, 3.638931868861E-7, 1.334197991475, 18.07370494127, 2.487013269476E-7, 3.749275558275, 0.0262983232899, 3.034165481994E-7, 0.4236622030873, 4.535059491685, 2.676278825586E-7, 5.970848007811, 3.93020969694, 2.764903818918E-7, 5.194636754501, 12.56262854127, 2.485149930507E-7, 1.002434207846, 5.088628793478, 2.199305540941E-7, 3.066773098403, 12.55903824622, 2.571106500435E-7, 0.7588312459063, 13.36797263425, 2.049751817158E-7, 3.444977434856, 11.37170464392, 2.599707296297E-7, 1.873128542205, 71.43069561767, 1.785018072217E-7, 5.015891306615, 1.74801635876, 2.324833891115E-7, 4.61827123973, 18.31953657923, 1.709711119545E-7, 5.300003455669, 4.933208510675, 2.107159351716E-7, 2.229819815115, 7.477522907414, 1.750333080295E-7, 6.161485880008, 10.44738781244, 2.000598210339E-7, 2.967357299999, 8.031092209206, 1.380920248681E-7, 3.027007923917, 8.635942003952, 1.412460470299E-7, 6.037597163798, 2.942463415728, 1.888459803001E-7, 0.8561476243374, 156.1374759853, 1.788370542585E-7, 4.869736290209, 1.592596075957, 1.360893296167E-7, 3.626411886436, 13.095842673, 1.50684653016E-7, 1.550975377427, 16.49636139783, 1.800913376176E-7, 2.07582603319, 17.29818233119, 1.436261390649E-7, 6.148876420255, 20.42657109477, 1.220227114151E-7, 4.382583879906, 7.632943190217, 1.337883603592E-7, 2.036644327361, 12.13955354133, 1.159326650738E-7, 3.892276994687, 5.331357529664, 1.352853128569E-7, 1.447950649744, 16.73046366289, 1.433408296083E-7, 4.457854692961, 7.342457794669, 1.234701666518E-7, 1.538818147151, 6.2794855554, 1.234027192007E-7, 1.96852322076, 6.286666145492, 1.244024091797E-7, 5.779803499985, 15.11046609763, 1.097934945516E-7, 0.6210975221388, 10.98880815746, 1.254611329856E-7, 2.591963807998, 15.72083878776, 1.158247286784E-7, 2.48361281267, 5.729506548653, 9.03907825296E-8, 3.857554579796, 9.623688285163, 9.108024978836E-8, 5.826368512984, 7.234794171227, 8.887068108436E-8, 3.475694573987, 6.148010737701, 8.632374035438E-8, 0.03059070488983, 6.41814096319, 7.893186992967E-8, 1.583194837728, 2.118763888447, 8.297650201172E-8, 0.8519770534637, 14.71231707864, 1.019759578988E-7, 0.1319598738732, 1.349867339771, 1.010037696236E-7, 0.9937860115618, 6.836645152238, 1.047727548266E-7, 1.382138405399, 5.999216516294, 7.351993881086E-8, 3.833397851735, 6.04034711426, 9.868771092341E-8, 2.12491381439, 6.566935184597, 7.00732195939E-8, 5.946305343763, 6.525804586632, 6.861411679709E-8, 4.574654977089, 7.238675589263, 7.554519809614E-8, 5.949232686844, 12.5398533776, 9.541880448335E-8, 3.495242990564, 21.22839202813, 7.185606722155E-8, 4.310113471661, 6.245048154254, 7.13136087171E-8, 5.48030932365, 6.321103546637, 6.651142021039E-8, 5.411097713654, 5.327476111629, 8.538618213667E-8, 1.827849973951, 11.01510648075, 8.634954288044E-8, 5.443584943349, 5.643178611111, 7.449415051484E-8, 2.01153545906, 0.5368044267797, 7.421047599169E-8, 3.464562529249, 23.54323048545, 6.140694354424E-8, 5.657556228815, 12.96430071988, 6.353525143033E-8, 3.463816593821, 1.990745094947, 6.221964013447E-8, 1.532259498697, 0.9517183207817, 5.852480257244E-8, 1.375396598875, 0.9555997388169, 6.398637498911E-8, 2.405645801972, 24.07292145756, 7.039744069878E-8, 5.397541799027, 0.5225775174439, 6.977997694382E-8, 4.762347105419, 10.97355562493, 7.460629558396E-8, 2.711944692164, 22.0039146382, 5.376577536101E-8, 2.352980430239, 14.31416805965, 7.530607893556E-8, 1.943940180699, 18.42262939178, 6.822928971605E-8, 4.337651846959, 0.1554202828031, 6.220772380094E-8, 0.6716871369278, 18.45107853235, 6.586950799043E-8, 2.229714460505, 5.216580451554, 5.873800565771E-8, 0.762701392058, 0.6398972393349, 6.264346929745E-8, 0.6202785478961, 6.277552955062, 6.257929115669E-8, 2.886775596668, 6.288598745829, 5.343536033409E-8, 1.977241012051, 4.690479774488, 5.587849781714E-8, 1.922923484825, 1.551045220144, 6.905100845603E-8, 3.570757164631, 0.1030928125552, 6.178957066649E-8, 5.197558947765, 5.23080736089, 6.187270224331E-8, 0.8193497368922, 5.650292065779, 5.385664291426E-8, 5.406336665586, 77.71377146812, 6.329363917926E-8, 2.837760654536, 26.0879031406, 4.546018761604E-8, 2.93358029705, 0.5535693017924, 6.196091049375E-8, 4.157871494377, 84.67247584405, 6.159555108218E-8, 3.211703561703, 239.4243902548, 4.995340539317E-8, 1.459098102922, 4.732030630302, 5.457031243572E-8, 1.430457676136, 6.17998303789, 4.863461418397E-8, 2.19642591673, 90.27992316901, 5.34294762687E-8, 2.086612890268, 6.386168663001, 5.674296648439E-8, 2.760204966535, 6.915859635113, 4.745783120161E-8, 4.245368971862, 6.282970628506, 4.745676961198E-8, 5.544725787016, 6.283181072386, 4.049796869973E-8, 2.213984363586, 6.254626709878, 4.24833359694E-8, 0.8075781952896, 7.875671926403, 4.027178070205E-8, 1.293268540378, 6.311524991013, 4.066543943476E-8, 3.986141175804, 3.634620989887, 4.85886378788E-8, 1.276112738231, 5.760498333002, 5.27739826353E-8, 4.916111741527, 25.15860172507, 4.105635656559E-8, 1.725805864426, 6.709674010002, 4.376781925772E-8, 2.243642442106, 6.80565336789, 3.235827894693E-8, 3.614135118271, 1.066495398892, 3.073244740308E-8, 2.46087339346, 5.863591145557, 3.088609271373E-8, 5.67843177179, 9.917696840332, 3.393022279836E-8, 3.814017477291, 13.91601904066, 3.038686508802E-8, 4.660216229171, 12.56621883632, 4.019677752497E-8, 5.906906243735, 13.34167431096, 3.288834998232E-8, 0.9536146445882, 16.20077269078, 3.889973794631E-8, 3.942205097644, 0.0747816656905, 3.050438987141E-8, 1.624810271286, 18.05292951336, 3.601142564638E-8, 4.030467142575, 6.208294184755, 3.689015557141E-8, 3.648878818694, 5.966683958112, 3.563471893565E-8, 5.749584017096, 6.357857516136, 2.776183170667E-8, 2.63012418707, 0.003523159621801, 2.922350530341E-8, 1.790346403629, 12.72157198369, 3.511076917302E-8, 6.142198301611, 6.599467742779, 3.619351007632E-8, 1.432421386492, 6.019991944201, 2.561254711098E-8, 2.302822475792, 12.59245002418, 2.62690394292E-8, 0.8660470994571, 6.702560555334, 2.550187397083E-8, 6.069721995383, 10.57540660594, 2.535873526138E-8, 0.01079020331795, 31.41537925223, 3.519786153847E-8, 3.809066902283, 250.5706758577, 3.424651492873E-8, 2.075435114417, 6.546159756691, 2.372676630861E-8, 2.057803120154, 2.388894113936, 2.710980779541E-8, 1.51006848801, 12.02934727411, 3.038710889704E-8, 5.043617528901, 12.56608456547, 2.220364130585E-8, 3.694793218205, 13.36244973887, 3.02588082546E-8, 0.05450618999049, 29.08881142201, 2.784493486864E-8, 3.381164084502, 14.94531617769, 2.294414142438E-8, 4.38230902521, 6.076890225335, 2.012723294724E-8, 0.9142212256518, 6.262720680387, 2.036357831958E-8, 5.676172293154, 4.701116388778, 2.003474823288E-8, 2.592767977625, 6.303431020504, 2.207144900109E-8, 5.40497627118, 6.489261475556, 2.481664905135E-8, 4.373284587027, 12.04357418345, 2.674949182295E-8, 5.859182188482, 4.590910121555, 2.450554720322E-8, 4.555381557451, 0.149563331381, 2.601975986457E-8, 3.933165584959, 19.6510484847, 2.199860022848E-8, 5.227977189087, 13.51787002167, 2.448121172316E-8, 4.858060353949, 1.162474756779, 1.876014864049E-8, 5.690546553605, 6.27919443241, 1.874513219396E-8, 4.099539297446, 6.286957268481, 2.156380842559E-8, 0.4382594769913, 18.13929450232, 1.981691240061E-8, 1.829784152444, 4.686889479442, 2.329992648539E-8, 2.836254278973, 10.02183730415, 1.765184135302E-8, 2.803494925833, 4.292330755499, 2.436368366085E-8, 2.836897959677, 95.14313292143, 2.164089203889E-8, 6.127522446024, 6.037244212485, 1.847755034221E-8, 3.683163635008, 0.2427287361862, 1.674798769966E-8, 0.3316993867246, 13.11972100268, 2.222542124356E-8, 0.829409780548, 12.66924451345, 2.071074505925E-8, 3.659492220261, 6.528907488406, 1.608224471835E-8, 4.774492067182, 13.52175143971, 1.857583439071E-8, 2.873120597682, 8.662240327241, 1.793018836159E-8, 0.5282441177929, 6.819880277225, 1.575391221692E-8, 1.320789654258, 0.1102062672231, 1.840132009557E-8, 1.917110916256, 65.14761976723, 1.760917288281E-8, 2.972635937132, 5.746271423666, 1.561779518516E-8, 4.372569261981, 6.272439236156, 1.558687885205E-8, 5.416424926425, 6.293712464735, 1.951359382579E-8, 3.094448898752, 23.01353951334, 1.569144275614E-8, 2.802103689808, 17.65478049437, 1.479130389462E-8, 2.136435020467, 0.0207754279066, 1.467828510764E-8, 0.7072627435674, 1.052268489556, 1.62762733744E-8, 3.947607143237, 0.632783784667, 1.503498479758E-8, 4.07924890919, 0.0762658362624, 1.297967708237E-8, 6.26963712284, 11.499656302, 1.374416896634E-8, 4.175657970702, 6.016468784579, 1.783812325219E-8, 1.47654054756, 33.01902111895, 1.525884228756E-8, 4.653477715241, 9.411464614024, 1.451067396763E-8, 2.573001128225, 12.77945078067, 1.29771311195E-8, 5.612799618771, 6.549682916313, 1.46278401282E-8, 4.18966162387, 18.63592847156, 1.384185980007E-8, 2.656915472196, 2.379164476796, 1.221497599801E-8, 5.612515760138, 12.57326515556, 1.560574525896E-8, 4.783414317919, 18.87552587463, 1.544598372036E-8, 2.694431138063, 18.209330312, 1.531678928696E-8, 4.105103489666, 25.93412433514, 1.349321503795E-8, 0.3082437194015, 5.120601093667, 1.252030290917E-8, 6.124072334087, 6.993008899458, 1.459243816687E-8, 3.733103981697, 0.0381329181312, 1.226103625262E-8, 1.267127706817, 24.35678079171, 1.019449641504E-8, 4.367790112269, 17.25663147538, 1.380789433607E-8, 3.3872017687, 0.2458316379602, 1.019453421658E-8, 0.9204143073737, 6.112403035119, 1.297929434405E-8, 5.786874896426, 12.4913700352, 9.912677786097E-9, 3.164232870746, 6.247047890016, 9.829386098599E-9, 2.586762413351, 6.453748665772, 1.226807746104E-8, 6.239068436607, 5.429879531333, 1.192691755997E-8, 1.867380051424, 6.290122169689, 9.836499227081E-9, 0.3424716293727, 6.319103810876, 9.642862564285E-9, 5.661372990657, 8.273820945392, 1.165184404862E-8, 5.768367239093, 17.78273215245, 1.175794418818E-8, 1.657351222943, 6.276029531202, 1.018948635601E-8, 0.6458292350865, 12.54537627298, 9.500383606676E-9, 1.054306140741, 12.56517118505, 1.227512202906E-8, 2.505278379114, 22.48384854122, 9.664792009993E-9, 4.289737277, 6.259197520765, 9.613285666331E-9, 5.500597673141, 6.306954180126, 1.117906736211E-8, 2.361405953468, 17.79695906178, 9.611378640782E-9, 2.851310576269, 0.2061856251104, 8.84535485237E-9, 6.208777705343, 1.692165728891, 1.0540469666E-8, 5.413091423934, 0.2204125344462, 1.215539124483E-8, 5.613969479755, 82.57698122054, 9.932460955209E-9, 1.106124877015, 10.17725758696, 8.785804715043E-9, 2.869224476477, 0.9491756770005, 8.538084097562E-9, 6.159640899344, 6.393282117669, 8.648994369529E-9, 1.374901198784, 4.804209201333, 1.039063219067E-8, 5.171080641327, 15.50861511662, 8.867983926439E-9, 0.8317320304902, 3.90391137365, 8.327495955244E-9, 3.60559196918, 6.172869583223, 9.243088356133E-9, 6.114299196843, 6.267823317922, 9.205657357835E-9, 3.675153683737, 6.298328382969, 1.033269714606E-8, 3.313328813024, 5.573142801433, 8.001706275552E-9, 2.019980960053, 2.648454860559, 9.171858254191E-9, 0.8992015524177, 149.8544001348, 1.075327150242E-8, 2.898669963648, 36.94923081589, 9.884866689828E-9, 4.946715904478, 11.40367694411, 9.541835576677E-9, 2.371787888469, 12.56713221673, 7.739903376237E-9, 2.213775190612, 7.83412107059, 7.311962684106E-9, 3.429378787739, 11.92625446156, 9.724904869624E-9, 6.195878564404, 22.80573557157, 9.251628983612E-9, 0.651150952739, 2.787043132925, 7.320763787842E-9, 6.001083639421, 6.282655592598, 7.320296650962E-9, 3.789073265087, 6.283496108294, 7.947032271039E-9, 1.059659582204, 12.41073141809, 9.005277053115E-9, 1.280315624361, 6.281591679874, 8.995601652048E-9, 2.224439106766, 6.284560021018, 8.288040568796E-9, 5.234914433867, 12.41658836951, 6.359381347255E-9, 4.13798944149, 1.596186371003, 8.699572228626E-9, 1.758411009497, 6.133512519065, 6.456797542736E-9, 5.919285089994, 16.85848245639, 7.424573475452E-9, 5.414616938827, 4.061219149443, 7.235671196168E-9, 1.496516557134, 161.0006857377, 8.104015182733E-9, 1.919918242764, 0.8460828644453, 8.098576535937E-9, 3.819615855458, 3.89418173651, 6.275292346625E-9, 6.244264115141, 0.8531963191132, 6.052432989112E-9, 0.503773187261, 15.67108171867, 5.705651535817E-9, 2.984557271995, 12.5869271288, 5.789650115138E-9, 6.087038140697, 11.93336791622, 5.512132153377E-9, 5.855668994076, 12.32342296471, 7.388890819102E-9, 2.44312857474, 4.907302013889, 5.467593991798E-9, 3.017561234194, 18.84211409667, 6.388519802999E-9, 5.887386712935, 52.1758062812, 6.106777149944E-9, 0.3483461059895, 0.0142269093358, 7.383420275489E-9, 5.417387056707, 23.58125818164, 5.505208141738E-9, 2.848193644783, 11.51388321134, 6.310757462877E-9, 2.349882520828, 10.41998632314, 6.166904929691E-9, 0.5728575944077, 6.151533897323, 5.263442042754E-9, 4.495796125937, 18.85275071096, 5.591828082629E-9, 1.355441967677, 0.4337116142245, 5.397051680497E-9, 1.673422864307, 6.286362197481, 5.396992745159E-9, 1.833502206373, 6.27978950341, 6.572913000726E-9, 3.331122065824, 11.76433076753, 5.123421866413E-9, 2.165327142679, 12.45594543367, 5.930495725999E-9, 2.931146089284, 6.414617803568, 6.431797403933E-9, 4.134407994088, 0.1350651127443, 5.003182207604E-9, 3.805420303749, 10.96996532989, 5.587731032504E-9, 1.082469260599, 6.062663316, 5.935263407816E-9, 0.8384333678401, 5.326786718777, 4.75601982776E-9, 3.552588749309, 3.104930017775, 6.599951172637E-9, 4.320826409528, 40.87944051283, 5.902606868464E-9, 4.811879454445, 5.849364236221, 5.921147809031E-9, 0.09942628922396, 1.581959461667, 5.505382581266E-9, 2.466557607764, 6.503488384892, 5.353771071862E-9, 4.551978748683, 173.5668374386, 5.063282210946E-9, 5.710812312425, 12.48988586463, 5.926120403383E-9, 1.333998428358, 26.73594526851, 5.211016176149E-9, 4.64931536076, 24.60261242967, 5.347075084894E-9, 5.512754081205, 4.171425416666, 4.872609773574E-9, 1.308025299938, 5.333900173445, 4.72771132142E-9, 2.144908368062, 7.232251527446, 6.029426018652E-9, 5.567259412084, 322.7113045244, 4.321485284369E-9, 5.230667156451, 9.388005868221, 4.476406760553E-9, 6.134081115303, 5.547199253223, 5.83526827742E-9, 4.783808492071, 72.8505617157, 5.172183602748E-9, 5.161817911099, 18.84570439172, 5.693571465184E-9, 1.381646203111, 97.23862754494, 4.060634965349E-9, 0.3876705259495, 4.274518229222, 3.967398770473E-9, 5.029491776223, 3.496032717521, 3.943754005255E-9, 1.92316295549, 6.244942932314, 4.781323427824E-9, 4.633332586423, 29.29661536378, 3.871483781204E-9, 1.616650009743, 6.321208768577, 5.141741733997E-9, 0.09817316704659, 12.32032006293, 4.002385978497E-9, 3.656161212139, 7.018952447668, 4.901092604097E-9, 4.404098713092, 1.478866649112, 3.740932630345E-9, 0.5181188732639, 6.922973089781, 4.387283718538E-9, 3.254859566869, 233.1413144044, 5.019197802033E-9, 3.086773224677, 17.15706182245, 3.834931695175E-9, 2.797882673542, 14.9190178544, 3.760413942497E-9, 2.892676280217, 17.26726808967, 3.719717204628E-9, 5.861046025739, 6.297302759782, 4.145623530149E-9, 2.168239627033, 13.76059875786, 3.93278842538E-9, 6.271811124181, 7.872148766781, 3.686377476857E-9, 3.936853151404, 6.26884894111, 3.779077950339E-9, 1.404148734043, 4.157198507331, 4.091334550598E-9, 2.452436180854, 9.779108567966, 3.926694536146E-9, 6.10229273904, 10.98419223922, 4.841000253289E-9, 6.072760457276, 12.52801878276, 4.94934013024E-9, 1.154832815171, 161.7106187867, 3.76155773736E-9, 5.527545321897, 3.185192151914, 3.647396268188E-9, 1.525035688629, 6.271346477544, 3.932405074189E-9, 5.570681040569, 21.39354194808, 3.631322501141E-9, 1.98124060116, 6.294805223347, 4.130007425139E-9, 2.050060880201, 21.95415756911, 4.433905965176E-9, 3.277477970321, 7.445550607224, 3.851814176947E-9, 5.210690074886, 0.9562891316684, 3.485807052785E-9, 0.6653274904611, 11.61697602389, 3.979772816991E-9, 1.767941436148, 22.77943724828, 3.4026074605E-9, 3.421746306465, 10.873985972, 4.049993000926E-9, 1.127144787547, 0.3163918923335, 3.420511182382E-9, 4.214794779161, 13.62553364512, 3.640772365012E-9, 5.324905497687, 17.25304118033, 3.323037987501E-9, 6.135761838271, 6.27914338782, 4.503141663637E-9, 1.802305450666, 1.385561574497, 4.314560055588E-9, 4.812299731574, 4.1760413349, 3.29422694911E-9, 3.657547059723, 6.287008313071, 3.215657197281E-9, 4.866676894425, 5.749861718712, 4.129362656266E-9, 3.809342558906, 5.905702259363, 3.137762976388E-9, 2.494635174443, 20.99539292909, 3.514010952384E-9, 2.699961831678, 7.335344340001, 3.32760757153E-9, 3.318457714816, 5.436992986, 3.541066946675E-9, 4.382703582466, 12.34573916645, 3.216179847052E-9, 5.271066317054, 0.0380276961914, 2.95904505957E-9, 5.819591585302, 26.70964694522, 3.884040326665E-9, 5.980934960428, 6.660449441528, 2.922027539886E-9, 3.337290282483, 1.375773836557, 4.110846382042E-9, 5.742978187327, 44.80965020977, 2.934508411032E-9, 2.2780758042, 0.6408777551755, 3.966896193E-9, 5.835747858477, 0.3773735910827, 3.28669582761E-9, 5.838898193902, 0.0039324626253, 3.720643094196E-9, 1.122212337858, 16.4603334374, 3.285508906174E-9, 0.9182250996416, 10.81813534213, 3.753880575973E-9, 5.174761973266, 5.64219809527, 3.022129385587E-9, 3.381611020639, 29.82630633589, 2.798569205621E-9, 3.546193723922, 19.37891852345, 3.397872070505E-9, 4.533203197934, 6.923953605621, 3.708099772977E-9, 2.756168198616, 30.66615496545, 3.59928354151E-9, 1.934395469918, 6.147450479709, 3.688702753059E-9, 0.7149920971109, 2.636725487657, 2.681084724003E-9, 4.899819493154, 6.816289982179, 3.495993460759E-9, 1.572418915115, 6.418701221183, 3.130770324995E-9, 0.8912190180489, 12.35996607578, 2.744353821941E-9, 3.800821940055, 20.5972439101, 2.842732906341E-9, 2.644717440029, 28.28699048865, 3.046882682154E-9, 3.987793020179, 6.055599646783, 2.399072455143E-9, 0.9908826440764, 6.255674361143, 2.384306274204E-9, 2.51614975222, 6.310477339748, 2.977324500559E-9, 5.849195642118, 16.52265972112, 3.062835258972E-9, 1.681660100162, 11.72006883645, 3.109682589231E-9, 0.5804143987737, 27.51146787858, 2.903920355299E-9, 5.800768280123, 6.510552054109, 2.823221989212E-9, 0.9241118370216, 5.469525544182, 3.187949696649E-9, 3.139776445735, 169.3792562116, 2.922559771655E-9, 3.549440782984, 0.263083906245, 2.436302066603E-9, 4.735540696319, 0.3946258593675, 3.049473043606E-9, 4.998289124561, 8.390110365991, 2.863682575784E-9, 0.6709515671102, 0.2243449970715, 2.641750517966E-9, 5.410978257284, 29.86433403208, 2.704093466243E-9, 4.778317207821, 6.129297044991, 2.445522177011E-9, 6.009020662222, 11.71295538178, 2.62360881023E-9, 5.010449777147, 6.436854655901, 2.079259704053E-9, 5.980943768809, 20.19909489111, 2.820225596771E-9, 2.679965110468, 5.93415139993, 2.365221950927E-9, 1.89423114881, 24.70570524223, 2.359682077149E-9, 4.22075295078, 8.671969964381, 2.387577137206E-9, 2.571783940617, 7.096626156709, 1.982102089816E-9, 0.5169765997119, 17.2718840079, 2.687502389925E-9, 6.239078264579, 70.75506709219, 2.207751669135E-9, 2.031184412677, 4.377611041777, 2.618370214274E-9, 0.8266079985979, 6.632000300961, 2.591951887361E-9, 0.8819350522008, 48.73985990671, 2.375055656248E-9, 3.520944177789, 15.90676413561, 2.472019978911E-9, 1.551431908671, 0.6612329252343, 2.368157127199E-9, 4.178610147412, 34.59636466239, 1.764846605693E-9, 1.506764000157, 19.80094587212, 2.291769608798E-9, 2.118250611782, 0.0284491405673, 2.209997316943E-9, 3.363255261678, 0.2666070658668, 2.292699097923E-9, 0.420042395646, 0.0014841705719, 1.629683015329E-9, 2.331362582487, 30.355997308, 2.206492862426E-9, 3.400274026992, 6.281667977667, 2.205746568257E-9, 0.1066051230724, 6.284483723224, 2.026310767991E-9, 2.779066487979, 24.49240616245, 1.762977622163E-9, 0.995145069184, 20.45286941806, 1.368535049606E-9, 0.6402447365817, 24.73415438279, 1.72059877545E-9, 0.2303524214705, 167.9593901136, 1.702429015449E-9, 6.164622655048, 333.8575901272, 1.414033197685E-9, 3.95456118558, 162.4205518357, 1.573768958043E-9, 2.028286308984, 31.44167757552, 1.650705184447E-9, 2.304040666128, 52.67006960365, 1.651087618855E-9, 2.53846105728, 89.56999012, 1.616409518983E-9, 5.111054348152, 33.32657872986, 1.537175173581E-9, 5.601130666603, 38.52657435933, 1.593191980553E-9, 2.614340453411, 228.2781046519, 1.499480170643E-9, 3.624721577264, 28.23723341956, 1.493807843235E-9, 4.214569879008, 28.76692439167, 1.074571199328E-9, 0.1496911744704, 83.97383534231, 1.074406983417E-9, 1.187817671922, 84.01985929482, 9.757576855851E-10, 2.655703035858, 78.2637094218, 1.258432887565E-9, 4.969896184844, 311.5650189215, 1.240336343282E-9, 5.192460776926, 178.430047191, 9.016107005164E-10, 1.960356923057, 58.86454391678, 1.135392360918E-9, 5.082427809068, 78.42370451713, 9.216046089565E-10, 2.793775037273, 101.4262087719, 1.06127661503E-9, 3.726144311409, 56.60027930059, 1.010110596263E-9, 0.7404080708937, 42.45678405627, 7.217424756199E-10, 0.02697449980577, 245.7074661053, 6.912003846756E-10, 4.253296276335, 167.9936946371, 6.871814664847E-10, 5.148072412354, 60.53048899753, 4.887158016343E-10, 2.153581148294, 96.56299901946, 5.161802866314E-10, 3.852750634351, 244.2876000072, 5.652599559057E-10, 1.23323335627, 83.65903305582, 4.710812608586E-10, 5.610486976767, 316.4282286739, 4.909977500324E-10, 1.639629524123, 405.9982187939, 4.772641839378E-10, 3.737100368583, 180.5255418145, 4.487562567153E-10, 0.1158417054478, 84.33466158131, 3.943441230497E-10, 0.6243502862796, 256.8537517081, 3.952236913598E-10, 3.510377382385, 244.9975330562, 3.788898363417E-10, 5.916128302299, 156.8131045107, 3.738329328831E-10, 1.042266763456, 394.851933191, 2.451199165151E-10, 1.1667884357, 143.5713242844, 2.436734402904E-10, 3.254726114901, 226.8582385539, 2.213605274325E-10, 1.68721059853, 165.8638954901, 1.491521204829E-10, 2.657541786794, 221.9950288015, 1.474995329744E-10, 5.013089805819, 305.281943071, 1.661939475656E-10, 5.495315428418, 252.6661704812, 9.015946748003E-11, 2.236989966505, 417.1445043968};
        static final double[] e0z = new double[]{2.796207639075E-6, 3.198701560209, 84.33466158131, 1.016042198142E-6, 5.422360395913, 5.507553240374, 8.044305033647E-7, 3.880222866652, 5.223693906222, 4.385347909274E-7, 3.704369937468, 2.352866153506, 3.186156414906E-7, 3.999639363235, 1.577343543434, 2.272412285792E-7, 3.984738315952, 1.047747311755, 1.645620103007E-7, 3.565412516841, 5.856477690889, 1.815836921166E-7, 4.98450705902, 6.283075850446, 1.447461676364E-7, 3.702753570108, 9.437762937313, 1.430760876382E-7, 3.409658712357, 10.21328554739, 1.120445753226E-7, 4.829561570246, 14.14349524433, 1.090232840797E-7, 2.080729178066, 6.812766822558, 9.715727346551E-8, 3.476295881948, 4.69400293411, 1.036267136217E-7, 4.056639536648, 71.09288135493, 8.75266527134E-8, 4.448159519911, 5.753384878334, 8.331864956004E-8, 4.991704044208, 7.084896783808, 6.901658670245E-8, 4.325358994219, 6.275962395778, 9.144536848998E-8, 1.141826375363, 6.620890113188, 7.205085037435E-8, 3.624344170143, 0.5296909721118, 7.697874654176E-8, 5.554257458998, 167.6215758509, 5.197545738384E-8, 6.251760961735, 18.07370494127, 5.031345378608E-8, 2.497341091913, 4.705732307012, 4.52711020584E-8, 2.335079920992, 6.309374173736, 4.753355798089E-8, 0.7094148987474, 5.884926831456, 4.296951977516E-8, 1.101916352091, 6.681224869435, 3.855341568387E-8, 1.825495405486, 5.486777812467, 5.25393097099E-8, 4.424740687208, 7.86041939388, 4.024630496471E-8, 5.120498157053, 13.36797263425, 4.061069791453E-8, 6.029771435451, 3.93020969694, 3.797883804205E-8, 0.4435193600836, 3.154687086868, 2.933033225587E-8, 5.124157356507, 1.059381944224, 3.503000930426E-8, 5.421830162065, 6.069776770667, 3.67009621405E-8, 4.582101667297, 12.19403291462, 2.905609437008E-8, 1.926566420072, 10.97707878456, 2.466827821713E-8, 0.6090174539834, 6.496374930224, 2.691647295332E-8, 1.393432595077, 22.0039146382, 2.150554667946E-8, 4.308671715951, 5.643178611111, 2.23748192268E-8, 0.8133968269414, 8.635942003952, 1.817741038157E-8, 3.755205127454, 3.340612434717, 2.227820762132E-8, 2.759558596664, 12.03646072878, 1.944713772307E-8, 5.699645869121, 11.79062909082, 1.527340520662E-8, 1.986749091746, 0.3981490189893, 1.577282574914E-8, 3.205017217983, 5.088628793478, 1.424738825424E-8, 6.256747903666, 2.544314396739, 1.616563121701E-8, 0.2601671259394, 17.29818233119, 1.401210391692E-8, 4.686939173506, 7.058598460518, 1.488726974214E-8, 2.815862451372, 25.93412433514, 1.692626442388E-8, 4.956894109797, 156.475290248, 1.12357158291E-8, 2.381192697696, 3.738761453707, 9.903308606317E-9, 4.294851657684, 9.225539266174, 9.174533187191E-9, 3.075171510642, 4.164311961999, 8.645985631457E-9, 0.5477534821633, 8.429241228195, -1.085876492688E-8, 0.0, 0.0, 9.264309077815E-9, 5.968571670097, 7.079373888424, 8.243116984954E-9, 1.489098777643, 10.44738781244, 8.268102113708E-9, 3.512977691983, 11.50676975667, 9.043613988227E-9, 0.1290704408221, 11.01510648075, 7.432912038789E-9, 1.991086893337, 26.0879031406, 8.586233727285E-9, 4.238357924414, 29.86433403208, 7.612230060131E-9, 2.911090150166, 4.732030630302, 7.097787751408E-9, 1.90893839239, 8.031092209206, 7.640237040175E-9, 0.6129219000168, 0.7962980379786, 7.070445688081E-9, 1.380417036651, 2.14616537775, 7.690770957702E-9, 1.680504249084, 21.22839202813, 8.051292542594E-9, 5.127423484511, 2.942463415728, 5.902709104515E-9, 2.020274190917, 0.775522610072, 5.134567496462E-9, 2.606778676418, 12.56615170089, 5.525802046102E-9, 1.613011769663, 0.8018209333619, 5.880724784221E-9, 4.604483417236, 4.690479774488, 5.21169908137E-9, 5.718964114193, 8.827390247185, 4.891849573562E-9, 3.689658932196, 0.2132990797783, 5.150246069997E-9, 4.099769855122, 64.80980550449, 5.102434319633E-9, 5.660834602509, 33.79454372902, 5.083405254252E-9, 0.9842221218974, 4.136910472696, 4.206562585682E-9, 0.1341363634163, 3.128388763578, 4.663249683579E-9, 0.8130132735866, 5.216580451554, 4.09947441653E-9, 5.791497770644, 0.4265981595566, 4.628251220767E-9, 1.249802769331, 15.72083878776, 5.024068728142E-9, 4.795684802743, 6.290189305114, 5.120234327758E-9, 3.810420387208, 5.23080736089, 5.52402981528E-9, 1.029264714351, 239.7622045175, 4.75741571886E-9, 3.528044781779, 16.49636139783, 3.915786131127E-9, 5.593889282646, 1.589072916335, 4.869053149991E-9, 3.299636454433, 7.632943190217, 3.649365703729E-9, 1.286049002584, 6.206810014183, 3.992493949002E-9, 3.100307589464, 25.15860172507, 3.320247477418E-9, 6.212683940807, 12.1680026819, 3.287123739696E-9, 4.699118445928, 7.234794171227, 3.472776811103E-9, 2.630507142004, 7.342457794669, 3.423253294767E-9, 2.946432844305, 9.623688285163, 3.896173898244E-9, 1.224834179264, 6.438496133249, 3.388455337924E-9, 1.543807616351, 14.94531617769, 3.062704716523E-9, 1.19177757231, 8.662240327241, 3.2700756004E-9, 5.483498767737, 1.194447056968, 3.101209215259E-9, 0.8000833804348, 37.72475342596, 2.780883347311E-9, 0.4077980721888, 5.863591145557, 2.903605931824E-9, 2.617490302147, 19.6510484847, 2.682014743119E-9, 2.63470315829, 7.238675589263, 2.534360108492E-9, 6.102446114873, 6.836645152238, 2.392564882509E-9, 3.681820208691, 5.849364236221, 2.656667254856E-9, 6.216045388886, 6.133512519065, 2.331242096773E-9, 5.864949777744, 4.535059491685, 2.287898363668E-9, 4.566628532802, 7.477522907414, 2.336944521306E-9, 2.44272212693, 11.37170464392, 3.156632236269E-9, 1.626628050682, 250.9084901204, 2.982612402766E-9, 2.803604512609, 1.74801635876, 2.774031674807E-9, 4.654002897158, 82.2391669578, 2.295236548638E-9, 4.326518333253, 0.3378142627421, 2.190714699873E-9, 4.519614578328, 29.08881142201, 2.191495845045E-9, 3.012626912549, 16.73046366289, 2.492901628386E-9, 0.1290101424052, 154.3797956245, 1.993778064319E-9, 3.864046799414, 17.78984560711, 1.898146479022E-9, 5.053777235891, 20.42657109477, 1.918280127634E-9, 2.222470192548, 41.6549631229, 1.916351061607E-9, 0.8719067257774, 77.37595720538, 1.834720181466E-9, 4.03149109804, 23.58125818164, 1.249201523806E-9, 5.938379466835, 33.01902111895, 1.477304050539E-9, 0.6544722606797, 95.48094718417, 1.264316431249E-9, 2.059072853236, 83.99684731857, 1.203526495039E-9, 3.644813532605, 45.58517281984, 9.221681059831E-10, 3.241815055602, 78.05158573086, 7.849278367646E-10, 5.043812342457, 52.1758062812, 7.983392077387E-10, 5.000024502753, 150.1922143975, 7.925395431654E-10, 0.01398734871821, 90.61773743175, 7.640473285886E-10, 5.06711172313, 49.51538251678, 5.398937754482E-10, 5.597382200075, 161.3385000004, 5.626247550193E-10, 2.601338209422, 73.18837597844, 5.525197197855E-10, 5.814832109256, 143.2335100216, 5.407629837898E-10, 3.384820609076, 323.0491187871, 3.856739119801E-10, 1.072391840473, 233.4791286671, 3.856425239987E-10, 2.369540393327, 173.9046517013, 4.350867755983E-10, 5.255575751082, 162.0484330494, 3.844113924996E-10, 5.482356246182, 97.57644180768, 2.854869155431E-10, 0.9573634763143, 169.7170704744, 1.719227671416E-10, 1.887203025202, 226.5204242912, 1.527846879755E-10, 3.982183931157, 334.19540439, 1.128229264847E-10, 2.787457156298, 311.9028331842};
        static final double[] e1x = new double[]{1.234046326004E-6, 0.0, 0.0, 5.150068824701E-7, 6.002664557501, 12.56615170089, 1.290743923245E-8, 5.959437664199, 18.84922755134, 1.068615564952E-8, 2.015529654209, 6.283075850446, 2.079619142538E-9, 1.732960531432, 6.279552690824, 2.078009243969E-9, 4.915604476996, 6.286599010068, 6.206330058856E-10, 0.3616457953824, 4.705732307012, 5.989335313746E-10, 3.802607304474, 6.256777527156, 5.95849566384E-10, 2.845866560031, 6.309374173736, 4.866923261539E-10, 5.213203771824, 0.775522610072, 4.267785823142E-10, 0.4368189727818, 1.059381944224, 4.610675141648E-10, 0.01837249181372, 7.86041939388, 3.626989993973E-10, 2.161590545326, 5.753384878334, 3.563071194389E-10, 1.452631954746, 5.884926831456, 3.557015642807E-10, 4.470593393054, 6.812766822558, 3.210412089122E-10, 5.195926078314, 6.681224869435, 2.875473577986E-10, 5.916256610193, 25.13230340178, 2.842913681629E-10, 1.149902426047, 6.127655567643, 2.751248215916E-10, 5.502088574662, 6.438496133249, 2.481432881127E-10, 2.921989846637, 5.486777812467, 2.05988597656E-10, 3.718070376585, 7.079373888424, 2.015522342591E-10, 5.97939525974, 6.290189305114, 1.995364084253E-10, 0.6772087985494, 6.275962395778, 1.957436436943E-10, 2.899210654665, 5.507553240374, 1.651609818948E-10, 6.228206482192, 11.50676975667, 1.822980550699E-10, 1.469348746179, 11.79062909082, 1.67522315976E-10, 3.813910555688, 7.058598460518, 1.706491764745E-10, 0.3004380506684, 0.0071134546679, 1.392952362615E-10, 1.440393973406, 0.7962980379786, 1.209868266342E-10, 4.150425791727, 4.69400293411, 1.009827202611E-10, 3.290040429843, 3.738761453707, 1.047261388602E-10, 4.229590090227, 6.282095334605, 1.047006652004E-10, 2.418967680575, 6.284056366286, 9.609993143095E-11, 4.627943659201, 6.069776770667, 9.590900593873E-11, 1.894393939924, 4.136910472696, 9.146249188071E-11, 2.010647519562, 6.496374930224, 8.54527448029E-11, 0.05529846956226, 1.194447056968, 8.224377881194E-11, 1.254304102174, 1.589072916335, 6.18352951041E-11, 3.360862168815, 8.827390247185, 6.259255147141E-11, 4.755628243179, 8.429241228195, 5.539291694151E-11, 5.371746955142, 4.933208510675, 7.328259466314E-11, 0.4927699613906, 4.535059491685, 6.01783584356E-11, 0.05776682001734, 12.55903824622, 7.079827775243E-11, 4.395059432251, 5.088628793478, 5.170358878213E-11, 5.154062619954, 11.76985366291, 4.872301838682E-11, 0.6289611648973, 6.04034711426, 5.249869411058E-11, 5.617272046949, 3.154687086868, 4.716172354411E-11, 3.965901800877, 5.331357529664, 4.871214940964E-11, 4.627507050093, 12.56967486051, 4.598076850751E-11, 6.023631226459, 6.525804586632, 4.562196089485E-11, 4.138562084068, 3.93020969694, 4.325493872224E-11, 1.330845906564, 7.632943190217, 5.673781176748E-11, 2.558752615657, 5.729506548653, 3.961436642503E-11, 2.72807173463, 7.234794171227, 5.101868209058E-11, 4.113444965144, 6.836645152238, 5.257043167676E-11, 6.19508983059, 8.031092209206, 5.076613989393E-11, 2.305124132918, 7.477522907414, 3.342169352778E-11, 5.415998155071, 10.97707878456, 3.545881983591E-11, 3.727160564574, 4.164311961999, 3.364063738599E-11, 0.2901121049204, 11.37170464392, 3.357039670776E-11, 1.652229354331, 5.223693906222, 4.307412268687E-11, 4.938909587445, 1.592596075957, 3.405769115435E-11, 2.408890766511, 3.128388763578, 3.00192619848E-11, 4.862239006386, 1.74801635876, 2.778264787325E-11, 5.241168661353, 7.342457794669, 2.676159480666E-11, 3.423593942199, 2.14616537775, 2.954273399939E-11, 1.881721265406, 0.5368044267797, 3.309362888795E-11, 1.931525677349, 0.8018209333619, 2.810283608438E-11, 2.41465949505, 0.5225775174439, 3.378045637764E-11, 4.23801916343, 0.1554202828031, 2.55813497984E-11, 1.828225235805, 5.23080736089, 2.273755578447E-11, 5.858184283998, 7.084896783808, 2.29417603769E-11, 4.514589779057, 17.260154635, 2.533506099435E-11, 2.355717851551, 5.216580451554, 2.716685375812E-11, 2.2210036251, 8.635942003952, 2.419043435198E-11, 5.955704951635, 4.690479774488, 2.521232544812E-11, 1.395676848521, 5.481254917084, 2.630195021491E-11, 5.727468918743, 0.0262983232899, 2.548395840944E-11, 2.6283518594E-4, 1.349867339771};
        static final double[] e1y = new double[]{9.304690546528E-7, 0.0, 0.0, 5.150715570663E-7, 4.431807116294, 12.56615170089, 1.290825411056E-8, 4.388610039678, 18.84922755134, 4.645466665386E-9, 5.827263376034, 6.283075850446, 2.079625310718E-9, 0.1621698662282, 6.279552690824, 2.078189850907E-9, 3.34471343514, 6.286599010068, 6.207190138027E-10, 5.074049319576, 4.705732307012, 5.989826532569E-10, 2.23184221662, 6.256777527156, 5.961360812618E-10, 1.274975769045, 6.309374173736, 4.874165471016E-10, 3.642277426779, 0.775522610072, 4.28383403436E-10, 5.148765510106, 1.059381944224, 4.652389287529E-10, 4.715794792175, 7.86041939388, 3.751707476401E-10, 0.6617207370325, 5.753384878334, 3.559998806198E-10, 6.155548875404, 5.884926831456, 3.558447558857E-10, 2.898827297664, 6.812766822558, 3.211116927106E-10, 3.625813502509, 6.681224869435, 2.875609914672E-10, 4.345435813134, 25.13230340178, 2.843109704069E-10, 5.862263940038, 6.127655567643, 2.744676468427E-10, 3.926419475089, 6.438496133249, 2.481285237789E-10, 1.351976572828, 5.486777812467, 2.060338481033E-10, 2.147556998591, 7.079373888424, 2.015822358331E-10, 4.408358972216, 6.290189305114, 2.001195944195E-10, 5.385829822531, 6.275962395778, 1.953667642377E-10, 1.30493374612, 5.507553240374, 1.839744078713E-10, 6.173567228835, 11.79062909082, 1.643334294845E-10, 4.635942997523, 11.50676975667, 1.768051018652E-10, 5.086283558874, 0.0071134546679, 1.674874205489E-10, 2.243332137241, 7.058598460518, 1.421445397609E-10, 6.186899771515, 0.7962980379786, 1.255163958267E-10, 5.730238465658, 4.69400293411, 1.013945281961E-10, 1.726055228402, 3.738761453707, 1.047294335852E-10, 2.658801228129, 6.282095334605, 1.047103879392E-10, 0.8481047835035, 6.284056366286, 9.530343962826E-11, 3.079267149859, 6.069776770667, 9.60463761169E-11, 0.3258679792918, 4.136910472696, 9.153518537177E-11, 0.4398599886584, 6.496374930224, 8.562458214922E-11, 4.772686794145, 1.194447056968, 8.232525360654E-11, 5.966220721679, 1.589072916335, 6.150223411438E-11, 1.780985591923, 8.827390247185, 6.272087858E-11, 3.184305429012, 8.429241228195, 5.54047631104E-11, 3.801260595433, 4.933208510675, 7.331901699361E-11, 5.205948591865, 4.535059491685, 6.018528702791E-11, 4.770139083623, 12.55903824622, 5.150530724804E-11, 3.574796899585, 11.76985366291, 6.471933741811E-11, 2.679787266521, 5.088628793478, 5.317460644174E-11, 0.9528763345494, 3.154687086868, 4.832187748783E-11, 5.329322498232, 6.04034711426, 4.71676355511E-11, 2.395235316466, 5.331357529664, 4.871509139861E-11, 3.056663648823, 12.56967486051, 4.598417696768E-11, 4.452762609019, 6.525804586632, 5.674189533175E-11, 0.9879680872193, 5.729506548653, 4.073560328195E-11, 5.939127696986, 7.632943190217, 5.040994945359E-11, 4.54987582451, 8.031092209206, 5.078185134679E-11, 0.7346659893982, 7.477522907414, 3.769343537061E-11, 1.071317188367, 7.234794171227, 4.980331365299E-11, 2.500345341784, 6.836645152238, 3.458236594757E-11, 3.825159450711, 10.97707878456, 3.578859493602E-11, 5.299664791549, 4.164311961999, 3.370504646419E-11, 5.002316301593, 11.37170464392, 3.299873338428E-11, 2.526123275282, 3.93020969694, 4.304917318409E-11, 3.368078557132, 1.592596075957, 3.402418753455E-11, 0.83854954258, 3.128388763578, 2.778460572146E-11, 3.66990520324, 7.342457794669, 2.782710128902E-11, 0.269166481217, 1.74801635876, 2.711725179646E-11, 4.707487217718, 0.5296909721118, 2.98176094634E-11, 0.3190260867816, 0.5368044267797, 2.811672977772E-11, 3.196532315372, 7.084896783808, 2.863454474467E-11, 0.226324032478, 5.223693906222, 3.333464634051E-11, 3.498451685065, 0.8018209333619, 3.312991747609E-11, 5.839154477412, 0.1554202828031, 2.813255564006E-11, 0.8268044346621, 0.5225775174439, 2.665098083966E-11, 3.93402172536, 5.216580451554, 2.349795705216E-11, 5.197620913779, 2.14616537775, 2.330352293961E-11, 2.984999231807, 17.260154635, 2.728001683419E-11, 0.6521679638544, 8.635942003952, 2.484061007669E-11, 3.468955561097, 5.23080736089, 2.646328768427E-11, 1.013724533516, 0.0262983232899, 2.518630264831E-11, 6.108081057122, 5.481254917084, 2.421901455384E-11, 1.65109777626, 1.349867339771, 6.348533267831E-12, 3.220226560321, 84.33466158131};
        static final double[] e1z = new double[]{2.278290449966E-6, 3.413716033863, 6.283075850446, 5.42945820983E-8, 0.0, 0.0, 1.903240492525E-8, 3.370592358297, 12.56615170089, 2.385409276743E-10, 3.327914718416, 18.84922755134, 8.676928342573E-11, 1.824006811264, 5.223693906222, 7.765442593544E-11, 3.888564279247, 5.507553240374, 7.066158332715E-11, 5.194267231944, 2.352866153506, 7.092175288657E-11, 2.333246960021, 83.99684731857, 5.357582213535E-11, 2.224031176619, 0.5296909721118, 3.828035865021E-11, 2.156710933584, 6.279552690824, 3.824857220427E-11, 1.529755219915, 6.286599010068, 3.286995181628E-11, 4.879512900483, 10.21328554739};
        static final double[] e2x = new double[]{-4.143818297913E-11, 0.0, 0.0, 2.171497694435E-11, 4.398225628264, 12.56615170089, 9.845398442516E-12, 0.2079720838384, 6.283075850446, 9.256833552682E-13, 4.191264694361, 18.84922755134, 1.022049384115E-13, 5.381133195658, 83.99684731857};
        static final double[] e2y = new double[]{5.063375872532E-11, 0.0, 0.0, 2.17381578598E-11, 2.827805833053, 12.56615170089, 1.01023199992E-11, 4.634612377133, 6.283075850446, 9.259745317636E-13, 2.620612076189, 18.84922755134, 1.022202095812E-13, 3.809562326066, 83.99684731857};
        static final double[] e2z = new double[]{9.722666114891E-11, 5.152219582658, 6.283075850446, -3.494819171909E-12, 0.0, 0.0, 6.713034376076E-13, 0.6440188750495, 12.56615170089};

        private Ephemeris() {
        }
    }

    public static class ReferenceEllipsoid {
        public double a;
        public double f;

        public ReferenceEllipsoid(double a, double f) {
            this.a = a;
            this.f = f;
        }
    }

    private static class TERM {
        final int[] nfa;
        final double s;
        final double c;

        public TERM(int[] nfa, double s, double c) {
            this.nfa = nfa;
            this.s = s;
            this.c = c;
        }
    }

    static class LeapInfo {
        public final int iyear;
        public final int month;
        public final double delat;

        public LeapInfo(int i, int m, double t) {
            this.iyear = i;
            this.month = m;
            this.delat = t;
        }
    }

    public static class CalendarHMS {
        public final int iy;
        public final int im;
        public final int id;
        public final int[] ihmsf;

        public CalendarHMS(int iy, int im, int id, int[] hmsf) {
            this.iy = iy;
            this.im = im;
            this.id = id;
            this.ihmsf = hmsf;
        }
    }

    public static class Calendar {
        public final int iy;
        public final int im;
        public final int id;
        public final double fd;

        public Calendar(int iy, int im, int id, double fd) {
            this.iy = iy;
            this.im = im;
            this.id = id;
            this.fd = fd;
        }
    }

    public static class CelestialIntermediatePole {
        public double x;
        public double y;

        public CelestialIntermediatePole(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class FrameBias {
        public double dpsibi;
        public double depsbi;
        public double dra;
    }

    public static class JulianDate {
        public double djm0;
        public double djm1;

        public JulianDate(double d1, double d2) {
            this.djm0 = d1;
            this.djm1 = d2;
        }
    }
}

