/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.Javers;
import org.javers.core.MappingStyle;
import org.javers.core.pico.JaversContainerFactory;
import org.picocontainer.PicoContainer;

public class JaversBuilder {
    private static final MappingStyle DEFAULT_MAPPING_STYLE = MappingStyle.BEAN;
    private MappingStyle mappingStyle = DEFAULT_MAPPING_STYLE;
    private List<Class> managedClasses = new ArrayList<Class>();

    public Javers build() {
        PicoContainer container = JaversContainerFactory.create(this.mappingStyle);
        Javers javers = (Javers)container.getComponent(Javers.class);
        for (Class managedClass : this.managedClasses) {
            javers.manage(managedClass);
        }
        return javers;
    }

    public JaversBuilder manageClasses(Class<?> ... managedClasses) {
        for (Class<?> managedClass : managedClasses) {
            this.managedClasses.add(managedClass);
        }
        return this;
    }

    public JaversBuilder withMappingStyle(MappingStyle mappingStyle) {
        Validate.argumentIsNotNull((Object)mappingStyle);
        this.mappingStyle = mappingStyle;
        return this;
    }
}

