/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.lang.reflect.Method;
import javax.persistence.Id;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.JaversType;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class BeanProperty
implements Property {
    private final Method getter;
    private final String name;
    private final JaversType javersType;

    protected BeanProperty(Method getter, JaversType javersType) {
        Validate.argumentIsNotNull(getter, "getter should not be null!");
        Validate.argumentIsNotNull(javersType, "javersType should not be null!");
        this.getter = getter;
        this.name = ReflectionUtil.getterToField(getter);
        this.javersType = javersType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object get(Object target) {
        return ReflectionUtil.invokeGetterEvenIfPrivate(this.getter, target);
    }

    @Override
    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    @Override
    public boolean isId() {
        return this.getter.isAnnotationPresent(Id.class);
    }

    @Override
    public JaversType getType() {
        return this.javersType;
    }

    @Override
    public void setValue(Object value) {
        throw new NotImplementedException();
    }
}

