/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.ManagedClass;
import org.javers.model.mapping.Property;

public class Entity<S>
extends ManagedClass<S> {
    private final Property idProperty;

    public Entity(Class<S> sourceClass, List<Property> properties) {
        super(sourceClass, properties);
        Validate.argumentIsNotNull(sourceClass);
        Validate.argumentIsNotNull(properties);
        this.idProperty = this.findIdProperty();
    }

    private Property findIdProperty() {
        for (Property p : this.properties) {
            if (!p.isId()) continue;
            return p;
        }
        throw new JaversException(JaversExceptionCode.ENTITY_WITHOUT_ID, this.sourceClass.getName());
    }

    public Property getIdProperty() {
        return this.idProperty;
    }
}

