/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Transient;
import org.javers.model.mapping.FieldProperty;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.PropertyScanner;
import org.javers.model.mapping.type.JaversType;
import org.javers.model.mapping.type.TypeMapper;

public class FieldBasedPropertyScanner
extends PropertyScanner {
    public FieldBasedPropertyScanner(TypeMapper typeMapper) {
        super(typeMapper);
    }

    @Override
    public List<Property> scan(Class<?> valueObjectClass) {
        List<Field> declaredFields = this.getFields(valueObjectClass);
        ArrayList<Property> propertyList = new ArrayList<Property>(declaredFields.size());
        for (Field field : declaredFields) {
            if (!this.fieldIsPersistance(field)) continue;
            JaversType javersType = this.typeMapper.getJavesrType(field.getType());
            FieldProperty fieldProperty = new FieldProperty(field, javersType);
            propertyList.add(fieldProperty);
        }
        return propertyList;
    }

    private List<Field> getFields(Class<?> clazz) {
        List<Object> superFields = clazz.getSuperclass() == Object.class ? new ArrayList() : this.getFields(clazz.getSuperclass());
        superFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        return superFields;
    }

    private boolean fieldIsPersistance(Field field) {
        return !Modifier.isTransient(field.getModifiers()) && field.getAnnotation(Transient.class) == null;
    }
}

