/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.lang.reflect.Field;
import javax.persistence.Id;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.JaversType;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class FieldProperty
implements Property {
    private final Field field;
    private final JaversType javersType;

    public FieldProperty(Field field, JaversType javersType) {
        Validate.argumentIsNotNull(field, "field should not be null!");
        Validate.argumentIsNotNull(javersType, "javersType should not be null!");
        this.field = field;
        this.javersType = javersType;
    }

    @Override
    public boolean isId() {
        return this.field.isAnnotationPresent(Id.class);
    }

    @Override
    public Object get(Object target) {
        return ReflectionUtil.invokeFieldEvenIfPrivate(this.field, target);
    }

    @Override
    public boolean isNull(Object target) {
        return this.get(target) == null;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public JaversType getType() {
        return this.javersType;
    }

    @Override
    public void setValue(Object value) {
        throw new NotImplementedException();
    }
}

