/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import java.util.ArrayList;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.model.mapping.Entity;
import org.javers.model.object.graph.Edge;
import org.javers.model.object.graph.ObjectNode;

public class ObjectWrapper
implements ObjectNode {
    private final Object cdo;
    private final Entity entity;
    private final List<Edge> edges;

    public ObjectWrapper(Object cdo, Entity entity) {
        Validate.argumentIsNotNull(cdo);
        Validate.argumentIsNotNull(entity);
        if (!entity.isInstance(cdo)) {
            throw new IllegalArgumentException("cdo is not an instance of entity");
        }
        this.cdo = cdo;
        this.entity = entity;
        this.edges = new ArrayList<Edge>();
    }

    public Object getCdo() {
        return this.cdo;
    }

    @Override
    public Object getCdoId() {
        return this.entity.getIdProperty().get(this.cdo);
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public List<Edge> getEdges() {
        return this.edges;
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }
}

