/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.scanner;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Set;
import org.javers.core.model.DummyUser;
import org.javers.core.model.DummyUserDetails;
import org.javers.model.mapping.PropertiesAssert;
import org.javers.model.mapping.PropertyScanner;
import org.javers.model.mapping.type.ArrayType;
import org.javers.model.mapping.type.CollectionType;
import org.javers.model.mapping.type.EntityReferenceType;
import org.javers.model.mapping.type.PrimitiveType;
import org.javers.model.mapping.type.ValueObjectType;
import org.javers.test.assertion.Assertions;
import org.junit.Test;

public abstract class PropertyScannerTest {
    protected PropertyScanner propertyScanner;

    @Test
    public void shouldScanId() throws Throwable {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasId();
    }

    @Test
    public void shouldScanAllProperties() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        Assertions.assertThat((List)properties).hasSize(14);
    }

    @Test
    public void shouldScanEntityReferenceProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("supervisor").hasJaversType(EntityReferenceType.class).hasJavaType(DummyUser.class);
    }

    @Test
    public void shouldScanInheritedProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("inheritedInt");
    }

    @Test
    public void shouldNotScanTransientProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasntGotProperty("someTransientField");
    }

    @Test
    public void shouldScanSetProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("stringSet").hasJaversType(CollectionType.class).hasJavaType(Set.class);
    }

    @Test
    public void shouldScanListProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("integerList").hasJaversType(CollectionType.class).hasJavaType(List.class);
    }

    @Test
    public void shouldScanArrayProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("intArray").hasJaversType(ArrayType.class).hasJavaType(Array.class);
    }

    @Test
    public void shouldScanIntProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("age").hasJaversType(PrimitiveType.class).hasJavaType(Integer.TYPE);
    }

    @Test
    public void shouldScanEnumProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("sex").hasJaversType(PrimitiveType.class).hasJavaType(Enum.class);
    }

    @Test
    public void shouldScanIntegerProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("largeInt").hasJaversType(PrimitiveType.class).hasJavaType(Integer.class);
    }

    @Test
    public void shouldScanBooleanProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("flag").hasJaversType(PrimitiveType.class).hasJavaType(Boolean.TYPE);
    }

    @Test
    public void shouldScanBigBooleanProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("bigFlag").hasJaversType(PrimitiveType.class).hasJavaType(Boolean.class);
    }

    @Test
    public void shouldScanStringProperty() {
        List properties = this.propertyScanner.scan(DummyUser.class);
        PropertiesAssert.assertThat(properties).hasProperty("name").hasJaversType(PrimitiveType.class).hasJavaType(String.class);
    }

    @Test
    public void shouldScanValueObjectProperty() {
        List properties = this.propertyScanner.scan(DummyUserDetails.class);
        PropertiesAssert.assertThat(properties).hasProperty("dummyAddress").hasJaversType(ValueObjectType.class);
    }

    protected static class ManagedClass {
        private int privateProperty;

        protected ManagedClass() {
        }

        private int getPrivateProperty() {
            return 0;
        }
    }
}

