/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import org.fest.assertions.api.Assertions;
import org.javers.core.JaversBuilder;
import org.javers.core.MappingStyle;
import org.javers.model.mapping.BeanBasedPropertyScanner;
import org.javers.model.mapping.FieldBasedPropertyScanner;
import org.javers.model.mapping.PropertyScanner;
import org.junit.Test;

public class JaversBuilderPropertyScannerTest {
    @Test
    public void shouldContainFieldBasedPropertyScannerWhenFieldStyle() {
        JaversBuilder javersBuilder = JaversBuilder.javers().withMappingStyle(MappingStyle.FIELD);
        javersBuilder.build();
        Assertions.assertThat((Object)javersBuilder.getContainerComponent(PropertyScanner.class)).isInstanceOf(FieldBasedPropertyScanner.class);
    }

    @Test
    public void shouldContainBeanBasedPropertyScannerWhenBeanStyle() {
        JaversBuilder javersBuilder = JaversBuilder.javers().withMappingStyle(MappingStyle.BEAN);
        javersBuilder.build();
        Assertions.assertThat((Object)javersBuilder.getContainerComponent(PropertyScanner.class)).isInstanceOf(BeanBasedPropertyScanner.class);
    }

    @Test
    public void shouldNotContainFieldBasedPropertyScannerWhenBeanStyle() {
        JaversBuilder javersBuilder = JaversBuilder.javers().withMappingStyle(MappingStyle.BEAN);
        javersBuilder.build();
        Assertions.assertThat((Object)javersBuilder.getContainerComponent(FieldBasedPropertyScanner.class)).isNull();
    }

    @Test
    public void shouldNotContainBeanBasedPropertyScannerWhenFieldStyle() {
        JaversBuilder javersBuilder = JaversBuilder.javers().withMappingStyle(MappingStyle.FIELD);
        javersBuilder.build();
        Assertions.assertThat((Object)javersBuilder.getContainerComponent(BeanBasedPropertyScanner.class)).isNull();
    }
}

