/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core;

import javax.persistence.Id;
import org.fest.assertions.api.Assertions;
import org.javers.common.pico.JaversModule;
import org.javers.core.DummyJaversBean;
import org.javers.core.DummyJaversModule;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.model.DummyNetworkAddress;
import org.javers.model.mapping.BeanBasedPropertyScanner;
import org.javers.model.mapping.EntityManager;
import org.javers.model.mapping.PropertyScanner;
import org.javers.model.mapping.type.TypeMapper;
import org.junit.Test;

public class JaversBuilderTest {
    @Test
    public void shouldLoadDefaultPropertiesFile() {
        JaversBuilder javersBuilder = JaversBuilder.javers();
        javersBuilder.build();
        Assertions.assertThat((Object)javersBuilder.getContainerComponent(PropertyScanner.class)).isInstanceOf(BeanBasedPropertyScanner.class);
    }

    @Deprecated
    public void shouldBootNonCoreModule() {
        JaversBuilder javersBuilder = JaversBuilder.javers();
        javersBuilder.addModule((JaversModule)new DummyJaversModule()).build();
        org.javers.test.assertion.Assertions.assertThat((Object)javersBuilder.getContainerComponent(DummyJaversBean.class)).isNotNull();
    }

    @Test
    public void shouldManageEntity() {
        Javers javers = JaversBuilder.javers().registerEntity(DummyEntity.class).build();
        org.javers.test.assertion.Assertions.assertThat((boolean)javers.isManaged(DummyEntity.class)).isTrue();
    }

    @Test
    public void shouldInitializeEntityManager() {
        JaversBuilder javersBuilder = JaversBuilder.javers().registerEntity(DummyEntity.class).registerValueObject(DummyNetworkAddress.class);
        javersBuilder.build();
        EntityManager em = this.getEntityManager(javersBuilder);
        TypeMapper tm = this.getTypeMapper(javersBuilder);
        org.javers.test.assertion.Assertions.assertThat((boolean)em.isInitialized()).isTrue();
        org.javers.test.assertion.Assertions.assertThat((int)tm.getCountOfEntitiesAndValueObjects()).isEqualTo(2);
    }

    private EntityManager getEntityManager(JaversBuilder javersBuilder) {
        return (EntityManager)javersBuilder.getContainerComponent(EntityManager.class);
    }

    private TypeMapper getTypeMapper(JaversBuilder javersBuilder) {
        return (TypeMapper)javersBuilder.getContainerComponent(TypeMapper.class);
    }

    @Test
    public void shouldManageValueObject() {
        Javers javers = JaversBuilder.javers().registerValueObject(DummyNetworkAddress.class).build();
        org.javers.test.assertion.Assertions.assertThat((boolean)javers.isManaged(DummyNetworkAddress.class)).isTrue();
    }

    @Test
    public void shouldCreateJavers() throws Exception {
        Javers javers = JaversBuilder.javers().build();
        org.javers.test.assertion.Assertions.assertThat((Object)javers).isNotNull();
    }

    @Test
    public void shouldCreateMultipleJaversInstances() {
        Javers javers1 = JaversBuilder.javers().build();
        Javers javers2 = JaversBuilder.javers().build();
        org.javers.test.assertion.Assertions.assertThat((Object)javers1).isNotSameAs((Object)javers2);
    }

    private class DummyEntity {
        private int id;
        private DummyEntity parent;

        private DummyEntity() {
        }

        @Id
        private int getId() {
            return this.id;
        }

        private DummyEntity getParent() {
            return this.parent;
        }
    }
}

