/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.pico;

import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.diff.DiffFactory;
import org.javers.core.pico.JaversContainerFactory;
import org.javers.model.mapping.EntityManager;
import org.javers.model.mapping.type.TypeMapper;
import org.junit.Test;
import org.picocontainer.PicoContainer;

public class JaversContainerFactoryTest {
    @Test
    public void shouldCreateMultipleJaversContainers() {
        PicoContainer container1 = JaversContainerFactory.createDefaultCore();
        PicoContainer container2 = JaversContainerFactory.createDefaultCore();
        Assertions.assertThat((Object)container1).isNotSameAs((Object)container2);
        Assertions.assertThat((Object)container1.getComponent(EntityManager.class)).isNotSameAs(container2.getComponent(EntityManager.class));
    }

    @Test
    public void shouldContainRequiredJaversBeans() {
        PicoContainer container = JaversContainerFactory.createDefaultCore();
        Assertions.assertThat((Object)container.getComponent(Javers.class)).isNotNull();
        Assertions.assertThat((Object)container.getComponent(EntityManager.class)).isNotNull();
        Assertions.assertThat((Object)container.getComponent(TypeMapper.class)).isNotNull();
        Assertions.assertThat((Object)container.getComponent(DiffFactory.class)).isNotNull();
    }

    @Test
    public void shouldContainSingletons() {
        PicoContainer container = JaversContainerFactory.createDefaultCore();
        Javers javers = (Javers)container.getComponent(Javers.class);
        Javers javersSecondRef = (Javers)container.getComponent(Javers.class);
        Assertions.assertThat((Object)javers).isSameAs((Object)javersSecondRef);
    }
}

