/*
 * Decompiled with CFR 0.152.
 */
package org.javers.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import org.fest.assertions.data.Offset;
import org.javers.json.DummyJsonPerson;
import org.javers.json.DummyJsonPersonTypeAdapter;
import org.javers.json.JsonConverter;
import org.javers.test.assertion.Assertions;
import org.joda.time.LocalDateTime;
import org.junit.Test;

public class JsonConverterTest {
    @Test
    public void shouldConvertIntToJson() {
        JsonConverter jsonConverter = new JsonConverter();
        String json = jsonConverter.toJson((Object)12);
        Assertions.assertThat((String)json).isEqualTo((Object)"12");
    }

    @Test
    public void shouldConvertIntDoubleToJson() {
        JsonConverter jsonConverter = new JsonConverter();
        double value = 0.3333333333333333;
        String json = jsonConverter.toJson((Object)value);
        Assertions.assertThat((String)json).isEqualTo((Object)"0.3333333333333333");
    }

    @Test
    public void shouldConvertIntDoubleFromJson() {
        JsonConverter jsonConverter = new JsonConverter();
        double value = (Double)jsonConverter.fromJson("0.3333333333333333", Double.class);
        Assertions.assertThat((double)value).isEqualTo(0.3333333333333333, Offset.offset((Double)1.0E-16));
    }

    @Test
    public void shouldConvertLocalDateTimeToJsonInIsoFormat() {
        JsonConverter jsonConverter = new JsonConverter();
        LocalDateTime date = new LocalDateTime(2001, 12, 1, 22, 23, 3);
        String json = jsonConverter.toJson((Object)date);
        Assertions.assertThat((String)json).isEqualTo((Object)"\"2001-12-01T22:23:03\"");
    }

    @Test
    public void shouldConvertLocalDateTimeFromJsonInIsoFormat() {
        JsonConverter jsonConverter = new JsonConverter();
        LocalDateTime date = (LocalDateTime)jsonConverter.fromJson("\"2001-12-01T22:23:03\"", LocalDateTime.class);
        Assertions.assertThat((Object)date).isEqualTo((Object)new LocalDateTime(2001, 12, 1, 22, 23, 3));
    }

    @Test
    public void customTypeAdaptersShouldBeNullSafeWhenConvertingToJson() {
        JsonConverter jsonConverter = new JsonConverter();
        String valueJson = jsonConverter.toJson(null, LocalDateTime.class);
        Assertions.assertThat((String)valueJson).isEqualTo((Object)"null");
    }

    @Test
    public void customTypeAdaptersShouldBeNullSafeWhenConvertingFromJson() {
        JsonConverter jsonConverter = new JsonConverter();
        LocalDateTime value = (LocalDateTime)jsonConverter.fromJson("null", LocalDateTime.class);
        Assertions.assertThat((Object)value).isNull();
    }

    @Test
    public void shouldConvertBigDecimalToJson() {
        JsonConverter jsonConverter = new JsonConverter();
        BigDecimal value = new BigDecimal(22.22).setScale(3, RoundingMode.HALF_UP);
        String valueJson = jsonConverter.toJson((Object)value);
        Assertions.assertThat((String)valueJson).isEqualTo((Object)"22.220");
    }

    @Test
    public void shouldConvertBigDecimalFromJson() {
        JsonConverter jsonConverter = new JsonConverter();
        BigDecimal value = (BigDecimal)jsonConverter.fromJson("22.220", BigDecimal.class);
        Assertions.assertThat((BigDecimal)value).isEqualTo((Object)new BigDecimal(22.22).setScale(3, RoundingMode.HALF_UP));
    }

    @Test
    public void shouldConvertIntFromJson() {
        JsonConverter jsonConverter = new JsonConverter();
        int value = (Integer)jsonConverter.fromJson("12", Integer.class);
        Assertions.assertThat((int)value).isEqualTo(12);
    }

    @Test
    public void shouldConvertNullToJson() {
        JsonConverter jsonConverter = new JsonConverter();
        String json = jsonConverter.toJson(null);
        Assertions.assertThat((String)json).isEqualTo((Object)"null");
    }

    @Test
    public void shouldConvertNullFromJson() {
        JsonConverter jsonConverter = new JsonConverter();
        Integer value = (Integer)jsonConverter.fromJson("null", Integer.class);
        Assertions.assertThat((Integer)value).isNull();
    }

    @Test
    public void shouldUseCustomTypeAdapterWhenConvertingToJson() {
        JsonConverter jsonConverter = new JsonConverter((Collection)ImmutableList.of((Object)((Object)new DummyJsonPersonTypeAdapter())));
        String json = jsonConverter.toJson((Object)new DummyJsonPerson("mad", "kaz"));
        Assertions.assertThat((String)json).isEqualTo((Object)"\"mad@kaz\"");
    }

    @Test
    public void shouldUseCustomTypeAdapterWhenConvertingFromJson() {
        JsonConverter jsonConverter = new JsonConverter((Collection)ImmutableList.of((Object)((Object)new DummyJsonPersonTypeAdapter())));
        DummyJsonPerson person = (DummyJsonPerson)jsonConverter.fromJson("\"mad@kaz\"", DummyJsonPerson.class);
        Assertions.assertThat((Object)person).isEqualTo((Object)new DummyJsonPerson("mad", "kaz"));
    }
}

