/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import org.fest.assertions.api.Assertions;
import org.fest.assertions.api.ObjectAssert;
import org.javers.core.model.DummyNetworkAddress;
import org.javers.model.mapping.BeanBasedPropertyScanner;
import org.javers.model.mapping.ManagedClass;
import org.javers.model.mapping.ManagedClasses;
import org.javers.model.mapping.ValueObject;
import org.javers.model.mapping.type.TypeMapper;
import org.junit.Before;
import org.junit.Test;

public class ManagedClassesTest {
    private ManagedClasses managedClasses;
    private ManagedClass<DummyNetworkAddress> managedClass;

    @Before
    public void setUp() throws Throwable {
        this.managedClasses = new ManagedClasses();
        TypeMapper typeMapper = new TypeMapper();
        typeMapper.registerValueObjectType(DummyNetworkAddress.class);
        BeanBasedPropertyScanner scanner = new BeanBasedPropertyScanner(typeMapper);
        this.managedClass = new ValueObject(DummyNetworkAddress.class);
    }

    @Test
    public void shouldAddManagedClass() throws Throwable {
        this.managedClasses.add(this.managedClass);
        Assertions.assertThat((boolean)this.managedClasses.contains(this.managedClass)).isTrue();
    }

    @Test
    public void shouldContainManagedClassOfGivenSourceClass() throws Throwable {
        this.managedClasses.add(this.managedClass);
        boolean contain = this.managedClasses.containsManagedClassWithSourceClass(this.managedClass.getSourceClass());
        Assertions.assertThat((boolean)contain).isTrue();
    }

    @Test
    public void shouldGetManagedClassBySourceClass() throws Throwable {
        this.managedClasses.add(this.managedClass);
        ManagedClass returnedManagedClass = this.managedClasses.getBySourceClass(this.managedClass.getSourceClass());
        ((ObjectAssert)Assertions.assertThat((Object)returnedManagedClass).isNotNull()).isEqualTo(this.managedClass);
    }
}

