/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import com.googlecode.catchexception.CatchException;
import com.googlecode.catchexception.apis.CatchExceptionBdd;
import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.core.model.DummyAddress;
import org.javers.core.model.DummyUser;
import org.javers.model.mapping.EntityManager;
import org.javers.model.object.graph.ObjectGraphBuilder;
import org.javers.model.object.graph.ObjectNode;
import org.javers.test.assertion.JaversExceptionAssert;
import org.javers.test.assertion.NodeAssert;
import org.javers.test.builder.DummyUserBuilder;
import org.junit.Test;

public abstract class ObjectGraphBuilderTest {
    protected EntityManager entityManager;

    @Test
    public void shouldBuildOneNodeGraph() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser user = DummyUserBuilder.dummyUser().withName("Mad Kaz").build();
        ObjectNode node = graphBuilder.buildGraph((Object)user);
        Assertions.assertThat((Object)node.getEntity().getSourceClass()).isSameAs(DummyUser.class);
        Assertions.assertThat((Object)node.getLocalCdoId()).isEqualTo((Object)"Mad Kaz");
        Assertions.assertThat((List)node.getEdges()).isEmpty();
    }

    @Test
    public void shouldBuildTwoNodesGraphForTheSameEntity() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser user = DummyUserBuilder.dummyUser().withName("Mad Kaz").withSupervisor("Mad Stach").build();
        ObjectNode node = graphBuilder.buildGraph((Object)user);
        NodeAssert.assertThat(node).hasEdges(1).hasCdoId("Mad Kaz").hasEdge("supervisor").isSingleEdgeTo("Mad Stach");
    }

    @Test
    public void shouldBuildTwoNodesGraphForDifferentEntities() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser user = DummyUserBuilder.dummyUser().withName("Mad Kaz").withDetails().build();
        ObjectNode node = graphBuilder.buildGraph((Object)user);
        NodeAssert.assertThat(node).hasEdges(1).hasCdoId("Mad Kaz").hasEdge("dummyUserDetails").isSingleEdgeTo(1L);
    }

    @Test
    public void shouldBuildThreeNodesLinearGraph() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser[] kaziki = new DummyUser[4];
        for (int i = 0; i < 3; ++i) {
            kaziki[i] = DummyUserBuilder.dummyUser().withName("Mad Kaz " + i).build();
            if (i <= 0) continue;
            kaziki[i - 1].setSupervisor(kaziki[i]);
        }
        ObjectNode node = graphBuilder.buildGraph((Object)kaziki[0]);
        NodeAssert.assertThat(node).hasEdges(1).hasCdoId("Mad Kaz 0").hasSingleEdge("supervisor").andTargetNode().hasEdges(1).hasCdoId("Mad Kaz 1").hasSingleEdge("supervisor").andTargetNode().hasNoEdges().hasCdoId("Mad Kaz 2");
    }

    @Test
    public void shouldBuildFourNodesGraphWithThreeLevels() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser stach = DummyUserBuilder.dummyUser().withName("Mad Stach").withDetails(2L).build();
        DummyUser kaz = DummyUserBuilder.dummyUser().withName("Mad Kaz").withDetails(1L).withSupervisor(stach).build();
        ObjectNode node = graphBuilder.buildGraph((Object)kaz);
        NodeAssert.assertThat(node).hasEdges(2).hasCdoId("Mad Kaz").and().hasEdge("supervisor").isSingleEdge().andTargetNode().hasCdoId("Mad Stach").hasEdge("dummyUserDetails").isSingleEdgeTo(2L);
        NodeAssert.assertThat(node).hasEdge("dummyUserDetails").isSingleEdgeTo(1L);
    }

    @Test
    public void shouldBuildGraphWithOneSingleEdgeAndOneMultiEdge() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser stach = DummyUserBuilder.dummyUser().withName("Mad Stach").withDetails(2L).withDetailsList(3).build();
        ObjectNode node = graphBuilder.buildGraph((Object)stach);
        NodeAssert.assertThat(node).hasEdges(2);
        NodeAssert.assertThat(node).hasSingleEdge("dummyUserDetails");
        NodeAssert.assertThat(node).hasMultiEdge("dummyUserDetailsList").ofSize(3);
    }

    @Test
    public void shouldBuildGraphWithThreeLevelsWithMultiEdge() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser stach = DummyUserBuilder.dummyUser().withName("Stach").withDetailsList(3).build();
        DummyUser kaz = DummyUserBuilder.dummyUser().withName("Mad Kaz").withSupervisor(stach).build();
        ObjectNode node = graphBuilder.buildGraph((Object)kaz);
        NodeAssert.assertThat(node).hasCdoId("Mad Kaz").hasEdge("supervisor").isSingleEdgeTo("Stach").andTargetNode().hasMultiEdge("dummyUserDetailsList").ofSize(3);
    }

    @Test
    public void shouldBuildGraphWithMultiEdgeToNodeWithMultiEdge() {
        int numberOfElements = 3;
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser rob = DummyUserBuilder.dummyUser().withName("rob").withEmployees(3).build();
        DummyUser stach = DummyUserBuilder.dummyUser().withName("stach").withEmployee(rob).withEmployees(2).build();
        DummyUser kaz = DummyUserBuilder.dummyUser().withName("kaz").withSupervisor(stach).build();
        ObjectNode node = graphBuilder.buildGraph((Object)kaz);
        NodeAssert.assertThat(node).hasCdoId("kaz").and().hasEdge("supervisor").isSingleEdgeTo("stach").andTargetNode().hasEdge("employeesList").isMultiEdge("Em1", "Em2", "rob").andTargetNode("rob").hasEdge("employeesList").isMultiEdge("Em1", "Em2", "Em3");
    }

    @Test
    public void shouldThrowExceptionWhenTryToBuildGraphFromValueObject() throws Throwable {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyAddress valueObject = new DummyAddress();
        ((ObjectGraphBuilder)CatchExceptionBdd.when((Object)graphBuilder)).buildGraph((Object)valueObject);
        JaversExceptionAssert.assertThat((JaversException)CatchException.caughtException()).hasCode(JaversExceptionCode.UNEXPECTED_VALUE_OBJECT);
    }

    @Test
    public void shouldManageGraphCycles() {
        ObjectGraphBuilder graphBuilder = new ObjectGraphBuilder(this.entityManager);
        DummyUser superKaz = DummyUserBuilder.dummyUser().withName("superKaz").build();
        DummyUser kaz = DummyUserBuilder.dummyUser().withName("kaz").withSupervisor(superKaz).build();
        DummyUser microKaz = DummyUserBuilder.dummyUser().withName("microKaz").withSupervisor(kaz).build();
        superKaz.setEmployeesList(kaz, microKaz);
        ObjectNode node = graphBuilder.buildGraph((Object)superKaz);
        NodeAssert.assertThat(node).hasCdoId("superKaz").hasEdge("employeesList").isMultiEdge("kaz", "microKaz").andTargetNode("kaz").hasEdge("supervisor").isSingleEdgeTo("superKaz");
        NodeAssert.assertThat(node).hasCdoId("superKaz").hasMultiEdge("employeesList").andTargetNode("microKaz").hasEdge("supervisor").isSingleEdgeTo("kaz").andTargetNode().hasEdge("supervisor").isSingleEdgeTo("superKaz");
    }
}

