/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.object.graph;

import org.javers.core.model.DummyUser;
import org.javers.model.domain.Cdo;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.EntityFactory;
import org.javers.model.object.graph.ObjectNode;
import org.javers.model.object.graph.ObjectWrapper;
import org.javers.test.assertion.Assertions;
import org.javers.test.builder.DummyUserBuilder;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class ObjectWrapperTest {
    protected EntityFactory entityFactory;

    @Test
    public void shouldHoldEntityReference() {
        DummyUser cdo = DummyUserBuilder.dummyUser().build();
        Entity entity = this.entityFactory.create(DummyUser.class);
        ObjectWrapper wrapper = new ObjectWrapper((Object)cdo, entity);
        Assertions.assertThat(wrapper.getEntity()).isSameAs(entity);
    }

    @Test
    public void shouldHoldCdoReference() {
        DummyUser cdo = DummyUserBuilder.dummyUser().build();
        Entity entity = this.entityFactory.create(DummyUser.class);
        ObjectWrapper wrapper = new ObjectWrapper((Object)cdo, entity);
        Assertions.assertThat((Object)wrapper.unwrapCdo()).isSameAs((Object)cdo);
    }

    @Test
    public void shouldReturnCdoId() {
        DummyUser cdo = DummyUserBuilder.dummyUser().withName("Mad Kaz").build();
        Entity entity = this.entityFactory.create(DummyUser.class);
        ObjectWrapper wrapper = new ObjectWrapper((Object)cdo, entity);
        Assertions.assertThat((Object)wrapper.getLocalCdoId()).isEqualTo((Object)"Mad Kaz");
    }

    @Test
    public void shouldBeEqualByIdValueAndEntityClass() {
        ObjectWrapper first = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        ObjectWrapper second = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        Assertions.assertThat((int)first.hashCode()).isEqualTo(second.hashCode());
        Assertions.assertThat((ObjectNode)first).isEqualTo(second);
    }

    @Test
    public void shouldNotBeEqualWithDifferentIdValue() {
        ObjectWrapper first = new ObjectWrapper((Object)new DummyUser("stach"), this.entityFactory.create(DummyUser.class));
        ObjectWrapper second = new ObjectWrapper((Object)new DummyUser("Mad Kax 1"), this.entityFactory.create(DummyUser.class));
        Assertions.assertThat((ObjectNode)first).isNotEqualTo(second);
    }

    @Test
    public void shouldHaveReflexiveEqualsMethod() {
        ObjectWrapper objectWrapper = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        Assertions.assertThat((ObjectNode)objectWrapper).isEqualTo(objectWrapper);
    }

    @Test
    public void shouldHaveSymmetricAndTransitiveEqualsMethod() {
        ObjectWrapper first = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        ObjectWrapper second = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        ObjectWrapper third = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        Assertions.assertThat((ObjectNode)first).isEqualTo(second);
        Assertions.assertThat((ObjectNode)second).isEqualTo(third);
        Assertions.assertThat((ObjectNode)first).isEqualTo(third);
    }

    @Test
    public void shouldReturnFalseWhenEqualsMethodHasNullArg() {
        ObjectWrapper first = new ObjectWrapper((Object)new DummyUser("Mad Kax"), this.entityFactory.create(DummyUser.class));
        Assertions.assertThat((ObjectNode)first).isNotEqualTo(null);
    }

    @Test
    public void shouldDelegateEqualsAndHashCodeToCdo() {
        Cdo mockedCdo = (Cdo)Mockito.mock(Cdo.class);
        ObjectWrapper node1 = new ObjectWrapper(mockedCdo);
        ObjectWrapper node2 = new ObjectWrapper(mockedCdo);
        Assertions.assertThat((boolean)node1.equals((Object)node2)).isTrue();
        Assertions.assertThat((int)node1.hashCode()).isEqualTo(mockedCdo.hashCode());
    }
}

