/*
 * Decompiled with CFR 0.152.
 */
package org.javers.test.assertion;

import org.fest.assertions.api.AbstractAssert;
import org.javers.model.domain.Change;
import org.javers.model.domain.Diff;
import org.javers.model.domain.changeType.NewObject;
import org.javers.model.domain.changeType.ObjectRemoved;
import org.javers.model.domain.changeType.ReferenceAdded;
import org.javers.test.assertion.Assertions;

public class ChangeAssert
extends AbstractAssert<ChangeAssert, Change> {
    private ChangeAssert(Change actual) {
        super((Object)actual, ChangeAssert.class);
    }

    public static ChangeAssert assertThat(Change actual) {
        return new ChangeAssert(actual);
    }

    public ChangeAssert isNewObject() {
        Assertions.assertThat((Object)this.actual).isExactlyInstanceOf(NewObject.class);
        return this;
    }

    public ChangeAssert isObjectRemoved() {
        Assertions.assertThat((Object)this.actual).isExactlyInstanceOf(ObjectRemoved.class);
        return this;
    }

    public ChangeAssert hasCdoId(Object cdoId) {
        Assertions.assertThat((Object)((Change)this.actual).getGlobalCdoId().getLocalCdoId()).isEqualTo(cdoId);
        return this;
    }

    public ChangeAssert isReferenceAdded() {
        Assertions.assertThat((Object)this.actual).isExactlyInstanceOf(ReferenceAdded.class);
        return this;
    }

    public ChangeAssert hasEntityTypeOf(Class<?> entityClass) {
        Assertions.assertThat((Object)((Change)this.actual).getGlobalCdoId().getEntity().getSourceClass()).isEqualTo(entityClass);
        return this;
    }

    public ChangeAssert hasParentEqualTo(Diff parent) {
        Assertions.assertThat((Object)((Change)this.actual).getParent()).isEqualTo((Object)parent);
        return this;
    }

    public ChangeAssert hasCdo(Object expected) {
        Assertions.assertThat((Object)((Change)this.actual).getAffectedCdo()).isSameAs(expected);
        return this;
    }
}

