/*
 * Decompiled with CFR 0.152.
 */
package org.javers.test.assertion;

import java.util.List;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.api.ListAssert;
import org.javers.model.object.graph.Edge;
import org.javers.model.object.graph.ObjectNode;
import org.javers.test.assertion.Assertions;
import org.javers.test.assertion.EdgeAssert;
import org.javers.test.assertion.MultiEdgeAssert;
import org.javers.test.assertion.SingleEdgeAssert;

public class NodeAssert
extends AbstractAssert<NodeAssert, ObjectNode> {
    private NodeAssert(ObjectNode actual) {
        super((Object)actual, NodeAssert.class);
    }

    public static NodeAssert assertThat(ObjectNode actual) {
        return new NodeAssert(actual);
    }

    public NodeAssert hasCdoId(String expectedCdoId) {
        Assertions.assertThat((Object)((ObjectNode)this.actual).getLocalCdoId()).isEqualTo((Object)expectedCdoId);
        return this;
    }

    public NodeAssert hasEdges(int expectedSize) {
        ((ListAssert)Assertions.assertThat((List)((ObjectNode)this.actual).getEdges()).overridingErrorMessage("expected edges:" + expectedSize + " but was:" + ((ObjectNode)this.actual).getEdges().size(), new Object[0])).hasSize(expectedSize);
        return this;
    }

    public EdgeAssert andFirstEdge() {
        Assertions.assertThat((List)((ObjectNode)this.actual).getEdges()).isNotEmpty();
        return EdgeAssert.assertThat((Edge)((ObjectNode)this.actual).getEdges().get(0));
    }

    public EdgeAssert hasEdge(String edgeName) {
        ((ListAssert)Assertions.assertThat((List)((ObjectNode)this.actual).getEdges()).overridingErrorMessage("no edges", new Object[0])).isNotEmpty();
        for (Edge edge : ((ObjectNode)this.actual).getEdges()) {
            if (!edge.getProperty().getName().equals(edgeName)) continue;
            return EdgeAssert.assertThat(edge);
        }
        Assertions.fail((String)("no such edge: " + edgeName));
        return null;
    }

    public NodeAssert hasNoEdges() {
        return this.hasEdges(0);
    }

    public NodeAssert and() {
        return this;
    }

    public SingleEdgeAssert hasSingleEdge(String edgeName) {
        return this.hasEdge(edgeName).isSingleEdge();
    }

    public MultiEdgeAssert hasMultiEdge(String edgeName) {
        return this.hasEdge(edgeName).isMultiEdge();
    }
}

