/*
 * Decompiled with CFR 0.152.
 */
package org.javers.test.builder;

import java.util.ArrayList;
import org.javers.core.model.DummyUser;
import org.javers.core.model.DummyUserDetails;
import org.javers.test.builder.DummyUserDetailsBuilder;

public class DummyUserBuilder {
    private int DUMMY_ID = 1;
    private DummyUser dummyUser = new DummyUser();

    private DummyUserBuilder() {
    }

    public static DummyUserBuilder dummyUser() {
        return new DummyUserBuilder();
    }

    public DummyUser build() {
        if (this.dummyUser.getName() == null) {
            this.dummyUser.setName("some");
        }
        return this.dummyUser;
    }

    public DummyUserBuilder withName(String name) {
        this.dummyUser.setName(name);
        return this;
    }

    public DummyUserBuilder withInteger(Integer largeInt) {
        this.dummyUser.setLargeInt(largeInt);
        return this;
    }

    public DummyUserBuilder withSex(DummyUser.Sex sex) {
        this.dummyUser.setSex(sex);
        return this;
    }

    public DummyUserBuilder withSupervisor(String supervisorName) {
        this.dummyUser.setSupervisor(new DummyUser(supervisorName));
        return this;
    }

    public DummyUserBuilder withSupervisor(DummyUser supervisor) {
        this.dummyUser.setSupervisor(supervisor);
        return this;
    }

    public DummyUserBuilder withDetails() {
        this.dummyUser.setDummyUserDetails(DummyUserDetailsBuilder.dummyUserDetails().build());
        return this;
    }

    public DummyUserBuilder withDetails(long id) {
        this.dummyUser.setDummyUserDetails(DummyUserDetailsBuilder.dummyUserDetails().withId(id).build());
        return this;
    }

    public DummyUserBuilder withDetailsList(int numberOfDetailsInList) {
        ArrayList<DummyUserDetails> detailsList = new ArrayList<DummyUserDetails>(numberOfDetailsInList);
        for (int i = 0; i < numberOfDetailsInList; ++i) {
            detailsList.add(DummyUserDetailsBuilder.dummyUserDetails().withId(i + this.DUMMY_ID).build());
            ++this.DUMMY_ID;
        }
        this.dummyUser.setDummyUserDetailsList(detailsList);
        return this;
    }

    public DummyUserBuilder withEmployees(int numberOfEmployees) {
        for (int i = 0; i < numberOfEmployees; ++i) {
            this.dummyUser.addEmployee(new DummyUser("Em" + this.DUMMY_ID++));
        }
        return this;
    }

    public DummyUserBuilder withEmployee(DummyUser rob) {
        this.dummyUser.addEmployee(rob);
        return this;
    }

    public DummyUserBuilder withFlag(boolean flag) {
        this.dummyUser.setFlag(flag);
        return this;
    }

    public DummyUserBuilder withBoxedFlag(Boolean boxedFlag) {
        this.dummyUser.setBigFlag(boxedFlag);
        return this;
    }

    public DummyUserBuilder withAge(int age) {
        this.dummyUser.setAge(age);
        return this;
    }
}

