/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import org.javers.common.validation.Validate;
import org.javers.model.domain.GlobalCdoId;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.Property;
import org.javers.model.object.graph.ObjectNode;

public class NodePair {
    private final ObjectNode left;
    private final ObjectNode right;

    public NodePair(ObjectNode left, ObjectNode right) {
        Validate.argumentsAreNotNull(left, right);
        Validate.argumentCheck(left.getGlobalCdoId().equals(right.getGlobalCdoId()), "left & right should refer to the same Cdo");
        this.left = left;
        this.right = right;
    }

    public Object getLeftPropertyValue(Property property) {
        return this.left.getPropertyValue(property);
    }

    public Object getRightPropertyValue(Property property) {
        return this.right.getPropertyValue(property);
    }

    public ObjectNode getLeft() {
        return this.left;
    }

    public ObjectNode getRight() {
        return this.right;
    }

    public GlobalCdoId getGlobalCdoId() {
        return this.left.getGlobalCdoId();
    }

    public Entity getEntity() {
        return this.left.getEntity();
    }
}

