/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.model.domain.PropertyChange;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.type.CollectionType;
import org.javers.model.mapping.type.EntityReferenceType;
import org.javers.model.mapping.type.JaversType;
import org.javers.model.mapping.type.PrimitiveType;
import org.javers.model.mapping.type.ValueObjectType;

public abstract class PropertyChangeAppender<T extends PropertyChange> {
    protected static final Set<Class<JaversType>> COLLECTION_TYPES = Sets.asSet(CollectionType.class);
    protected static final Set<Class<JaversType>> VALUE_TYPES = Sets.asSet(PrimitiveType.class, ValueObjectType.class);
    protected static final Set<Class<JaversType>> ENTITY_REF_TYPES = Sets.asSet(EntityReferenceType.class);

    public final Collection<T> calculateChangesIfSupported(NodePair pair, Property property) {
        if (!this.supports(property)) {
            return Collections.EMPTY_SET;
        }
        return this.calculateChanges(pair, property);
    }

    protected boolean supports(Property property) {
        return this.getSupportedPropertyTypes().contains(property.getType().getClass());
    }

    protected abstract Set<Class<JaversType>> getSupportedPropertyTypes();

    protected abstract Collection<T> calculateChanges(NodePair var1, Property var2);
}

