/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.pico;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.javers.common.pico.JaversModule;
import org.javers.common.validation.Validate;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.pico.CoreJaversModule;
import org.javers.model.pico.ModelJaversModule;
import org.picocontainer.Characteristics;
import org.picocontainer.DefaultPicoContainer;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class JaversContainerFactory {
    public static PicoContainer create(List<JaversModule> modules, List<?> beans) {
        Validate.argumentIsNotNull(modules);
        DefaultPicoContainer container = new DefaultPicoContainer();
        for (JaversModule module : modules) {
            for (Class component : module.getModuleComponents()) {
                JaversContainerFactory.addComponent((MutablePicoContainer)container, component);
            }
        }
        if (beans != null) {
            for (JaversModule bean : beans) {
                JaversContainerFactory.addComponent((MutablePicoContainer)container, bean);
            }
        }
        return container;
    }

    private static void addComponent(MutablePicoContainer container, Object classOrInstance) {
        container.as(new Properties[]{Characteristics.CACHE}).addComponent(classOrInstance);
    }

    public static PicoContainer createDefaultCore() {
        List<JaversModule> coreModules = Arrays.asList(new CoreJaversModule(), new ModelJaversModule(new JaversCoreConfiguration()));
        return JaversContainerFactory.create(coreModules, null);
    }
}

