/*
 * Decompiled with CFR 0.152.
 */
package org.javers.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.javers.json.JsonTypeAdapter;
import org.javers.json.typeAdapter.LocalDateTimeTypeAdapter;

public class JsonConverter {
    private Gson gson;
    private static final JsonTypeAdapter[] BUILT_IN_ADAPTERS = new JsonTypeAdapter[]{new LocalDateTimeTypeAdapter()};

    public JsonConverter() {
        this.gson = this.initGsonBuilder().create();
    }

    public JsonConverter(Collection<JsonTypeAdapter> customAdapters) {
        GsonBuilder gsonBuilder = this.initGsonBuilder();
        this.registerAdapters(gsonBuilder, customAdapters);
        this.gson = gsonBuilder.create();
    }

    private GsonBuilder initGsonBuilder() {
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
        this.registerAdapters(gsonBuilder, Arrays.asList(BUILT_IN_ADAPTERS));
        return gsonBuilder;
    }

    private void registerAdapters(GsonBuilder gsonBuilder, Collection<JsonTypeAdapter> adapters) {
        for (JsonTypeAdapter adapter : adapters) {
            this.registerSerializerAndDeserializer(gsonBuilder, adapter);
        }
    }

    private void registerSerializerAndDeserializer(GsonBuilder gsonBuilder, final JsonTypeAdapter adapter) {
        JsonSerializer jsonSerializer = new JsonSerializer(){

            public JsonElement serialize(Object value, Type type, JsonSerializationContext jsonSerializationContext) {
                return adapter.toJson(value);
            }
        };
        JsonDeserializer jsonDeserializer = new JsonDeserializer(){

            public Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
                return adapter.fromJson(jsonElement);
            }
        };
        gsonBuilder.registerTypeAdapter(adapter.getType(), (Object)jsonSerializer);
        gsonBuilder.registerTypeAdapter(adapter.getType(), (Object)jsonDeserializer);
    }

    public String toJson(Object value) {
        return this.gson.toJson(value);
    }

    public String toJson(Object value, Type requiredType) {
        return this.gson.toJson(value);
    }

    public <T> T fromJson(String json, Class<T> expectedType) {
        return (T)this.gson.fromJson(json, expectedType);
    }
}

