/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.Entity;
import org.javers.model.mapping.EntityDefinition;
import org.javers.model.mapping.Property;
import org.javers.model.mapping.PropertyScanner;

public class EntityFactory {
    private PropertyScanner propertyScanner;

    public EntityFactory(PropertyScanner propertyScanner) {
        Validate.argumentIsNotNull(propertyScanner);
        this.propertyScanner = propertyScanner;
    }

    @Deprecated
    public <S> Entity create(Class<S> clazz) {
        return this.create(new EntityDefinition(clazz));
    }

    public <S> Entity create(EntityDefinition entityDefinition) {
        List<Property> beanProperties = this.propertyScanner.scan(entityDefinition.getClazz());
        Property idProperty = null;
        if (entityDefinition.hasCustomId()) {
            idProperty = this.findIdPropertyByName(beanProperties, entityDefinition);
        }
        return new Entity(entityDefinition.getClazz(), beanProperties, idProperty);
    }

    private Property findIdPropertyByName(List<Property> beanProperties, EntityDefinition entityDefinition) {
        for (Property property : beanProperties) {
            if (!property.getName().equals(entityDefinition.getIdPropertyName())) continue;
            return property;
        }
        throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, entityDefinition.getIdPropertyName(), entityDefinition.getClazz().getName());
    }
}

