/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import java.util.HashSet;
import java.util.Set;
import org.javers.common.validation.Validate;
import org.javers.core.exceptions.JaversException;
import org.javers.core.exceptions.JaversExceptionCode;
import org.javers.model.mapping.EntityDefinition;
import org.javers.model.mapping.EntityFactory;
import org.javers.model.mapping.ManagedClass;
import org.javers.model.mapping.ManagedClasses;
import org.javers.model.mapping.ValueObjectFactory;
import org.javers.model.mapping.type.TypeMapper;
import org.javers.model.mapping.type.ValueObjectType;

public class EntityManager {
    private final EntityFactory entityFactory;
    private final ValueObjectFactory valueObjectFactory;
    private final TypeMapper typeMapper;
    private final Set<EntityDefinition> entityDefinitions = new HashSet<EntityDefinition>();
    private final ManagedClasses managedClasses = new ManagedClasses();

    public EntityManager(EntityFactory entityFactory, ValueObjectFactory valueObjectFactory, TypeMapper typeMapper) {
        Validate.argumentsAreNotNull(entityFactory, valueObjectFactory, typeMapper);
        this.entityFactory = entityFactory;
        this.typeMapper = typeMapper;
        this.valueObjectFactory = valueObjectFactory;
    }

    public ManagedClass getByClass(Class<?> clazz) {
        if (!this.isRegisterd(clazz)) {
            throw new JaversException(JaversExceptionCode.CLASS_NOT_MANAGED, clazz.getName());
        }
        if (this.isRegisterd(clazz) && !this.isManaged(clazz)) {
            throw new JaversException(JaversExceptionCode.ENTITY_MANAGER_NOT_INITIALIZED, clazz.getName());
        }
        return this.managedClasses.getBySourceClass(clazz);
    }

    @Deprecated
    public void registerEntity(Class<?> entityClass) {
        this.registerEntity(new EntityDefinition(entityClass));
    }

    public void registerEntity(EntityDefinition def) {
        Validate.argumentIsNotNull(def);
        if (this.isRegisterd(def)) {
            return;
        }
        this.typeMapper.registerEntityReferenceType(def.getClazz());
        this.entityDefinitions.add(def);
    }

    public void registerValueObject(Class<?> valueObjectClass) {
        Validate.argumentIsNotNull(valueObjectClass);
        if (this.isRegisterd(valueObjectClass)) {
            return;
        }
        this.typeMapper.registerValueObjectType(valueObjectClass);
    }

    private boolean isRegisterd(Class<?> managedClass) {
        return this.typeMapper.isMapped(managedClass);
    }

    private boolean isRegisterd(EntityDefinition def) {
        return this.entityDefinitions.contains(def);
    }

    public boolean isManaged(Class<?> clazz) {
        return this.managedClasses.containsManagedClassWithSourceClass(clazz);
    }

    public boolean isInitialized() {
        return this.managedClasses.count() == this.typeMapper.getCountOfEntitiesAndValueObjects();
    }

    public void buildManagedClasses() {
        for (EntityDefinition entityDef : this.entityDefinitions) {
            this.manageEntity(entityDef);
        }
        for (ValueObjectType voType : this.typeMapper.getMappedValueObjectTypes()) {
            this.manageValueObject(voType.getBaseJavaType());
        }
    }

    private void manageEntity(EntityDefinition entityDef) {
        this.managedClasses.add(this.entityFactory.create(entityDef));
    }

    private void manageValueObject(Class classToManage) {
        this.managedClasses.add(this.valueObjectFactory.create(classToManage));
    }
}

