/*
 * Decompiled with CFR 0.152.
 */
package org.javers.model.mapping;

import org.javers.common.validation.Validate;

public abstract class ManagedClass<S> {
    protected final Class<S> sourceClass;

    public ManagedClass(Class<S> sourceClass) {
        Validate.argumentIsNotNull(sourceClass);
        this.sourceClass = sourceClass;
    }

    public boolean isInstance(Object cdo) {
        Validate.argumentIsNotNull(cdo);
        return this.sourceClass.isAssignableFrom(cdo.getClass());
    }

    public Class<S> getSourceClass() {
        return this.sourceClass;
    }

    public int hashCode() {
        return this.sourceClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ManagedClass other = (ManagedClass)obj;
        return this.sourceClass.equals(other.sourceClass);
    }
}

