/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.util.Collections;
import java.util.List;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.diff.Diff;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.joda.time.LocalDateTime;

public final class Commit {
    private final CommitId id;
    private final List<CdoSnapshot> snapshots;
    private final String author;
    private final LocalDateTime commitDate;
    private final Diff diff;

    Commit(CommitId id, String author, List<CdoSnapshot> snapshots, Diff diff) {
        Validate.argumentsAreNotNull(id, author, snapshots, diff);
        this.author = author;
        this.snapshots = snapshots;
        this.commitDate = new LocalDateTime();
        this.diff = diff;
        this.id = id;
        for (CdoSnapshot snapshot : snapshots) {
            snapshot.bindTo(id);
        }
    }

    public CommitId getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public Diff getDiff() {
        return this.diff;
    }

    public LocalDateTime getCommitDate() {
        return this.commitDate;
    }

    public List<CdoSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Commit(id:" + this.id);
        b.append(", snapshots:" + this.snapshots.size());
        b.append(", " + this.diff.toString());
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit other = (Commit)o;
        return this.id.equals(other.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

