/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collections;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.ObjectGraph;
import org.javers.core.graph.ObjectNode;

public class GraphPair {
    private final ObjectGraph leftGraph;
    private final ObjectGraph rightGraph;
    private final Set<ObjectNode> onlyOnLeft;
    private final Set<ObjectNode> onlyOnRight;

    public GraphPair(ObjectGraph leftGraph, ObjectGraph rightGraph) {
        this.leftGraph = leftGraph;
        this.rightGraph = rightGraph;
        this.onlyOnLeft = Sets.difference(leftGraph.flatten(), rightGraph.flatten());
        this.onlyOnRight = Sets.difference(rightGraph.flatten(), leftGraph.flatten());
    }

    public GraphPair(ObjectGraph currentGraph) {
        this.leftGraph = new ObjectGraph(){

            @Override
            public Set<ObjectNode> flatten() {
                return Collections.EMPTY_SET;
            }
        };
        this.rightGraph = currentGraph;
        this.onlyOnLeft = Collections.EMPTY_SET;
        this.onlyOnRight = this.rightGraph.flatten();
    }

    public Set<ObjectNode> getOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Set<ObjectNode> getOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Set<ObjectNode> getLeftNodeSet() {
        return this.leftGraph.flatten();
    }

    public Set<ObjectNode> getRightNodeSet() {
        return this.rightGraph.flatten();
    }
}

