/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.MapChangeAppender;
import org.javers.core.diff.appenders.MapChangesToListChangesFunction;
import org.javers.core.diff.appenders.PropertyChangeAppender;
import org.javers.core.diff.changetype.ContainerValueChange;
import org.javers.core.diff.changetype.ListChange;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListChangeAppender
extends PropertyChangeAppender<ListChange> {
    private static final Logger logger = LoggerFactory.getLogger(ListChangeAppender.class);
    private final MapChangeAppender mapChangeAppender;
    private final TypeMapper typeMapper;

    public ListChangeAppender(MapChangeAppender mapChangeAppender, TypeMapper typeMapper) {
        this.mapChangeAppender = mapChangeAppender;
        this.typeMapper = typeMapper;
    }

    @Override
    protected Class<? extends JaversType> getSupportedPropertyType() {
        return ListType.class;
    }

    public boolean isSupportedContainer(Property property) {
        ContainerType propertyType = (ContainerType)this.typeMapper.getPropertyType(property);
        if (!this.typeMapper.isPrimitiveOrValueOrObject(propertyType.getItemClass())) {
            logger.error("not implemented Enumerable content type {} on {}", propertyType.getElementTypes(), (Object)property);
            return false;
        }
        return true;
    }

    @Override
    protected ListChange calculateChanges(NodePair pair, Property property) {
        List leftList = (List)pair.getLeftPropertyValue(property);
        List rightList = (List)pair.getRightPropertyValue(property);
        List<EntryChange> entryChanges = this.mapChangeAppender.calculateEntryChanges(Lists.asMap(leftList), Lists.asMap(rightList));
        if (!entryChanges.isEmpty()) {
            if (!this.isSupportedContainer(property)) {
                return null;
            }
            List<ContainerValueChange> elementChanges = Lists.transform(entryChanges, new MapChangesToListChangesFunction());
            return new ListChange(pair.getGlobalCdoId(), property, elementChanges);
        }
        return null;
    }
}

