/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashSet;
import java.util.Set;
import org.javers.common.patterns.visitors.Visitor;
import org.javers.core.graph.ObjectNode;

public abstract class GraphVisitor
implements Visitor<ObjectNode> {
    private final Set<ObjectNode> visited = new HashSet<ObjectNode>();

    @Override
    public final void visit(ObjectNode node) {
        this.visitOnce(node);
        this.markVisited(node);
    }

    protected void visitOnce(ObjectNode node) {
    }

    public boolean wasVisited(ObjectNode node) {
        return this.visited.contains(node);
    }

    private void markVisited(ObjectNode node) {
        this.visited.add(node);
    }
}

