/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.HashMap;
import java.util.Map;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;

class NodeReuser {
    private final Map<Cdo, ObjectNode> reverseCdoIdMap = new HashMap<Cdo, ObjectNode>();
    private int reusedNodes;
    private int entities;
    private int valueObjects;

    NodeReuser() {
    }

    boolean isReusable(Cdo cdo) {
        return this.reverseCdoIdMap.containsKey(cdo);
    }

    ObjectNode getForReuse(Cdo cdo) {
        ++this.reusedNodes;
        return this.reverseCdoIdMap.get(cdo);
    }

    void saveForReuse(ObjectNode reference) {
        if (reference.getGlobalCdoId() instanceof InstanceId) {
            ++this.entities;
        }
        if (reference.getGlobalCdoId() instanceof ValueObjectId) {
            ++this.valueObjects;
        }
        this.reverseCdoIdMap.put(reference.getCdo(), reference);
    }

    public int nodesCount() {
        return this.reverseCdoIdMap.size();
    }

    public int reusedNodesCount() {
        return this.reusedNodes;
    }

    public int entitiesCount() {
        return this.entities;
    }

    public int voCount() {
        return this.valueObjects;
    }
}

