/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter;

import org.javers.core.json.BasicStringTypeAdapter;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class LocalDateTypeAdapter
extends BasicStringTypeAdapter<LocalDate> {
    public static final DateTimeFormatter ISO_FORMATTER = ISODateTimeFormat.date();

    @Override
    public String serialize(LocalDate sourceValue) {
        return ISO_FORMATTER.print((ReadablePartial)sourceValue);
    }

    @Override
    public LocalDate deserialize(String serializedValue) {
        return ISO_FORMATTER.parseLocalDate(serializedValue);
    }

    @Override
    public Class getValueType() {
        return LocalDate.class;
    }
}

