/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.collections.Optional;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.ManagedClass;
import org.javers.core.metamodel.property.Property;

public abstract class Cdo {
    private final GlobalCdoId globalId;

    protected Cdo(GlobalCdoId globalId) {
        Validate.argumentIsNotNull(globalId);
        this.globalId = globalId;
    }

    public GlobalCdoId getGlobalId() {
        return this.globalId;
    }

    public ManagedClass getManagedClass() {
        return this.globalId.getCdoClass();
    }

    public abstract Optional<Object> getWrappedCdo();

    public abstract Object getPropertyValue(Property var1);

    public abstract boolean isNull(Property var1);

    public Object getPropertyValue(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        Property property = this.getGlobalId().getCdoClass().getProperty(propertyName);
        if (property == null) {
            throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, propertyName, this.getGlobalId().getCdoClass().getName());
        }
        return this.getPropertyValue(property);
    }

    public String toString() {
        return this.globalId.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Cdo)) {
            return false;
        }
        Cdo other = (Cdo)o;
        return this.globalId.equals(other.globalId);
    }

    public int hashCode() {
        return this.globalId.hashCode();
    }
}

