/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.Map;
import org.javers.common.collections.Defaults;
import org.javers.common.collections.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitId;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.Property;

public final class CdoSnapshot
extends Cdo {
    private CommitId commitId;
    private final Map<Property, Object> state;

    CdoSnapshot(GlobalCdoId globalId, Map<Property, Object> state) {
        super(globalId);
        Validate.argumentIsNotNull(state);
        this.state = state;
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.empty();
    }

    public int size() {
        return this.state.size();
    }

    @Override
    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        Object val = this.state.get(property);
        if (val == null) {
            return Defaults.defaultValue(property.getType());
        }
        return val;
    }

    @Override
    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return !this.state.containsKey(property);
    }

    public void bindTo(CommitId commitId) {
        if (this.commitId != null) {
            throw new IllegalStateException("snapshot already bound");
        }
        this.commitId = commitId;
    }

    public CommitId getCommitId() {
        return this.commitId;
    }

    public boolean stateEquals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CdoSnapshot other = (CdoSnapshot)o;
        return this.state.equals(other.state);
    }
}

