/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import java.util.HashMap;
import java.util.Map;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalCdoId;
import org.javers.core.metamodel.property.Property;

public class CdoSnapshotBuilder {
    private final GlobalCdoId globalCdoId;
    private final Map<Property, Object> state = new HashMap<Property, Object>();

    private CdoSnapshotBuilder(GlobalCdoId globalCdoId) {
        this.globalCdoId = globalCdoId;
    }

    public static CdoSnapshotBuilder cdoSnapshot(GlobalCdoId globalCdoId) {
        Validate.argumentIsNotNull(globalCdoId);
        return new CdoSnapshotBuilder(globalCdoId);
    }

    public CdoSnapshotBuilder withPropertyValue(Property property, Object value) {
        Validate.argumentIsNotNull(property);
        if (value == null) {
            return this;
        }
        if (this.state.containsKey(property)) {
            throw new JaversException(JaversExceptionCode.SNAPSHOT_STATE_VIOLATION, new Object[0]);
        }
        this.state.put(property, value);
        return this;
    }

    public CdoSnapshot build() {
        return new CdoSnapshot(this.globalCdoId, this.state);
    }
}

