/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples;

import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.examples.Person;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.junit.Test;

public class BasicCommitExample {
    @Test
    public void shouldListChangeHistory() {
        Javers javers = JaversBuilder.javers().build();
        Person robert = new Person("bob", "Robert", "Martin");
        javers.commit("user", (Object)robert);
        robert.setFirstName("Robert C.");
        javers.commit("user", (Object)robert);
        List changes = javers.getChangeHistory((Object)"bob", Person.class, 5);
        Assertions.assertThat((List)changes).hasSize(1);
        Assertions.assertThat(changes.get(0)).isInstanceOf(ValueChange.class);
        ValueChange change = (ValueChange)changes.get(0);
        Assertions.assertThat((String)change.getProperty().getName()).isEqualTo((Object)"firstName");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)"Robert");
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)"Robert C.");
        List snapshots = javers.getStateHistory((Object)"bob", Person.class, 5);
        Assertions.assertThat((List)snapshots).hasSize(2);
        CdoSnapshot newState = (CdoSnapshot)snapshots.get(0);
        CdoSnapshot oldState = (CdoSnapshot)snapshots.get(1);
        Assertions.assertThat((Object)oldState.getPropertyValue("firstName")).isEqualTo((Object)"Robert");
        Assertions.assertThat((Object)newState.getPropertyValue("firstName")).isEqualTo((Object)"Robert C.");
        Assertions.assertThat((Object)oldState.getPropertyValue("login")).isEqualTo((Object)"bob");
        Assertions.assertThat((Object)newState.getPropertyValue("login")).isEqualTo((Object)"bob");
        Assertions.assertThat((Object)oldState.getPropertyValue("lastName")).isEqualTo((Object)"Martin");
        Assertions.assertThat((Object)newState.getPropertyValue("lastName")).isEqualTo((Object)"Martin");
    }
}

