/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javers.common.patterns.visitors.Visitable;
import org.javers.core.diff.Change;
import org.javers.core.diff.ChangeVisitor;

public class Diff
implements Visitable<ChangeVisitor> {
    private final List<Change> changes;

    Diff(List<Change> changes) {
        this.changes = changes;
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public boolean hasChanges() {
        return !this.changes.isEmpty();
    }

    @Override
    public void accept(ChangeVisitor changeVisitor) {
        for (Change change : this.changes) {
            change.accept(changeVisitor);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("changes - ");
        for (Map.Entry<Class<? extends Change>, Integer> e : this.countByType().entrySet()) {
            b.append(e.getKey().getSimpleName() + ":" + e.getValue() + " ");
        }
        return b.toString().trim();
    }

    public Map<Class<? extends Change>, Integer> countByType() {
        HashMap<Class<? extends Change>, Integer> result = new HashMap<Class<? extends Change>, Integer>();
        for (Change change : this.changes) {
            Class<?> key = change.getClass();
            if (result.containsKey(change.getClass())) {
                result.put(key, (Integer)result.get(key) + 1);
                continue;
            }
            result.put(key, 1);
        }
        return result;
    }
}

