/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.examples;

import java.util.List;
import org.fest.assertions.api.Assertions;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.javers.core.examples.Address;
import org.junit.Test;

public class BasicDiffExample {
    @Test
    public void shouldCompareTwoObjects() {
        Javers javers = JaversBuilder.javers().build();
        Address a1 = new Address("New York", "5th Avenue");
        Address a2 = new Address("New York", "6th Avenue");
        Diff diff = javers.compare((Object)a1, (Object)a2);
        this.println("diff: " + javers.toJson(diff));
        Assertions.assertThat((List)diff.getChanges()).hasSize(1);
        Assertions.assertThat(diff.getChanges().get(0)).isInstanceOf(ValueChange.class);
        ValueChange change = (ValueChange)diff.getChanges().get(0);
        this.println("propertyName: " + change.getProperty().getName());
        this.println("old value:    " + change.getLeft());
        this.println("new value:    " + change.getRight());
        Assertions.assertThat((String)change.getProperty().getName()).isEqualTo((Object)"street");
        Assertions.assertThat((Object)change.getLeft()).isEqualTo((Object)"5th Avenue");
        Assertions.assertThat((Object)change.getRight()).isEqualTo((Object)"6th Avenue");
    }

    private void println(String text) {
        System.out.println(text);
    }
}

