/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.javers.common.validation.Validate;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.JsonTypeAdapter;
import org.javers.core.json.typeadapter.AtomicTypeAdapter;
import org.javers.core.json.typeadapter.LocalDateTimeTypeAdapter;
import org.javers.core.json.typeadapter.LocalDateTypeAdapter;
import org.javers.core.json.typeadapter.change.ChangeTypeAdapter;
import org.javers.core.json.typeadapter.change.NewObjectTypeAdapter;
import org.javers.core.json.typeadapter.change.ObjectRemovedTypeAdapter;
import org.javers.core.json.typeadapter.change.ReferenceChangeTypeAdapter;
import org.javers.core.json.typeadapter.change.ValueChangeTypeAdapter;

public class JsonConverterBuilder {
    private static final JsonTypeAdapter[] BUILT_IN_ADAPTERS = new JsonTypeAdapter[]{new LocalDateTimeTypeAdapter(), new LocalDateTypeAdapter(), new NewObjectTypeAdapter(), new ObjectRemovedTypeAdapter(), new ReferenceChangeTypeAdapter(), new ValueChangeTypeAdapter(), new ChangeTypeAdapter()};
    private boolean typeSafeValues = false;
    private final JsonConverter jsonConverter = new JsonConverter();

    public JsonConverterBuilder() {
        this.jsonConverter.registerJsonTypeAdapters(Arrays.asList(BUILT_IN_ADAPTERS));
    }

    public static JsonConverterBuilder jsonConverter() {
        return new JsonConverterBuilder();
    }

    public JsonConverterBuilder typeSafeValues(boolean typeSafeValues) {
        this.typeSafeValues = typeSafeValues;
        return this;
    }

    public JsonConverterBuilder registerNativeTypeAdapter(Type targetType, TypeAdapter nativeAdapter) {
        Validate.argumentsAreNotNull(targetType, nativeAdapter);
        this.jsonConverter.registerNativeGsonTypeAdapter(targetType, nativeAdapter);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonSerializer(Type targetType, JsonSerializer<?> jsonSerializer) {
        Validate.argumentsAreNotNull(targetType, jsonSerializer);
        this.jsonConverter.registerNativeGsonSerializer(targetType, jsonSerializer);
        return this;
    }

    public JsonConverterBuilder registerNativeGsonDeserializer(Type targetType, JsonDeserializer<?> jsonDeserializer) {
        Validate.argumentsAreNotNull(targetType, jsonDeserializer);
        this.jsonConverter.registerNativeGsonDeserializer(targetType, jsonDeserializer);
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapter(JsonTypeAdapter adapter) {
        Validate.argumentIsNotNull(adapter);
        this.jsonConverter.registerJsonTypeAdapter(adapter);
        return this;
    }

    public JsonConverterBuilder registerJsonTypeAdapters(Collection<JsonTypeAdapter> adapters) {
        Validate.argumentIsNotNull(adapters);
        this.jsonConverter.registerJsonTypeAdapters(adapters);
        return this;
    }

    public JsonConverter build() {
        this.jsonConverter.registerJsonTypeAdapter(new AtomicTypeAdapter(this.typeSafeValues));
        this.jsonConverter.initialize();
        return this.jsonConverter;
    }
}

