/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.object;

import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.GlobalIdDTO;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.InstanceIdDTO;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.property.ValueObject;
import org.javers.core.metamodel.type.TypeMapper;

public class ValueObjectIdDTO
extends GlobalIdDTO {
    private InstanceIdDTO ownerIdDTO;
    private final String fragment;

    ValueObjectIdDTO(Class ownerClass, Object ownerLocalId, String fragment) {
        Validate.argumentsAreNotNull(ownerClass, ownerLocalId, fragment);
        this.ownerIdDTO = InstanceIdDTO.instanceId(ownerLocalId, ownerClass);
        this.fragment = fragment;
    }

    public static ValueObjectIdDTO valueObjectId(Object ownerLocalId, Class ownerClass, String fragment) {
        return new ValueObjectIdDTO(ownerClass, ownerLocalId, fragment);
    }

    @Override
    public ValueObjectId create(TypeMapper typeMapper) {
        String voProperty = this.decodePropertyName();
        InstanceId ownerId = this.ownerIdDTO.create(typeMapper);
        ValueObject valueObject = typeMapper.getChildValueObject(ownerId.getCdoClass(), voProperty);
        return new ValueObjectId(valueObject, ownerId, this.fragment);
    }

    @Override
    public String value() {
        return this.ownerIdDTO.value() + "#" + this.fragment;
    }

    private String decodePropertyName() {
        String[] parts = this.fragment.split("/");
        if (parts.length > 0) {
            return parts[0];
        }
        return "";
    }
}

