/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.json.typeadapter.change;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.core.diff.changetype.map.EntryAddOrRemove;
import org.javers.core.diff.changetype.map.EntryAdded;
import org.javers.core.diff.changetype.map.EntryChange;
import org.javers.core.diff.changetype.map.EntryRemoved;
import org.javers.core.diff.changetype.map.EntryValueChange;
import org.javers.core.diff.changetype.map.MapChange;
import org.javers.core.json.typeadapter.change.ChangeTypeAdapter;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.TypeMapper;

public class MapChangeTypeAdapter
extends ChangeTypeAdapter<MapChange> {
    private final TypeMapper typeMapper;
    private static final String ENTRY_CHANGES_FIELD = "entryChanges";
    private static final String ENTRY_CHANGE_TYPE_FIELD = "entryChangeType";
    private static final String KEY_FIELD = "key";
    private static final String VALUE_FIELD = "value";
    private static final String LEFT_VALUE_FIELD = "leftValue";
    private static final String RIGHT_VALUE_FIELD = "rightValue";

    public MapChangeTypeAdapter(TypeMapper typeMapper) {
        this.typeMapper = typeMapper;
    }

    @Override
    public MapChange fromJson(JsonElement json, JsonDeserializationContext context) {
        JsonObject jsonObject = (JsonObject)json;
        ChangeTypeAdapter.PropertyChangeStub stub = this.deserializeStub(jsonObject, context);
        MapType mapType = (MapType)this.typeMapper.getPropertyType(stub.property);
        List<EntryChange> changes = this.parseChanges(jsonObject, context, mapType);
        return this.appendCommitMetadata(jsonObject, context, new MapChange(stub.id, stub.property, changes));
    }

    @Override
    public JsonElement toJson(MapChange change, JsonSerializationContext context) {
        JsonObject jsonObject = this.createJsonObject(change, context);
        this.appendBody(change, jsonObject, context);
        return jsonObject;
    }

    @Override
    public Class getValueType() {
        return MapChange.class;
    }

    private List<EntryChange> parseChanges(JsonObject jsonObject, JsonDeserializationContext context, MapType mapType) {
        ArrayList<EntryChange> result = new ArrayList<EntryChange>();
        JsonArray array = jsonObject.getAsJsonArray(ENTRY_CHANGES_FIELD);
        for (JsonElement e : array) {
            JsonObject entryChange = (JsonObject)e;
            String entryChangeType = entryChange.get(ENTRY_CHANGE_TYPE_FIELD).getAsString();
            if (EntryAdded.class.getSimpleName().equals(entryChangeType)) {
                result.add(this.parseEntryAdded(entryChange, context, mapType));
                continue;
            }
            if (EntryRemoved.class.getSimpleName().equals(entryChangeType)) {
                result.add(this.parseEntryRemoved(entryChange, context, mapType));
                continue;
            }
            if (EntryValueChange.class.getSimpleName().equals(entryChangeType)) {
                result.add(this.parseEntryValueChange(entryChange, context, mapType));
                continue;
            }
            throw new JaversException(JaversExceptionCode.MALFORMED_ENTRY_CHANGE_TYPE_FIELD, entryChangeType);
        }
        return result;
    }

    private EntryAdded parseEntryAdded(JsonObject entryChange, JsonDeserializationContext context, MapType mapType) {
        Object key = this.decodeValue(entryChange, context, KEY_FIELD, mapType.getKeyClass());
        Object value = this.decodeValue(entryChange, context, VALUE_FIELD, mapType.getValueClass());
        return new EntryAdded(key, value);
    }

    private EntryRemoved parseEntryRemoved(JsonObject entryChange, JsonDeserializationContext context, MapType mapType) {
        Object key = this.decodeValue(entryChange, context, KEY_FIELD, mapType.getKeyClass());
        Object value = this.decodeValue(entryChange, context, VALUE_FIELD, mapType.getValueClass());
        return new EntryRemoved(key, value);
    }

    private EntryValueChange parseEntryValueChange(JsonObject entryChange, JsonDeserializationContext context, MapType mapType) {
        Object key = this.decodeValue(entryChange, context, KEY_FIELD, mapType.getKeyClass());
        Object leftValue = this.decodeValue(entryChange, context, LEFT_VALUE_FIELD, mapType.getValueClass());
        Object rightValue = this.decodeValue(entryChange, context, RIGHT_VALUE_FIELD, mapType.getValueClass());
        return new EntryValueChange(key, leftValue, rightValue);
    }

    private Object decodeValue(JsonObject entryChange, JsonDeserializationContext context, String fieldName, Class expectedType) {
        return context.deserialize(entryChange.get(fieldName), (Type)this.typeMapper.getDehydratedType(expectedType));
    }

    private void appendBody(MapChange change, JsonObject toJson, JsonSerializationContext context) {
        JsonArray jsonArray = new JsonArray();
        for (EntryChange entryChange : change.getEntryChanges()) {
            EntryChange entry;
            JsonObject jsonElement = new JsonObject();
            jsonElement.addProperty(ENTRY_CHANGE_TYPE_FIELD, entryChange.getClass().getSimpleName());
            if (entryChange instanceof EntryAddOrRemove) {
                entry = (EntryAddOrRemove)entryChange;
                jsonElement.add(KEY_FIELD, context.serialize((Object)entry.getWrappedKey()));
                jsonElement.add(VALUE_FIELD, context.serialize((Object)((EntryAddOrRemove)entry).getWrappedValue()));
            }
            if (entryChange instanceof EntryValueChange) {
                entry = (EntryValueChange)entryChange;
                jsonElement.add(KEY_FIELD, context.serialize((Object)entry.getWrappedKey()));
                jsonElement.add(LEFT_VALUE_FIELD, context.serialize((Object)((EntryValueChange)entry).getWrappedLeftValue()));
                jsonElement.add(RIGHT_VALUE_FIELD, context.serialize((Object)((EntryValueChange)entry).getWrappedRightValue()));
            }
            jsonArray.add((JsonElement)jsonElement);
        }
        toJson.add(ENTRY_CHANGES_FIELD, (JsonElement)jsonArray);
    }
}

