/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.javers.common.collections.Predicate;
import org.javers.common.exception.exceptions.JaversException;
import org.javers.common.exception.exceptions.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsDomainClass;
import org.javers.core.metamodel.property.Property;

public abstract class ManagedClass
extends ClientsDomainClass {
    private final List<Property> properties;
    private final List<Property> propertiesUnmodifiable;

    ManagedClass(Class clientsClass, List<Property> properties) {
        super(clientsClass);
        Validate.argumentsAreNotNull(properties);
        this.properties = new ArrayList<Property>(properties);
        this.propertiesUnmodifiable = Collections.unmodifiableList(properties);
    }

    public List<Property> getProperties() {
        return this.propertiesUnmodifiable;
    }

    public List<Property> getProperties(Predicate<Property> query) {
        ArrayList<Property> retProperties = new ArrayList<Property>();
        for (Property property : this.properties) {
            if (!query.apply(property)) continue;
            retProperties.add(property);
        }
        return retProperties;
    }

    public Property getProperty(String withName) {
        for (Property property : this.properties) {
            if (!property.getName().equals(withName)) continue;
            return property;
        }
        throw new JaversException(JaversExceptionCode.PROPERTY_NOT_FOUND, withName, this.getName());
    }

    public boolean hasProperty(String withName) {
        try {
            this.getProperty(withName);
            return true;
        }
        catch (JaversException e) {
            return false;
        }
    }
}

